/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.custom;

import com.ibm.ws.webservices.custom.CustomPropertyDescriptor;
import com.ibm.ws.webservices.custom.CustomPropertyValidator;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import org.apache.commons.logging.Log;

public class CustomPropertyIntValidator
implements CustomPropertyValidator {
    private Log log = LogFactory.getLog(CustomPropertyIntValidator.class.getName());
    private static final String newline = "\n";
    private int minVal;
    private int maxVal;

    CustomPropertyIntValidator(int minIn, int maxIn) {
        this.minVal = minIn;
        this.maxVal = maxIn;
    }

    public Object validate(Object value2, CustomPropertyDescriptor desc) {
        int intValue = (Integer)value2;
        if (intValue < this.minVal || intValue > this.maxVal) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failure occured during int validation of: " + intValue + " for key: " + desc.getKey());
                this.log.debug("minVal: " + this.minVal + "  maxVal: " + this.maxVal + "  returning: " + desc.getValue());
            }
            return desc.getValue();
        }
        return value2;
    }
}

