/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.configuration;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.protocol.Protocols;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.WebServicesService;
import com.ibm.ws.webservices.WebServicesServiceHome;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDeployment;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDispatcher;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDGlobalConfiguration;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDJAXRPCHandlerInfo;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDJAXRPCHandlerInfoChain;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDPort;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDTransport;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.ExtendedHandlerInfo;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleException;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleObject;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleOwner;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleSetImpl;
import com.ibm.ws.webservices.engine.lifecycle._LifeCycleObject;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.metadata.PortMetaData;
import com.ibm.ws.webservices.xml.WASEntityResolver;
import com.ibm.ws.webservices.xml.waswebservices.client;
import com.ibm.ws.webservices.xml.waswebservices.dispatcher;
import com.ibm.ws.webservices.xml.waswebservices.global;
import com.ibm.ws.webservices.xml.waswebservices.handler;
import com.ibm.ws.webservices.xml.waswebservices.header;
import com.ibm.ws.webservices.xml.waswebservices.parameter;
import com.ibm.ws.webservices.xml.waswebservices.pool;
import com.ibm.ws.webservices.xml.waswebservices.port;
import com.ibm.ws.webservices.xml.waswebservices.server;
import com.ibm.ws.webservices.xml.waswebservices.transport;
import com.ibm.ws.webservices.xml.waswebservices.wasws;
import com.ibm.ws.webservices.xml.waswebservices.waswsFactory;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import com.ibm.wsspi.webservices.rpc.handler.Handler;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.discovery.log.DiscoveryLogFactory;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.xml.sax.InputSource;

public class WebServicesEngineConfigurationGenerator
implements LifeCycleOwner,
_LifeCycleObject {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.webservices.resources.webservicesMessages");
    private static final TraceComponent _tc = Tr.register(WebServicesEngineConfigurationGenerator.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private LifeCycleSetImpl _lifeCycleSet = this.lifeCycleSetFactory(this);
    private static final String ALL_TRANSPORTS_PROTOCOL = "com.ibm.ws.webservices.transports.all";
    private static WebServicesEngineConfigurationGenerator[] _aecg = new WebServicesEngineConfigurationGenerator[2];
    private final int engineType;
    private final ClassLoader classLoader = ExtClassLoader.getInstance();
    private final WASConfig clientConfig;
    private final WASConfig serverConfig;
    public static final int CLIENT_CONTAINER = 1;
    public static final int SERVER_CONTAINER = 2;

    private static synchronized WebServicesEngineConfigurationGenerator getConfigGenerator() {
        return WebServicesEngineConfigurationGenerator.getConfigGeneratorInternal(0);
    }

    private static synchronized WebServicesEngineConfigurationGenerator getConfigGeneratorInternal(int whichEngine) {
        if (WebServicesEngineConfigurationGenerator.isValidEngineSelection(whichEngine)) {
            WebServicesEngineConfigurationGenerator.loadConfiguration(whichEngine);
            if (_aecg[whichEngine] == null) {
                Tr.error(_tc, "webservices.config.not.loaded");
            }
            return _aecg[whichEngine];
        }
        Object[] params = new Object[]{"WebServicesEngineConfigurationGenerator.getConfigGenerator: Invalid engine selection " + whichEngine};
        Tr.error(_tc, "internal.error", params);
        return null;
    }

    public static synchronized WebServicesEngineConfigurationGenerator getConfigGenerator(int unused) {
        WebServicesEngineConfigurationGenerator.loadConfiguration();
        return WebServicesEngineConfigurationGenerator.getConfigGenerator();
    }

    private static synchronized void loadConfiguration(int whichEngine) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadConfiguration", "whichEngine=" + whichEngine);
        }
        if (WebServicesEngineConfigurationGenerator.isValidEngineSelection(whichEngine)) {
            if (_aecg[whichEngine] == null) {
                WebServicesEngineConfigurationGenerator._aecg[whichEngine] = new WebServicesEngineConfigurationGenerator(whichEngine);
                _aecg[whichEngine].init();
            }
        } else {
            Object[] params = new Object[]{"Invalid engine selction " + whichEngine};
            Tr.error(_tc, "internal.error", params);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadConfiguration");
        }
    }

    private static boolean isValidEngineSelection(int whichEngine) {
        return whichEngine >= 0 && whichEngine <= 1;
    }

    private static synchronized void loadConfiguration() {
        WebServicesEngineConfigurationGenerator.loadConfiguration(0);
    }

    public static synchronized void destroyConfigGenerator() {
        WebServicesEngineConfigurationGenerator.destroyConfigGenerator(0);
    }

    public static synchronized void destroyConfigGenerator(int whichEngine) {
        if (WebServicesEngineConfigurationGenerator.isValidEngineSelection(whichEngine)) {
            if (_aecg[whichEngine] != null) {
                _aecg[whichEngine].destroy();
                WebServicesEngineConfigurationGenerator._aecg[whichEngine] = null;
            }
        } else {
            Object[] params = new Object[]{"WebServicesEngineConfigurationGenerator.destroyConfigGenerator: Invalid engine selection " + whichEngine};
            Tr.error(_tc, "internal.error", params);
        }
    }

    private WebServicesEngineConfigurationGenerator() {
        this(0);
    }

    private WebServicesEngineConfigurationGenerator(int engineType) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WebServicesEngineConfigurationGenerator ctor", "engineType=" + engineType);
        }
        this.engineType = engineType;
        this.clientConfig = new WASConfig(1, this.classLoader);
        this.serverConfig = new WASConfig(2, this.classLoader);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "WebServicesEngineConfigurationGenerator ctor");
        }
    }

    public static WSDDDeployment createServerDeployment(Collection ports) {
        return WebServicesEngineConfigurationGenerator.createServerDeployment(0, ports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSDDDeployment createServerDeployment(int whichEngine, Collection ports) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createServerDeployment");
        }
        if ((ports == null || ports.size() < 1) && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "no services to deploy for server");
        }
        try {
            WASConfig config = WebServicesEngineConfigurationGenerator.getConfigGeneratorInternal(whichEngine) == null ? null : WebServicesEngineConfigurationGenerator.getConfigGeneratorInternal((int)whichEngine).serverConfig;
            WSDDDeployment wSDDDeployment = WebServicesEngineConfigurationGenerator.getDeployment(config, ports);
            return wSDDDeployment;
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "createServerDeployment");
            }
        }
    }

    public static WSDDDeployment createClientDeployment(Collection ports) {
        return WebServicesEngineConfigurationGenerator.createClientDeployment(0, ports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSDDDeployment createClientDeployment(int whichEngine, Collection ports) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createClientDeployment", "ports=" + (ports != null ? ports.toString() : "<null>"));
        }
        if ((ports == null || ports.size() < 1) && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "no services to deploy for client");
        }
        try {
            WASConfig config = WebServicesEngineConfigurationGenerator.getConfigGeneratorInternal(whichEngine) == null ? null : WebServicesEngineConfigurationGenerator.getConfigGeneratorInternal((int)whichEngine).clientConfig;
            WSDDDeployment wSDDDeployment = WebServicesEngineConfigurationGenerator.getDeployment(config, ports);
            return wSDDDeployment;
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "createClientDeployment");
            }
        }
    }

    private boolean isRoleApplicableToService(int role2) {
        WebServicesService service = null;
        if (role2 == 1) {
            return true;
        }
        service = this.engineType == 1 ? WebServicesServiceHome.getWebServicesSystemService() : WebServicesServiceHome.getWebServicesService();
        return service == null ? false : service.isRoleApplicableToService(role2);
    }

    private static WSDDDeployment getDeployment(WASConfig baseConfig, Collection portComponents) {
        WSDDDeployment deployment = (WSDDDeployment)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                WSDDDeployment d = new WSDDDeployment();
                d.setContainerManaged(true);
                return d;
            }
        });
        if (baseConfig != null) {
            baseConfig.deploy(deployment);
        }
        if (portComponents != null && portComponents.size() > 0) {
            Iterator iter = portComponents.iterator();
            int jj = 0;
            while (iter.hasNext()) {
                WSDDPort wsddPort = ((PortMetaData)iter.next()).getWsddPort();
                if (baseConfig != null) {
                    baseConfig.deploy(wsddPort);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Port(" + jj + ") is " + wsddPort);
                }
                deployment.deployPort(wsddPort);
                ++jj;
            }
        }
        if (_tc.isDebugEnabled()) {
            deployment.dump();
        }
        return deployment;
    }

    private LifeCycleSetImpl lifeCycleSetFactory(_LifeCycleObject container) {
        return new LifeCycleSetImpl(container, true, false);
    }

    public void setOwner(LifeCycleOwner owner) throws LifeCycleException {
        this._lifeCycleSet.setOwner(owner);
    }

    public LifeCycleOwner getOwner() {
        return this._lifeCycleSet.getOwner();
    }

    public final void init() throws LifeCycleException {
        this._lifeCycleSet.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void _init() throws LifeCycleException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "_init");
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    WebServicesEngineConfigurationGenerator.this.privilegedInit();
                    return null;
                }
            });
            this.serverConfig.distributeGlobals();
            this.serverConfig.addGlobalHeadersToPortHandlers();
            this.serverConfig.gatherProtectedHeaders();
            this.clientConfig.distributeGlobals();
            this.clientConfig.addGlobalHeadersToPortHandlers();
            this.clientConfig.gatherProtectedHeaders();
            this._lifeCycleSet._init();
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "_init");
            }
        }
    }

    private String getGlobalConfigFile() {
        if (this.engineType == 1) {
            return "META-INF/was-syswebservices.xml";
        }
        return "META-INF/was-webservices.xml";
    }

    private void privilegedInit() {
        String epid;
        IExtensionPoint extensionPoint;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "privilegedInit");
        }
        Enumeration<URL> e = null;
        String globalConfigFile = this.getGlobalConfigFile();
        try {
            e = this.classLoader.getResources(globalConfigFile);
        }
        catch (IOException ioe) {
            Tr.error(_tc, "cannot.load.resource", new Object[]{globalConfigFile, ioe});
        }
        HashSet<URL> resourceSet = new HashSet<URL>();
        while (e != null && e.hasMoreElements()) {
            resourceSet.add(e.nextElement());
        }
        String localEpid = null;
        localEpid = globalConfigFile.equals("META-INF/was-syswebservices.xml") ? "syswebservices" : "webservices";
        String resourceName = globalConfigFile;
        IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        if (registry != null && (extensionPoint = registry.getExtensionPoint(epid = ExtensionRegistryFactory.instance().getDefaultPluginID() + "." + localEpid)) != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Processing extension point " + epid);
            }
            HashSet<String> bundlesProcessed = new HashSet<String>();
            IExtension[] extensions = extensionPoint.getExtensions();
            for (int i = 0; i < extensions.length; ++i) {
                Bundle bundle;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Processing extension " + extensions[i].getUniqueIdentifier());
                }
                if ((bundle = Platform.getBundle((String)extensions[i].getNamespace())) == null) continue;
                String bundleName = bundle.getSymbolicName();
                if (!bundlesProcessed.contains(bundleName)) {
                    bundlesProcessed.add(bundleName);
                    Enumeration e2 = null;
                    try {
                        e2 = bundle.getResources(resourceName);
                    }
                    catch (IOException e1) {
                        Tr.error(_tc, "Exception trying to get bundle resources", e1);
                    }
                    while (e2 != null && e2.hasMoreElements()) {
                        resourceSet.add((URL)e2.nextElement());
                    }
                    continue;
                }
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "bundle " + bundleName + " has already been processed");
            }
        }
        if (resourceSet != null) {
            Iterator i = resourceSet.iterator();
            while (i.hasNext()) {
                InputStream is;
                URL u = (URL)i.next();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "About to read global config file: " + u.toString());
                }
                try {
                    is = u.openStream();
                }
                catch (IOException ioe) {
                    Tr.error(_tc, "internal.error", ioe);
                    is = null;
                }
                if (is == null) continue;
                waswsFactory iwf = new waswsFactory();
                iwf.setPackageName("com.ibm.ws.webservices.xml.waswebservices");
                wasws root = (wasws)iwf.loadDocument("wasws", new InputSource(is), globalConfigFile, false, true, new WASEntityResolver());
                if (root == null) {
                    Tr.warning(_tc, "warning.parse.file.failure", globalConfigFile);
                    continue;
                }
                int globalCount = root.getglobalCount();
                for (int gIdx = 0; gIdx < globalCount; ++gIdx) {
                    global global2 = root.getGlobal(gIdx);
                    this.clientConfig.add(global2);
                    this.serverConfig.add(global2);
                }
                int portCount = root.getportCount();
                for (int pIdx = 0; pIdx < portCount; ++pIdx) {
                    port port2 = root.getPort(pIdx);
                    this.clientConfig.add(port2);
                    this.serverConfig.add(port2);
                }
                int transportCount = root.gettransportCount();
                for (int tIdx = 0; tIdx < transportCount; ++tIdx) {
                    transport transport2 = root.getTransport(tIdx);
                    this.clientConfig.add(transport2);
                    this.serverConfig.add(transport2);
                }
                int paramCount = root.getparameterCount();
                for (int paramIdx = 0; paramIdx < paramCount; ++paramIdx) {
                    parameter param = root.getParameter(paramIdx);
                    this.clientConfig.add(param);
                    this.serverConfig.add(param);
                }
                int clientCount = root.getclientCount();
                for (int clientIdx = 0; clientIdx < clientCount; ++clientIdx) {
                    this.clientConfig.add(root.getClient(clientIdx));
                }
                int serverCount = root.getserverCount();
                for (int serverIdx = 0; serverIdx < serverCount; ++serverIdx) {
                    this.serverConfig.add(root.getServer(serverIdx));
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "privilegedInit");
        }
    }

    public final void destroy() {
        this._lifeCycleSet.destroy();
    }

    public void _destroy() {
        this._lifeCycleSet._destroy();
    }

    public int getState() {
        return this._lifeCycleSet.getState();
    }

    public boolean isActive() {
        return this._lifeCycleSet.isActive();
    }

    public void verifyActive() throws LifeCycleException {
        this._lifeCycleSet.verifyActive();
    }

    public void verifyInactive() throws LifeCycleException {
        this._lifeCycleSet.verifyInactive();
    }

    public boolean releaseLifeCycleManagementOf(LifeCycleObject object) throws LifeCycleException {
        return false;
    }

    protected boolean manageLifeCycleOf(LifeCycleObject object) {
        return this._lifeCycleSet.manageLifeCycleOf(object);
    }

    protected boolean tempManageLifeCycleOf(LifeCycleObject object) {
        return this._lifeCycleSet.manageLifeCycleOf(object, false);
    }

    static {
        DiscoveryLogFactory.setFactory(LogFactory.getLogFactory());
        Protocols.init();
        if (_tc.isDebugEnabled()) {
            String prop = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("java.protocol.handler.pkgs");
                }
            });
            Tr.debug(_tc, "java.protocol.handler.pkgs=" + prop);
        }
    }

    private final class WASConfig {
        private final String _role;
        private final boolean _applicable;
        private final int _modeClientServer;
        private final ClassLoader _classLoader;
        private WASParameters _parameters;
        private final WASHandlers _globalHandlers;
        private final WASHandlers _portHandlers;
        private HashMap _transportMap;
        private ArrayList _protectedHeaders;

        WASConfig(int role2, ClassLoader classLoader) {
            this._parameters = new WASParameters();
            this._transportMap = new HashMap();
            this._protectedHeaders = new ArrayList();
            if (role2 == 1) {
                this._role = Handler.HANDLER_PARAM_ROLE_CLIENT;
                this._modeClientServer = 1;
            } else {
                this._role = Handler.HANDLER_PARAM_ROLE_SERVER;
                this._modeClientServer = 2;
            }
            this._applicable = WebServicesEngineConfigurationGenerator.this.isRoleApplicableToService(role2);
            this._classLoader = classLoader;
            this._globalHandlers = new WASHandlers(Handler.HANDLER_PARAM_CAT_GLOBAL, this._role, this._modeClientServer);
            this._portHandlers = new WASHandlers(Handler.HANDLER_PARAM_CAT_PORT, this._role, this._modeClientServer);
        }

        void add(client client2) {
            if (this._applicable && client2 != null) {
                int globalCount = client2.getglobalCount();
                for (int gIdx = 0; gIdx < globalCount; ++gIdx) {
                    this.add(client2.getGlobal(gIdx));
                }
                int portCount = client2.getportCount();
                for (int pIdx = 0; pIdx < portCount; ++pIdx) {
                    this.add(client2.getPort(pIdx));
                }
                int transportCount = client2.gettransportCount();
                for (int tIdx = 0; tIdx < transportCount; ++tIdx) {
                    this.add(client2.getTransport(tIdx));
                }
                int paramCount = client2.getparameterCount();
                for (int paramIdx = 0; paramIdx < paramCount; ++paramIdx) {
                    this.add(client2.getParameter(paramIdx));
                }
            }
        }

        void add(server server2) {
            if (this._applicable && server2 != null) {
                int globalCount = server2.getglobalCount();
                for (int gIdx = 0; gIdx < globalCount; ++gIdx) {
                    this.add(server2.getGlobal(gIdx));
                }
                int portCount = server2.getportCount();
                for (int pIdx = 0; pIdx < portCount; ++pIdx) {
                    this.add(server2.getPort(pIdx));
                }
                int transportCount = server2.gettransportCount();
                for (int tIdx = 0; tIdx < transportCount; ++tIdx) {
                    this.add(server2.getTransport(tIdx));
                }
                int paramCount = server2.getparameterCount();
                for (int paramIdx = 0; paramIdx < paramCount; ++paramIdx) {
                    this.add(server2.getParameter(paramIdx));
                }
                int dispatcherCount = server2.getdispatcherCount();
                for (int pcIdx = 0; pcIdx < dispatcherCount; ++pcIdx) {
                    this.add(server2.getDispatcher(pcIdx));
                }
            }
        }

        void add(parameter parameter2) {
            if (this._applicable && parameter2 != null) {
                this._parameters.add(parameter2);
            }
        }

        void add(global global2) {
            if (this._applicable && global2 != null) {
                int globalHandlerCount = global2.gethandlerCount();
                for (int ghIdx = 0; ghIdx < globalHandlerCount; ++ghIdx) {
                    this._globalHandlers.add(new WASHandler(global2.getHandler(ghIdx), this.getClassLoader()));
                }
                int globalRoleCount = global2.getroleCount();
                for (int roleIdx = 0; roleIdx < globalRoleCount; ++roleIdx) {
                    this._globalHandlers.addRole(global2.getRole(roleIdx));
                    this._portHandlers.addRole(global2.getRole(roleIdx));
                }
            }
        }

        void add(port port2) {
            if (this._applicable && port2 != null) {
                int portHandlerCount = port2.gethandlerCount();
                for (int phIdx = 0; phIdx < portHandlerCount; ++phIdx) {
                    this._portHandlers.add(new WASHandler(port2.getHandler(phIdx), this.getClassLoader()));
                }
                int roleCount = port2.getroleCount();
                for (int roleIdx = 0; roleIdx < roleCount; ++roleIdx) {
                    this._portHandlers.addRole(port2.getRole(roleIdx));
                }
            }
        }

        void add(transport transport2) {
            block6: {
                int protocolCount;
                block7: {
                    if (!this._applicable || transport2 == null) break block6;
                    protocolCount = transport2.getprotocolCount();
                    if (protocolCount <= 0) break block7;
                    for (int pIdx = 0; pIdx < protocolCount; ++pIdx) {
                        String protocol2 = transport2.getProtocol(pIdx);
                        WASTransport trans = this.getTransport(protocol2);
                        trans.addParameters(transport2);
                        if (transport2.getJavaclass() != null) {
                            trans.setPivot(transport2.getJavaclass());
                        }
                        int transportHandlerCount = transport2.gethandlerCount();
                        for (int thIdx = 0; thIdx < transportHandlerCount; ++thIdx) {
                            trans.addHandler(new WASHandler(transport2.getHandler(thIdx), this.getClassLoader()));
                        }
                        int roleCount = transport2.getroleCount();
                        for (int roleIdx = 0; roleIdx < roleCount; ++roleIdx) {
                            this._portHandlers.addRole(transport2.getRole(roleIdx));
                        }
                    }
                    break block6;
                }
                if (protocolCount != 0) break block6;
                WASTransport trans = this.getTransport(WebServicesEngineConfigurationGenerator.ALL_TRANSPORTS_PROTOCOL);
                trans.addParameters(transport2);
                int transportHandlerCount = transport2.gethandlerCount();
                for (int thIdx = 0; thIdx < transportHandlerCount; ++thIdx) {
                    trans.addHandler(new WASHandler(transport2.getHandler(thIdx), this.getClassLoader()));
                }
                int roleCount = transport2.getroleCount();
                for (int roleIdx = 0; roleIdx < roleCount; ++roleIdx) {
                    this._portHandlers.addRole(transport2.getRole(roleIdx));
                }
            }
        }

        Iterator getTransports() {
            return this._transportMap.values().iterator();
        }

        WASTransport getTransport(String protocol2) {
            WASTransport transport2 = (WASTransport)this._transportMap.get(protocol2);
            if (transport2 == null) {
                transport2 = new WASTransport(protocol2, this._role, this._modeClientServer);
                this._transportMap.put(protocol2, transport2);
            }
            return transport2;
        }

        void removeTransport(String protocol2) {
            this._transportMap.remove(protocol2);
        }

        void add(dispatcher dispatcher2) {
            if (this._applicable && dispatcher2 != null) {
                String name2 = dispatcher2.getName();
                String javaclass2 = dispatcher2.getJavaclass();
                try {
                    WSDDDispatcher.registerDispatcher(QNameTable.createQName("http://websphere.ibm.com/webservices/wsdd/dispatchers/java", name2), javaclass2);
                }
                catch (ConfigurationException ce) {
                    Tr.error(_tc, "warning.provider.not.verified", new Object[]{javaclass2, name2, ce});
                }
            }
        }

        void distributeGlobals() {
            WASTransport allTransports = this.getTransport(WebServicesEngineConfigurationGenerator.ALL_TRANSPORTS_PROTOCOL);
            this.removeTransport(WebServicesEngineConfigurationGenerator.ALL_TRANSPORTS_PROTOCOL);
            this._portHandlers.addRoles(allTransports.getRoles());
            if (this._portHandlers._chain != null && allTransports.getHandlers()._chain != null) {
                this._portHandlers._chain.addGlobalHeaders(allTransports.getHandlers()._chain.getAllHeaders());
            }
            Iterator iter = this.getTransports();
            while (iter.hasNext()) {
                WASTransport trans = (WASTransport)iter.next();
                this._portHandlers.addRoles(trans.getRoles());
                if (trans.getHandlers()._chain != null) {
                    this._portHandlers._chain.addGlobalHeaders(trans.getHandlers()._chain.getAllHeaders());
                }
                trans.addParameters(allTransports.getMap());
                trans.addHandlers(allTransports.getHandlers());
            }
        }

        void addGlobalHeadersToPortHandlers() {
            ArrayList globalHeaders = (ArrayList)this._globalHandlers._chain.getAllHeaders();
            if (globalHeaders != null) {
                this._portHandlers._chain.addGlobalHeaders(globalHeaders);
            }
        }

        void gatherProtectedHeaders() {
            if (this._globalHandlers._chain != null) {
                this._protectedHeaders.addAll(this._globalHandlers._chain.getProtectedHeaders());
            }
            if (this._portHandlers._chain != null) {
                this._protectedHeaders.addAll(this._portHandlers._chain.getProtectedHeaders());
            }
            Iterator iter = this.getTransports();
            while (iter.hasNext()) {
                WASTransport trans = (WASTransport)iter.next();
                if (trans.getHandlers()._chain == null) continue;
                this._protectedHeaders.addAll(trans.getHandlers()._chain.getProtectedHeaders());
            }
        }

        void deploy(WSDDDeployment deployment) {
            Iterator iter = this.getTransports();
            while (iter.hasNext()) {
                deployment.deployTransport(((WASTransport)iter.next()).createWSDDTransport());
            }
            WSDDGlobalConfiguration wgc = new WSDDGlobalConfiguration(this.getModeClientServer());
            wgc.setParameters(this._parameters.getMap());
            wgc.setHandlerInfoChain(this._globalHandlers._chain);
            wgc.setProtectedHeaders(this._protectedHeaders);
            deployment.setGlobalConfiguration(wgc);
        }

        void deploy(WSDDPort wsddPort) {
            wsddPort.addHandlerInfo(this._portHandlers._chain);
            wsddPort.addRoles(this._portHandlers._chain.getRoles());
        }

        public int getModeClientServer() {
            return this._modeClientServer;
        }

        private ClassLoader getClassLoader() {
            return this._classLoader;
        }
    }

    private class WASTransport {
        private final int _modeClientServer;
        private String _protocol;
        private String _pivotClass;
        private WASHandlers _handlers;
        private WASParameters _parameters;

        WASTransport(String protocol2, String role2, int modeClientServer) {
            this._parameters = new WASParameters();
            this._protocol = protocol2;
            this._modeClientServer = modeClientServer;
            this._handlers = new WASHandlers(Handler.HANDLER_PARAM_CAT_TRANSPORT, role2, modeClientServer);
        }

        void addParameters(transport trans) {
            if (trans != null) {
                int count = trans.getparameterCount();
                for (int idx = 0; idx < count; ++idx) {
                    this._parameters.add(trans.getParameter(idx));
                }
            }
        }

        void addParameters(Map params) {
            if (params != null) {
                this._parameters.add(params);
            }
        }

        WASHandlers getHandlers() {
            return this._handlers;
        }

        Collection getRoles() {
            return this._handlers.getRoles();
        }

        void addHandler(WASHandler handler2) {
            this._handlers.add(handler2);
        }

        void addRole(String role2) {
            this._handlers.addRole(role2);
        }

        void addHandlers(WASHandlers handlers) {
            this._handlers.addHandlers(handlers);
        }

        void addRoles(Collection roles) {
            this._handlers.addRoles(roles);
        }

        void setPivot(String pivot) {
            this._pivotClass = pivot;
        }

        private WSDDTransport createWSDDTransport() {
            WSDDTransport transport2 = new WSDDTransport(this._modeClientServer);
            transport2.setName(this._protocol);
            transport2.setParameters(this._parameters.getMap());
            transport2.setHandlerInfoChain(this._handlers._chain);
            if (this._pivotClass != null) {
                transport2.setPivotQName(QNameTable.createQName("http://websphere.ibm.com/webservices/wsdd/dispatchers/java", this._pivotClass));
            }
            return transport2;
        }

        public Map getMap() {
            return this._parameters.getMap();
        }
    }

    private class WASHandlers {
        private final String _name;
        private final String _role;
        final WSDDJAXRPCHandlerInfoChain _chain;

        WASHandlers(String name2, String role2, int modeClientServer) {
            this._chain = new WSDDJAXRPCHandlerInfoChain(modeClientServer == 1, false);
            this._name = name2;
            this._role = role2;
            WebServicesEngineConfigurationGenerator.this.manageLifeCycleOf(this._chain);
        }

        void add(WASHandler h) {
            if (h == null) {
                return;
            }
            WSDDJAXRPCHandlerInfo handler2 = h.createWSDDJAXRPCHandlerInfo(this._name, this._role);
            if (handler2 != null) {
                this._chain.addHandlerInfo(handler2);
            }
        }

        void addHandlers(WASHandlers h) {
            if (h != null) {
                this._chain.addHandlerInfoList(h._chain.getHandlerInfoList());
            }
        }

        void addRole(String role2) {
            this._chain.addRole(role2);
        }

        void addRoles(Collection roles) {
            this._chain.addRoles(roles);
        }

        Collection getRoles() {
            return this._chain.getRoles();
        }
    }

    private final class WASHandler {
        private final String _name;
        private final String _javaclass;
        private final ClassLoader _classLoader;
        private final int _priority;
        private final WASParameters _params;
        private int _min;
        private int _max;
        private boolean _faultLocal = false;
        private boolean _autoResponse = true;
        private WASHeaders _headers;
        private boolean _canLoad;

        WASHandler(handler handler2, ClassLoader classLoader) {
            String faultLocalStr;
            this._name = handler2.getName();
            this._javaclass = handler2.getJavaclass();
            this._classLoader = classLoader;
            this._canLoad = true;
            this._params = new WASParameters();
            int count = handler2.getparameterCount();
            for (int idx = 0; idx < count; ++idx) {
                this._params.add(handler2.getParameter(idx));
            }
            int py = 50000000;
            if (handler2.getPriority() != null) {
                try {
                    py = Integer.parseInt(handler2.getPriority());
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            this._priority = py;
            this._min = 0;
            this._max = 0;
            if (handler2.getPool() != null) {
                pool pull = handler2.getPool();
                try {
                    this._min = Integer.parseInt(pull.getMin());
                    this._max = Integer.parseInt(pull.getMax());
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if ((faultLocalStr = handler2.getFault()) != null) {
                if (faultLocalStr.equalsIgnoreCase("local")) {
                    this._faultLocal = true;
                } else if (faultLocalStr.equalsIgnoreCase("upstream")) {
                    this._faultLocal = false;
                }
            }
            this._autoResponse = JavaUtils.isTrue(handler2.getAutoresponse(), true);
            QName tempQName = null;
            int headerCount = handler2.getheaderCount();
            this._headers = new WASHeaders(headerCount);
            for (int i = 0; i < headerCount; ++i) {
                try {
                    header nextHeader = handler2.getHeader(i);
                    tempQName = new QName(nextHeader.getNamespaceURI(), nextHeader.getElementValue());
                    boolean protectedHeader = false;
                    if (nextHeader.getProtect() != null) {
                        protectedHeader = nextHeader.getProtect().equalsIgnoreCase("true");
                    }
                    this._headers.setHeader(i, tempQName, protectedHeader);
                    continue;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.configuration.WebServicesEngineConfigurationGenerator$WASHandler", "468", this);
                    Tr.warning(_tc, "Exception caught while processing header: " + tempQName.toString() + ".  The header has NOT been added to the handlerInfo");
                }
            }
        }

        final String getName() {
            return this._name;
        }

        final String getJavaclass() {
            return this._javaclass;
        }

        final ClassLoader getClassLoader() {
            return this._classLoader;
        }

        final int getPriority() {
            return this._priority;
        }

        final QName[] getHeaders() {
            return this._headers.getHeaders();
        }

        final QName[] getProtectedHeaders() {
            return this._headers.getProtectedHeaders();
        }

        private WSDDJAXRPCHandlerInfo createWSDDJAXRPCHandlerInfo(String category, String deployRole) {
            WSDDJAXRPCHandlerInfo wh = null;
            if (this._canLoad) {
                wh = new WSDDJAXRPCHandlerInfo();
                wh.setName(this.getName());
                wh.setHandlerClassName(this.getJavaclass());
                ClassLoader handlerLoader = this.getClassLoader();
                wh.setClassLoader(handlerLoader);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Handler ClassLoader: " + handlerLoader.toString());
                }
                wh.setPriority(this.getPriority());
                wh.setMinPoolSize(this._min);
                wh.setMaxPoolSize(this._max);
                wh.setFaultLocal(this._faultLocal);
                wh.setAutoResponse(this._autoResponse);
                wh.setHeaders(this._headers.getHeaders());
                wh.setProtectedHeaders(this._headers.getProtectedHeaders());
                wh.setHandlerMap(this._params.getMap());
                wh.putHandlerMap(Handler.HANDLER_PARAM_CATEGORY, category);
                wh.putHandlerMap(Handler.HANDLER_PARAM_ROLE, deployRole);
                ExtendedHandlerInfo handlerInfo = null;
                try {
                    handlerInfo = wh.getHandlerInfo();
                    if (_tc.isDebugEnabled()) {
                        if (handlerInfo == null) {
                            Tr.debug(_tc, "Handler " + this.getName() + " disabled");
                        } else {
                            Tr.debug(_tc, "Handler " + this.getName() + " loaded: " + this.getJavaclass());
                        }
                    }
                }
                catch (ClassNotFoundException cnf) {
                    Tr.warning(_tc, "warning.handler.not.verified", new Object[]{this.getJavaclass(), this.getName(), cnf});
                }
                catch (NoClassDefFoundError cnf) {
                    FFDCFilter.processException((Throwable)cnf, "com.ibm.ws.webservices.configuration.WebServicesEngineConfigurationGenerator.createWSDDJAXRPCHandlerInfo", "367", this);
                    Tr.warning(_tc, "warning.handler.not.verified", new Object[]{this.getJavaclass(), this.getName(), cnf});
                }
                if (handlerInfo == null) {
                    wh = null;
                    this._canLoad = false;
                }
            }
            return wh;
        }
    }

    private final class WASHeaders {
        private QName[] _headerNames;
        private boolean[] _protect;
        private QName[] _protectedHeaders = null;

        WASHeaders(int count) {
            this._headerNames = new QName[count];
            this._protect = new boolean[count];
        }

        public void setHeader(int i, QName name2, boolean p) {
            this._protect[i] = p;
            this._headerNames[i] = name2;
        }

        public QName[] getHeaders() {
            return this._headerNames;
        }

        public QName[] getProtectedHeaders() {
            if (this._protectedHeaders == null) {
                int protectedCount = 0;
                for (int i = 0; i < this._headerNames.length; ++i) {
                    protectedCount += this._protect[i] ? 1 : 0;
                }
                this._protectedHeaders = new QName[protectedCount];
                int nextHeader = 0;
                for (int i = 0; i < this._headerNames.length; ++i) {
                    if (!this._protect[i]) continue;
                    this._protectedHeaders[nextHeader++] = this._headerNames[i];
                }
            }
            return this._protectedHeaders;
        }

        public void setProtect(int i, boolean p) {
            this._protect[i] = p;
            this._protectedHeaders = null;
        }

        public boolean getProtect(int i) {
            return this._protect[i];
        }

        public void setName(int i, QName name2) {
            this._headerNames[i] = name2;
        }

        public QName getName(int i) {
            return this._headerNames[i];
        }
    }

    private class WASParameters {
        private HashMap map = new HashMap();

        private WASParameters() {
        }

        void add(parameter p) {
            if (p != null) {
                String name2 = p.getName();
                String value2 = p.getValue();
                if (name2 != null && name2.length() > 0 && value2 != null) {
                    if (_tc.isDebugEnabled() && this.map.containsKey(name2)) {
                        Tr.debug(_tc, "WASParameters.add: The current value for parameter [" + name2 + "] of [" + this.map.get(name2) + "] is about to be replaced with the value [" + value2 + "]");
                    }
                    this.map.put(name2, value2);
                }
            }
        }

        void add(Map m) {
            if (m != null) {
                this.map.putAll(m);
            }
        }

        Map getMap() {
            return this.map;
        }
    }
}

