/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.etools.webservice.wsbnd.WSDescBinding;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.pmi.WebServicesPerf;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.soap.container.SoapContainerService;
import com.ibm.ws.webservices.WSConstants;
import com.ibm.ws.webservices.WebServicesServiceHome;
import com.ibm.ws.webservices.WebServicesSystemService;
import com.ibm.ws.webservices.component.JAXRPCMetaDataHelper;
import com.ibm.ws.webservices.component.JAXRPCMetaDataWrapper;
import com.ibm.ws.webservices.component.WSServerImpl;
import com.ibm.ws.webservices.configuration.WASWebServicesBindException;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.dispatchers.java.JavaBeanDispatcher;
import com.ibm.ws.webservices.metadata.ClientEntityMetaData;
import com.ibm.ws.webservices.metadata.ServerModuleMetaData;
import com.ibm.ws.webservices.metadata.ServerPortMetaData;
import com.ibm.ws.webservices.metadata.SysServerModuleMetaData;
import com.ibm.ws.webservices.pmi.modules.ModulePmiModule;
import com.ibm.ws.webservices.sysengine.SystemEngineRouter;
import com.ibm.ws.webservices.utils.ServiceRefPartialInfo;
import com.ibm.ws.webservices.wsdl.mapping.MappingMetaData;
import com.ibm.ws.webservices.xml.wassysapp.systemApp;
import com.ibm.ws.webservices.xml.wassysapp.systemAppPort;
import com.ibm.ws.webservices.xml.wassysapp.systemApps;
import com.ibm.ws.webservices.xml.wassysapp.systemAppsFactory;
import com.ibm.ws.wsaddressing.urimap.PortURIManager;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.webservices.models.WSModels;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;
import org.eclipse.wst.common.internal.emf.resource.EMF2SAXRendererFactory;
import org.osgi.framework.Bundle;
import org.xml.sax.InputSource;

public class WSSysServerImpl
extends ComponentImpl
implements WebServicesSystemService {
    private static final TraceComponent _tc;
    private static WSSysServerImpl singleton;
    private boolean loadedConfig = false;
    private Map serviceRefInfoMap = null;
    private SoapContainerService soapContainerService = null;

    public static WSSysServerImpl getWSSysServerImpl() {
        return singleton;
    }

    public EngineConfiguration getClientEngineConfig() {
        return null;
    }

    public ClientEntityMetaData getClientEntityMetaData() {
        return null;
    }

    public WebServicesPerf getPMIServicesModule() {
        return null;
    }

    public ModulePmiModule getPMIEndpointsModule() {
        return null;
    }

    public EngineConfiguration getServerEngineConfig() {
        EngineConfiguration configuration = null;
        SysServerModuleMetaData smmd = this.getSysServerModuleMetaData();
        if (smmd == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "com.ibm.ws.webservices.component.WSSysServerImpl.getServerEngineConfig(): ServerModuleMetaData is null");
            }
        } else {
            configuration = smmd.getConfiguration();
        }
        return configuration;
    }

    public boolean isClientWebServiceEnabled() {
        return false;
    }

    public boolean isRoleApplicableToService(int role2) {
        return true;
    }

    public boolean isServerWebServiceEnabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Object config) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initialize");
        }
        try {
            if (AdminServiceFactory.getAdminService().getProcessType().equals("DeploymentManager")) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Disabling component in DMGR process.");
                }
                throw new ComponentDisabledException();
            }
            this.addService(WebServicesSystemService.class, this);
            WebServicesServiceHome.setWebServicesSystemService(this);
            singleton = this;
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "initialize");
            }
        }
    }

    public void start() throws RuntimeWarning, RuntimeError {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "start");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "start");
        }
    }

    public void stop() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "stop");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "stop");
        }
    }

    public void loadConfiguration() {
        String epid;
        IExtensionPoint extensionPoint;
        if (this.loadedConfig) {
            return;
        }
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadConfiguration");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "CCL is currently: " + Thread.currentThread().getContextClassLoader());
        }
        this.getSOAPContainerService();
        String resourceName = "META-INF/was-sysapp.xml";
        ArrayList<Bundle> bundleList = new ArrayList<Bundle>();
        IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        if (registry != null && (extensionPoint = registry.getExtensionPoint(epid = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".sysapp")) != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Processing extension point " + epid);
            }
            HashSet<String> bundlesVisited = new HashSet<String>();
            IExtension[] extensions = extensionPoint.getExtensions();
            for (int i = 0; i < extensions.length; ++i) {
                String bundleName;
                Bundle bundle;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Processing extension " + extensions[i].getUniqueIdentifier());
                }
                if ((bundle = Platform.getBundle((String)extensions[i].getNamespace())) == null || bundlesVisited.contains(bundleName = bundle.getSymbolicName())) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Processing bundle " + bundleName);
                }
                bundlesVisited.add(bundleName);
                bundleList.add(bundle);
            }
        }
        CommonarchiveFactory archiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
        EMF2SAXRendererFactory.INSTANCE.setValidating(false);
        String installRoot = this.getInstallRootDir();
        boolean foundAConfigFile = false;
        for (int i = 0; i < bundleList.size(); ++i) {
            Bundle bundle = (Bundle)bundleList.get(i);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Processing bundle '" + bundle.getSymbolicName() + "', location '" + bundle.getLocation() + "'.");
            }
            URL sysappURL = bundle.getResource(resourceName);
            if (sysappURL == null) continue;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found sysapp config file: " + sysappURL.toString() + " within bundle '" + bundle.getSymbolicName() + "'.");
            }
            foundAConfigFile = true;
            systemApps sysAppsConfig = WSSysServerImpl.loadSysAppConfigXML(sysappURL);
            String jarFilename = this.getJarName(installRoot, bundle.getLocation());
            LoadStrategy loadStrategy = null;
            Archive archive = null;
            try {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "About to crack open jar: " + jarFilename);
                }
                ArchiveOptions options = new ArchiveOptions();
                options.setIsReadOnly(true);
                options.setUseJavaReflection(false);
                options.setDiscriminateNestedArchives(false);
                archive = archiveFactory.openArchive(options, jarFilename);
                loadStrategy = archive.getLoadStrategy();
            }
            catch (Exception e) {
                Tr.error(_tc, "internal.error", e);
            }
            if (loadStrategy == null) {
                Tr.error(_tc, "internal.error", "Can't create LoadStrategy for " + jarFilename);
                continue;
            }
            JAXRPCMetaDataWrapper wrapper = null;
            JAXRPCMetaDataHelper helper = new JAXRPCMetaDataHelper(archive, archive.getArchiveClassLoader());
            wrapper = helper.loadJAXRPCMetaData();
            if (wrapper == null || !wrapper.containsJAXRPCServices()) {
                Tr.error(_tc, "internal.error", "loadConfiguration: SysApp doesn't contain JAX-RPC port components.");
                continue;
            }
            WSBinding wsServerBinding = WSServerImpl.loadWebServicesBindingXML(loadStrategy, "META-INF/ibm-webservices-bnd.xmi");
            String appName = bundle.getSymbolicName();
            ArrayList smmdList = null;
            try {
                smmdList = WSSysServerImpl.createSysAppServerMetaDatas(appName, sysAppsConfig, wrapper.getWebServices(), wsServerBinding, loadStrategy, jarFilename, Thread.currentThread().getContextClassLoader(), wrapper.getJaxrpcPortComponents());
            }
            catch (ClassNotFoundException e1) {
                FFDCFilter.processException((Throwable)e1, "com.ibm.ws.webservices.component.WSSysServerImpl.loadConfiguration", "433", this);
                Tr.error(_tc, "internal.error", e1);
            }
            catch (IOException e1) {
                FFDCFilter.processException((Throwable)e1, "com.ibm.ws.webservices.component.WSSysServerImpl.loadConfiguration", "441", this);
                Tr.error(_tc, "internal.error", e1);
            }
            if (smmdList != null && !smmdList.isEmpty()) {
                Iterator iter = smmdList.iterator();
                while (iter.hasNext()) {
                    SysServerModuleMetaData smmd = (SysServerModuleMetaData)iter.next();
                    this.getSOAPContainerService().cacheMetaData(smmd.getModuleName(), smmd);
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "Caching SMMD object:  key=" + smmd.getModuleName() + ", value=" + smmd.toString());
                }
            } else {
                Tr.error(_tc, "internal.error", "loadConfiguration: no ServerModuleMetaData objects returned!");
            }
            archive.close();
            loadStrategy = null;
        }
        if (foundAConfigFile) {
            this.getSOAPContainerService().registerRouter(new SystemEngineRouter());
        }
        this.loadedConfig = true;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadConfiguration");
        }
    }

    private String getInstallRootDir() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getInstallRootDir");
        }
        String s = null;
        try {
            VariableMap vmap = (VariableMap)WsServiceRegistry.getService(this, VariableMap.class);
            s = vmap.expand("${WAS_INSTALL_ROOT}");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (s == null || s.length() == 0) {
            s = System.getProperty("was.install.root");
        }
        if (_tc.isEntryEnabled()) {
            Tr.debug(_tc, "Returning WAS install root directory: " + s);
            Tr.exit(_tc, "getInstallRootDir");
        }
        return s;
    }

    private String getJarName(String installRoot, String bundleLocation) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getJarName", "installRoot=" + installRoot + ", bundleLocation=" + bundleLocation);
        }
        StringBuffer s = new StringBuffer();
        s.append(installRoot);
        s.append(File.separator);
        int i = bundleLocation.indexOf(64);
        if (i >= 0) {
            String t = bundleLocation.substring(i + 1);
            s.append(t);
        } else {
            s.append(bundleLocation);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getJarName", "jarName = '" + s.toString() + "'.");
        }
        return s.toString();
    }

    public SoapContainerService getSOAPContainerService() {
        if (this.soapContainerService == null) {
            this.soapContainerService = (SoapContainerService)this.getService(SoapContainerService.class);
            if (this.soapContainerService == null) {
                Tr.error(_tc, "internal.error", "com.ibm.ws.webservices.component.WSSysServerImpl.getSOAPContainerService: Could not get service for SoapContainerService.class");
            }
        }
        return this.soapContainerService;
    }

    static systemApps loadSysAppConfigXML(URL sysappConfigurationFile) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "About to load sysapp config xml file: " + sysappConfigurationFile.toString());
        }
        InputStream configInputStream = null;
        systemApps returnSystemApps = null;
        try {
            configInputStream = sysappConfigurationFile.openStream();
        }
        catch (IOException e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.component.WSSysServerImpl.loadSysAppConfigXML", "426");
            Tr.error(_tc, "internal.error", e);
        }
        if (configInputStream != null) {
            systemAppsFactory sysappsFactory = new systemAppsFactory();
            sysappsFactory.setPackageName("com.ibm.ws.webservices.xml.wassysapp");
            returnSystemApps = (systemApps)sysappsFactory.loadDocument("systemApps", new InputSource(configInputStream));
        }
        return returnSystemApps;
    }

    static ArrayList createSysAppServerMetaDatas(String applicationArchiveName, systemApps sysAppsConfig, WebServices wsServerDD, WSBinding wsServerBinding, LoadStrategy loadStrategy, String absolutePathToArchive, ClassLoader classLoader, List jaxrpcPortComponents) throws ClassNotFoundException, IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createSysAppServerMetaData");
        }
        ArrayList<ServerModuleMetaData> smmdList = new ArrayList<ServerModuleMetaData>();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Inside createSysAppServerMetaData, CCL = " + Thread.currentThread().getContextClassLoader());
        }
        String applicationName = applicationArchiveName;
        int wsDescriptionCount = wsServerDD.getWebServiceDescriptions().size();
        block0: for (int i = 0; i < wsDescriptionCount; ++i) {
            ServerModuleMetaData smmd = null;
            String moduleName = null;
            WebServiceDescription wsDescription = (WebServiceDescription)wsServerDD.getWebServiceDescriptions().get(i);
            MappingMetaData j2wMapping = WSServerImpl.loadJavaWsdlMappingXML(loadStrategy, wsDescription.getJaxrpcMappingFile());
            if (j2wMapping == null) {
                Object[] params = new Object[]{wsDescription.getJaxrpcMappingFile(), wsDescription.getWebServiceDescriptionName(), "WEB-INF/webservices.xml", absolutePathToArchive, applicationName};
                Tr.error(_tc, "mappingFile.not.found", params);
                continue;
            }
            String wsWsdlFilename = wsDescription.getWsdlFile();
            WSDescBinding wsbDescription = WSServerImpl.findWsDescBinding("META-INF/ibm-webservices-bnd.xmi", wsServerBinding, wsDescription);
            int wsPortComponentCount = wsDescription.getPortComponents().size();
            for (int wsPortComponentIdx = 0; wsPortComponentIdx < wsPortComponentCount; ++wsPortComponentIdx) {
                PortComponent wsPortComponent = (PortComponent)wsDescription.getPortComponents().get(wsPortComponentIdx);
                String portComponentName = wsPortComponent.getPortComponentName();
                if (!jaxrpcPortComponents.contains(portComponentName)) {
                    if (!_tc.isDebugEnabled() || !_tc.isDebugEnabled()) continue block0;
                    Tr.debug(_tc, "The port component: " + portComponentName + " in the module: " + moduleName + " is not a JAX-RPC port component.");
                    continue block0;
                }
                String wsServletLink = wsPortComponent.getServiceImplBean().getEServletLink().getServletLink();
                systemApp sysAppConfig = WSSysServerImpl.findSysappForServlet(wsServletLink, sysAppsConfig);
                if (sysAppConfig == null) {
                    Tr.warning(_tc, "warning.servlet.link.not.found", new Object[]{wsServletLink, portComponentName});
                    continue;
                }
                systemAppPort sysAppPort = WSSysServerImpl.findSysappPort(wsServletLink, sysAppsConfig);
                if (sysAppPort == null) {
                    Tr.warning(_tc, "warning.servlet.link.not.found", new Object[]{wsServletLink, portComponentName});
                    continue;
                }
                if (smmd == null) {
                    moduleName = sysAppConfig.getSystemAppName();
                    smmd = new SysServerModuleMetaData(applicationName, moduleName);
                    smmdList.add(smmd);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Created SysServerModuleMetaData: appName=" + applicationName + ", moduleName=" + moduleName);
                    }
                }
                String servletImplName = sysAppPort.getServletClass();
                ServerPortMetaData port2 = smmd.getPort(portComponentName, true);
                port2.setServletName(sysAppPort.getServletName());
                String urlPattern2 = sysAppPort.getUrlPattern();
                if (urlPattern2 != null) {
                    port2.setURLPattern(urlPattern2, false);
                } else {
                    port2.setURLPattern("/services/" + portComponentName, true);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "System Application:  App(" + applicationName + ")" + " Mod(" + moduleName + ")" + " Service(" + portComponentName + ")" + " ServiceName(" + port2.getWsddPort().getName() + ")");
                }
                String wsdlFilePath = WSServerImpl.buildWSDLPath(absolutePathToArchive, wsWsdlFilename);
                WSServerImpl.setupWsddPort(port2.getWsddPort(), wsbDescription, classLoader, servletImplName, wsPortComponent, WSServerImpl.createWSDDGen(j2wMapping, wsdlFilePath, loadStrategy.getContainer().getInputStream(wsWsdlFilename)));
                port2.getWsddPort().setDispatcherQName(WSConstants.QNAME_JAVARPC_DISPATCHER);
                JavaBeanDispatcher.setClassName(port2.getWsddPort(), servletImplName);
                List allowedMethods = WSServerImpl.getAllowedMethods(classLoader, wsPortComponent.getServiceEndpointInterface());
                port2.getWsddPort().setAllowedMethods(allowedMethods);
                port2.getWsddPort().validateDescriptors();
                if (_tc.isDebugEnabled()) {
                    port2.getWsddPort().dump();
                }
                PortURIManager.addSysAppPortMappings(moduleName, wsDescription.getWebServiceDescriptionName(), port2.getWsddPort().getQName(), port2.getURLPattern());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createSysAppServerMetaData");
        }
        return smmdList;
    }

    private static systemAppPort findSysappPort(String servletLink, systemApps sysAppsConfig) {
        for (int j = 0; j < sysAppsConfig.getsystemAppCount(); ++j) {
            systemApp sysAppConfig = sysAppsConfig.getSystemApp(j);
            for (int i = 0; i < sysAppConfig.getsystemAppPortCount(); ++i) {
                String sysappServletLink = sysAppConfig.getSystemAppPort(i).getServletName();
                if (sysappServletLink == null || !sysappServletLink.equals(servletLink)) continue;
                return sysAppConfig.getSystemAppPort(i);
            }
        }
        return null;
    }

    private static systemApp findSysappForServlet(String servletLink, systemApps sysAppsConfig) {
        for (int j = 0; j < sysAppsConfig.getsystemAppCount(); ++j) {
            systemApp sysAppConfig = sysAppsConfig.getSystemApp(j);
            for (int i = 0; i < sysAppConfig.getsystemAppPortCount(); ++i) {
                String sysappServletLink = sysAppConfig.getSystemAppPort(i).getServletName();
                if (sysappServletLink == null || !sysappServletLink.equals(servletLink)) continue;
                return sysAppConfig;
            }
        }
        return null;
    }

    private SysServerModuleMetaData getSysServerModuleMetaData() {
        return (SysServerModuleMetaData)this.getSOAPContainerService().getMetaData();
    }

    public ServerModuleMetaData getServerModuleMetaData() {
        return null;
    }

    public ServiceRefPartialInfo getServiceRefInfo(String portComponentName, ModuleMetaData mmd) {
        return null;
    }

    public void setServiceRefInfo(Map serviceRefInfoMap, ModuleMetaData mmd) {
        this.serviceRefInfoMap = serviceRefInfoMap;
    }

    public void bindServiceRef(J2EEName name2, ClassLoader classLoader, LoadStrategy loadStrategy, ModuleMetaData moduleMetaData, Context javaColonCompEnvContext, List serviceRefs) throws WASWebServicesBindException, RuntimeError {
    }

    static {
        WSModels.init();
        _tc = Tr.register(WSSysServerImpl.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
        singleton = null;
    }
}

