/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.util.utilHandlerClass;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipFile;

public class URLHandlerFactory
implements URLStreamHandlerFactory {
    private static final TraceComponent tc = Tr.register(URLHandlerFactory.class, "Runtime", "com.ibm.ws.runtime.runtime");
    private Map streamHandlerTable;

    public URLHandlerFactory() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "URLHandlerFactory ctor");
        }
        this.streamHandlerTable = new HashMap();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "URLHandlerFactory ctor");
        }
    }

    public void registerProvider(String protocol2, String classpath) {
        String classname = URLHandlerFactory.getClassName(classpath);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerProvider " + protocol2 + " : " + classname);
        }
        if (protocol2 != null && classname != null) {
            this.streamHandlerTable.put(protocol2, new utilHandlerClass(classname, classpath));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerProvider(provider,class)");
        }
    }

    public void deregisterProvider(String protocol2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deregisterProvider");
        }
        if (protocol2 != null) {
            this.streamHandlerTable.remove(protocol2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deregisterProvider");
        }
    }

    public boolean queryProvider(String protocol2) {
        Tr.entry(tc, "queryProvider");
        boolean result = false;
        if (protocol2 != null) {
            result = this.streamHandlerTable.containsKey(protocol2);
        }
        Tr.exit(tc, "queryProvider");
        return result;
    }

    public URLStreamHandler createURLStreamHandler(String protocol2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createURLStreamHandler for protocol=" + protocol2);
        }
        URLStreamHandler handler2 = null;
        if (protocol2 != null && protocol2.length() > 0) {
            protocol2 = protocol2.toLowerCase();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "streamHandlerTable=" + this.streamHandlerTable);
            }
            utilHandlerClass hc = (utilHandlerClass)this.streamHandlerTable.get(protocol2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "handler class " + hc + " retrieved from streamHandlerTable");
            }
            if (hc != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found a handlerClass object for " + protocol2);
                }
                if (hc.getClassname() != null) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "attempting to get a class loader for " + hc.getClasspath());
                        }
                        ClassLoader cl = URLHandlerFactory.getResourceClassLoader(tc, hc.getClasspath(), null);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Attempting to load " + hc.getClassname());
                        }
                        Class<?> streamhandlerClass = cl.loadClass(hc.getClassname());
                        handler2 = (URLStreamHandler)streamhandlerClass.newInstance();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found streamHandlerClass " + hc.getClassname() + " for protocol " + protocol2);
                        }
                    }
                    catch (Throwable t) {
                        String[] parms = new String[]{hc.getClassname(), protocol2};
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "URLStreamHandlerError " + t.toString() + " " + hc.getClassname() + " " + protocol2);
                        }
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not find streamHandlerClass for: " + protocol2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createURLStreamHandler returning handler:" + handler2);
        }
        return handler2;
    }

    public static String getClassName(String providerClasspath) {
        String classname = new String(providerClasspath);
        classname = classname.replace(File.pathSeparatorChar, '.');
        return classname;
    }

    public static String appendClasspathStrings(String s1, String s2) {
        if (!URLHandlerFactory.isStringEmpty(s1)) {
            s1 = s1.trim();
        }
        if (!URLHandlerFactory.isStringEmpty(s2)) {
            s2 = s2.trim();
        }
        if (!URLHandlerFactory.isStringEmpty(s2)) {
            if (URLHandlerFactory.isStringEmpty(s1)) {
                return s2;
            }
            if (s1.endsWith(File.pathSeparator)) {
                return s1 + s2;
            }
            return s1 + File.pathSeparator + s2;
        }
        return s1;
    }

    public static boolean isStringEmpty(String s) {
        return s == null || s.length() <= 0;
    }

    public static ClassLoader getResourceClassLoader(TraceComponent tc, String classpath, ClassLoader parent) throws MalformedURLException {
        ClassLoader classloader = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceClassLoader " + classpath + " : " + parent);
        }
        if (classpath == null || classpath.equalsIgnoreCase("")) {
            classloader = Thread.currentThread().getContextClassLoader();
            if (classloader == null) {
                classloader = ClassLoader.getSystemClassLoader();
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parsing urls classpath=" + classpath);
            }
            StringTokenizer st = new StringTokenizer(classpath.trim(), File.pathSeparator);
            ArrayList<String> entries = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String urlString = st.nextToken().trim();
                if (urlString.equals("")) continue;
                entries.add(urlString);
            }
            URL[] urls = URLHandlerFactory.toLocalURLs(entries, File.separator);
            StringBuffer msgurls = new StringBuffer();
            for (int i = 0; i < urls.length; ++i) {
                msgurls.append("\n       " + urls[i]);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadingurls: " + msgurls.toString());
            }
            classloader = parent == null ? new URLClassLoader(urls, Thread.currentThread().getContextClassLoader()) : new URLClassLoader(urls, parent);
        }
        return classloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL[] toLocalURLs(List entries, String uriRoot) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (int i = 0; i < entries.size(); ++i) {
            String pathEntry = (String)entries.get(i);
            File aFile = new File(pathEntry);
            if (!aFile.isAbsolute()) {
                pathEntry = URLHandlerFactory.getOSUri(uriRoot, pathEntry);
                aFile = new File(pathEntry);
            }
            if (!aFile.exists()) continue;
            if (aFile.isDirectory()) {
                if (!pathEntry.endsWith(File.separator)) {
                    pathEntry = pathEntry + File.separatorChar;
                }
            } else {
                ZipFile zip = null;
                try {
                    zip = new ZipFile(aFile);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    continue;
                }
                finally {
                    if (zip != null) {
                        try {
                            zip.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
            }
            try {
                aFile = new File(pathEntry);
                URL aUrl = aFile.toURL();
                urls.add(aUrl);
                continue;
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        URL[] urlArray = new URL[urls.size()];
        return urls.toArray(urlArray);
    }

    public static String getOSUri(String directoryname, String filename) {
        String osDirName = URLHandlerFactory.getOSUri(directoryname);
        String osFileName = URLHandlerFactory.getOSUri(filename);
        return URLHandlerFactory.concatUri(osDirName, osFileName, File.separatorChar);
    }

    public static String getOSUri(String uri) {
        char sep = File.separatorChar;
        if (sep != '/') {
            return uri.replace('/', sep);
        }
        return uri.replace('\\', sep);
    }

    public static String concatUri(String directoryname, String filename, char separator) {
        String uri = directoryname;
        if (!directoryname.endsWith(separator + "") && !filename.startsWith(separator + "")) {
            uri = uri + separator;
        }
        return uri + filename;
    }
}

