/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ws.util.ClauseNode;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class URIMatcher {
    protected ClauseNode root;
    protected HashMap extensions = new HashMap();
    protected final int star = URIMatcher.computeHash("*");
    protected ClauseNode defaultNode;
    private boolean scalable;
    protected static int range = 91;

    public static int computeHash(String key) {
        int hash = 0;
        for (int i = 0; i < key.length(); ++i) {
            hash = hash * range + key.charAt(i);
        }
        return hash;
    }

    public URIMatcher() {
        this(false);
    }

    public URIMatcher(boolean scalable) {
        this.scalable = scalable;
        this.init();
    }

    public URIMatcher(boolean scalable, int r) {
        this.scalable = scalable;
        range = r;
        this.init();
    }

    URIMatcher(String file) throws Exception {
        this();
        BufferedReader in = new BufferedReader(new FileReader(file));
        String line = in.readLine();
        while (line != null) {
            if (line.equals("")) {
                line = in.readLine();
                continue;
            }
            StringTokenizer tok = new StringTokenizer(line);
            String tok1 = tok.nextToken();
            String tok2 = tok.nextToken();
            this.put(tok1, tok2);
            line = in.readLine();
        }
        in.close();
    }

    private void init() {
        if (this.root == null) {
            this.root = new ClauseNode("/", null, this.scalable);
        }
    }

    public void put(String uri, Object target) throws Exception {
        if (uri.startsWith("*.")) {
            this.extensions.put(uri.substring(2), target);
            return;
        }
        if (!uri.startsWith("/")) {
            uri = "/" + uri;
        }
        StringBuffer clause = new StringBuffer();
        ClauseNode currentNode = this.root;
        int len = uri.length();
        for (int i = 1; i < len; ++i) {
            if (uri.charAt(i) == '/') {
                currentNode = currentNode.add(new ClauseNode(clause.toString(), null, this.scalable));
                clause.delete(0, clause.length());
                continue;
            }
            if (i == len - 1) {
                clause.append(uri.charAt(i));
                currentNode = currentNode.add(new ClauseNode(clause.toString(), target, this.scalable));
                continue;
            }
            clause.append(uri.charAt(i));
        }
        this.defaultNode = this.root.traverse(this.star);
    }

    public Iterator iterator() {
        List l = this.root.targets();
        l.addAll(this.extensions.values());
        return l.listIterator();
    }

    public Object match(String uri) {
        ClauseNode currentNode = this.root;
        ClauseNode prevNode = this.root;
        ClauseNode starNode = null;
        ClauseNode temp = null;
        boolean exact = true;
        int len = uri.length();
        int hash = 0;
        for (int i = 1; i < len; ++i) {
            char c = uri.charAt(i);
            if (c == '/') {
                if ((currentNode = currentNode.traverse(hash)) == null) {
                    exact = false;
                    break;
                }
                temp = prevNode.traverse(this.star);
                if (temp != null) {
                    starNode = temp;
                }
                prevNode = currentNode;
                hash = 0;
                continue;
            }
            if (i == len - 1) {
                if ((currentNode = currentNode.traverse(hash = range * hash + c)) != null) continue;
                exact = false;
                continue;
            }
            hash = range * hash + c;
        }
        Object target = null;
        if (exact) {
            target = currentNode.getTarget();
            if (target != null) {
                return target;
            }
            temp = currentNode.traverse(this.star);
            if (temp != null && (target = temp.getTarget()) != null) {
                return target;
            }
        }
        if ((temp = prevNode.traverse(this.star)) != null) {
            starNode = temp;
        }
        if (starNode != null && starNode != this.defaultNode) {
            return starNode.getTarget();
        }
        int dot = uri.lastIndexOf(".");
        if (dot != -1 && (target = this.extensions.get(uri.substring(dot + 1))) != null) {
            return target;
        }
        if (starNode != null) {
            return starNode.getTarget();
        }
        return null;
    }

    public List matchAll(String uri) {
        Object tar;
        ClauseNode currentNode = this.root;
        ClauseNode prevNode = this.root;
        ClauseNode starNode = null;
        ClauseNode temp = null;
        ArrayList<Object> returnList = new ArrayList<Object>();
        int dot = uri.lastIndexOf(".");
        if (dot != -1 && (tar = this.extensions.get(uri.substring(dot + 1))) != null) {
            returnList.add(tar);
        }
        boolean exact = true;
        int len = uri.length();
        int hash = 0;
        for (int i = 1; i < len; ++i) {
            char c = uri.charAt(i);
            if (c == '/') {
                if ((currentNode = currentNode.traverse(hash)) == null) {
                    exact = false;
                    break;
                }
                temp = prevNode.traverse(this.star);
                if (temp != null) {
                    if (temp.getTarget() != null) {
                        returnList.add(temp.getTarget());
                    }
                    starNode = temp;
                }
                prevNode = currentNode;
                hash = 0;
                continue;
            }
            if (i == len - 1) {
                if ((currentNode = currentNode.traverse(hash = range * hash + c)) != null) continue;
                exact = false;
                continue;
            }
            hash = range * hash + c;
        }
        if ((temp = prevNode.traverse(this.star)) != null && temp.getTarget() != null) {
            returnList.add(temp.getTarget());
        }
        Object target = null;
        if (exact) {
            target = currentNode.getTarget();
            if (target != null) {
                returnList.add(target);
                return returnList;
            }
            temp = currentNode.traverse(this.star);
            if (temp != null && (target = temp.getTarget()) != null) {
                returnList.add(target);
                return returnList;
            }
        }
        return returnList;
    }

    public void remove(String path) {
        if (path.startsWith("*.")) {
            this.extensions.remove(path.substring(2));
        }
        this.root.remove(path);
    }

    public static void main(String[] args) {
        try {
            URIMatcher t = new URIMatcher();
            t.put("/portal/*", new String("/portal/* target"));
            t.put("/portal/abc/xyz/*", new String("/portal/abc/xyz/* target1"));
            t.put("/exact/exact.jsp", new String("/exact/exact.jsp"));
            List l = t.matchAll("/portal/abc/xyz/blah.jsp");
            Iterator it = l.iterator();
            while (it.hasNext()) {
                System.out.println("out:" + it.next());
            }
            l = t.matchAll("/exact/exact.jsp");
            it = l.iterator();
            while (it.hasNext()) {
                System.out.println("out:" + it.next());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object replace(String uri, Object newTarget) throws Exception {
        ClauseNode currentNode = this.root;
        ClauseNode prevNode = this.root;
        ClauseNode starNode = null;
        ClauseNode temp = null;
        boolean exact = true;
        int len = uri.length();
        int hash = 0;
        for (int i = 1; i < len; ++i) {
            char c = uri.charAt(i);
            if (c == '/') {
                if ((currentNode = currentNode.traverse(hash)) == null) {
                    exact = false;
                    break;
                }
                temp = prevNode.traverse(this.star);
                if (temp != null) {
                    starNode = temp;
                }
                prevNode = currentNode;
                hash = 0;
                continue;
            }
            if (i == len - 1) {
                if ((currentNode = currentNode.traverse(hash = range * hash + c)) != null) continue;
                exact = false;
                continue;
            }
            hash = range * hash + c;
        }
        Object target = null;
        if (exact) {
            target = currentNode.getTarget();
            if (target != null) {
                currentNode.setTarget(newTarget);
                return target;
            }
            throw new Exception("No target to replace at given node");
        }
        int dot = uri.lastIndexOf(".");
        if (dot != -1 && (target = this.extensions.get(uri.substring(dot + 1))) != null) {
            this.extensions.put(uri.substring(dot + 1), newTarget);
            return target;
        }
        throw new Exception("No exact matching path found to replace");
    }

    public boolean exists(String uri) {
        ClauseNode currentNode = this.root;
        ClauseNode prevNode = this.root;
        ClauseNode starNode = null;
        ClauseNode temp = null;
        boolean exact = true;
        int len = uri.length();
        int hash = 0;
        for (int i = 1; i < len; ++i) {
            char c = uri.charAt(i);
            if (c == '/') {
                if ((currentNode = currentNode.traverse(hash)) == null) {
                    exact = false;
                    break;
                }
                temp = prevNode.traverse(this.star);
                if (temp != null) {
                    starNode = temp;
                }
                prevNode = currentNode;
                hash = 0;
                continue;
            }
            if (i == len - 1) {
                if ((currentNode = currentNode.traverse(hash = range * hash + c)) != null) continue;
                exact = false;
                continue;
            }
            hash = range * hash + c;
        }
        Object target = null;
        if (exact) {
            return true;
        }
        return this.extensions.get(uri) != null;
    }
}

