/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.core;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.ssl.JSSEProvider;
import com.ibm.ws.ssl.JSSEProviderFactory;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.util.Stack;
import java.util.prefs.Preferences;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public final class WSPKCSInKeyStore {
    private static final TraceComponent tc = Tr.register(WSPKCSInKeyStore.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private KeyManagerFactory kmf;
    private KeyStore ks;
    private TrustManagerFactory tmf;
    private KeyStore ts;
    private JSSEProvider jsseProvider = null;
    private static Provider hwProvider = null;
    private String tokenLib_key;
    private String tokenType_key;
    private String tokenLib_trust;
    private String tokenType_trust;
    private static String pkcsType = "PKCS11IMPLKS";
    private static String pkcsProvider = "IBMPKCS11Impl";
    public static final int DEFAULT_SLOT = 0;
    public static final int SLOT_NOT_SPECIFIED = -1;
    private Stack providerInstancePool = new Stack();
    private int noOfWorkerThreads = 0;
    private int noOfProvidersCreated = 0;
    private BufferedReader fileReader = null;
    private StringBuffer tokenConfigBuffer = new StringBuffer();
    private String nameAttribute = null;

    public WSPKCSInKeyStore(String tokenLibraryFile, String tokenPassword) throws Exception {
        this.initializePKCS11ImplProvider(tokenLibraryFile, tokenPassword);
    }

    public WSPKCSInKeyStore(String tokenConfigName) throws Exception {
        this.initializePKCS11ImplProvider(tokenConfigName);
    }

    public void asKeyStore(String tokenType, String tokenlib, String tokenPwd, String contextProvider, boolean pureAcceleration) throws Exception {
        if ("IBMPKCS11Impl".equalsIgnoreCase(contextProvider)) {
            contextProvider = hwProvider.getName();
        }
        this.jsseProvider = JSSEProviderFactory.getInstance(contextProvider);
        try {
            if (this.tokenLib_key != null && this.tokenLib_key.compareToIgnoreCase(tokenlib) == 0 && this.ks != null) {
                return;
            }
            if (this.tokenLib_trust != null && tokenlib.compareTo(this.tokenLib_trust) == 0 && this.ts != null) {
                this.kmf = this.jsseProvider.getKeyManagerFactoryInstance();
                this.ks = this.ts;
                if (!pureAcceleration) {
                    this.kmf.init(this.ts, tokenPwd.toCharArray());
                }
            } else {
                this.kmf = this.jsseProvider.getKeyManagerFactoryInstance();
                this.ks = KeyStore.getInstance(pkcsType, hwProvider.getName());
                if (!pureAcceleration) {
                    this.ks.load(null, tokenPwd.toCharArray());
                    this.kmf.init(this.ks, tokenPwd.toCharArray());
                }
            }
            this.tokenLib_key = new String(tokenlib);
            this.tokenType_key = new String(tokenType);
        }
        catch (Exception e) {
            this.kmf = null;
            this.ks = null;
            this.tokenLib_key = null;
            this.tokenType_key = null;
            throw e;
        }
    }

    public void asTrustStore(String tokenType, String tokenlib, String tokenPwd, String contextProvider, boolean pureAcceleration) throws Exception {
        this.jsseProvider = JSSEProviderFactory.getInstance(contextProvider);
        try {
            if (this.tokenLib_trust != null && this.tokenLib_trust.compareToIgnoreCase(tokenlib) == 0 && this.ts != null) {
                return;
            }
            if (this.tokenLib_key != null && tokenlib.compareTo(this.tokenLib_key) == 0 && this.ks != null) {
                this.tmf = this.jsseProvider.getTrustManagerFactoryInstance();
                this.ts = this.ks;
                if (!pureAcceleration) {
                    this.tmf.init(this.ks);
                }
            } else {
                this.tmf = this.jsseProvider.getTrustManagerFactoryInstance();
                this.ts = KeyStore.getInstance(pkcsType, hwProvider.getName());
                if (!pureAcceleration) {
                    this.ts.load(null, tokenPwd.toCharArray());
                    this.tmf.init(this.ts);
                }
            }
            this.tokenLib_trust = new String(tokenlib);
            this.tokenType_trust = new String(tokenType);
        }
        catch (Exception e) {
            this.tmf = null;
            this.ts = null;
            this.tokenLib_trust = null;
            this.tokenType_trust = null;
            throw e;
        }
    }

    public KeyManagerFactory getKMF() {
        return this.kmf;
    }

    public KeyStore getKS() {
        return this.ks;
    }

    public TrustManagerFactory getTMF() {
        return this.tmf;
    }

    public KeyStore getTS() {
        return this.ts;
    }

    public String getlibName_key() {
        return this.tokenLib_key;
    }

    public String getlibName_trust() {
        return this.tokenLib_trust;
    }

    public String gettokType_key() {
        return this.tokenType_key;
    }

    public String gettokType_trust() {
        return this.tokenType_trust;
    }

    public void initializePKCS11ImplProvider(String tokenLibraryFile, String tokenPassword) throws Exception {
        Provider pkcs11implProvider = Security.getProvider("IBMPKCS11Impl");
        if (pkcs11implProvider == null && tokenLibraryFile != null && tokenPassword != null) {
            Preferences prefs = Preferences.userNodeForPackage(IBMPKCS11Impl.class);
            prefs.put("IBMPKCSImpl DLL", tokenLibraryFile);
            prefs.put("IBMPKCSImpl password", tokenPassword);
            AddHardwareProviderAction action = new AddHardwareProviderAction();
            try {
                AccessController.doPrivileged(action);
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.security.orbssl.WSPKCSInKeyStore", "249");
                throw e;
            }
            finally {
                if (prefs != null) {
                    prefs.remove("IBMPKCSImpl DLL");
                    prefs.remove("IBMPKCSImpl password");
                }
            }
            pkcs11implProvider = Security.getProvider("IBMPKCS11Impl");
        }
    }

    public void initializePKCS11ImplProvider(String tokenConfigName) throws Exception {
        final String configFile = tokenConfigName;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    hwProvider = (Provider)new IBMPKCS11Impl(configFile);
                    Security.addProvider(hwProvider);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The provider: " + hwProvider + "is added at the end of the provider list");
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot initialize IBMPKCS11Impl provider: ", new Object[]{ex});
            }
            Manager.Ffdc.log(ex, this, "com.ibm.ws.security.orbssl.WSPKCSInKeyStore", "259");
            throw ex;
        }
        BufferedReader buf = this.convertFileToBuffer(tokenConfigName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Provider getHWCryptoProviderInstance(String tokenConfigName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHWCryptoProviderInstance(String)");
        }
        Stack stack = this.providerInstancePool;
        synchronized (stack) {
            if (!this.providerInstancePool.empty()) {
                Provider p;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "try to get the HW crypto provider instance from pool");
                }
                if ((p = (Provider)this.providerInstancePool.pop()) != null) {
                    return p;
                }
            }
        }
        ++this.noOfProvidersCreated;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "continue creating new HW crypto provider instance");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.nameAttribute).append(this.noOfProvidersCreated).append(LINE_SEPARATOR).append(this.tokenConfigBuffer);
        BufferedReader buf = new BufferedReader(new StringReader(sb.toString()));
        try {
            return new IBMPKCS11Impl(buf);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot get the HW crypto provider instance" + new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.core.WSPKCSInKeyStore.getHWCryptoProviderInstance", "273", this);
            Tr.error(tc, "Cannot get the HW crypto provider instance", new Object[]{tokenConfigName, e.getMessage()});
            throw e;
        }
    }

    private BufferedReader convertFileToBuffer(String tokenConfigName) throws Exception {
        StringBuffer sb = new StringBuffer();
        String inLine = null;
        try {
            if (this.fileReader == null) {
                this.fileReader = new BufferedReader(new FileReader(tokenConfigName));
                try {
                    while ((inLine = this.fileReader.readLine()) != null) {
                        String str = inLine.trim();
                        if (str.startsWith("name")) {
                            this.nameAttribute = str;
                            continue;
                        }
                        this.tokenConfigBuffer.append(str).append(LINE_SEPARATOR);
                    }
                }
                catch (IOException ioe) {
                    Manager.Ffdc.log(ioe, this, "com.ibm.ws.security.orbssl.WSPKCSInKeyStore", "333");
                    throw ioe;
                }
                finally {
                    if (this.fileReader != null) {
                        try {
                            this.fileReader.close();
                        }
                        catch (IOException ioe) {
                            Manager.Ffdc.log(ioe, this, "com.ibm.ws.security.orbssl.WSPKCSInKeyStore", "342");
                            throw ioe;
                        }
                    }
                }
            }
            sb.append(this.nameAttribute).append(this.noOfProvidersCreated).append(LINE_SEPARATOR).append(this.tokenConfigBuffer);
        }
        catch (FileNotFoundException fne) {
            Manager.Ffdc.log(fne, this, "com.ibm.ws.security.orbssl.WSPKCSInKeyStore", "352");
            throw fne;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Name attribute and other card related info: " + this.nameAttribute + ":" + this.tokenConfigBuffer.toString());
        }
        return new BufferedReader(new StringReader(sb.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Provider getHWCryptoProviderInstance(String tokenLib, String tokenSlot) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHWCryptoProviderInstance(String, String)");
        }
        Stack stack = this.providerInstancePool;
        synchronized (stack) {
            if (!this.providerInstancePool.empty()) {
                Provider p;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "try to get the HW crypto provider instance from pool");
                }
                if ((p = (Provider)this.providerInstancePool.pop()) != null) {
                    return p;
                }
            }
        }
        ++this.noOfProvidersCreated;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "continue creating new HW provider instance");
        }
        StringBuffer buf = new StringBuffer();
        String uniqueName = "thread-" + this.noOfProvidersCreated;
        buf.append("name=" + uniqueName);
        buf.append(LINE_SEPARATOR);
        buf.append("library=" + tokenLib);
        buf.append(LINE_SEPARATOR);
        buf.append("slotListIndex=" + tokenSlot);
        buf.append(LINE_SEPARATOR);
        BufferedReader br = new BufferedReader(new StringReader(buf.toString()));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getting new HW crypto provider instance : " + buf.toString());
        }
        try {
            return new IBMPKCS11Impl(br);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot get the HW crypto provider instance" + new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.core.WSPKCSInKeyStore.getHWCryptoProviderInstance", "273", this);
            Tr.error(tc, "Cannot get the HW crypto provider instance", new Object[]{tokenLib, tokenSlot, e.getMessage()});
            throw e;
        }
    }

    public void returnHWCryptoProviderInstance(Provider providerInstance) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "returnHWCryptoProviderInstance()");
        }
        if (providerInstance != null) {
            this.providerInstancePool.push(providerInstance);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "returnHWCryptoProviderInstance()");
        }
    }

    static class AddHardwareProviderAction
    implements PrivilegedAction {
        public Object run() {
            Security.addProvider((Provider)new IBMPKCS11Impl());
            return null;
        }
    }
}

