/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.config.SSLConfigManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.List;
import java.util.Properties;

public class FIPSManager {
    private static final TraceComponent tc = Tr.register(FIPSManager.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static FIPSManager thisClass = null;
    private boolean fipsEnabled = false;

    private FIPSManager() {
    }

    public static FIPSManager getInstance() {
        if (thisClass == null) {
            thisClass = new FIPSManager();
        }
        return thisClass;
    }

    public boolean isFIPSEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFIPSEnabled");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFIPSEnabled -> " + this.fipsEnabled);
        }
        return this.fipsEnabled;
    }

    public void initializeFIPS() throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeFips");
        }
        try {
            String useFIPS = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String useFips = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.security.useFIPS");
                    if (useFips == null) {
                        useFips = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.jsse2.JSSEFIPS");
                    }
                    if (useFips == null) {
                        useFips = Security.getProperty("USEFIPS_ENABLED");
                    }
                    if (useFips == null) {
                        useFips = Security.getProperty("com.ibm.websphere.security.fips.enabled");
                    }
                    return useFips;
                }
            });
            if (useFIPS != null && useFIPS.equalsIgnoreCase("true")) {
                this.fipsEnabled = true;
                Security.setProperty("DEFAULT_JCE_PROVIDER", "IBMJCEFIPS");
                Security.setProperty("USEFIPS_ENABLED", "true");
                Security.setProperty("com.ibm.websphere.security.fips.enabled", "true");
                Tr.info(tc, "ssl.fips.enabled.CWPKI0012I");
                this.checkDefaultProviderListFromJavaSecurity();
                JSSEProviderFactory.initializeFips();
            } else {
                Security.setProperty("DEFAULT_JCE_PROVIDER", "IBMJCE");
                Security.setProperty("USEFIPS_ENABLED", "false");
                Security.setProperty("com.ibm.websphere.security.fips.enabled", "false");
            }
            Security.setProperty("com.ibm.websphere.security.fips.jsseProviders", "IBMJSSE2");
            Security.setProperty("com.ibm.websphere.security.fips.jceProviders", "IBMJCEFIPS");
        }
        catch (Exception e) {
            Tr.debug(tc, "Exception initializing FIPS.", new Object[]{e});
            Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.config.FIPSManager.initializeFIPS", "135", this);
            throw new SSLException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeFips");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDefaultProviderListFromJavaSecurity() {
        BufferedReader in = null;
        String s = null;
        String javaSecurityFile = null;
        boolean fipsFound = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkDefaultProviderListFromJavaSecurity");
        }
        if (System.getProperty("os.name").equals("OS/400")) {
            javaSecurityFile = System.getProperty("user.install.root") + File.separator + "properties" + File.separator + "java.security";
        } else {
            String javaHome = System.getProperty("java.home");
            javaSecurityFile = javaHome + File.separator + "lib" + File.separator + "security" + File.separator + "java.security";
        }
        try {
            in = new BufferedReader(new FileReader(javaSecurityFile));
            while ((s = in.readLine()) != null) {
                if (s.trim().startsWith("#") || s.trim().length() <= 0 || !s.trim().startsWith("security.provider")) continue;
                if (s.indexOf("com.ibm.crypto.fips.provider.IBMJCEFIPS") != -1) {
                    fipsFound = true;
                }
                if (s.indexOf("com.ibm.crypto.provider.IBMJCE") == -1) continue;
                if (fipsFound) {
                } else {
                    Tr.warning(tc, "ssl.checkProviderList.warning.CWPKI0013W");
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "In FIPS mode, IBMJCEFIPS provider is not found before the IBMJCE provider in the java.security file.");
                    }
                }
                break;
            }
        }
        catch (FileNotFoundException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "FileNotFoundException caught for " + javaSecurityFile);
            }
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught: " + ex.getMessage());
            }
        }
        finally {
            block28: {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block28;
                    Tr.debug(tc, "Exception caught: " + e.getMessage());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkDefaultProviderListFromJavaSecurity");
        }
    }

    private Properties getProperties(List props) {
        Properties oProps = new Properties();
        if (props != null) {
            for (int i = 0; i < props.size(); ++i) {
                Property p = (Property)props.get(i);
                oProps.put(p.getName(), p.getValue());
            }
        }
        return oProps;
    }
}

