/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.channel.impl.SSLBaseServiceContext;
import com.ibm.ws.ssl.channel.impl.SSLConnectionLink;
import com.ibm.ws.ssl.channel.impl.SSLHandshakeCompletedCallback;
import com.ibm.ws.ssl.channel.impl.SSLUtils;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;
import java.nio.ReadOnlyBufferException;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public class SSLWriteServiceContext
extends SSLBaseServiceContext
implements TCPWriteRequestContext,
TCPWriteCompletedCallback {
    protected static final TraceComponent tc = Tr.register(SSLWriteServiceContext.class, "SSLChannel", "com.ibm.ws.ssl.channel.resources.sslchannelmessages");
    private static final String CLASS_NAME = "com.ibm.ws.ssl.channel.impl.SSLWriteServiceContext";
    protected TCPWriteCompletedCallback callback = null;
    private WsByteBuffer encryptedAppBuffer = null;
    private TCPWriteRequestContext deviceWriteContext;
    private QueuedWork queuedWork = new QueuedWork();
    private MyHandshakeCompletedCallback handshakeCallback = new MyHandshakeCompletedCallback(this);

    public SSLWriteServiceContext(SSLConnectionLink connLink) {
        super(connLink);
    }

    public long write(long _numBytes, int timeout) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "write, numBytes=" + _numBytes + ", timeout=" + timeout + ", vc=" + this.getVCHash());
        }
        long numBytes = _numBytes;
        if (this.deviceWriteContext == null) {
            this.deviceWriteContext = this.getConnLink().getDeviceWriteInterface();
        }
        if (timeout == -2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Requested to timeout former request.  Calling device side.");
            }
            this.deviceWriteContext.write(numBytes, timeout);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "write");
            }
            return 0L;
        }
        IOException exception = this.checkForErrors(numBytes, false);
        if (exception != null) {
            throw exception;
        }
        long appBytesWritten = 0L;
        SSLEngineResult sslResult = null;
        long appBufferSizeBefore = WsByteBufferUtils.lengthOf(this.getBuffers());
        if (numBytes == -1L) {
            numBytes = appBufferSizeBefore;
        }
        if (SSLUtils.isHandshaking(this.getConnLink().getSSLEngine())) {
            try {
                sslResult = this.doHandshake(null);
            }
            catch (IOException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught during handshake, " + e);
                }
                FFDCFilter.processException((Throwable)e, CLASS_NAME, "84", this);
                throw e;
            }
            if (sslResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) {
                e = new IOException("Unable to complete SSLhandshake");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to complete SSLhandshake, " + e);
                }
                FFDCFilter.processException((Throwable)e, CLASS_NAME, "117", this);
                throw e;
            }
        }
        if ((exception = this.encryptMessage(numBytes)) == null) {
            int dataLengthToWrite = this.encryptedAppBuffer.remaining();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "write bytes: " + dataLengthToWrite);
            }
            long devBytesWritten = this.deviceWriteContext.write(dataLengthToWrite, timeout);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "wrote " + devBytesWritten + " bytes to the network");
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught during encryption, " + exception);
            }
            FFDCFilter.processException((Throwable)exception, CLASS_NAME, "109", this);
            throw exception;
        }
        appBytesWritten = appBufferSizeBefore - (long)WsByteBufferUtils.lengthOf(this.getBuffers());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "write");
        }
        return appBytesWritten;
    }

    public VirtualConnection write(long numBytes, TCPWriteCompletedCallback userCallback, boolean forceQueue, int timeout) {
        return this.write(numBytes, userCallback, forceQueue, timeout, false);
    }

    protected VirtualConnection write(long _numBytes, TCPWriteCompletedCallback userCallback, boolean forceQueue, int timeout, boolean fromQueue) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "writeAsync, numBytes=" + _numBytes + ", timeout=" + timeout + ", fromQueue=" + fromQueue + ", vc=" + this.getVCHash());
        }
        long numBytes = _numBytes;
        if (this.deviceWriteContext == null) {
            this.deviceWriteContext = this.getConnLink().getDeviceWriteInterface();
        }
        if (timeout == -2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Requested to timeout former request.  Calling device side.");
            }
            this.deviceWriteContext.write(numBytes, this, forceQueue, timeout);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "writeAsync");
            }
            return this.getVC();
        }
        IOException exceptionInRequest = this.checkForErrors(numBytes, true);
        if (exceptionInRequest != null) {
            if (forceQueue) {
                this.queuedWork.setErrorParameters(this.getConnLink().getVirtualConnection(), this, userCallback, exceptionInRequest);
                ChannelException errorCause = null;
                try {
                    int executeRc = this.getConnLink().getThreadPool().execute(this.queuedWork, 2);
                    if (executeRc != 0) {
                        errorCause = new ChannelException("threadpool at capacity, request rejected");
                    }
                }
                catch (ChannelException ce) {
                    errorCause = ce;
                }
                if (errorCause != null) {
                    FFDCFilter.processException((Throwable)errorCause, CLASS_NAME, "172", this);
                    userCallback.error(this.getConnLink().getVirtualConnection(), this, exceptionInRequest);
                }
            } else {
                userCallback.error(this.getConnLink().getVirtualConnection(), this, exceptionInRequest);
            }
            return null;
        }
        if (forceQueue) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Forcing write request to another thread, vc=" + this.getVCHash());
            }
            this.queuedWork.setWriteParameters(numBytes, userCallback, timeout);
            ChannelException errorCause = null;
            try {
                int executeRc = this.getConnLink().getThreadPool().execute(this.queuedWork, 2);
                if (executeRc != 0) {
                    errorCause = new ChannelException("threadpool at capacity, request rejected");
                }
            }
            catch (ChannelException ce) {
                errorCause = ce;
            }
            if (errorCause != null) {
                FFDCFilter.processException((Throwable)errorCause, CLASS_NAME, "294", this);
                userCallback.error(this.getConnLink().getVirtualConnection(), this, new IOException(errorCause.getMessage()));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "writeAsync");
            }
            return null;
        }
        this.callback = userCallback;
        if (numBytes == -1L) {
            numBytes = WsByteBufferUtils.lengthOf(this.getBuffers());
        }
        VirtualConnection vc = null;
        SSLEngineResult sslResult = null;
        if (SSLUtils.isHandshaking(this.getConnLink().getSSLEngine())) {
            this.handshakeCallback.setWriteParameters(numBytes, timeout);
            try {
                sslResult = this.doHandshake(this.handshakeCallback);
            }
            catch (IOException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught exception during SSL handshake, " + e);
                }
                FFDCFilter.processException((Throwable)e, CLASS_NAME, "152", this);
                this.callback.error(this.getConnLink().getVirtualConnection(), this, e);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "writeAsynch");
                }
                return null;
            }
            if (sslResult != null) {
                if (sslResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) {
                    e = new IOException("Unable to complete SSLhandshake");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unable to complete SSLhandshake, " + e);
                    }
                    FFDCFilter.processException((Throwable)e, CLASS_NAME, "157", this);
                    this.callback.error(this.getConnLink().getVirtualConnection(), this, e);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "writeAsynch");
                    }
                    return null;
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "writeAsynch");
                }
                return null;
            }
        }
        if ((vc = this.encryptAndWriteAsync(numBytes, false, timeout)) != null && fromQueue) {
            this.callback.complete(vc, this);
            vc = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "writeAsynch");
        }
        return vc;
    }

    private IOException checkForErrors(long numBytes, boolean async) {
        WsByteBuffer[] callerBuffers;
        IOException exception = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "checkForErrors: numBytes=" + numBytes + " buffers=" + SSLUtils.getBufferTraceInfo(this.getBuffers()));
        }
        if ((callerBuffers = this.getBuffers()) == null || callerBuffers.length == 0) {
            exception = new IOException("No buffer(s) provided for writing data.");
        } else if (numBytes < -1L || numBytes == 0L && async) {
            exception = new IOException("Number of bytes requested, " + numBytes + " is not valid.");
        } else {
            int bytesAvail = WsByteBufferUtils.lengthOf(callerBuffers);
            if ((long)bytesAvail < numBytes) {
                exception = new IOException("Number of bytes requested, " + numBytes + " exceeds space remaining in the buffers provided: " + bytesAvail);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && exception != null) {
            Tr.debug(tc, "Found error, exception generated: " + exception);
        }
        return exception;
    }

    public VirtualConnection encryptAndWriteAsync(long numBytes, boolean forceQueue, int timeout) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "encryptAndWriteAsync");
        }
        VirtualConnection vc = null;
        IOException exception = this.encryptMessage(numBytes);
        if (exception == null) {
            int dataLengthToWrite = this.encryptedAppBuffer.remaining();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "write bytes: " + dataLengthToWrite);
            }
            vc = this.deviceWriteContext.write(dataLengthToWrite, this, forceQueue, timeout);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught exception during encryption, " + exception);
            }
            this.callback.error(this.getConnLink().getVirtualConnection(), this, exception);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "encryptAndWriteAsync");
        }
        return vc;
    }

    private SSLEngineResult doHandshake(MyHandshakeCompletedCallback hsCallback) throws IOException {
        SSLEngineResult sslResult;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "doHandshake");
        }
        SSLEngine sslEngine = this.getConnLink().getSSLEngine();
        WsByteBuffer netBuffer = SSLUtils.allocateByteBuffer(sslEngine.getSession().getPacketBufferSize(), true);
        WsByteBuffer decryptedNetBuffer = SSLUtils.allocateByteBuffer(sslEngine.getSession().getApplicationBufferSize(), false);
        this.getEncryptedAppBuffer(1L);
        hsCallback.setNetBuffer(netBuffer);
        hsCallback.setDecryptedNetBuffer(decryptedNetBuffer);
        try {
            sslResult = SSLUtils.handleHandshake(this.getConnLink(), netBuffer, decryptedNetBuffer, this.encryptedAppBuffer, null, hsCallback, false);
        }
        catch (IOException e) {
            netBuffer.release();
            decryptedNetBuffer.release();
            throw e;
        }
        catch (ReadOnlyBufferException robe) {
            netBuffer.release();
            decryptedNetBuffer.release();
            throw new IOException("Caught exception during handshake: " + robe);
        }
        if (sslResult != null) {
            netBuffer.release();
            decryptedNetBuffer.release();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "doHandshake");
        }
        return sslResult;
    }

    private IOException encryptMessage(long bytesToEncrypt) {
        IOException exception;
        block13: {
            SSLEngineResult.Status status;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "encryptMessage, numBytes=" + bytesToEncrypt);
            }
            exception = null;
            this.getEncryptedAppBuffer(bytesToEncrypt);
            WsByteBuffer[] appBuffers = this.getBuffers();
            int bytesConsumed = 0;
            while (true) {
                int[] appLimitInfo = SSLUtils.adjustBuffersForJSSE(appBuffers, this.getConnLink().getAppBufferSize());
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "before wrap: appBuffers: " + SSLUtils.getBufferTraceInfo(appBuffers) + "\r\n\tencAppBuf: " + SSLUtils.getBufferTraceInfo(this.encryptedAppBuffer));
                }
                SSLEngineResult result = null;
                try {
                    result = this.getConnLink().getSSLEngine().wrap(SSLUtils.getWrappedByteBuffers(appBuffers), this.encryptedAppBuffer.getWrappedByteBuffer());
                }
                catch (SSLException e) {
                    exception = e;
                    break block13;
                }
                status = result.getStatus();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "after wrap: appBuffers: " + SSLUtils.getBufferTraceInfo(appBuffers) + "\r\n\tencAppBuf: " + SSLUtils.getBufferTraceInfo(this.encryptedAppBuffer) + "\r\n\tstatus=" + (Object)((Object)status) + " consumed=" + result.bytesConsumed() + " produced=" + result.bytesProduced());
                }
                if (appLimitInfo != null) {
                    SSLUtils.resetBuffersAfterJSSE(appBuffers, appLimitInfo);
                }
                bytesConsumed += result.bytesConsumed();
                if (status == SSLEngineResult.Status.OK) {
                    if ((long)bytesConsumed < bytesToEncrypt) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "More encryption needed: bytesToEncrypt=" + bytesToEncrypt + " bytesEncrypted=" + bytesConsumed);
                        continue;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "OK result from the SSL engine");
                    }
                    break block13;
                }
                if (status != SSLEngineResult.Status.BUFFER_OVERFLOW) break;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "BUFFER_OVERFLOW result from the SSL engine");
                }
                this.increaseEncryptedBuffer();
            }
            exception = new IOException("Unable to encrypt data, status=" + (Object)((Object)status));
        }
        if (exception == null) {
            this.encryptedAppBuffer.flip();
            this.getConnLink().getDeviceWriteInterface().setBuffer(this.encryptedAppBuffer);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "encryptMessage: " + exception);
        }
        return exception;
    }

    protected void increaseEncryptedBuffer() {
        int packetSize = this.getConnLink().getPacketBufferSize();
        if (null == this.encryptedAppBuffer) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Allocating encryptedAppBuffer, size=" + packetSize);
            }
            this.encryptedAppBuffer = SSLUtils.allocateByteBuffer(packetSize, this.getConfig().getEncryptBuffersDirect());
        } else {
            int newsize = this.encryptedAppBuffer.capacity() + packetSize;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Increasing encBuffer to " + newsize);
            }
            WsByteBuffer temp = SSLUtils.allocateByteBuffer(newsize, this.encryptedAppBuffer.isDirect());
            this.encryptedAppBuffer.flip();
            SSLUtils.copyBuffer(this.encryptedAppBuffer, temp, this.encryptedAppBuffer.remaining());
            this.encryptedAppBuffer.release();
            this.encryptedAppBuffer = temp;
        }
    }

    private void getEncryptedAppBuffer(long size) {
        int maxSize = this.getConnLink().getPacketBufferSize();
        if (size > (long)maxSize) {
            maxSize = (int)size;
        }
        if (null == this.encryptedAppBuffer) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Allocating encryptedAppBuffer, size=" + maxSize);
            }
            this.encryptedAppBuffer = SSLUtils.allocateByteBuffer(maxSize, this.getConfig().getEncryptBuffersDirect());
        } else {
            this.encryptedAppBuffer.clear();
        }
    }

    public void close() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "close");
        }
        if (null != this.encryptedAppBuffer) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Releasing ssl output buffer during close. " + SSLUtils.getBufferTraceInfo(this.encryptedAppBuffer));
            }
            this.encryptedAppBuffer.release();
            this.encryptedAppBuffer = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "close");
        }
    }

    public void complete(VirtualConnection vc, TCPWriteRequestContext wsc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "complete, vc=" + this.getVCHash());
        }
        this.callback.complete(vc, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "complete");
        }
    }

    public void error(VirtualConnection vc, TCPWriteRequestContext wsc, IOException ioe) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "error, vc=" + this.getVCHash());
        }
        this.callback.error(vc, this, ioe);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "error");
        }
    }

    private class QueuedWork
    implements Runnable {
        private long numBytes = 0L;
        private TCPWriteCompletedCallback userCallback = null;
        private int timeout = 0;
        private VirtualConnection vc = null;
        private TCPWriteRequestContext tcpWriteRequestContext = null;
        private IOException exception = null;
        private boolean isWrite = true;

        protected QueuedWork() {
        }

        public void setWriteParameters(long _numBytes, TCPWriteCompletedCallback _userCallback, int _timeout) {
            this.numBytes = _numBytes;
            this.userCallback = _userCallback;
            this.timeout = _timeout;
            this.isWrite = true;
        }

        public void setErrorParameters(VirtualConnection _vc, TCPWriteRequestContext _tcpWriteRequestContext, TCPWriteCompletedCallback _userCallback, IOException _exception) {
            this.vc = _vc;
            this.tcpWriteRequestContext = _tcpWriteRequestContext;
            this.userCallback = _userCallback;
            this.exception = _exception;
            this.isWrite = false;
        }

        public void run() {
            if (this.isWrite) {
                SSLWriteServiceContext.this.write(this.numBytes, this.userCallback, false, this.timeout, true);
            } else {
                this.userCallback.error(this.vc, this.tcpWriteRequestContext, this.exception);
            }
        }
    }

    public class MyHandshakeCompletedCallback
    implements SSLHandshakeCompletedCallback {
        private TCPWriteRequestContext writeContext;
        private long numBytes;
        private int timeout;
        private WsByteBuffer netBuffer;
        private WsByteBuffer decryptedNetBuffer;

        public MyHandshakeCompletedCallback(TCPWriteRequestContext _writeContext) {
            this.writeContext = _writeContext;
        }

        public void setWriteParameters(long _numBytes, int _timeout) {
            this.numBytes = _numBytes;
            this.timeout = _timeout;
        }

        public void setNetBuffer(WsByteBuffer buffer) {
            this.netBuffer = buffer;
        }

        public void setDecryptedNetBuffer(WsByteBuffer buffer) {
            this.decryptedNetBuffer = buffer;
        }

        public void complete(SSLEngineResult sslResult) {
            this.netBuffer.release();
            this.netBuffer = null;
            this.decryptedNetBuffer.release();
            this.decryptedNetBuffer = null;
            if (sslResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) {
                IOException e = new IOException("Unable to complete SSLhandshake");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to complete SSLhandshake, " + e);
                }
                FFDCFilter.processException((Throwable)e, SSLWriteServiceContext.CLASS_NAME, "245", this);
                SSLWriteServiceContext.this.callback.error(SSLWriteServiceContext.this.getConnLink().getVirtualConnection(), this.writeContext, e);
            } else {
                VirtualConnection vc = SSLWriteServiceContext.this.encryptAndWriteAsync(this.numBytes, false, this.timeout);
                if (vc != null) {
                    SSLWriteServiceContext.this.callback.complete(vc, this.writeContext);
                }
            }
        }

        public void error(IOException ioe) {
            FFDCFilter.processException((Throwable)ioe, SSLWriteServiceContext.CLASS_NAME, "117", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught exception during encryption, " + ioe);
            }
            this.netBuffer.release();
            this.netBuffer = null;
            this.decryptedNetBuffer.release();
            this.decryptedNetBuffer = null;
            SSLWriteServiceContext.this.callback.error(SSLWriteServiceContext.this.getConnLink().getVirtualConnection(), this.writeContext, ioe);
        }
    }
}

