/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.config.SecurityConfigGlobals;
import com.ibm.ws.security.config.SecurityConfigResource;
import com.ibm.ws.security.config.SecurityObjectLocator;
import java.util.EmptyStackException;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityThreadLocal {
    private static TraceComponent tc = Tr.register(SecurityThreadLocal.class, "SecurityConfig", "com.ibm.ejs.resources.security");
    private Stack<SecurityConfigResource> resourceStack = null;

    SecurityThreadLocal(Stack<SecurityConfigResource> stack) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "ctor", stack);
        }
        this.resourceStack = stack;
    }

    Stack<SecurityConfigResource> getStack() {
        return this.resourceStack;
    }

    public SecurityConfigResource popResource() {
        SecurityConfigResource res;
        block5: {
            if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                Tr.entry(tc, "popResource");
            }
            res = null;
            try {
                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                    this.debugCallingMethod(false);
                }
                res = this.resourceStack.pop();
            }
            catch (EmptyStackException e) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "popResource with empty stack!", e);
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "popResource", new Object[]{res, this.resourceStack});
        }
        return res;
    }

    public SecurityConfigResource peekResource() {
        SecurityConfigResource res;
        block5: {
            if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                Tr.entry(tc, "peekResource");
            }
            res = null;
            if (!this.resourceStack.empty()) {
                try {
                    res = this.resourceStack.peek();
                }
                catch (EmptyStackException e) {
                    if (!SecurityConfigGlobals.enableVerbose || !tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "peekResource with empty stack");
                }
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "peekResource", new Object[]{res, this.resourceStack});
        }
        return res;
    }

    public boolean pushResource(SecurityConfigResource res) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "pushResource ", res);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            this.debugCallingMethod(true);
        }
        if (res != null) {
            if (res.isAdmin()) {
                res.setSecurityConfig(SecurityObjectLocator.getAdminSecurityConfig());
                res.setContextManager(SecurityObjectLocator.getAdminContextManager());
            } else if (res.isApplication()) {
                res.setSecurityConfig(SecurityObjectLocator.getApplicationSecurityConfig());
                res.setContextManager(SecurityObjectLocator.getApplicationContextManager());
            }
        }
        this.resourceStack.push(res);
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "pushResource", this.resourceStack);
        }
        return true;
    }

    public boolean pushResource(String name2, String type) {
        SecurityConfigResource res;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "pushResource ", new Object[]{name2, type});
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            this.debugCallingMethod(true);
        }
        if ((res = new SecurityConfigResource(name2, type)).isAdmin()) {
            res.setSecurityConfig(SecurityObjectLocator.getAdminSecurityConfig());
            res.setContextManager(SecurityObjectLocator.getAdminContextManager());
        } else if (res.isApplication()) {
            res.setSecurityConfig(SecurityObjectLocator.getApplicationSecurityConfig());
            res.setContextManager(SecurityObjectLocator.getApplicationContextManager());
        }
        this.resourceStack.push(res);
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "pushResource", this.resourceStack);
        }
        return true;
    }

    private void debugCallingMethod(boolean push) {
        StackTraceElement[] ste = new Exception().getStackTrace();
        for (int i = 0; i < ste.length; ++i) {
            StackTraceElement stackTraceElement = ste[i];
            if (stackTraceElement.getClassName().equals(this.getClass().getName()) || stackTraceElement.getClassName().equals("com.ibm.ws.security.config.SecurityObjectLocator") || !stackTraceElement.getClassName().startsWith("com.ibm.")) continue;
            if (push) {
                Tr.debug(tc, "Push called: " + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + "(" + stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + ")");
                break;
            }
            Tr.debug(tc, "Pop called: " + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + "(" + stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + ")");
            break;
        }
    }
}

