/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.runtime.metadata.MetaDataSlotImpl;

public abstract class MetaDataImpl
implements MetaData {
    private static final TraceComponent tc = Tr.register(MetaDataImpl.class, "Runtime", "com.ibm.ws.runtime.runtime");
    Object[] slots;

    public MetaDataImpl(int slotCnt) {
        this.slots = new Object[slotCnt];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setMetaData(MetaDataSlot slot, Object metadata) {
        MetaDataSlotImpl slotImpl;
        int slotNumber;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setMetaData(this=" + this + ", slot=" + slot + ", metadata=" + metadata + ")");
        }
        if ((slotNumber = (slotImpl = (MetaDataSlotImpl)slot).getSlot()) >= this.slots.length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "allocating more metadata slots");
            }
            Object[] newSlots = new Object[slotNumber + 1];
            Object[] objectArray = this.slots;
            // MONITORENTER : this.slots
            System.arraycopy(this.slots, 0, newSlots, 0, this.slots.length);
            // MONITOREXIT : objectArray
            this.slots = newSlots;
        }
        this.slots[slotImpl.getSlot()] = metadata;
    }

    public Object getMetaData(MetaDataSlot slot) {
        MetaDataSlotImpl slotImpl = (MetaDataSlotImpl)slot;
        Object result = null;
        int slotNumber = slotImpl.getSlot();
        if (slotNumber < this.slots.length) {
            result = this.slots[slotNumber];
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getMetaData(this=" + this + ", slot=" + slot + ") --> " + result);
        }
        return result;
    }

    public String toString() {
        return "MetaDataImpl@" + this.hashCode();
    }
}

