/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component.binder;

import com.ibm.ejs.j2c.ConnectionFactoryRefBuilder;
import com.ibm.ejs.j2c.ConnectorProperties;
import com.ibm.ejs.j2c.ConnectorProperty;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.binder.ResourceBindingException;
import com.ibm.ws.runtime.resource.ResourceBinderImpl;
import com.ibm.ws.runtime.resource.ResourceHelper;
import com.ibm.wsspi.runtime.config.ConfigObject;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class J2CBinder
extends ResourceBinderImpl {
    private static final TraceComponent tc = Tr.register(J2CBinder.class, "WAS.j2c", "com.ibm.ws.j2c.resources.J2CAMessages");
    protected static final String RAR_PROPERTIES = "RAR.PROPS";

    protected void addJ2CResourceAdapterProperties(Properties properties, ConfigObject j2cra) {
        Properties rarProps = new Properties();
        ConfigObject c = j2cra.getObject("deploymentDescriptor");
        this.addConnectorProperties(rarProps, c);
        String archivePath = j2cra.getString("archivePath", "__null__");
        List classPath = j2cra.getStringList("classpath");
        List nativePath = j2cra.getStringList("nativepath");
        this.addPaths(rarProps, archivePath, classPath, nativePath);
        properties.putAll((Map<?, ?>)rarProps);
    }

    private void addConnectorProperties(Properties properties, ConfigObject conn) {
        if (conn == null) {
            return;
        }
        String specVersion = conn.getString("specVersion", "__null__");
        boolean isJCA15 = this.checkJCA15(specVersion);
        ConfigObject ra = conn.getObject("resourceAdapter");
        ConfigObject ora = ra.getObject("outboundResourceAdapter");
        List authMechanisms = null;
        authMechanisms = !isJCA15 ? ra.getObjectList("authenticationMechanisms") : ora.getObjectList("authenticationMechanisms");
        int numMechanisms = authMechanisms.size();
        for (int i = 0; i < numMechanisms; ++i) {
            ConfigObject authMechanism = (ConfigObject)authMechanisms.get(i);
            String credentialInterface = authMechanism.getString("credentialInterface", "__null__");
            String authMechanismType = authMechanism.getString("authenticationMechanismType", "BasicPassword");
            if (authMechanismType.equals("BasicPassword")) {
                this.setProperty(properties, ConnectionFactoryRefBuilder.SECURITY_BasicPassword, credentialInterface, true);
                continue;
            }
            this.setProperty(properties, ConnectionFactoryRefBuilder.SECURITY_Kerbv5, credentialInterface, true);
        }
        if (!isJCA15) {
            this.setProperty(properties, "connectionFactoryImplClass", ra.getString("connectionFactoryImplClass", "__null__"), true);
            this.setProperty(properties, "connectionFactoryInterface", ra.getString("connectionFactoryInterface", "__null__"), true);
            this.setProperty(properties, "connectionImplClass", ra.getString("connectionImplClass", "__null__"), true);
            this.setProperty(properties, "connectionInterface", ra.getString("connectionInterface", "__null__"), true);
            this.setProperty(properties, "managedConnectionFactoryClass", ra.getString("managedConnectionFactoryClass", "__null__"), true);
            this.setProperty(properties, "reauthenticationSupport", new Boolean(ra.getBoolean("reauthenticationSupport", false)), false);
            this.setProperty(properties, "transactionSupport", ra.getString("transactionSupport", "NoTransaction"), true);
        } else {
            this.setProperty(properties, "reauthenticationSupport", new Boolean(ora.getBoolean("reauthenticationSupport", false)), false);
            this.setProperty(properties, "transactionSupport", ora.getString("transactionSupport", "NoTransaction"), true);
        }
        this.checkSetFirstItem(properties, "displayName", conn.getObjectList("displayNames"));
        this.setProperty(properties, "eisType", conn.getString("eisType", "__null__"), true);
        this.setProperty(properties, "specVersion", conn.getString("specVersion", "__null__"), true);
        this.setProperty(properties, "vendorName", conn.getString("vendorName", "__null__"), true);
        this.setProperty(properties, "version", conn.getString("version", "__null__"), true);
        List icons = conn.getObjectList("icons");
        this.checkSetFirstItem(properties, "j2c.adapter.largeIcon", icons);
        this.checkSetFirstItem(properties, "j2c.adapter.smallIcon", icons);
        ConfigObject license = conn.getObject("license");
        if (license != null) {
            this.checkSetFirstItem(properties, "j2c.adapter.licenseDescription", license.getObjectList("descriptions"));
            this.setProperty(properties, "j2c.adapter.licenseRequired", new Boolean(license.getBoolean("required", false)), false);
        }
    }

    protected void addConnectionPoolProperties(Properties p, ConfigObject pool2) {
        if (pool2 != null) {
            this.setProperty(p, "maxConnections", new Integer(pool2.getInt("maxConnections", 10)), false);
            this.setProperty(p, "minConnections", new Integer(pool2.getInt("minConnections", 1)), false);
            this.setProperty(p, "connectionTimeout", new Long(pool2.getLong("connectionTimeout", 180L)), false);
            this.setProperty(p, "reapTime", new Long(pool2.getLong("reapTime", 180L)), false);
            this.setProperty(p, "unusedTimeout", new Long(pool2.getLong("unusedTimeout", 1800L)), false);
            this.setProperty(p, "purgePolicy", pool2.getString("purgePolicy", "FailingConnectionOnly"), false);
            this.setProperty(p, "agedTimeout", new Long(pool2.getLong("agedTimeout", 0L)), false);
            this.setProperty(p, "numberOfSharedPoolPartitions", new Integer(pool2.getInt("numberOfSharedPoolPartitions", 0)), false);
            this.setProperty(p, "numberOfFreePoolPartitions", new Integer(pool2.getInt("numberOfFreePoolPartitions", 0)), false);
            this.setProperty(p, "freePoolDistributionTableSize", new Integer(pool2.getInt("freePoolDistributionTableSize", 0)), false);
            this.setProperty(p, "surgeThreshold", new Integer(pool2.getInt("surgeThreshold", -1)), false);
            this.setProperty(p, "surgeCreationInterval", new Integer(pool2.getInt("surgeCreationInterval", 0)), false);
            this.setProperty(p, "stuckTime", new Integer(pool2.getInt("stuckTime", 0)), false);
            this.setProperty(p, "stuckTimerTime", new Integer(pool2.getInt("stuckTimerTime", 0)), false);
            this.setProperty(p, "stuckThreshold", new Integer(pool2.getInt("stuckThreshold", 0)), false);
            this.setProperty(p, "testConnection", new Boolean(pool2.getBoolean("testConnection", false)), false);
            this.setProperty(p, "testConnectionInterval", new Integer(pool2.getInt("testConnectionInterval", 0)), false);
        }
    }

    protected void addConnectorPropertySet(ConnectorProperties p, ConfigObject set) {
        if (set == null) {
            return;
        }
        if (p == null) {
            return;
        }
        if (set != null) {
            List propertyList = set.getObjectList("resourceProperties");
            for (int i = 0; i < propertyList.size(); ++i) {
                ConfigObject property = (ConfigObject)propertyList.get(i);
                String name2 = property.getString("name", "__null__");
                String value2 = property.getString("value", "__null__");
                try {
                    value2 = this.expandVariable(value2);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.runtime.component.binder.J2CBinder.addConnectorPropertySet", "154", this);
                    Tr.service(tc, "Exception attempting to expand string: " + value2, e);
                }
                String type = property.getString("type", "__null__");
                if (name2 == null || value2 == null || type == null) continue;
                ConnectorProperty connProp = new ConnectorProperty(name2, type, value2);
                p.add((Object)connProp);
            }
        }
    }

    protected void addJ2EEHrefProperties(Properties props, ConfigObject resourceFactory) {
        MBeanFactory mbeanFactory = null;
        try {
            mbeanFactory = AdminServiceFactory.getAdminService().getMBeanFactory();
            if (mbeanFactory != null) {
                this.setProperty(props, "j2ee.resource.factory.href", mbeanFactory.getConfigId(resourceFactory), false);
                ConfigObject provider = resourceFactory.getParent();
                this.setProperty(props, "j2ee.resource.provider.href", mbeanFactory.getConfigId(provider), false);
                this.setProperty(props, "providerName", provider.getString("name", "__null__"), true);
                this.setProperty(props, "description", resourceFactory.getString("description", "__null__"), true);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.runtime.component.binder.J2CBinder.addJ2EEHrefPropeties", "276", this);
        }
        this.setProperty(props, "FactoryJndiName", ResourceHelper.getJndiName(resourceFactory), false);
    }

    public void activateProviderMBean(ConfigObject rp, String serverName) {
    }

    public Object getBindingObject(ConfigObject f) throws ResourceBindingException {
        return null;
    }

    public String getNamePrefix() {
        return null;
    }

    public boolean isUsedFor(ConfigObject f) {
        return false;
    }

    private void addPaths(Properties rarProps, String archivePath, List optionalClasspath, List nativePath) {
        int i;
        StringBuffer pathBuffer = new StringBuffer();
        String currentPathEntry = this.expandVariable(archivePath);
        pathBuffer.append(currentPathEntry);
        if (optionalClasspath != null) {
            for (i = 0; i < optionalClasspath.size(); ++i) {
                currentPathEntry = (String)optionalClasspath.get(i);
                try {
                    currentPathEntry = this.expandVariable(currentPathEntry);
                    if (pathBuffer.charAt(pathBuffer.length() - 1) != File.pathSeparatorChar) {
                        pathBuffer.append(File.pathSeparatorChar);
                    }
                    pathBuffer.append(currentPathEntry);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.runtime.component.binder.J2CBinder.addPaths", "388", this);
                    Tr.warning(tc, "ILLEGAL_ARGUMENT_EXCEPTION_J2CA0080", new Object[]{"addPaths", e});
                }
            }
        }
        if (nativePath != null) {
            for (i = 0; i < nativePath.size(); ++i) {
                currentPathEntry = (String)nativePath.get(i);
                try {
                    currentPathEntry = this.expandVariable(currentPathEntry);
                    if (pathBuffer.charAt(pathBuffer.length() - 1) != File.pathSeparatorChar) {
                        pathBuffer.append(File.pathSeparatorChar);
                    }
                    pathBuffer.append(currentPathEntry);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.runtime.component.binder.J2CBinder.addPaths", "406", this);
                    Tr.warning(tc, "ILLEGAL_ARGUMENT_EXCEPTION_J2CA0080", new Object[]{"addPaths", e});
                }
            }
        }
        this.setProperty(rarProps, "classpath", pathBuffer.toString(), false);
    }

    protected void checkSetProperty(Properties properties, String name2, Object value2) {
        if (value2 != null) {
            this.setProperty(properties, name2, value2, true);
        }
    }

    protected void addConnectionDefinitionProperties(Properties properties, ConfigObject cd) {
        if (cd == null) {
            return;
        }
        this.setProperty(properties, "connectionFactoryImplClass", cd.getString("connectionFactoryImplClass", "__null__"), true);
        this.setProperty(properties, "connectionFactoryInterface", cd.getString("connectionFactoryInterface", "__null__"), true);
        this.setProperty(properties, "connectionImplClass", cd.getString("connectionImplClass", "__null__"), true);
        this.setProperty(properties, "connectionInterface", cd.getString("connectionInterface", "__null__"), true);
        this.setProperty(properties, "managedConnectionFactoryClass", cd.getString("managedConnectionFactoryClass", "__null__"), true);
    }

    protected void checkSetFirstItem(Properties properties, String name2, List list) {
        if (list.size() > 0) {
            this.setProperty(properties, name2, list.get(0), true);
        }
    }

    protected boolean checkJCA15(String version) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "checkJCA15 version: " + version);
        }
        if (version != null) {
            return version.trim().equals("1.5");
        }
        return false;
    }
}

