/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.orbimpl.transport;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.ffdc.Manager;
import com.ibm.ws.orbimpl.transport.WSHTTPTransportConnection;
import com.ibm.ws.orbimpl.transport.content.IIOPContentHandlerFactory;
import com.ibm.ws.orbimpl.transport.protocol.HttpsURLStreamHandlerFactory;
import com.ibm.ws.orbimpl.transport.protocol.https.Handler;
import com.ibm.ws.orbimpl.transport.protocol.https.HttpsURLConnection;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;

class HTTPOutputStream
extends OutputStream {
    WSHTTPTransportConnection transportConnection = null;
    private static boolean needFactories = true;
    private URL url = null;
    private Profile profile = null;
    private boolean isRunningInApplet;
    private ORB orb = null;
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    public static final int TAG_FIREWALL_TRAVERSAL = 1229081859;
    private static boolean httpsProtocol = false;
    URLConnection urlc;
    private ByteArrayOutputStream buffer;
    private int bytesRemaining = -1;
    public static final int GIOP_MSG_HEADER_LENGTH = 12;

    public HTTPOutputStream(WSHTTPTransportConnection transportConnection, Profile profile, ORB orb) {
        this.transportConnection = transportConnection;
        this.profile = profile;
        this.orb = orb;
        this.isRunningInApplet = orb.isRunningInApplet();
        this.buffer = new ByteArrayOutputStream();
    }

    public void close() throws IOException {
        if (this.outputStream == null) {
            throw new INTERNAL("HTTPOUTPUTSTREAM_NO_OUTPUTSTREAM", 1229066330, CompletionStatus.COMPLETED_MAYBE);
        }
        this.outputStream.close();
    }

    public void flush() throws IOException {
        if (this.outputStream == null) {
            throw new INTERNAL("HTTPOUTPUTSTREAM_NO_OUTPUTSTREAM", 1229066330, CompletionStatus.COMPLETED_MAYBE);
        }
        this.outputStream.flush();
    }

    private void setUpURL() throws IOException {
        String methodName = "setUpURL";
        if (this.url == null) {
            String protocol2;
            int idx;
            String tunnelAgentURLStr = null;
            byte[] tgBytes = this.profile.getTaggedComponent(1229081859);
            tunnelAgentURLStr = tgBytes != null ? new String(tgBytes) : this.transportConnection.getTunnelAgentURLString();
            if (tunnelAgentURLStr == null || tunnelAgentURLStr.equals("")) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "setUpURL", "tunnelAgentURLSring is null or empty, throwing COMM_FAILURE");
                }
                throw new COMM_FAILURE("WRITE_ERROR_SEND_1", 1229066320, CompletionStatus.COMPLETED_NO);
            }
            String urlStr = null;
            urlStr = tunnelAgentURLStr.indexOf("?") == -1 ? tunnelAgentURLStr + "?host=" + this.profile.getHost() + "&port=" + this.profile.getPort() : tunnelAgentURLStr + "&host=" + this.profile.getHost() + "&port=" + this.profile.getPort();
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "setUpURL", "ursStr=" + urlStr);
            }
            if (needFactories && !this.isRunningInApplet && (idx = urlStr.indexOf(":")) != -1 && (protocol2 = urlStr.substring(0, idx)).equalsIgnoreCase("https")) {
                URLConnection.setContentHandlerFactory(new IIOPContentHandlerFactory());
                httpsProtocol = true;
                needFactories = false;
            }
            if (httpsProtocol) {
                String protocolPropertyValue = System.getProperty("java.protocol.handler.pkgs");
                if (protocolPropertyValue == null | protocolPropertyValue == "") {
                    protocolPropertyValue = "com.ibm.ws.orbimpl.transport.protocol.https.Handler";
                } else if (!protocolPropertyValue.equalsIgnoreCase("com.ibm.ws.orbimpl.transport.protocol.https.Handler")) {
                    protocolPropertyValue = "com.ibm.ws.orbimpl.transport.protocol.https.Handler | " + protocolPropertyValue;
                }
                System.setProperty("java.protocol.handler.pkgs", protocolPropertyValue);
                HttpsURLStreamHandlerFactory aHttpsURLStreamHandlerFactory = new HttpsURLStreamHandlerFactory();
                Handler aHandler = (Handler)aHttpsURLStreamHandlerFactory.createURLStreamHandler("https");
                this.url = new URL(null, urlStr, aHandler);
            } else if (!httpsProtocol) {
                this.url = new URL(urlStr);
            }
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "setUpURL", "url=" + this.url);
            }
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        String methodName = "write( byte[] b, int off, int len)";
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "write( byte[] b, int off, int len)", "at the beginning of the method");
        }
        if (!this.buildMessage(b, off, len)) {
            return;
        }
        this.setUpURL();
        this.urlc = this.url.openConnection();
        this.urlc.setDoOutput(true);
        if (this.url.getProtocol().equalsIgnoreCase("https")) {
            this.urlc.setUseCaches(false);
            if (!this.isRunningInApplet) {
                ((HttpsURLConnection)this.urlc).setOrb(this.orb);
                String file = this.url.getFile();
                String str = "POST " + file + " HTTP/1.1";
                this.outputStream = this.urlc.getOutputStream();
                PrintStream pout = new PrintStream(this.outputStream);
                pout.println(str);
                pout.println("host: " + this.profile.getHost());
                pout.println("Content-Length: " + this.buffer.size());
                pout.println("");
                pout.flush();
                this.outputStream.write(this.buffer.toByteArray(), 0, this.buffer.size());
                this.resetBuffer();
                this.outputStream.flush();
                pout.println("");
                pout.flush();
                this.inputStream = (InputStream)this.urlc.getContent();
                this.transportConnection.setInputStream(this.inputStream);
                this.transportConnection.readAndProcessReply();
            } else {
                this.outputStream = this.urlc.getOutputStream();
                this.outputStream.write(this.buffer.toByteArray(), 0, this.buffer.size());
                this.resetBuffer();
                this.inputStream = this.urlc.getInputStream();
                this.transportConnection.setInputStream(this.inputStream);
                this.transportConnection.readAndProcessReply();
            }
        } else {
            this.outputStream = this.urlc.getOutputStream();
            this.outputStream.write(this.buffer.toByteArray(), 0, this.buffer.size());
            this.resetBuffer();
            this.inputStream = this.urlc.getInputStream();
            this.transportConnection.setInputStream(this.inputStream);
            this.transportConnection.readAndProcessReply();
        }
    }

    private boolean buildMessage(byte[] b, int off, int len) {
        String methodName = "buildMessage";
        if (this.bytesRemaining == -1) {
            ByteBuffer bb = ByteBuffer.wrap(b, off, len);
            bb.position(8);
            this.bytesRemaining = bb.getInt();
        }
        this.buffer.write(b, off, len);
        this.bytesRemaining -= len;
        return 0 == this.bytesRemaining + 12;
    }

    private void resetBuffer() {
        this.buffer.reset();
        this.bytesRemaining = -1;
    }

    public void disconnect() {
        try {
            this.inputStream.close();
            this.outputStream.close();
        }
        catch (IOException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.ws.orbimpl.transport.HTTPOutputStream.disconnect", "365", this);
        }
        if (this.url.getProtocol().equalsIgnoreCase("https") && !this.isRunningInApplet) {
            try {
                ((HttpsURLConnection)this.urlc).disconnect();
            }
            catch (IOException ex) {
                Manager.Ffdc.log(ex, this, "com.ibm.ws.orbimpl.transport.HTTPOutputStream.disconnect", "374", this);
            }
        }
    }

    public void write(int b) throws IOException {
        throw new NO_IMPLEMENT("HTTPOUTPUTSTREAM_WRITE", 1229066320, CompletionStatus.COMPLETED_MAYBE);
    }
}

