/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.repository;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.management.repository.AppInfo;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

class NodeAppInfo {
    private static TraceComponent tc = Tr.register(NodeAppInfo.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private String name;
    private String serverIndexURI;
    private String cellName;
    private ConfigRepository repository = null;
    private DocumentDigest prevDigest = null;
    private List applications = new ArrayList();
    private static HashMap appInfo;

    NodeAppInfo(String cellName, String nodeName) {
        this.cellName = cellName;
        this.name = nodeName;
        this.serverIndexURI = "cells/" + cellName + "/nodes/" + nodeName + "/serverindex.xml";
        appInfo = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void update() {
        block22: {
            ServerIndex si;
            InputStream in;
            block21: {
                DocumentDigest currentDigest;
                in = null;
                si = null;
                if (this.repository == null) {
                    this.repository = ConfigRepositoryFactory.getConfigRepository();
                }
                if (!((Object)(currentDigest = this.repository.getDigest(this.serverIndexURI))).equals(this.prevDigest)) {
                    DocumentContentSource dcs = this.repository.extract(this.serverIndexURI);
                    in = dcs.getSource();
                    si = this.loadServerIndex(in);
                    EList servers = si.getServerEntries();
                    this.applications = new ArrayList();
                    for (int i = 0; i < servers.size(); ++i) {
                        ServerEntry server2 = (ServerEntry)servers.get(i);
                        EList serverApps = server2.getDeployedApplications();
                        for (int j = 0; j < serverApps.size(); ++j) {
                            if (this.applications.contains(serverApps.get(j))) continue;
                            this.applications.add(serverApps.get(j));
                        }
                    }
                    this.prevDigest = dcs.getDocument().getDigest();
                }
                for (int i = 0; i < this.applications.size(); ++i) {
                    AppInfo info;
                    String appName = (String)this.applications.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Updating app: " + appName);
                    }
                    if ((info = (AppInfo)appInfo.get(appName)) == null) {
                        info = new AppInfo(this.cellName, appName);
                        appInfo.put(appName, info);
                    }
                    info.update();
                }
                if (si == null) break block21;
                Resource res = si.eResource();
                ResourceSet set = res.getResourceSet();
                EList l = set.getResources();
                l.remove(res);
            }
            try {
                if (in != null) {
                    in.close();
                }
                break block22;
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.management.repository.NodeAppInfo.loadServerIndex", "135", this);
            }
            break block22;
            catch (Exception e) {
                block23: {
                    try {
                        Manager.Ffdc.log(e, this, "com.ibm.ws.management.repository.NodeAppInfo.loadServerIndex", "109", this);
                        if (si == null) break block23;
                    }
                    catch (Throwable throwable) {
                        if (si != null) {
                            Resource res = si.eResource();
                            ResourceSet set = res.getResourceSet();
                            EList l = set.getResources();
                            l.remove(res);
                        }
                        try {
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (Exception e2) {
                            Manager.Ffdc.log(e2, this, "com.ibm.ws.management.repository.NodeAppInfo.loadServerIndex", "135", this);
                        }
                        throw throwable;
                    }
                    Resource res = si.eResource();
                    ResourceSet set = res.getResourceSet();
                    EList l = set.getResources();
                    l.remove(res);
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception e3) {
                    Manager.Ffdc.log(e3, this, "com.ibm.ws.management.repository.NodeAppInfo.loadServerIndex", "135", this);
                }
            }
        }
    }

    public List getAppList() {
        return this.applications;
    }

    public AppInfo getAppInfo(String appName) {
        return (AppInfo)appInfo.get(appName);
    }

    private ServerIndex loadServerIndex(InputStream in) {
        ServerIndex serverIndex = null;
        try {
            WASResourceSetImpl resourceSet = new WASResourceSetImpl();
            URI uri = URI.createURI("serverindex.xml");
            Resource resource = resourceSet.createResource(uri);
            HashMap options = new HashMap();
            resource.load(in, options);
            serverIndex = (ServerIndex)resource.getContents().get(0);
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.management.repository.NodeAppInfo.loadServerIndex", "164", this);
        }
        return serverIndex;
    }
}

