/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class ServerInfo
implements Serializable {
    private static TraceComponent tc = Tr.register(ServerInfo.class, "Admin", "com.ibm.ws.management.discovery");
    private static final long serialVersionUID = 3198058148218818720L;
    private String pid;
    private String cell;
    private String node;
    private String name;
    private String role;
    private String version;
    private String hostName;
    private Vector connectors;
    private Vector endPoints;
    private Vector services;

    public ServerInfo(String cell, String node, String role2) {
        this.cell = cell;
        this.node = node;
        this.role = role2;
    }

    public ServerInfo(String pid, String cell, String node, String name2, String role2, String version, Vector services) {
        this.pid = pid;
        this.cell = cell;
        this.node = node;
        this.name = name2;
        this.role = role2;
        this.version = version;
        this.services = services;
    }

    public AdminClient getAdminClient() throws ConnectorException {
        return AdminClientFactory.createAdminClient(this.getPreferredConnectorProps());
    }

    public String getCell() {
        return this.cell;
    }

    public String getNode() {
        return this.node;
    }

    public String getPid() {
        return this.pid;
    }

    public String getVersion() {
        return this.version;
    }

    public String getRole() {
        return this.role;
    }

    public String getName() {
        return this.name;
    }

    public List getConnectors() {
        this.convert();
        return Collections.unmodifiableList(this.connectors);
    }

    public List getEndPoints() {
        this.convert();
        return Collections.unmodifiableList(this.endPoints);
    }

    public String toString() {
        Properties props = new Properties();
        if (this.pid != null) {
            props.setProperty("pid", this.pid);
        }
        if (this.cell != null) {
            props.setProperty("cell", this.cell);
        }
        if (this.node != null) {
            props.setProperty("node", this.node);
        }
        if (this.name != null) {
            props.setProperty("name", this.name);
        }
        if (this.role != null) {
            props.setProperty("role", this.role);
        }
        if (this.version != null) {
            props.setProperty("version", this.version);
        }
        if (this.services != null) {
            props.setProperty("services", this.services.toString());
        }
        if (this.hostName != null) {
            props.setProperty("hostName", this.hostName);
        }
        return props.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerInfo)) {
            return false;
        }
        ServerInfo si = (ServerInfo)o;
        return si.cell.equals(this.cell) && si.node.equals(this.node) && si.name.equals(this.name);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.cell.hashCode();
        result = 37 * result + this.node.hashCode();
        result = 37 * result + this.name.hashCode();
        return result;
    }

    boolean match(ServerInfo info) {
        return this.cell != null && this.cell.equalsIgnoreCase(info.getCell()) && this.node != null && this.node.equalsIgnoreCase(info.getNode()) && this.role != null && this.role.equalsIgnoreCase(info.getRole());
    }

    Vector getServices() {
        return this.services;
    }

    private void convert() {
        if (this.connectors == null || this.endPoints == null) {
            this.connectors = new Vector();
            this.endPoints = new Vector();
            for (String access : this.services) {
                int idx = access.indexOf(58);
                String category = access.substring(0, idx);
                String detail = access.substring(idx + 1);
                Properties props = this.convert(detail);
                if (category.equalsIgnoreCase("connector")) {
                    this.connectors.addElement(props);
                    continue;
                }
                if (!category.equalsIgnoreCase("endpoint")) continue;
                this.endPoints.addElement(props);
            }
        }
    }

    private Properties convert(String str) {
        Properties props = new Properties();
        StringTokenizer st = new StringTokenizer(str, ";=");
        while (st.hasMoreTokens()) {
            String name2 = st.nextToken();
            String value2 = st.nextToken();
            props.setProperty(name2, value2);
        }
        return props;
    }

    private Properties getPreferredConnectorProps() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getPreferredConnectorProps");
        }
        Properties props2 = null;
        Properties tmp = null;
        Properties soap2 = null;
        Properties nonipc = null;
        Properties ipc = null;
        for (Properties props2 : this.connectors) {
            if (props2.getProperty("preferred") != null) {
                tmp = props2;
            }
            if (props2.getProperty("type") != null && props2.getProperty("type").equals("SOAP")) {
                soap2 = props2;
            }
            if (props2.getProperty("type") != null && !props2.getProperty("type").equals("IPC")) {
                nonipc = props2;
            }
            if (props2.getProperty("type") != null && props2.getProperty("type").equals("IPC")) {
                ipc = props2;
            }
            Tr.debug(tc, "Connector properties: ");
            Iterator<Object> itr = props2.keySet().iterator();
            if (!tc.isDebugEnabled()) continue;
            while (itr.hasNext()) {
                String key = (String)itr.next();
                Tr.debug(tc, "> " + key + "=" + props2.getProperty(key));
            }
        }
        if (tmp == null) {
            tmp = soap2 != null ? soap2 : (nonipc != null ? nonipc : ipc);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getPreferredConnectorProps", tmp);
        }
        return tmp;
    }

    private Properties getLocalConnectorProps() {
        Properties props2 = null;
        for (Properties props2 : this.connectors) {
            if (props2.getProperty("localAdminProtocol") == null) continue;
            return props2;
        }
        return props2;
    }

    private Properties getRemoteConnectorProps() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getRemoteConnectorProps");
        }
        Properties props2 = null;
        Properties tmp = null;
        Properties soap2 = null;
        Properties nonipc = null;
        for (Properties props2 : this.connectors) {
            if (props2.getProperty("remoteAdminProtocol") != null) {
                tmp = props2;
            }
            if (props2.getProperty("type") != null && props2.getProperty("type").equals("SOAP")) {
                soap2 = props2;
            }
            if (props2.getProperty("type") != null && !props2.getProperty("type").equals("IPC")) {
                nonipc = props2;
            }
            Tr.debug(tc, "Connector properties: ");
            Iterator<Object> itr = props2.keySet().iterator();
            if (!tc.isDebugEnabled()) continue;
            while (itr.hasNext()) {
                String key = (String)itr.next();
                Tr.debug(tc, "> " + key + "=" + props2.getProperty(key));
            }
        }
        if (tmp == null && soap2 != null) {
            tmp = soap2;
        } else if (tmp == null && soap2 == null) {
            tmp = nonipc;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getRemoteConnectorProps", tmp);
        }
        return tmp;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }
}

