/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundLink;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundServiceContextImpl;
import com.ibm.ws.http.logging.DebugLog;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;

public class Http100ContWriteCallback
implements TCPWriteCompletedCallback {
    private static final TraceComponent tc = Tr.register(Http100ContWriteCallback.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final Http100ContWriteCallback myInstance = new Http100ContWriteCallback();

    private Http100ContWriteCallback() {
    }

    public static final Http100ContWriteCallback getRef() {
        return myInstance;
    }

    public void complete(VirtualConnection vc, TCPWriteRequestContext wsc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "complete() called for vc=" + vc);
        }
        HttpInboundLink link = (HttpInboundLink)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPICL);
        link.getHTTPContext().resetMsgSentState();
        HttpResponseMessage msg = link.getHTTPContext().getResponse();
        msg.setStatusCode(StatusCodes.OK);
        msg.removeHeader(HttpHeaderKeys.HDR_CONTENT_LENGTH);
        link.handleDiscrimination();
    }

    public void error(VirtualConnection vc, TCPWriteRequestContext wsc, IOException ioe) {
        HttpInboundServiceContextImpl isc;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "error() called for vc=" + vc + " ioe=" + ioe);
        }
        if ((isc = (HttpInboundServiceContextImpl)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPISC)).getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.WARN)) {
            isc.getHttpConfig().getDebugLog().log(DebugLog.Level.WARN, "The write of the response failed from a socket exception.", (HttpServiceContext)isc);
        }
        isc.getLink().close(vc, ioe);
    }
}

