/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.http.logging.AccessLog;
import com.ibm.ws.http.logging.DebugLog;
import com.ibm.ws.http.logging.HTTPLoggingService;
import com.ibm.ws.http.logging.LogUtils;
import com.ibm.ws.http.logging.impl.AccessLogger;
import com.ibm.ws.http.logging.impl.DebugLogger;
import com.ibm.ws.http.logging.impl.DisabledLogger;
import com.ibm.ws.http.logging.impl.FRCALogger;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.http.channel.values.VersionValues;
import java.io.FileNotFoundException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpChannelConfig {
    private static final TraceComponent tc = Tr.register(HttpChannelConfig.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final int TIMEOUT_MODIFIER = 1000;
    private static final int LOGSIZE_MODIFIER = 0x100000;
    private int maxPersistRequest = 100;
    private VersionValues outgoingHttpVersion = VersionValues.V11;
    private boolean bDirectBuffers = true;
    private boolean bKeepAliveEnabled = true;
    private int outgoingHdrBuffSize = 1024;
    private int incomingHdrBuffSize = 8192;
    private int incomingBodyBuffSize = 32768;
    private int persistTimeout = 30000;
    private int readTimeout = 60000;
    private int writeTimeout = 60000;
    private int byteCacheSize = 512;
    private boolean bExtractValue = true;
    private boolean bBinaryTransport = false;
    private AccessLog accessLogger = DisabledLogger.getRef();
    private DebugLog debugLogger = DisabledLogger.getRef();
    private AccessLog frcaLogger = DisabledLogger.getRef();
    private int limitFieldSize = 32768;
    private int limitNumHeaders = 500;
    private int limitNumResponses = 10;
    private long limitMessageSize = -1L;
    private boolean bKeepThread = false;
    private boolean bAllowRetries = true;
    private boolean bServantRegion = false;
    private boolean bRunningOnZOS = false;
    private boolean bControlRegion = false;
    private boolean bHeaderValidation = true;
    private boolean bJITOnlyReads = false;
    private boolean bStrictURLFormat = false;
    private boolean bRemoveServerHeader = false;
    private byte[] baServerHeaderValue = null;
    private long lDateHeaderRange = 1000L;
    private boolean bCookiesConfigureNoCache = true;
    private int headerChangeLimit = -1;
    private boolean bAutoDecompression = true;
    private boolean bEnableSmugglingProtection = true;
    private ChannelFramework chfw = null;

    public HttpChannelConfig(ChannelData cc) {
        this.chfw = cc.getChannelFramework();
        this.parseConfig(cc);
    }

    public ChannelFramework getCHFW() {
        return this.chfw;
    }

    public void updateConfig(ChannelData cc) {
        this.parseConfig(cc);
    }

    private void parseConfig(ChannelData cc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "parseConfig: " + cc.getName());
        }
        Map props = cc.getPropertyBag();
        this.parseZOSInfo(props);
        this.parsePersistence(props);
        this.parseOutgoingVersion(props);
        this.parseBufferType(props);
        this.parseOutgoingBufferSize(props);
        this.parseIncomingHdrBufferSize(props);
        this.parseIncomingBodyBufferSize(props);
        this.parsePersistTimeout(props);
        this.parseReadTimeout(props);
        this.parseWriteTimeout(props);
        this.parseByteCacheSize(props);
        this.parseDelayedExtract(props);
        this.parseBinaryTransport(props);
        this.parseLimitFieldSize(props);
        this.parseLimitNumberHeaders(props);
        this.parseLimitNumberResponses(props);
        this.parseLimitMessageSize(props);
        this.parseKeepThread(props);
        this.parseAllowRetries(props);
        this.parseLoggingInfo(props);
        this.parseHeaderValidation(props);
        this.parseStrictURLFormat(props);
        this.parseServerHeader(props);
        this.parseDateHeaderRange(props);
        this.parseCookieUpdate(props);
        this.parseHeaderChangeLimit(props);
        this.parseAutoDecompression(props);
        this.parseRequestSmugglingProtection(props);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "parseConfig");
        }
    }

    private String getProp(Map<?, ?> props, String key) {
        String value2 = (String)props.get(key);
        if (null == value2) {
            value2 = (String)props.get(key.toLowerCase());
        }
        return null != value2 ? value2.trim() : null;
    }

    private void parsePersistence(Map<?, ?> props) {
        this.parseKeepAliveEnabled(props);
        if (this.isKeepAliveEnabled()) {
            this.parseMaxPersist(props);
        }
    }

    private void parseKeepAliveEnabled(Map<?, ?> props) {
        boolean flag = this.bKeepAliveEnabled;
        String value2 = this.getProp(props, "defaultToOutgoingKeepAlive");
        if (null != value2) {
            flag = this.convertBoolean(value2);
        }
        if (null != (value2 = this.getProp(props, "KeepAliveEnabled"))) {
            flag &= this.convertBoolean(value2);
        }
        this.bKeepAliveEnabled = flag;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Config: KeepAliveEnabled is " + this.isKeepAliveEnabled());
        }
    }

    private void parseMaxPersist(Map<?, ?> props) {
        block4: {
            String value2 = this.getProp(props, "MaxKeepAliveRequests");
            if (null != value2) {
                try {
                    this.maxPersistRequest = this.minLimit(Integer.parseInt(value2), -1);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Config: Max persistent requests is " + this.getMaximumPersistentRequests());
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException(nfe, this.getClass().getName() + ".parseMaxPersist", "1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event(tc, "Config: Invalid max persistent requests; " + value2);
                }
            }
        }
    }

    private void parseOutgoingVersion(Map<?, ?> props) {
        String value2 = this.getProp(props, "outgoingVersion");
        if ("1.0".equals(value2)) {
            this.outgoingHttpVersion = VersionValues.V10;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Config: Outgoing version is " + this.getOutgoingVersion().getName());
            }
        }
    }

    private void parseBufferType(Map<?, ?> props) {
        String value2 = this.getProp(props, "useDirectBuffers");
        if (null != value2) {
            this.bDirectBuffers = this.convertBoolean(value2);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Config: use direct buffers is " + this.isDirectBufferType());
            }
        }
    }

    private void parseOutgoingBufferSize(Map<?, ?> props) {
        block4: {
            String value2 = this.getProp(props, "outgoingHdrBufferSize");
            if (null != value2) {
                try {
                    this.outgoingHdrBuffSize = this.rangeLimit(Integer.parseInt(value2), 1024, 0x100000);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Config: Outgoing hdr buffer size is " + this.getOutgoingHdrBufferSize());
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException(nfe, this.getClass().getName() + ".parseOutgoingBufferSize", "1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event(tc, "Config: Invalid outgoing header buffer size; " + value2);
                }
            }
        }
    }

    private void parseIncomingHdrBufferSize(Map<?, ?> props) {
        block4: {
            String value2 = this.getProp(props, "incomingHdrBufferSize");
            if (null != value2) {
                try {
                    this.incomingHdrBuffSize = this.rangeLimit(Integer.parseInt(value2), 1024, 0x100000);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Config: Incoming hdr buffer size is " + this.getIncomingHdrBufferSize());
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException(nfe, this.getClass().getName() + ".parseIncomingHdrBufferSize", "1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event(tc, "Config: Invalid incoming hdr buffer size of " + value2);
                }
            }
        }
    }

    private void parseIncomingBodyBufferSize(Map<?, ?> props) {
        block4: {
            String value2 = this.getProp(props, "incomingBodyBufferSize");
            if (null != value2) {
                try {
                    this.incomingBodyBuffSize = this.rangeLimit(Integer.parseInt(value2), 1024, 0x100000);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Config: Incoming body buffer size is " + this.getIncomingBodyBufferSize());
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException(nfe, this.getClass().getName() + ".parseIncomingBodyBufferSize", "1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event(tc, "Config: Invalid incoming body buffer size; " + value2);
                }
            }
        }
    }

    private void parsePersistTimeout(Map<?, ?> props) {
        block4: {
            String value2 = this.getProp(props, "persistTimeout");
            if (null != value2) {
                try {
                    this.persistTimeout = 1000 * this.minLimit(Integer.parseInt(value2), 0);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Config: Persist timeout is " + this.getPersistTimeout());
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException(nfe, this.getClass().getName() + ".parsePersistTimeout", "1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event(tc, "Config: Invalid persist timeout; " + value2);
                }
            }
        }
    }

    private void parseReadTimeout(Map<?, ?> props) {
        block4: {
            String value2 = this.getProp(props, "readTimeout");
            if (null != value2) {
                try {
                    this.readTimeout = 1000 * this.minLimit(Integer.parseInt(value2), 0);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Config: Read timeout is " + this.getReadTimeout());
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException(nfe, this.getClass().getName() + ".parseReadTimeout", "1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event(tc, "Config: Invalid read timeout; " + value2);
                }
            }
        }
    }

    private void parseWriteTimeout(Map<?, ?> props) {
        block4: {
            String value2 = this.getProp(props, "writeTimeout");
            if (null != value2) {
                try {
                    this.writeTimeout = 1000 * this.minLimit(Integer.parseInt(value2), 0);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Config: Write timeout is " + this.getWriteTimeout());
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException(nfe, this.getClass().getName() + ".parseWriteTimeout", "1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event(tc, "Config: Invalid write timeout; " + value2);
                }
            }
        }
    }

    private void parseByteCacheSize(Map<?, ?> props) {
        block4: {
            String value2 = this.getProp(props, "byteCacheSize");
            if (null != value2) {
                try {
                    this.byteCacheSize = this.rangeLimit(Integer.parseInt(value2), 256, 2048);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Config: byte cache size is " + this.getByteCacheSize());
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException(nfe, this.getClass().getName() + ".parseByteCacheSize", "1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event(tc, "Config: Invalid bytecache setting of " + value2);
                }
            }
        }
    }

    private void parseDelayedExtract(Map<?, ?> props) {
        String value2 = this.getProp(props, "extractValue");
        if (null != value2) {
            this.bExtractValue = this.convertBoolean(value2);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Config: header value extraction is " + this.shouldExtractValue());
            }
        }
    }

    private void parseBinaryTransport(Map<?, ?> props) {
        String value2 = this.getProp(props, "enableBinaryTransport");
        if (null != value2) {
            this.bBinaryTransport = this.convertBoolean(value2);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Config: binary transport is " + this.isBinaryTransportEnabled());
            }
        }
    }

    private void parseLimitFieldSize(Map<?, ?> props) {
        block4: {
            String value2 = this.getProp(props, "limitFieldSize");
            if (null != value2) {
                try {
                    this.limitFieldSize = this.rangeLimit(Integer.parseInt(value2), 50, 32768);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Config: field size limit is " + this.getLimitOfFieldSize());
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException(nfe, this.getClass().getName() + ".parseLimitFieldSize", "1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event(tc, "Config: Invaild max field size setting of " + value2);
                }
            }
        }
    }

    private void parseLimitNumberHeaders(Map<?, ?> props) {
        block4: {
            String value2 = this.getProp(props, "limitNumHeaders");
            if (null != value2) {
                try {
                    this.limitNumHeaders = this.rangeLimit(Integer.parseInt(value2), 50, 500);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Config: Num hdrs limit is " + this.getLimitOnNumberOfHeaders());
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException(nfe, this.getClass().getName() + ".parseLimitNumberHeaders", "1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event(tc, "Config: Invalid number of headers limit; " + value2);
                }
            }
        }
    }

    private void parseLimitNumberResponses(Map<?, ?> props) {
        block4: {
            String value2 = this.getProp(props, "LimitNumberResponses");
            if (null != value2) {
                try {
                    int size = Integer.parseInt(value2);
                    this.limitNumResponses = -1 == size ? 50 : this.rangeLimit(size, 1, 50);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Config: Num responses limit is " + this.getLimitOnNumberOfResponses());
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException(nfe, this.getClass().getName() + ".parseLimitNumberResponses", "1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event(tc, "Config: Invalid max number of responses; " + value2);
                }
            }
        }
    }

    private void parseLimitMessageSize(Map<?, ?> props) {
        block4: {
            String value2 = this.getProp(props, "MessageSizeLimit");
            if (null != value2) {
                try {
                    this.limitMessageSize = Long.parseLong(value2);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Config: Message size limit is " + this.getMessageSizeLimit());
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException(nfe, this.getClass().getName() + ".parseLimitMessageSize", "1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event(tc, "Config: Invalid message size limit; " + value2);
                }
            }
        }
    }

    public long getMessageSizeLimit() {
        return this.limitMessageSize;
    }

    private void parseKeepThread(Map<?, ?> props) {
        String value2 = this.getProp(props, "keepThread");
        if (null != value2) {
            this.bKeepThread = this.convertBoolean(value2);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Config: keepthread flag is " + this.isKeepThread());
            }
        }
    }

    private void parseAccessLog(Map<?, ?> props) {
        block17: {
            String value2;
            block16: {
                String name2 = (String)props.get("accessLogFileName");
                if (null == name2) {
                    HTTPLoggingService svc = (HTTPLoggingService)this.chfw.lookupService(HTTPLoggingService.class);
                    if (null != svc) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Config: using logging service for NCSA");
                        }
                        this.accessLogger = svc.getAccessLog();
                    } else {
                        Tr.debug(tc, "Unable to find logging service");
                    }
                    return;
                }
                try {
                    this.accessLogger = new AccessLogger(name2);
                }
                catch (FileNotFoundException e) {
                    FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".parseAccessLog", "name", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Config: invalid access log name [" + name2 + "]");
                    }
                    this.accessLogger = DisabledLogger.getRef();
                    return;
                }
                value2 = this.getProp(props, "loggingFormatCombined");
                AccessLog.Format format = AccessLog.Format.COMMON;
                if (null == value2) {
                    value2 = this.getProp(props, "accessLogFormat");
                    format = LogUtils.convertNCSAFormat(value2);
                } else if (this.convertBoolean(value2)) {
                    format = AccessLog.Format.COMBINED;
                }
                this.accessLogger.setFormat(format);
                value2 = this.getProp(props, "MaximumAccessBackupFiles");
                if (null != value2) {
                    try {
                        this.accessLogger.setMaximumBackupFiles(Integer.parseInt(value2));
                    }
                    catch (NumberFormatException nfe) {
                        FFDCFilter.processException(nfe, this.getClass().getName() + ".parseAccessLog", "maxfiles");
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block16;
                        Tr.event(tc, "Config: invalid access max files: " + value2);
                    }
                }
            }
            if (null != (value2 = this.getProp(props, "accessLogMaximumSize"))) {
                try {
                    this.accessLogger.setMaximumSize(Long.parseLong(value2) * 0x100000L);
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException(nfe, this.getClass().getName() + ".parseAccessLog", "maxsize");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block17;
                    Tr.event(tc, "Config: invalid access size: " + value2);
                }
            }
        }
        this.accessLogger.start();
    }

    private void parseDebugLog(Map<?, ?> props) {
        block13: {
            String value2;
            block12: {
                String name2 = this.getProp(props, "errorLogFileName");
                if (null == name2) {
                    HTTPLoggingService svc = (HTTPLoggingService)this.chfw.lookupService(HTTPLoggingService.class);
                    if (null != svc) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Config: using logging service for debug");
                        }
                        this.debugLogger = svc.getDebugLog();
                    }
                    return;
                }
                try {
                    this.debugLogger = new DebugLogger(name2);
                }
                catch (FileNotFoundException e) {
                    FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".parseDebugLog", "name", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Config: invalid Debug log name [" + name2 + "]");
                    }
                    this.debugLogger = DisabledLogger.getRef();
                    return;
                }
                value2 = this.getProp(props, "loggingLevel");
                this.debugLogger.setCurrentLevel(LogUtils.convertDebugLevel(value2));
                value2 = this.getProp(props, "MaximumErrorBackupFiles");
                if (null != value2) {
                    try {
                        this.debugLogger.setMaximumBackupFiles(Integer.parseInt(value2));
                    }
                    catch (NumberFormatException nfe) {
                        FFDCFilter.processException(nfe, this.getClass().getName() + ".parseDebugLog", "maxfiles");
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block12;
                        Tr.event(tc, "Config: invalid Debug max files: " + value2);
                    }
                }
            }
            if (null != (value2 = this.getProp(props, "errorLogMaximumSize"))) {
                try {
                    this.debugLogger.setMaximumSize(Long.parseLong(value2) * 0x100000L);
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException(nfe, this.getClass().getName() + ".parseDebugLog", "maxsize");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block13;
                    Tr.event(tc, "Config: invalid Debug size: " + value2);
                }
            }
        }
        this.debugLogger.start();
    }

    private void parseFRCALog(Map<?, ?> props) {
        block14: {
            String value2;
            block13: {
                if (!this.isControlRegion()) {
                    return;
                }
                String name2 = this.getProp(props, "FRCALogName");
                if (null == name2) {
                    HTTPLoggingService svc = (HTTPLoggingService)this.chfw.lookupService(HTTPLoggingService.class);
                    if (null != svc) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Config: using logging service for FRCA");
                        }
                        this.frcaLogger = svc.getFRCALog();
                    }
                    return;
                }
                try {
                    this.frcaLogger = new FRCALogger(name2);
                }
                catch (FileNotFoundException e) {
                    FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".parseFRCALog", "name", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Config: invalid FRCA log name [" + name2 + "]");
                    }
                    this.frcaLogger = DisabledLogger.getRef();
                    return;
                }
                value2 = this.getProp(props, "FRCALogAccessFormat");
                this.frcaLogger.setFormat(LogUtils.convertNCSAFormat(value2));
                value2 = this.getProp(props, "FRCALogMaximumBackupFiles");
                if (null != value2) {
                    try {
                        this.frcaLogger.setMaximumBackupFiles(Integer.parseInt(value2));
                    }
                    catch (NumberFormatException nfe) {
                        FFDCFilter.processException(nfe, this.getClass().getName() + ".parseFRCALog", "maxfiles");
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block13;
                        Tr.event(tc, "Config: invalid FRCA max files: " + value2);
                    }
                }
            }
            if (null != (value2 = this.getProp(props, "FRCALogMaximumSize"))) {
                try {
                    this.frcaLogger.setMaximumSize(Long.parseLong(value2) * 0x100000L);
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException(nfe, this.getClass().getName() + ".parseFRCALog", "maxsize");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block14;
                    Tr.event(tc, "Config: invalid FRCA size: " + value2);
                }
            }
        }
        this.frcaLogger.start();
    }

    private void parseLoggingInfo(Map<?, ?> props) {
        if (this.isServantRegion()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Config: logging disabled on servant region");
            }
            return;
        }
        String value2 = this.getProp(props, "loggingDisable");
        if (null != value2 && this.convertBoolean(value2)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Config: logging is disabled");
            }
        } else {
            this.parseAccessLog(props);
            this.parseDebugLog(props);
            this.parseFRCALog(props);
        }
    }

    private void parseAllowRetries(Map<?, ?> props) {
        String value2 = this.getProp(props, "allowRetries");
        if (null != value2) {
            this.bAllowRetries = this.convertBoolean(value2);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Config: allow retries is " + this.allowsRetries());
            }
        } else if (this.runningOnZOS() && !this.isServantRegion()) {
            this.bAllowRetries = false;
        }
    }

    private void parseZOSInfo(Map<?, ?> props) {
        String value2 = this.getProp(props, "RunningOnZOS");
        if (null != value2) {
            this.bRunningOnZOS = this.convertBoolean(value2);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Config: running on z/OS is " + this.runningOnZOS());
            }
        }
        if (null != (value2 = this.getProp(props, "ServantRegion")) && this.convertBoolean(value2)) {
            this.bServantRegion = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Config: z/os servant region is " + this.isServantRegion());
            }
            this.bRunningOnZOS = true;
            this.bJITOnlyReads = true;
        }
        if (null != (value2 = this.getProp(props, "ControlRegion")) && this.convertBoolean(value2)) {
            this.bControlRegion = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Config: z/os control region is " + this.isControlRegion());
            }
            this.bRunningOnZOS = true;
        }
        this.parseJITOnlyReads(props);
    }

    private void parseHeaderValidation(Map<?, ?> props) {
        String value2 = this.getProp(props, "splitResponseProtection");
        if (null != value2) {
            this.bHeaderValidation = this.convertBoolean(value2);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Config: header validation is " + this.isHeaderValidationEnabled());
            }
        }
    }

    private void parseJITOnlyReads(Map<?, ?> props) {
        String value2 = this.getProp(props, "JITOnlyReads");
        if (null != value2) {
            this.bJITOnlyReads = this.convertBoolean(value2);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Config: JIT only reads is " + this.isJITOnlyReads());
            }
        }
    }

    private void parseStrictURLFormat(Map<?, ?> props) {
        String value2 = this.getProp(props, "StrictURLFormat");
        if (null != value2) {
            this.bStrictURLFormat = this.convertBoolean(value2);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Config: Strict URL formatting is " + this.isStrictURLFormat());
            }
        }
    }

    private void parseServerHeader(Map<?, ?> props) {
        String value2 = this.getProp(props, "ServerHeaderValue");
        if (null == value2 || "".equals(value2)) {
            value2 = "WebSphere Application Server/7.0";
        }
        this.baServerHeaderValue = GenericUtils.getEnglishBytes(value2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Config: server header value [" + value2 + "]");
        }
        if (null != (value2 = this.getProp(props, "RemoveServerHeader"))) {
            this.bRemoveServerHeader = this.convertBoolean(value2);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Config: remove server header is " + this.removeServerHeader());
            }
        }
    }

    private void parseDateHeaderRange(Map<?, ?> props) {
        block4: {
            String value2 = this.getProp(props, "DateHeaderRange");
            if (null != value2) {
                try {
                    this.lDateHeaderRange = this.minLimit(Long.parseLong(value2), 0L);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Config: date header range is " + value2);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException(nfe, this.getClass().getName() + ".parseDateHeaderRange", "1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event(tc, "Config: Invalid date header range; " + value2);
                }
            }
        }
    }

    private void parseCookieUpdate(Map<?, ?> props) {
        String value2 = this.getProp(props, "CookiesConfigureNoCache");
        if (null != value2) {
            this.bCookiesConfigureNoCache = this.convertBoolean(value2);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Config: set-cookie configures no-cache is " + this.shouldCookiesConfigureNoCache());
            }
        }
    }

    private void parseHeaderChangeLimit(Map<?, ?> props) {
        block4: {
            String value2 = this.getProp(props, "HeaderChangeLimit");
            if (null != value2) {
                try {
                    this.headerChangeLimit = Integer.parseInt(value2);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Config: header change limit is " + this.getHeaderChangeLimit());
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException(nfe, this.getClass().getName() + ".parseHeaderChangeLimit", "1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event(tc, "Config: Invalid header change count of " + value2);
                }
            }
        }
    }

    private void parseRequestSmugglingProtection(Map<?, ?> props) {
        String value2 = (String)props.get("EnableSmugglingProtection");
        if (null != value2) {
            this.bEnableSmugglingProtection = this.convertBoolean(value2);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Config: request smuggling protection is " + this.bEnableSmugglingProtection);
            }
        }
    }

    public boolean isRequestSmugglingProtectionEnabled() {
        return this.bEnableSmugglingProtection;
    }

    private void parseAutoDecompression(Map<?, ?> props) {
        String value2 = this.getProp(props, "AutoDecompression");
        if (null != value2) {
            this.bAutoDecompression = this.convertBoolean(value2);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Config: autodecompression is " + this.isAutoDecompressionEnabled());
            }
        }
    }

    private boolean convertBoolean(String s) {
        return "true".equalsIgnoreCase(s);
    }

    private int rangeLimit(int size, int min2, int max2) {
        if (size < min2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Config: " + size + " too small");
            }
            return min2;
        }
        if (size > max2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Config: " + size + " too large");
            }
            return max2;
        }
        return size;
    }

    private int minLimit(int input, int min2) {
        if (input < min2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Config: " + input + " too small.");
            }
            return min2;
        }
        return input;
    }

    private long minLimit(long input, long min2) {
        if (input < min2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Config: " + input + " too small.");
            }
            return min2;
        }
        return input;
    }

    public int getMaximumPersistentRequests() {
        return this.maxPersistRequest;
    }

    public VersionValues getOutgoingVersion() {
        return this.outgoingHttpVersion;
    }

    public boolean isDirectBufferType() {
        return this.bDirectBuffers;
    }

    public boolean isKeepAliveEnabled() {
        return this.bKeepAliveEnabled;
    }

    public int getOutgoingHdrBufferSize() {
        return this.outgoingHdrBuffSize;
    }

    public int getIncomingHdrBufferSize() {
        return this.incomingHdrBuffSize;
    }

    public int getIncomingBodyBufferSize() {
        return this.incomingBodyBuffSize;
    }

    public int getPersistTimeout() {
        return this.persistTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public int getByteCacheSize() {
        return this.byteCacheSize;
    }

    public boolean shouldExtractValue() {
        return this.bExtractValue;
    }

    public boolean isBinaryTransportEnabled() {
        return this.bBinaryTransport;
    }

    public AccessLog getAccessLog() {
        return this.accessLogger;
    }

    public DebugLog getDebugLog() {
        return this.debugLogger;
    }

    public AccessLog getFRCALog() {
        return this.frcaLogger;
    }

    public int getLimitOfFieldSize() {
        return this.limitFieldSize;
    }

    public int getLimitOnNumberOfHeaders() {
        return this.limitNumHeaders;
    }

    public int getLimitOnNumberOfResponses() {
        return this.limitNumResponses;
    }

    public boolean isKeepThread() {
        return this.bKeepThread;
    }

    public boolean allowsRetries() {
        return this.bAllowRetries;
    }

    public boolean isServantRegion() {
        return this.bServantRegion;
    }

    public boolean isControlRegion() {
        return this.bControlRegion;
    }

    public boolean runningOnZOS() {
        return this.bRunningOnZOS;
    }

    public boolean isHeaderValidationEnabled() {
        return this.bHeaderValidation;
    }

    public boolean isJITOnlyReads() {
        return this.bJITOnlyReads;
    }

    public boolean isStrictURLFormat() {
        return this.bStrictURLFormat;
    }

    public byte[] getServerHeaderValue() {
        return this.baServerHeaderValue;
    }

    public boolean removeServerHeader() {
        return this.bRemoveServerHeader;
    }

    public long getDateHeaderRange() {
        return this.lDateHeaderRange;
    }

    public boolean shouldCookiesConfigureNoCache() {
        return this.bCookiesConfigureNoCache;
    }

    public int getHeaderChangeLimit() {
        return this.headerChangeLimit;
    }

    public boolean isAutoDecompressionEnabled() {
        return this.bAutoDecompression;
    }
}

