/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.genericbnf.impl;

import com.ibm.ws.genericbnf.impl.FastNonSynchHashBucket;
import com.ibm.ws.genericbnf.impl.FastNonSynchHashEntry;

public class FastNonSynchHashTable {
    private static final int yVar = 3;
    private int xVar = 1000;
    private FastNonSynchHashBucket[][] mainTable = null;

    public FastNonSynchHashTable(int buckets) {
        this.xVar = buckets / 3 + 1;
        this.initBuckets();
    }

    public FastNonSynchHashTable() {
        this.initBuckets();
    }

    private void initBuckets() {
        this.mainTable = new FastNonSynchHashBucket[this.xVar][3];
        for (int i = 0; i < this.xVar; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.mainTable[i][j] = new FastNonSynchHashBucket();
            }
        }
    }

    public void clear() {
        for (int i = 0; i < this.xVar; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.mainTable[i][j].root = null;
            }
        }
    }

    public Object get(Object key) {
        int hc = key.hashCode();
        return this.getValueFromBucket(this.getBucket(hc), hc, key, false);
    }

    public Object get(Object key, int hc) {
        return this.getValueFromBucket(this.getBucket(hc), hc, key, false);
    }

    private Object getValueFromBucket(FastNonSynchHashBucket bucket, int hash, Object key, boolean remove) {
        FastNonSynchHashEntry e = bucket.root;
        FastNonSynchHashEntry last = null;
        while (null != e) {
            if (e.hash == hash && e.key.equals(key)) {
                if (remove) {
                    if (null == last) {
                        bucket.root = e.next;
                    } else {
                        last.next = e.next;
                    }
                }
                return e.value;
            }
            last = e;
            e = e.next;
        }
        return null;
    }

    public Object put(Object key, Object value2) {
        if (null == value2) {
            throw new NullPointerException();
        }
        int hc = key.hashCode();
        FastNonSynchHashBucket bucket = this.getBucket(hc);
        Object retVal = this.getValueFromBucket(bucket, hc, key, false);
        if (null != retVal) {
            return retVal;
        }
        FastNonSynchHashEntry e = new FastNonSynchHashEntry(hc, key, value2);
        return this.putIntoBucket(bucket, e);
    }

    public Object put(Object key, int hc, Object value2) {
        FastNonSynchHashBucket bucket = this.getBucket(hc);
        Object retVal = this.getValueFromBucket(bucket, hc, key, false);
        if (null != retVal) {
            return retVal;
        }
        FastNonSynchHashEntry e = new FastNonSynchHashEntry(hc, key, value2);
        return this.putIntoBucket(bucket, e);
    }

    public Object forcePut(Object key, Object value2) {
        if (null == value2) {
            throw new NullPointerException();
        }
        int hc = key.hashCode();
        FastNonSynchHashBucket bucket = this.getBucket(hc);
        this.getValueFromBucket(bucket, hc, key, true);
        FastNonSynchHashEntry e = new FastNonSynchHashEntry(hc, key, value2);
        return this.putIntoBucket(bucket, e);
    }

    public Object forcePut(Object key, int hc, Object value2) {
        if (null == value2) {
            throw new NullPointerException();
        }
        FastNonSynchHashBucket bucket = this.getBucket(hc);
        this.getValueFromBucket(bucket, hc, key, true);
        FastNonSynchHashEntry e = new FastNonSynchHashEntry(hc, key, value2);
        return this.putIntoBucket(bucket, e);
    }

    private FastNonSynchHashBucket getBucket(int hc) {
        int index = hc & Integer.MAX_VALUE;
        return this.mainTable[index % this.xVar][index % 3];
    }

    private Object putIntoBucket(FastNonSynchHashBucket bucket, FastNonSynchHashEntry newEntry) {
        FastNonSynchHashEntry e = bucket.root;
        FastNonSynchHashEntry last = null;
        while (null != e) {
            if (e.hash == newEntry.hash && e.key.equals(newEntry.key)) {
                return e.value;
            }
            last = e;
            e = e.next;
        }
        if (null == last) {
            if (null == bucket.root) {
                bucket.root = newEntry;
                return newEntry.value;
            }
            last = bucket.root;
            while (null != last.next) {
                last = last.next;
            }
        }
        last.next = newEntry;
        return newEntry.value;
    }

    public boolean containsKey(Object key) {
        int hc = key.hashCode();
        return null != this.getValueFromBucket(this.getBucket(hc), hc, key, false);
    }

    public boolean containsKey(Object key, int hc) {
        return null != this.getValueFromBucket(this.getBucket(hc), hc, key, false);
    }

    public Object remove(Object key) {
        int hc = key.hashCode();
        return this.getValueFromBucket(this.getBucket(hc), hc, key, true);
    }

    public Object remove(Object key, int hc) {
        return this.getValueFromBucket(this.getBucket(hc), hc, key, true);
    }
}

