/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.genericbnf.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.genericbnf.impl.QuickGenericMatcher;
import com.ibm.wsspi.genericbnf.GenericKeys;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BinaryHeaderNode {
    private static final TraceComponent tc = Tr.register(BinaryHeaderNode.class, "GenericBNF", "com.ibm.ws.genericbnf.resources.genericbnfMessages");
    protected char myChar;
    private int minSize = 100000;
    private int maxSize = 0;
    private List<String> stringCollection = new ArrayList<String>();
    private Map<String, Object> keyMap = new HashMap<String, Object>();
    private char[][] charMap;
    private Object[] values;
    private byte[][] byteMap;
    private boolean isNull = false;
    private boolean initialized = false;
    private boolean isCaseSensitive = true;
    private boolean makeAllLower = true;

    public BinaryHeaderNode(char thisNodesChar, boolean makeLower) {
        this.myChar = thisNodesChar;
        this.isCaseSensitive = false;
        this.makeAllLower = makeLower;
    }

    public BinaryHeaderNode(char thisNodesChar) {
        this.myChar = thisNodesChar;
        this.isCaseSensitive = true;
    }

    public boolean add(GenericKeys value2) {
        if (this.initialized) {
            throw new RuntimeException("Error in the order of setting this thing up");
        }
        String s = value2.getName();
        if (!this.isCaseSensitive) {
            s = this.makeAllLower ? s.toLowerCase() : s.toUpperCase();
        }
        this.stringCollection.add(s);
        this.keyMap.put(s, value2);
        return true;
    }

    public boolean add(String s, Object value2) {
        if (this.initialized) {
            throw new RuntimeException("Error in the order of setting this thing up");
        }
        if (!this.isCaseSensitive) {
            s = this.makeAllLower ? s.toLowerCase() : s.toUpperCase();
        }
        this.stringCollection.add(s);
        this.keyMap.put(s, value2);
        return true;
    }

    public void init() {
        this.initialized = true;
        if (this.stringCollection.size() <= 0) {
            this.isNull = true;
            this.stringCollection = null;
            this.keyMap = null;
            return;
        }
        int size = this.stringCollection.size();
        String[] myOrderedStrings = new String[size];
        this.stringCollection.toArray(myOrderedStrings);
        this.stringCollection = null;
        this.values = new Object[size];
        this.byteMap = new byte[size][];
        this.charMap = new char[size][];
        for (int i = 0; i < size; ++i) {
            if (null == myOrderedStrings[i]) {
                throw new RuntimeException("String is null for key");
            }
            this.values[i] = this.keyMap.get(myOrderedStrings[i]);
            if (null == this.values[i]) {
                throw new RuntimeException("values entry is be null");
            }
            this.byteMap[i] = GenericUtils.getEnglishBytes(myOrderedStrings[i]);
            this.charMap[i] = myOrderedStrings[i].toCharArray();
            if (myOrderedStrings[i].length() < this.minSize) {
                this.minSize = myOrderedStrings[i].length();
            }
            if (myOrderedStrings[i].length() <= this.maxSize) continue;
            this.maxSize = myOrderedStrings[i].length();
        }
        this.keyMap = null;
    }

    public Object match(byte[] input) {
        return this.match(input, 0, input.length);
    }

    public Object match(byte[] input, int offset, int length) {
        if (this.isNull || length < this.minSize || length > this.maxSize) {
            return null;
        }
        boolean found = false;
        int lastchar = offset + length - 1;
        for (int i = 0; i < this.values.length; ++i) {
            byte[] test = this.byteMap[i];
            if (test.length != length || !this.isEqual(input[lastchar], test[test.length - 1])) continue;
            found = true;
            int x = test.length - 2;
            int j = lastchar - 1;
            while (j > offset) {
                if (!this.isEqual(input[j], test[x])) {
                    found = false;
                    break;
                }
                --j;
                --x;
            }
            if (!found) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Byte value [" + GenericUtils.getEnglishString(input, offset, offset + length) + "] matches key: " + this.values[i]);
            }
            return this.values[i];
        }
        return null;
    }

    public Object match(char[] input) {
        return this.match(input, 0, input.length);
    }

    public Object match(char[] input, int offset, int length) {
        if (this.isNull || length < this.minSize || length > this.maxSize) {
            return null;
        }
        boolean found = false;
        int lastchar = offset + length - 1;
        for (int i = 0; i < this.values.length; ++i) {
            char[] test = this.charMap[i];
            if (test.length != length || !this.isEqual(input[lastchar], test[test.length - 1])) continue;
            found = true;
            int x = test.length - 2;
            int j = lastchar - 1;
            while (j > offset) {
                if (!this.isEqual(input[j], test[x])) {
                    found = false;
                    break;
                }
                --j;
                --x;
            }
            if (!found) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Char value [" + new String(input, offset, length) + "] matches key: " + this.values[i]);
            }
            return this.values[i];
        }
        return null;
    }

    private boolean isEqual(byte b1, byte b2) {
        return b1 == b2 || !this.isCaseSensitive && this.isEqualCaseInsensitive(b1, b2);
    }

    private boolean isEqual(char c1, char c2) {
        return c1 == c2 || !this.isCaseSensitive && this.isEqualCaseInsensitive(c1, c2);
    }

    private boolean isEqualCaseInsensitive(int i1, int i2) {
        int value2 = this.makeAllLower ? QuickGenericMatcher.normalizeToLower(i1) : QuickGenericMatcher.normalizeToUpper(i1);
        return value2 == i2;
    }
}

