/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc;

import com.ibm.ws.ffdc.IncidentStream;
import com.ibm.ws.ffdc.IntrospectionLevelMember;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntrospectionLevel {
    public static final String $sccsid = "@(#) 1.1 SERV1/ws/code/ras.lite/src/com/ibm/ws/ffdc/IntrospectionLevel.java, WAS.ras.lite, WAS70.SERV1, q0834.18 06/11/06 11:21:24 [8/27/08 16:06:20]";
    private int _sizeOfJustThisLevel = 0;
    private int _sizeOfAllLevelsUpToAndIncludingThisLevel = 0;
    private Set<IntrospectionLevelMember> _members;
    private IntrospectionLevel _nextLevel = null;
    private int _levelDepth;

    public IntrospectionLevel(Object rootObject) {
        this._levelDepth = 0;
        this._members = new HashSet<IntrospectionLevelMember>();
        this._members.add(new IntrospectionLevelMember(rootObject));
        this.computeSizeOfLevelMembers();
        this._sizeOfAllLevelsUpToAndIncludingThisLevel = this._sizeOfJustThisLevel;
    }

    private IntrospectionLevel(int levelDepth, IntrospectionLevel parentLevel, Set<IntrospectionLevelMember> members) {
        this._members = members;
        this._levelDepth = levelDepth;
        this.computeSizeOfLevelMembers();
        if (parentLevel != null) {
            this._sizeOfAllLevelsUpToAndIncludingThisLevel = parentLevel.getNumberOfBytesInAllLevelsIncludingThisOne();
        }
        this._sizeOfAllLevelsUpToAndIncludingThisLevel += this._sizeOfJustThisLevel;
    }

    private void computeSizeOfLevelMembers() {
        this._sizeOfJustThisLevel = 0;
        for (IntrospectionLevelMember ilm : this._members) {
            this._sizeOfJustThisLevel += ilm.sizeOfIntrospection();
        }
    }

    public IntrospectionLevel getNextLevel() {
        if (this._nextLevel == null) {
            HashSet<IntrospectionLevelMember> _nextSet = new HashSet<IntrospectionLevelMember>();
            for (IntrospectionLevelMember ilm : this._members) {
                _nextSet.addAll(ilm.getChildren());
            }
            this._nextLevel = new IntrospectionLevel(this._levelDepth + 1, this, _nextSet);
        }
        return this._nextLevel;
    }

    public int getNumberOfBytesinJustThisLevel() {
        return this._sizeOfJustThisLevel;
    }

    public boolean hasMembers() {
        return !this._members.isEmpty();
    }

    public int getNumberOfBytesInAllLevelsIncludingThisOne() {
        return this._sizeOfAllLevelsUpToAndIncludingThisLevel;
    }

    public void print(IncidentStream is, int actualDepth) {
        for (IntrospectionLevelMember ilm : this._members) {
            ilm.print(is, actualDepth);
        }
    }
}

