/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.models.config.ipc.ssl.KeySet;
import com.ibm.websphere.models.config.ipc.ssl.KeySetGroup;
import com.ibm.ws.crypto.config.KeyReference;
import com.ibm.ws.crypto.config.KeySetManager;
import com.ibm.ws.crypto.config.WSKeyPairReference;
import com.ibm.ws.crypto.config.WSKeyReference;
import com.ibm.ws.crypto.config.WSKeySet;
import com.ibm.ws.crypto.config.WSScheduler;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityConfigObjectList;
import com.ibm.ws.ssl.config.AdminContextHelper;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class WSKeySetGroup
implements AlarmListener {
    private static final TraceComponent tc = Tr.register(WSKeySetGroup.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    String name = null;
    boolean autoGenerate = true;
    WSScheduler scheduler = null;
    List keySetList = null;
    String scope = ManagementScopeManager.getInstance().getCellScopeName();

    public WSKeySetGroup(KeySetGroup ksGroup) {
        String uuid;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSKeySetGroup");
        }
        if ((uuid = AdminContextHelper.peekAdminContext()) == null) {
            uuid = "admin";
        }
        this.name = ksGroup.getName();
        this.autoGenerate = ksGroup.isAutoGenerate();
        this.keySetList = this.convertToWSKeySets(ksGroup.getKeySet());
        this.scope = ksGroup.getManagementScope().getScopeName();
        if (this.autoGenerate && (ManagementScopeManager.getInstance().getProcessType().equals("DeploymentManager") || ManagementScopeManager.getInstance().getProcessType().equals("UnManagedProcess") && !this.isCellRegistered() || ManagementScopeManager.getInstance().getProcessType().equals("JobManager") || ManagementScopeManager.getInstance().getProcessType().equals("AdminAgent"))) {
            this.scheduler = new WSScheduler(ksGroup.getWsSchedule(), (AlarmListener)this, this.name + "_" + uuid);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSKeySetGroup", new Object[]{this.toString()});
        }
    }

    public WSKeySetGroup(SecurityConfigObject ksGroup) {
        String uuid;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSKeySetGroup");
        }
        if ((uuid = AdminContextHelper.peekAdminContext()) == null) {
            uuid = "admin";
        }
        this.name = ksGroup.getString("name");
        this.autoGenerate = ksGroup.getBoolean("autoGenerate");
        this.keySetList = this.convertToWSKeySets(ksGroup.getObjectList("keySet"));
        this.scope = ksGroup.getObject("managementScope").getString("scopeName");
        if (this.autoGenerate && (ManagementScopeManager.getInstance().getProcessType().equals("DeploymentManager") || ManagementScopeManager.getInstance().getProcessType().equals("UnManagedProcess") && !this.isCellRegistered() || ManagementScopeManager.getInstance().getProcessType().equals("JobManager") || ManagementScopeManager.getInstance().getProcessType().equals("AdminAgent"))) {
            this.scheduler = new WSScheduler(ksGroup.getObject("wsSchedule"), (AlarmListener)this, this.name + "_" + uuid);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSKeySetGroup", new Object[]{this.toString()});
        }
    }

    public void alarm(Object alarmCtx) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "alarm", alarmCtx);
            }
            try {
                StartAlarm action = new StartAlarm(this);
                Class<?> cl1 = Class.forName("com.ibm.ws.security.core.ContextManagerFactory");
                Method theMethod1 = cl1.getMethod("getInstance", null);
                Object ctxMgr = theMethod1.invoke(null, null);
                Class<?> cl2 = Class.forName("com.ibm.ws.security.core.ContextManager");
                Method theMethod2 = cl2.getMethod("runAsSystem", PrivilegedExceptionAction.class);
                theMethod2.invoke(ctxMgr, action);
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.crypto.config.WSKeySetGroup.alarm", "120", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "WSKeySetGroup alarm did not execute.", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm");
        }
    }

    private List convertToWSKeySets(List keySetList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToWSKeySets");
        }
        ArrayList<WSKeySet> keySets = new ArrayList<WSKeySet>();
        if (keySetList != null && keySetList.size() > 0) {
            for (int i = 0; i < keySetList.size(); ++i) {
                KeySet ref = (KeySet)keySetList.get(i);
                WSKeySet wsks = KeySetManager.getInstance().getKeySet(ref.getName());
                if (wsks == null) continue;
                keySets.add(wsks);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertToWSKeySets");
        }
        return keySets;
    }

    private List convertToWSKeySets(SecurityConfigObjectList keySetList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToWSKeySets");
        }
        ArrayList<WSKeySet> keySets = new ArrayList<WSKeySet>();
        if (keySetList != null && keySetList.size() > 0) {
            for (int i = 0; i < keySetList.size(); ++i) {
                SecurityConfigObject ref = keySetList.get(i);
                WSKeySet wsks = KeySetManager.getInstance().getKeySet(ref.getString("name"));
                if (wsks == null) continue;
                keySets.add(wsks);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertToWSKeySets");
        }
        return keySets;
    }

    public TreeMap getAllKeysByVersion() throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllKeysByVersion");
        }
        TreeMap versionMap = new TreeMap();
        for (int i = 0; i < this.keySetList.size(); ++i) {
            KeyReference[] ksetRefArray;
            WSKeySet kset = (WSKeySet)this.keySetList.get(i);
            if (kset == null || (ksetRefArray = kset.getAllKeyReferences()) == null) continue;
            for (int j = 0; j < ksetRefArray.length; ++j) {
                String mapTreeSetKey = "version_" + ksetRefArray[j].getVersion();
                if (!versionMap.containsKey(mapTreeSetKey)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding versionSort key: " + mapTreeSetKey);
                    }
                    versionMap.put(mapTreeSetKey, new HashMap());
                }
                Map keyMap = (Map)versionMap.get(mapTreeSetKey);
                if (ksetRefArray[j] instanceof WSKeyReference) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding Key alias " + ksetRefArray[j].getKeyAlias() + " to keyMap " + mapTreeSetKey);
                    }
                    keyMap.put(ksetRefArray[j].getKeyAlias(), ((WSKeyReference)ksetRefArray[j]).getKey());
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding KeyPair alias " + ksetRefArray[j].getKeyAlias() + " to keyMap " + mapTreeSetKey);
                }
                keyMap.put(ksetRefArray[j].getKeyAlias(), ((WSKeyPairReference)ksetRefArray[j]).getKeyPair());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllKeysByVersion (size: " + versionMap.size() + ")");
        }
        return versionMap;
    }

    public Map getAllKeysByKeySetName(String keySetName) throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLatestKeyByKeySetName", new Object[]{keySetName});
        }
        for (int i = 0; i < this.keySetList.size(); ++i) {
            WSKeySet kset = (WSKeySet)this.keySetList.get(i);
            if (!kset.getName().equalsIgnoreCase(keySetName)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAllKeysByKeySetName (found)");
            }
            return kset.getAllKeys();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllKeysByKeySetName (not found)");
        }
        return null;
    }

    public Object getLatestKeyByKeySetName(String keySetName) throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLatestKeyByKeySetName", new Object[]{keySetName});
        }
        for (int i = 0; i < this.keySetList.size(); ++i) {
            WSKeySet kset = (WSKeySet)this.keySetList.get(i);
            if (!kset.getName().equalsIgnoreCase(keySetName)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getLatestKeyByKeySetName (found)");
            }
            return kset.getLatestKey();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLatestKeyByKeySetName (not found)");
        }
        return null;
    }

    public WSKeySet[] getAllKeySets() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllKeySets");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllKeySets (total: " + this.keySetList.size() + ")");
        }
        return this.keySetList.toArray(new WSKeySet[this.keySetList.size()]);
    }

    public Map getLatestKeys() throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLatestKeys");
        }
        HashMap<String, Serializable> keys = new HashMap<String, Serializable>();
        for (int i = 0; i < this.keySetList.size(); ++i) {
            WSKeySet kset = (WSKeySet)this.keySetList.get(i);
            KeyReference kref = kset.getLatestKeyReference();
            if (kref instanceof WSKeyReference) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding key with alias " + kref.getKeyAlias() + " of type java.security.Key.");
                }
                keys.put(kref.getKeyAlias(), ((WSKeyReference)kref).getKey());
                continue;
            }
            if (!(kref instanceof WSKeyPairReference)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding key with alias " + kref.getKeyAlias() + " of type com.ibm.websphere.crypto.KeyPair.");
            }
            keys.put(kref.getKeyAlias(), ((WSKeyPairReference)kref).getKeyPair());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLatestKeys");
        }
        return keys;
    }

    public String getScope() {
        return this.scope;
    }

    public String getName() {
        return this.name;
    }

    public boolean getAutoGenerate() {
        return this.autoGenerate;
    }

    public String toString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toString");
        }
        StringBuffer buf = new StringBuffer();
        buf.append("WSKeySetGroup.toString() {\n");
        buf.append("name = ");
        buf.append(this.name);
        buf.append("\n");
        buf.append("autoGenerate = ");
        buf.append(this.autoGenerate);
        buf.append("\n");
        buf.append("scope = ");
        buf.append(this.scope);
        buf.append("scheduler = ");
        buf.append(this.scheduler);
        buf.append("\n}");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toString");
        }
        return buf.toString();
    }

    public boolean isCellRegistered() {
        Method isCellRegisteredMethod = null;
        Method getInstance = null;
        try {
            Class<?> adminHelperClazz = Class.forName("com.ibm.ws.management.AdminHelperImpl");
            getInstance = adminHelperClazz.getMethod("getInstance", new Class[0]);
            Object instance = getInstance.invoke(null, new Object[0]);
            isCellRegisteredMethod = adminHelperClazz.getMethod("isCellRegistered", new Class[0]);
            Boolean ret = (Boolean)isCellRegisteredMethod.invoke(instance, new Object[0]);
            return ret;
        }
        catch (Throwable ex) {
            Manager.Ffdc.log(ex, WSKeySetGroup.class, "com.ibm.ws.crypto.config.WSKeySetGroup.isCellRegistered", "%C");
            return false;
        }
    }

    public WSScheduler getScheduler() {
        return this.scheduler;
    }

    class StartAlarm
    implements PrivilegedExceptionAction {
        private WSKeySetGroup thisKeySetGroup = null;

        public StartAlarm(WSKeySetGroup keySetGroup) {
            this.thisKeySetGroup = keySetGroup;
        }

        public Object run() throws Exception {
            Class<?> cl1 = Class.forName("com.ibm.ws.ssl.utils.KeySetGroupCommandActivator");
            Method theMethod1 = cl1.getMethod("invokeCreateKeyReferenceCommand", WSKeySetGroup.class);
            theMethod1.invoke(cl1.newInstance(), this.thisKeySetGroup);
            return null;
        }
    }
}

