/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.commons.logging;

import com.ibm.ejs.ras.MessageEvent6;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceEvent6;
import org.apache.commons.logging.Log;

public final class TrLog
implements Log {
    private TraceComponent tc = null;
    private static final String ibm = "IBM";
    private static final String webSphere = "WebSphere";
    private static final String method = "";
    private String component = null;
    private static final String className = "";

    public TrLog(String name2, String component) {
        this.component = component;
        this.tc = Tr.register(name2, component, null);
    }

    public void trace(Object message) {
        if (this.isTraceEnabled()) {
            this.trace(5, String.valueOf(message));
        }
    }

    public void trace(Object message, Throwable t) {
        if (this.isTraceEnabled()) {
            this.trace(5, String.valueOf(message));
            this.trace(5, t);
        }
    }

    public void debug(Object message) {
        if (this.isDebugEnabled()) {
            this.trace(2, String.valueOf(message));
        }
    }

    public void debug(Object message, Throwable t) {
        if (this.isDebugEnabled()) {
            this.trace(2, String.valueOf(message));
            this.trace(2, t);
        }
    }

    public void info(Object message) {
        if (this.isInfoEnabled()) {
            this.log(11, String.valueOf(message));
        }
    }

    public void info(Object message, Throwable t) {
        if (this.isInfoEnabled()) {
            this.log(11, String.valueOf(message));
            this.log(11, t);
        }
    }

    public void warn(Object message) {
        if (this.isWarnEnabled()) {
            this.log(10, String.valueOf(message));
        }
    }

    public void warn(Object message, Throwable t) {
        if (this.isWarnEnabled()) {
            this.log(10, String.valueOf(message));
            this.log(10, t);
        }
    }

    public void error(Object message) {
        if (this.isErrorEnabled()) {
            this.log(4, String.valueOf(message));
        }
    }

    public void error(Object message, Throwable t) {
        if (this.isErrorEnabled()) {
            this.log(4, String.valueOf(message));
            this.log(4, t);
        }
    }

    public void fatal(Object message) {
        if (this.isFatalEnabled()) {
            this.log(8, String.valueOf(message));
        }
    }

    public void fatal(Object message, Throwable t) {
        if (this.isFatalEnabled()) {
            this.log(8, String.valueOf(message));
            this.log(8, t);
        }
    }

    public boolean isTraceEnabled() {
        return this.tc.isEventEnabled();
    }

    public boolean isDebugEnabled() {
        return this.tc.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.tc.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.tc.isWarningEnabled();
    }

    public boolean isErrorEnabled() {
        return this.tc.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.tc.isFatalEnabled();
    }

    private void log(int type, String text) {
        try {
            MessageEvent6 event = new MessageEvent6(type, this.tc, text, null, null, ibm, webSphere, this.component, "", "", null);
            Tr.logJrasEvent((MessageEvent6)event);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void log(int type, Throwable throwable) {
        try {
            String bundle = "com.ibm.ejs.resources.RasMessages";
            String extendedMessage = RasHelper.throwableToString(throwable);
            MessageEvent6 event = new MessageEvent6(type, this.tc, "MSG_EXCEPTION_LOGGED", bundle, (Object)extendedMessage, ibm, webSphere, this.component, "", "", extendedMessage);
            Tr.logJrasEvent((MessageEvent6)event);
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    private void trace(int type, String text) {
        try {
            TraceEvent6 event = new TraceEvent6(type, this.tc, text, null, ibm, webSphere, this.component, "", "", null);
            Tr.logJrasEvent((TraceEvent6)event);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void trace(int type, Throwable throwable) {
        try {
            String extendedMessage = RasHelper.throwableToString(throwable);
            TraceEvent6 event = new TraceEvent6(type, this.tc, "The following exception was logged", (Object)extendedMessage, ibm, webSphere, this.component, "", "", extendedMessage);
            Tr.logJrasEvent((TraceEvent6)event);
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }
}

