/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionFactory;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.Format;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.cluster.Compressor;
import com.ibm.ws.cluster.topography.ConcernImpl;
import com.ibm.ws.cluster.topography.DescriptionKeyImpl;
import com.ibm.ws.cluster.topography.FormatImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ObjectPool;
import com.ibm.ws.wlm.TypeConversion;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class DescriptionManagerA
implements DescriptionManager {
    private static final TraceComponent tc = Tr.register(DescriptionManagerA.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    protected static final KeyRepository keyRepository;
    protected static final Format format;
    protected static final byte VERSION2 = 2;
    protected static final byte COMPRESSED = 1;
    protected static final byte UNCOMPRESSED = 0;
    private ObjectPool streamPool = new ObjectPool("WLMDescriptionManagerStreamPool", 5);

    public synchronized Description getDescription(DescriptionKey key) {
        if (key == null) {
            throw new IllegalArgumentException("The key must not be null.");
        }
        Description result = ((DescriptionKeyImpl)key).getDescription();
        return result;
    }

    public synchronized Description getDescription(DescriptionKey key, String implKey) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (key == null) {
            throw new IllegalArgumentException("The key must not be null.");
        }
        if (implKey == null || implKey.length() == 0) {
            throw new IllegalArgumentException("The implKey passed in was [" + implKey + "] which is not valid.");
        }
        Description result = ((DescriptionKeyImpl)key).getDescription();
        if (result != null) {
            return result;
        }
        result = DescriptionFactory.getInstance().createDescription(key, implKey);
        ((DescriptionKeyImpl)key).setDescription(result);
        return result;
    }

    synchronized Description getLocalDescription(DescriptionKey key, String implKey) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (key == null) {
            throw new IllegalArgumentException("The key must not be null.");
        }
        if (implKey == null || implKey.length() == 0) {
            throw new IllegalArgumentException("The implKey passed in was [" + implKey + "] which is not valid.");
        }
        Description result = ((DescriptionKeyImpl)key).getDescription();
        if (result != null) {
            return result;
        }
        result = DescriptionFactory.getInstance().createLocalDescription(key, implKey);
        ((DescriptionKeyImpl)key).setDescription(result);
        return result;
    }

    public void stream(Map formatsToKeys, ObjectOutput out) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stream", formatsToKeys);
        }
        int count = formatsToKeys.size();
        Set formats = formatsToKeys.keySet();
        Iterator iterator = formats.iterator();
        out.writeInt(count);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote count " + count);
        }
        while (iterator.hasNext()) {
            Format mapFormat = (Format)iterator.next();
            out.writeObject(mapFormat);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote format ", mapFormat);
            }
            Set descriptionKeySet = (Set)formatsToKeys.get(mapFormat);
            out.writeInt(descriptionKeySet.size());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote size " + descriptionKeySet.size());
            }
            for (DescriptionKey element : descriptionKeySet) {
                keyRepository.exportToStream(out, element);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "wrote key", element);
                }
                Description description = this.getDescription(element);
                out.writeObject(description.getDefinitionKey());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "wrote definiton key", description.getDefinitionKey());
                }
                description.exportToStream(out, mapFormat);
                if (!tc.isEventEnabled()) continue;
                Tr.event(tc, "Description streamed", description);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stream");
        }
    }

    public void update(ObjectInput in) throws IOException {
        Format mapFormat = null;
        DescriptionKey key = null;
        try {
            int count = in.readInt();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read count " + count);
            }
            while (count > 0) {
                mapFormat = (Format)in.readObject();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "read format ", mapFormat);
                }
                int size = in.readInt();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "read size " + size);
                }
                while (size > 0) {
                    key = keyRepository.importFromStream(in);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "read key", key);
                    }
                    String implString = (String)in.readObject();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "read definition key", implString);
                    }
                    Description description = this.getDescription(key, implString);
                    Description.Memento memento = description.importFromStream(in, mapFormat, null);
                    --size;
                    description.setMemento(memento);
                    if (!tc.isEventEnabled()) continue;
                    Tr.event(tc, "Description updated", memento);
                }
                --count;
            }
        }
        catch (InstantiationException e) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected", e);
            }
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        catch (IllegalAccessException e) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected", e);
            }
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        catch (InvocationTargetException e) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected", e);
            }
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        catch (NoSuchMethodException e) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected", e);
            }
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        catch (ClassNotFoundException e) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected", e);
            }
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public boolean publish(Description description) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "publish", description);
        }
        boolean result = true;
        byte[] data = this.getDatatFromDescription(description);
        byte[] v2array = null;
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        list.add(data);
        Iterator iter = list.iterator();
        v2array = this.aggregateMultipleInputs(iter, new Integer(42));
        if (tc.isEventEnabled()) {
            Tr.event(tc, "publishing (version " + v2array[0] + ") " + description.getKey(), new Object[]{String.valueOf(data.length), String.valueOf(v2array.length)});
        }
        if (!(result = description.isLocal() ? false : this.publish(this.keyToString(description.getKey()), v2array))) {
            this.handleLocal(description, data);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "publish", String.valueOf(result));
        }
        return result;
    }

    public void update(String identifier, byte[][] data) {
        block19: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "update", new Object[]{identifier, data == null ? null : String.valueOf(data.length)});
            }
            try {
                Description description;
                DescriptionKey key = this.stringToKey(identifier);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "processing update for subject " + key);
                }
                if ((description = this.getDescription(key)) == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "updated - description removed");
                    }
                    return;
                }
                Description.Memento memento = null;
                if (data == null) {
                    description.setMemento(description.createMemento());
                } else {
                    for (int i = 0; i < data.length; ++i) {
                        byte[] bytes = data[i];
                        if (bytes == null || bytes.length <= 2) continue;
                        byte version = bytes[0];
                        if (version <= 1) {
                            if (bytes[1] == 1) {
                                bytes = Compressor.decompress(bytes, 2);
                            }
                            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                            DataInputStream dis = new DataInputStream(bais);
                            do {
                                dis.skipBytes(2);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Available bytes (version " + version + ") " + String.valueOf(bais.available()));
                                }
                                memento = description.importFromStream(dis, format, memento);
                            } while (version >= 1 && bais.available() > 2);
                            continue;
                        }
                        if (version < 2) continue;
                        byte[][] theByteArrays = this.divideMultipleInputs(bytes);
                        for (int j = 0; j < theByteArrays.length; ++j) {
                            byte[] theseBytes = theByteArrays[j];
                            if (theseBytes[1] == 1) {
                                theseBytes = Compressor.decompress(theseBytes, 2);
                            }
                            ByteArrayInputStream bais = new ByteArrayInputStream(theseBytes);
                            DataInputStream dis = new DataInputStream(bais);
                            dis.skipBytes(2);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Available bytes (version " + version + ") " + String.valueOf(bais.available()));
                            }
                            memento = description.importFromStream(dis, format, memento);
                        }
                    }
                    if (memento == null) {
                        description.setMemento(description.createMemento());
                    } else {
                        description.setMemento(memento);
                    }
                }
            }
            catch (IOException e) {
                FFDCFilter.processException(e, DescriptionManagerA.class.getName() + ".update", "362", this, new Object[]{identifier, data});
                if (!tc.isEventEnabled()) break block19;
                Tr.event(tc, "Unexpected: Unable to perform update", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "update");
        }
    }

    public String keyToString(DescriptionKey key) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "keyToString", key);
        }
        if (key == null) {
            throw new IllegalArgumentException("Identity parameter is a null reference.");
        }
        String result = null;
        byte[] array = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream oos = new DataOutputStream(baos);
            TreeMap identities = new TreeMap(key.getProperties());
            oos.writeByte(0);
            int count = identities.size();
            oos.writeInt(count);
            Iterator iterator = identities.entrySet().iterator();
            for (int i = 0; i < count; ++i) {
                Map.Entry element = iterator.next();
                oos.writeUTF((String)element.getKey());
                oos.writeUTF((String)element.getValue());
            }
            oos.flush();
            baos.flush();
            array = baos.toByteArray();
            baos.close();
            oos.close();
            result = Util.toHexString((byte[])array);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, DescriptionManagerA.class.getName() + ".keyToString", "613", this, new Object[]{key});
            IllegalStateException iex = new IllegalStateException();
            iex.initCause(e);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected", e);
            }
            throw iex;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "keyToString", result);
        }
        return result;
    }

    public DescriptionKey stringToKey(String keyString) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToKey", keyString);
        }
        DescriptionKey key = null;
        try {
            byte[] array = Util.fromHexString((String)keyString);
            ByteArrayInputStream bais = new ByteArrayInputStream(array);
            DataInputStream ois = new DataInputStream(bais);
            HashMap<String, String> identities = new HashMap<String, String>();
            ois.readByte();
            int count = ois.readInt();
            for (int i = 0; i < count; ++i) {
                String name2 = ois.readUTF();
                String value2 = ois.readUTF();
                identities.put(name2, value2);
            }
            ois.close();
            bais.close();
            key = keyRepository.getDescriptionKey(identities);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, DescriptionManagerA.class.getName() + ".stringToKey", "648", this, new Object[]{keyString});
            IllegalStateException iex = new IllegalStateException();
            iex.initCause(e);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected", e);
            }
            throw iex;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToKey", key);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] aggregateMultipleInputs(Iterator iter, Object mutex) {
        byte[] result = new byte[4];
        Object object = mutex;
        synchronized (object) {
            short count = 0;
            result[0] = 2;
            while (iter.hasNext()) {
                byte[] next = (byte[])iter.next();
                count = (short)(count + 1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "count: " + count);
                    Tr.debug(tc, "data to aggregate: ", next);
                }
                if (next[1] == 1) {
                    next = Compressor.decompress(next, 2);
                    next[1] = 0;
                }
                byte[] newPublish = new byte[result.length + next.length + 4];
                System.arraycopy(result, 0, newPublish, 0, result.length);
                newPublish[result.length] = next[0];
                newPublish[result.length + 1] = next[1];
                TypeConversion.intToBytes((int)(next.length - 2), (byte[])newPublish, (int)(result.length + 2));
                System.arraycopy(next, 2, newPublish, result.length + 6, next.length - 2);
                result = newPublish;
            }
            TypeConversion.shortToBytes((short)count, (byte[])result, (int)1);
        }
        if (result.length > 128) {
            result = Compressor.compress(result, 4);
            result[3] = 1;
        } else {
            result[3] = 0;
        }
        return result;
    }

    protected byte[][] divideMultipleInputs(byte[] data) {
        byte version = data[0];
        int count = TypeConversion.bytesToShort((byte[])data, (int)1);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "data Length" + data.length);
            Tr.debug(tc, "data is ", data);
        }
        byte streamCompressed = data[3];
        byte[][] result = new byte[count][];
        if (streamCompressed == 1) {
            data = Compressor.decompress(data, 4);
        }
        int position = 4;
        for (int i = 0; i < count; ++i) {
            int lengthOfBytesToRead = TypeConversion.bytesToInt((byte[])data, (int)(position + 2));
            byte[] individualDescription = new byte[lengthOfBytesToRead + 2];
            individualDescription[0] = data[position];
            individualDescription[1] = data[position + 1];
            System.arraycopy(data, position + 6, individualDescription, 2, lengthOfBytesToRead);
            result[i] = individualDescription;
            position = position + lengthOfBytesToRead + 6;
        }
        return result;
    }

    protected byte[] getDatatFromDescription(Description description) {
        byte[] data;
        block4: {
            DataOutputStream dos;
            ByteArrayOutputStream baos;
            data = null;
            OutputStream[] streams = (OutputStream[])this.streamPool.remove();
            if (streams == null) {
                baos = new ByteArrayOutputStream();
                dos = new DataOutputStream(baos);
                streams = new OutputStream[]{baos, dos};
            } else {
                baos = (ByteArrayOutputStream)streams[0];
                dos = (DataOutputStream)streams[1];
            }
            try {
                dos.writeByte(1);
                dos.writeByte(0);
                description.exportToStream(dos, format);
                dos.flush();
                data = baos.toByteArray();
                baos.reset();
                this.streamPool.add(streams);
            }
            catch (IOException e) {
                FFDCFilter.processException(e, DescriptionManagerA.class.getName() + ".publish", "730", this, new Object[]{description});
                Tr.warning(tc, "NLSKEY_UNEXPECTED_EXCEPTION", new Object[]{DescriptionManagerA.class.getName() + ".publish", e});
                if (!tc.isEventEnabled()) break block4;
                Tr.event(tc, "unexpected", e);
            }
        }
        return data;
    }

    protected void handleLocal(Description description, byte[] data) {
        block2: {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                DataInputStream dis = new DataInputStream(bais);
                dis.readByte();
                dis.readByte();
                description.setMemento(description.importFromStream(dis, format, null));
            }
            catch (IOException e) {
                FFDCFilter.processException(e, DescriptionManagerA.class.getName() + ".publish", "763", this, new Object[]{description});
                Tr.warning(tc, "NLSKEY_UNEXPECTED_EXCEPTION", new Object[]{DescriptionManagerA.class.getName() + ".publish", e});
                if (!tc.isEventEnabled()) break block2;
                Tr.event(tc, "unexpected", e);
            }
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.17 ");
        }
        keyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
        format = new FormatImpl(new ConcernImpl(Integer.MAX_VALUE), 4);
    }
}

