/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.service;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.DescriptionModificationListener;
import com.ibm.websphere.cluster.topography.IdentityMap;
import com.ibm.websphere.cluster.topography.IntrinsicDescription;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.WLMCustomPropertyUtility;
import com.ibm.ws.cluster.service.ClientClusterContextImpl;
import com.ibm.ws.cluster.service.EndPointImpl;
import com.ibm.ws.cluster.topography.SelectionClusterMemberDescription;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cluster.ClusterObserver;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.IdentityMapping;
import com.ibm.wsspi.cluster.NoClusterDefinedException;
import com.ibm.wsspi.cluster.NoMemberAvailableException;
import com.ibm.wsspi.cluster.distribution.ClientClusterContext;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class ClusterServiceImpl
implements ClusterService,
DescriptionModificationListener {
    private static final TraceComponent tc = Tr.register(ClusterServiceImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private Map listeners = new HashMap();
    private Map coIdentifiers = Collections.synchronizedMap(new HashMap());
    private DescriptionManager descMgr = DescriptionManagerFactory.getDescriptionManager();
    private KeyRepository keyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
    protected ReferenceQueue refQueue = new ReferenceQueue();
    private boolean purgeNotifications = WLMCustomPropertyUtility.getPurgeNotificationsValue();

    public Identity getIdentity(Map nameValuePairs) throws IllegalArgumentException {
        return this.keyRepository.getDescriptionKey(nameValuePairs);
    }

    public byte[] getClusterScopedData(Identity clusterIdentity, Identity dataIdentity) throws NoClusterDefinedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterScopedData", new Object[]{clusterIdentity, dataIdentity});
        }
        byte[] result = null;
        DescriptionKey clusterKey = (DescriptionKey)clusterIdentity;
        DescriptionKey dataKey = (DescriptionKey)dataIdentity;
        ClusterDescription clusterDescription = null;
        try {
            clusterDescription = (ClusterDescription)this.descMgr.getDescription(clusterKey, ClusterDescription.class.getName());
            ClusterDescription.Memento cdMemento = (ClusterDescription.Memento)clusterDescription.getMemento();
            result = cdMemento.getClusterScopedData(dataKey);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, ClusterServiceImpl.class.getName() + ".getClusterScopedData", "174");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception ", e);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClusterScopedData");
            }
            throw new NoClusterDefinedException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterScopedData", result);
        }
        return result;
    }

    public byte[] getMemberScopedData(Identity memberIdentity, Identity dataIdentity) throws NoMemberAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMemberScopedData", new Object[]{memberIdentity, dataIdentity});
        }
        byte[] result = null;
        DescriptionKey memberKey = (DescriptionKey)memberIdentity;
        ClusterMemberDescription memberDescription = (ClusterMemberDescription)this.descMgr.getDescription(memberKey);
        if (memberDescription == null) {
            throw new NoMemberAvailableException();
        }
        ClusterMemberDescription.Memento memento = (ClusterMemberDescription.Memento)memberDescription.getMemento();
        EndPointImpl ep = (EndPointImpl)memento.getExtrinsicData((DescriptionKey)dataIdentity);
        if (ep != null) {
            result = ep.getData();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMemberScopedData", result);
        }
        return result;
    }

    public ClientClusterContext getClientClusterContextListener(List clusters) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientClusterContext", clusters);
        }
        ClientClusterContext result = null;
        SoftReference reference = (SoftReference)this.listeners.get(clusters);
        if (reference != null && (result = (ClientClusterContext)reference.get()) != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClientClusterContext", result);
            }
            return result;
        }
        result = new ClientClusterContextImpl(clusters);
        this.listeners.put(clusters, new SoftReference<ClientClusterContext>(result));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientClusterContext", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInterest(ClusterObserver observer, Identity identifier, String type) {
        Identity objIdentifier;
        block26: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "registerInterest", new Object[]{observer, identifier, type});
            }
            if (this.purgeNotifications) {
                this.purge();
            }
            objIdentifier = identifier;
            try {
                SelectionClusterMemberDescription member;
                Identity scmdIdentity;
                HashMap<String, String> scmdIdentityMap;
                ClusterMemberDescription member2;
                IdentityMap identityMap;
                if (type.equals("cluster.active")) {
                    identityMap = (IdentityMap)this.descMgr.getDescription((DescriptionKey)identifier, IdentityMap.class.getName());
                    identityMap.registerNotificationListener(this, "type.key.added", "cluster.active");
                } else if (type.equals("cluster.deactive")) {
                    identityMap = (IdentityMap)this.descMgr.getDescription((DescriptionKey)identifier, IdentityMap.class.getName());
                    identityMap.registerNotificationListener(this, "type.key.removed", "cluster.deactive");
                } else if (type.equals("type.endpoint.added")) {
                    member2 = (ClusterMemberDescription)this.descMgr.getDescription((DescriptionKey)identifier, ClusterMemberDescription.class.getName());
                    member2.registerNotificationListener(this, "type.add.extrinsic", "type.endpoint.added");
                } else if (type.equals("type.endpoint.removed")) {
                    member2 = (ClusterMemberDescription)this.descMgr.getDescription((DescriptionKey)identifier, ClusterMemberDescription.class.getName());
                    member2.registerNotificationListener(this, "type.remove.extrinsic", "type.endpoint.removed");
                } else if (type.equals("type.attribute.added")) {
                    scmdIdentityMap = new HashMap<String, String>(identifier.getProperties());
                    scmdIdentityMap.put(SelectionClusterMemberDescription.distinction[0], SelectionClusterMemberDescription.distinction[1]);
                    scmdIdentity = this.getIdentity(scmdIdentityMap);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SelectionClusterMemberDescription Identity = ", scmdIdentity);
                    }
                    member = (SelectionClusterMemberDescription)this.descMgr.getDescription((DescriptionKey)scmdIdentity, SelectionClusterMemberDescription.class.getName());
                    member.registerNotificationListener(this, "type.attribute.added", "type.attribute.added");
                    objIdentifier = scmdIdentity;
                } else if (type.equals("type.attribute.removed")) {
                    scmdIdentityMap = new HashMap(identifier.getProperties());
                    scmdIdentityMap.put(SelectionClusterMemberDescription.distinction[0], SelectionClusterMemberDescription.distinction[1]);
                    scmdIdentity = this.getIdentity(scmdIdentityMap);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SelectionClusterMemberDescription Identity = ", scmdIdentity);
                    }
                    member = (SelectionClusterMemberDescription)this.descMgr.getDescription((DescriptionKey)scmdIdentity, SelectionClusterMemberDescription.class.getName());
                    member.registerNotificationListener(this, "type.attribute.removed", "type.attribute.removed");
                    objIdentifier = scmdIdentity;
                } else if (type.equals("type.member.scoped.data.added")) {
                    EndPoint endPoint = (EndPoint)((Object)this.descMgr.getDescription((DescriptionKey)identifier, EndPoint.class.getName()));
                    ((EndPointImpl)endPoint).registerNotificationListener(this, "type.member.scoped.data.added", "type.member.scoped.data.added");
                } else {
                    ClusterDescription clusterDescription = (ClusterDescription)this.descMgr.getDescription((DescriptionKey)identifier, ClusterDescription.class.getName());
                    clusterDescription.registerNotificationListener(this, type, type);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, ClusterServiceImpl.class.getName() + ".registerInterest", "301");
                if (!tc.isDebugEnabled()) break block26;
                Tr.debug(tc, "unexpected exception ", e);
            }
        }
        Map map = this.coIdentifiers;
        synchronized (map) {
            HashSet<WeakReference<ClusterObserver>> observerSet;
            HashMap<String, HashSet<WeakReference<ClusterObserver>>> types = (HashMap<String, HashSet<WeakReference<ClusterObserver>>>)this.coIdentifiers.get(objIdentifier);
            if (types == null) {
                types = new HashMap<String, HashSet<WeakReference<ClusterObserver>>>();
                this.coIdentifiers.put(objIdentifier, types);
            }
            if ((observerSet = (HashSet<WeakReference<ClusterObserver>>)types.get(type)) == null) {
                observerSet = new HashSet<WeakReference<ClusterObserver>>();
                types.put(type, observerSet);
            }
            observerSet.add(new WeakReference<ClusterObserver>(observer, this.refQueue));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerInterest");
        }
    }

    public void deregisterInterest(ClusterObserver observer, Identity identifier, String type) {
        Identity objIdentifier;
        block44: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "deregisterInterest", new Object[]{observer, identifier, type});
            }
            objIdentifier = identifier;
            try {
                if (type.equals("cluster.active")) {
                    IdentityMap identityMap = (IdentityMap)this.descMgr.getDescription((DescriptionKey)identifier);
                    if (identityMap != null) {
                        identityMap.deregisterNotificationListener(this, "type.key.added");
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "deregister of cluster.active invalid, no description for given key", identifier);
                    }
                } else if (type.equals("cluster.deactive")) {
                    IdentityMap identityMap = (IdentityMap)this.descMgr.getDescription((DescriptionKey)identifier);
                    if (identityMap != null) {
                        identityMap.deregisterNotificationListener(this, "type.key.removed");
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "deregister of cluster.deactive invalid, no description for given key", identifier);
                    }
                } else if (type.equals("type.endpoint.added")) {
                    ClusterMemberDescription member = (ClusterMemberDescription)this.descMgr.getDescription((DescriptionKey)identifier);
                    if (member != null) {
                        member.deregisterNotificationListener(this, "type.add.extrinsic");
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "deregister of type.endpoint.added invalid, no description for given key", identifier);
                    }
                } else if (type.equals("type.endpoint.removed")) {
                    ClusterMemberDescription member = (ClusterMemberDescription)this.descMgr.getDescription((DescriptionKey)identifier);
                    if (member != null) {
                        member.deregisterNotificationListener(this, "type.remove.extrinsic");
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "deregister of type.endpoint.removed invalid, no description for given key", identifier);
                    }
                } else if (type.equals("type.attribute.added")) {
                    SelectionClusterMemberDescription member;
                    HashMap<String, String> scmdIdentityMap = new HashMap<String, String>(identifier.getProperties());
                    scmdIdentityMap.put(SelectionClusterMemberDescription.distinction[0], SelectionClusterMemberDescription.distinction[1]);
                    Identity scmdIdentity = this.getIdentity(scmdIdentityMap);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SelectionClusterMemberDescription Identity = ", scmdIdentity);
                    }
                    if ((member = (SelectionClusterMemberDescription)this.descMgr.getDescription((DescriptionKey)scmdIdentity, SelectionClusterMemberDescription.class.getName())) != null) {
                        member.deregisterNotificationListener(this, "type.attribute.added");
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "deregister of type.attribute.added invalid, no description for given key", identifier);
                    }
                    objIdentifier = scmdIdentity;
                } else if (type.equals("type.attribute.removed")) {
                    SelectionClusterMemberDescription member;
                    HashMap<String, String> scmdIdentityMap = new HashMap<String, String>(identifier.getProperties());
                    scmdIdentityMap.put(SelectionClusterMemberDescription.distinction[0], SelectionClusterMemberDescription.distinction[1]);
                    Identity scmdIdentity = this.getIdentity(scmdIdentityMap);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SelectionClusterMemberDescription Identity = ", scmdIdentity);
                    }
                    if ((member = (SelectionClusterMemberDescription)this.descMgr.getDescription((DescriptionKey)scmdIdentity, SelectionClusterMemberDescription.class.getName())) != null) {
                        member.deregisterNotificationListener(this, "type.attribute.removed");
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "deregister of type.attribute.removed invalid, no description for given key", identifier);
                    }
                    objIdentifier = scmdIdentity;
                } else if (type.equals("type.member.scoped.data.added")) {
                    EndPoint endPoint = (EndPoint)((Object)this.descMgr.getDescription((DescriptionKey)identifier));
                    if (endPoint != null) {
                        ((EndPointImpl)endPoint).deregisterNotificationListener(this, "type.member.scoped.data.added");
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "deregister of type.member.scoped.data.added invalid, no description for given key", identifier);
                    }
                } else {
                    ClusterDescription clusterDescription = (ClusterDescription)this.descMgr.getDescription((DescriptionKey)identifier, ClusterDescription.class.getName());
                    if (clusterDescription != null) {
                        clusterDescription.deregisterNotificationListener(this, type);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "deregister of " + type + " invalid, no description for given key", identifier);
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, ClusterServiceImpl.class.getName() + ".registerInterest", "301");
                if (!tc.isDebugEnabled()) break block44;
                Tr.debug(tc, "unexpected exception ", e);
            }
        }
        this.removeDeregisteredObserver(observer, type, objIdentifier);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deregisterInterest");
        }
    }

    public Identity[] getMemberIdentities(Identity clusterIdentity) {
        ClusterDescription clusterDescription;
        Identity[] result;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getMemberIdentities", clusterIdentity);
            }
            result = null;
            DescriptionKey clusterKey = (DescriptionKey)clusterIdentity;
            clusterDescription = null;
            try {
                clusterDescription = (ClusterDescription)this.descMgr.getDescription(clusterKey, ClusterDescription.class.getName());
            }
            catch (Exception e) {
                FFDCFilter.processException(e, ClusterServiceImpl.class.getName() + ".getMemberIdentities", "346");
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "unexpected exception ", e);
            }
        }
        if (clusterDescription != null) {
            Set keys = ((ClusterDescription.Memento)clusterDescription.getMemento()).getMembers().keySet();
            result = new Identity[keys.size()];
            keys.toArray(result);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMemberIdentities", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(DescriptionKey key, String type, Object data, Object handback) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", new Object[]{key, type, data, handback});
        }
        if (this.purgeNotifications) {
            this.purge();
        }
        boolean isAttributeNotification = false;
        if ((type.equals("type.add.extrinsic") || type.equals("type.remove.extrinsic")) && handback != null && (handback.equals("type.endpoint.added") || handback.equals("type.endpoint.removed"))) {
            if (!(data instanceof EndPoint)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleNotification: Not emitting a EndPoint added/removed notification for a non-EndPoint data type.");
                }
                return;
            }
            if (!(data instanceof EndPointImpl) || !((EndPointImpl)data).isChannelEndPoint()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleNotification: Not emitting a EndPoint added/removed notification for a non-Channel EndPoint");
                }
                return;
            }
        } else if ((type.equals("type.attribute.added") || type.equals("type.attribute.removed")) && handback != null && handback instanceof String) {
            type = (String)handback;
            isAttributeNotification = true;
        }
        if (data instanceof Description) {
            data = ((Description)data).getKey();
        }
        if ((type.equals("type.key.added") || type.equals("type.key.removed") || type.equals("type.value.modified") || type.equals("type.add.extrinsic") || type.equals("type.remove.extrinsic")) && handback != null && handback instanceof String) {
            if (data instanceof EndPoint) {
                data = ((EndPoint)data).getIdentity();
            }
            type = (String)handback;
        }
        HashMap observersToBeNotified = new HashMap();
        Map map = this.coIdentifiers;
        synchronized (map) {
            Map types = (Map)this.coIdentifiers.get(key);
            if (types != null) {
                HashSet observers = (HashSet)types.get(type);
                if (observers != null) {
                    Stack<WeakReference> garbage = new Stack<WeakReference>();
                    for (WeakReference ref : observers) {
                        ClusterObserver element;
                        ClusterObserver clusterObserver = element = ref == null ? null : (ClusterObserver)ref.get();
                        if (element != null) {
                            List<DescriptionKey> notificationList;
                            if (!observersToBeNotified.containsKey(element)) {
                                notificationList = new LinkedList();
                                observersToBeNotified.put(element, notificationList);
                            }
                            if (isAttributeNotification) {
                                SelectionClusterMemberDescription selectionMemberDescription = (SelectionClusterMemberDescription)this.descMgr.getDescription(key);
                                if (selectionMemberDescription != null) {
                                    SelectionClusterMemberDescription.Memento memento = (SelectionClusterMemberDescription.Memento)selectionMemberDescription.getMemento();
                                    if (memento != null) {
                                        DescriptionKey cmdkey = memento.getClusterMemberAssociation();
                                        if (cmdkey != null) {
                                            List notificationList2 = (List)observersToBeNotified.get(element);
                                            notificationList2.add(cmdkey);
                                            observersToBeNotified.put(element, notificationList2);
                                            continue;
                                        }
                                        if (!tc.isEventEnabled()) continue;
                                        Tr.event(tc, "ClusterMemberAssociation was null trying to send notification");
                                        continue;
                                    }
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "SelectionClusterMemberDescription.Memento was null, not sending notification");
                                    continue;
                                }
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "SelectionClusterMemberDescription was null, not sending notification");
                                continue;
                            }
                            notificationList = (List)observersToBeNotified.get(element);
                            notificationList.add(key);
                            observersToBeNotified.put(element, notificationList);
                            continue;
                        }
                        if (ref.get() != null) continue;
                        garbage.push(ref);
                    }
                    while (!garbage.empty()) {
                        observers.remove(garbage.pop());
                    }
                    if (observers.isEmpty()) {
                        types.remove(type);
                    }
                }
                if (types.isEmpty()) {
                    this.coIdentifiers.remove(key);
                }
            }
        }
        Iterator notifyIter = observersToBeNotified.keySet().iterator();
        while (notifyIter != null && notifyIter.hasNext()) {
            ClusterObserver element = (ClusterObserver)notifyIter.next();
            if (element == null) continue;
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Cluster Service, notify observer", new Object[]{element, key});
            }
            List notificationList = (List)observersToBeNotified.get(element);
            Iterator keyListIter = notificationList.iterator();
            while (keyListIter != null && keyListIter.hasNext()) {
                element.notify((Identity)keyListIter.next(), type, data);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    public EndPoint[] matchEndPoints(Identity owningIdentity, Map matchProperties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "matchEndPoints", new Object[]{owningIdentity, matchProperties});
        }
        EndPoint[] result = null;
        IntrinsicDescription description = (IntrinsicDescription)this.descMgr.getDescription((DescriptionKey)owningIdentity);
        if (description == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "matchEndPoints - no intrinsic description for passed Identity");
            }
            return new EndPoint[0];
        }
        IntrinsicDescription.Memento idMemento = (IntrinsicDescription.Memento)description.getMemento();
        Map extdescriptions = idMemento.getExtrinsicData();
        result = this.matchEndPoints(extdescriptions, matchProperties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "matchEndPoints");
        }
        return result;
    }

    public EndPoint[] matchEndPoints(Map endPoints, Map propertyNames) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "matchEndPoints", new Object[]{propertyNames});
        }
        if (endPoints == null) {
            throw new IllegalArgumentException("The endPoints argument must not be null.");
        }
        if (propertyNames == null) {
            throw new IllegalArgumentException("The propertyNames argument must not be null.");
        }
        EndPoint[] result = new EndPoint[]{};
        Iterator epiter = endPoints.values().iterator();
        while (epiter.hasNext()) {
            Iterator propiter = propertyNames.entrySet().iterator();
            Object o = epiter.next();
            if (!(o instanceof EndPoint)) continue;
            EndPoint next = (EndPoint)o;
            Identity identity = next.getIdentity();
            Map identityMap = identity.getProperties();
            while (propiter.hasNext()) {
                Map.Entry entry = propiter.next();
                try {
                    if (!identityMap.containsKey(entry.getKey()) || entry.getValue() != null && !((String)identityMap.get(entry.getKey())).startsWith((String)entry.getValue())) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "setting next to null", next);
                        }
                        next = null;
                        break;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "found a match: " + entry.getKey() + " " + entry.getValue());
                }
                catch (ClassCastException cce) {
                    throw new IllegalArgumentException("The property value " + entry.getValue().toString() + " should be a String type.");
                }
            }
            if (next == null) continue;
            EndPoint[] tmp = new EndPoint[result.length + 1];
            tmp[result.length] = next;
            System.arraycopy(result, 0, tmp, 0, result.length);
            result = tmp;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "matchEndPoints", result);
        }
        return result;
    }

    public String identityToString(Identity identity) {
        return this.descMgr.keyToString((DescriptionKey)identity);
    }

    public Identity stringToIdentity(String identityString) {
        return this.descMgr.stringToKey(identityString);
    }

    public Set getActiveClusterSet() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getActiveClusterSet");
        }
        Set result = null;
        String cellName = (String)ProcessProperties.getInstance().get("key.containing.cellname");
        result = this.getActiveClusterSet(cellName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActiveClusterSet", result);
        }
        return result;
    }

    public Set getActiveClusterSet(String cellName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getActiveClusterSet", cellName);
        }
        Set result = null;
        DescriptionKey identityMapKey = (DescriptionKey)IdentityMapping.getActiveClusterSetIdentityFromCellName(cellName == null ? "" : cellName);
        IdentityMap identityMap = this.getIdentityMap(identityMapKey);
        result = identityMap.keySet();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActiveClusterSet", result);
        }
        return result;
    }

    IdentityMap getIdentityMap(DescriptionKey identityMapKey) {
        IdentityMap identityMap;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getIdentityMap");
            }
            identityMap = null;
            try {
                identityMap = (IdentityMap)this.descMgr.getDescription(identityMapKey, IdentityMap.class.getName());
            }
            catch (Exception e) {
                FFDCFilter.processException(e, ClusterServiceImpl.class.getName() + "getIdentityMap", "623");
                if (!tc.isEventEnabled()) break block4;
                Tr.event(tc, "unexpected", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIdentityMap", identityMap.toString());
        }
        return identityMap;
    }

    protected void purge() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "purge");
        }
        boolean doCleanup = false;
        while (this.refQueue.poll() != null) {
            doCleanup = true;
        }
        if (doCleanup) {
            this.cleanupRegistrationTree();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "purge", doCleanup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupRegistrationTree() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupRegistrationTree");
        }
        Map map = this.coIdentifiers;
        synchronized (map) {
            Set identities = this.coIdentifiers.keySet();
            Iterator iter = identities.iterator();
            while (iter != null && iter.hasNext()) {
                Identity key = (Identity)iter.next();
                Map types = (Map)this.coIdentifiers.get(key);
                Set notifications = types.keySet();
                Iterator notificationIter = notifications.iterator();
                while (notificationIter != null && notificationIter.hasNext()) {
                    String type = (String)notificationIter.next();
                    Set observers = (Set)types.get(type);
                    if (observers != null && !observers.isEmpty()) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cleanupRegistrationTree removing notification", type);
                    }
                    notificationIter.remove();
                }
                if (types != null && !types.isEmpty()) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cleanupRegistrationTree identity", key);
                }
                iter.remove();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupRegistrationTree");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDeregisteredObserver(ClusterObserver observer, String type, Identity key) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeDeregisteredObserver", new Object[]{observer, type, key});
        }
        Map map = this.coIdentifiers;
        synchronized (map) {
            Map types = (Map)this.coIdentifiers.get(key);
            if (types != null) {
                Set observerSet = (Set)types.get(type);
                if (observer != null && observerSet != null) {
                    Iterator iter = observerSet.iterator();
                    while (iter != null && iter.hasNext()) {
                        WeakReference wr = (WeakReference)iter.next();
                        if (!wr.get().equals(observer)) continue;
                        iter.remove();
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "removeDeregisteredObserver removed observer", observer);
                    }
                }
                if (observerSet == null || observerSet.isEmpty()) {
                    Object removedType = types.remove(type);
                    if (tc.isDebugEnabled()) {
                        if (removedType != null) {
                            Tr.debug(tc, "removeDeregisteredObserver removed notification", type);
                        } else {
                            Tr.debug(tc, "Unexpected removeDeregisteredObserver notification not removed", type);
                        }
                    }
                    if (types.isEmpty()) {
                        Object removedIdentity = this.coIdentifiers.remove(key);
                        if (tc.isDebugEnabled()) {
                            if (removedIdentity != null) {
                                Tr.debug(tc, "removeDeregisteredObserver cleared ref", key);
                            } else {
                                Tr.debug(tc, "Unexpected removeDeregisteredObserver ref did not exist", key);
                            }
                        }
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unexpected empty notification in removeDeregisteredObserver");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeDeregisteredObserver");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.48 ");
        }
    }
}

