/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection.rule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.DescriptionModificationListener;
import com.ibm.ws.cluster.WLMCustomPropertyUtility;
import com.ibm.ws.cluster.selection.feedback.WeightBasedFeedback;
import com.ibm.ws.cluster.selection.rule.ApplicableStatesRule;
import com.ibm.ws.cluster.selection.rule.ReachabilityRule;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.selection.RuleArbitrator;
import com.ibm.wsspi.cluster.selection.SelectionRule;
import com.ibm.wsspi.cluster.selection.rule.RouteActionRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public final class RuleEtiquette
implements RuleArbitrator,
DescriptionModificationListener {
    private static final TraceComponent tc = Tr.register(RuleEtiquette.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    protected static final DescriptionManager descMgr = DescriptionManagerFactory.getDescriptionManager();
    private final ClusterDescription cluster;
    private final SelectionRule[] rules;
    private final String[] ruleIdentifier;
    private final StringBuffer reason;
    private final WeightBasedFeedback feedback;
    private boolean tryAgain;
    private Map registeredNotifications = new HashMap();
    private boolean timerRunning = false;
    private Integer syncObject = new Integer(42);
    private static int waitTime = WLMCustomPropertyUtility.getRunRulesTimerValue();
    private boolean beingRemoved = false;

    public RuleEtiquette(DescriptionKey clusterKey, SelectionRule[] rules, StringBuffer reason, WeightBasedFeedback feedback) {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{clusterKey, feedback});
        }
        this.rules = new SelectionRule[rules.length];
        System.arraycopy(rules, 0, this.rules, 0, rules.length);
        this.ruleIdentifier = new String[this.rules.length];
        this.reason = reason;
        this.feedback = feedback;
        this.cluster = (ClusterDescription)descMgr.getDescription(clusterKey);
        if (this.cluster == null) {
            throw new IllegalStateException("The cluster, " + clusterKey + " should have already been fluffed up.");
        }
        this.cluster.registerNotificationListener(this, "type.memento.updated", null);
        for (i = 0; i < rules.length; ++i) {
            rules[i].registerRuleArbitrator(this);
        }
        for (i = 0; i < rules.length; ++i) {
            this.ruleIdentifier[i] = rules[i].toString();
        }
        this.tryAgain = true;
        this.triggerRuleUpdate();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public RuleEtiquette(DescriptionKey clusterKey, SelectionRule[] rules, StringBuffer reason, WeightBasedFeedback feedback, Map criteria) {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{clusterKey, feedback, criteria, String.valueOf(rules.length)});
        }
        this.rules = new SelectionRule[rules.length];
        System.arraycopy(rules, 0, this.rules, 0, rules.length);
        this.ruleIdentifier = new String[this.rules.length];
        this.reason = reason;
        this.feedback = feedback;
        this.cluster = (ClusterDescription)descMgr.getDescription(clusterKey);
        if (this.cluster == null) {
            throw new IllegalStateException("The cluster, " + clusterKey + " should have already been fluffed up.");
        }
        if (!criteria.containsKey("affinity.key")) {
            this.cluster.registerNotificationListener(this, "type.memento.updated", null);
            for (i = 0; i < rules.length; ++i) {
                rules[i].registerRuleArbitrator(this);
            }
        }
        for (i = 0; i < rules.length; ++i) {
            this.ruleIdentifier[i] = rules[i].toString();
        }
        this.tryAgain = true;
        this.triggerRuleUpdate();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public void triggerRuleUpdate() {
        block4: {
            List list = this.runRules();
            Identity[] identities = new Identity[list.size()];
            list.toArray(identities);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "triggerRuleUpdate", this.reason);
            }
            try {
                this.feedback.applyStructuralUpdate(identities);
                this.tryAgain = true;
            }
            catch (IllegalArgumentException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "triggerRuleUpdate: caught IllegalArgumentException ", e);
                }
                if (!this.tryAgain) break block4;
                this.tryAgain = false;
                this.triggerRuleUpdate();
            }
        }
    }

    private List runRules() {
        Map table = ((ClusterDescription.Memento)this.cluster.getMemento()).getMembers();
        ArrayList identities = new ArrayList(table.keySet());
        this.reason.setLength(0);
        this.reason.append("Removal (");
        if (!identities.isEmpty()) {
            for (int i = 0; i < this.rules.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "working on rule " + this.rules[i]);
                }
                this.reason.append(this.ruleIdentifier[i]);
                this.reason.append("[");
                if (this.rules[i] instanceof ReachabilityRule || this.rules[i] instanceof ApplicableStatesRule) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "resetting RuleEttiquette pointer");
                    }
                    this.rules[i].registerRuleArbitrator(this);
                }
                this.rules[i].subset(identities, this.reason);
                this.reason.append("] ");
            }
        }
        this.reason.append(")\n  Applicable Targets ").append(identities);
        return identities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNotificationType(SelectionRule rule, Identity identity, String type) {
        Description description;
        Set<SelectionRule> ruleListeners;
        HashMap<Identity, Set<SelectionRule>> descriptions = (HashMap<Identity, Set<SelectionRule>>)this.registeredNotifications.get(type);
        if (descriptions != null && (ruleListeners = (Set)descriptions.get(identity)) != null && ruleListeners.contains(rule)) {
            return;
        }
        ruleListeners = this.registeredNotifications;
        synchronized (ruleListeners) {
            descriptions = (Map)this.registeredNotifications.get(type);
            if (descriptions == null) {
                descriptions = new HashMap<Identity, Set<SelectionRule>>();
                this.registeredNotifications.put(type, descriptions);
            }
        }
        HashMap<Identity, Set<SelectionRule>> hashMap = descriptions;
        synchronized (hashMap) {
            ruleListeners = (Set)descriptions.get(identity);
            if (ruleListeners == null) {
                ruleListeners = Collections.synchronizedSet(new HashSet(3));
                descriptions.put(identity, ruleListeners);
            }
        }
        if (ruleListeners.contains(rule)) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "registerNotificationType", new Object[]{rule, identity, type});
        }
        if ((description = descMgr.getDescription((DescriptionKey)identity)) != null) {
            ruleListeners.add(rule);
            description.registerNotificationListener(this, type, null);
        } else if (tc.isEventEnabled()) {
            Tr.event(tc, "Failed to register for " + type + " for description " + identity + " the description is not yet available.");
        }
    }

    public void deregisterNotificationType(SelectionRule rule, Identity identity, String type) {
        Map descriptions = (Map)this.registeredNotifications.get(type);
        if (descriptions == null) {
            return;
        }
        Set ruleListeners = (Set)descriptions.get(identity);
        if (ruleListeners == null) {
            return;
        }
        if (!ruleListeners.contains(rule)) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "deregisterNotificationType", new Object[]{rule, identity, type});
        }
        ruleListeners.remove(rule);
        Description description = descMgr.getDescription((DescriptionKey)identity);
        description.deregisterNotificationListener(this, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(DescriptionKey key, String type, Object userData, Object handback) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", new Object[]{key, type, userData, handback});
        }
        if (!this.beingRemoved) {
            if (waitTime > 0) {
                boolean timerExists = false;
                Integer n = this.syncObject;
                synchronized (n) {
                    timerExists = this.timerRunning;
                    this.timerRunning = true;
                }
                if (!timerExists) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "creating a timer for " + super.toString());
                    }
                    Timer notifier = new Timer();
                    notifier.schedule((TimerTask)new NotificationTimer(), waitTime);
                }
            } else {
                this.triggerRuleUpdate();
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "beingRemoved");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    public Identity getClusterIdentity() {
        return this.cluster.getKey();
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append("[");
        result.append(this.cluster.getKey());
        result.append(" restrict{");
        for (int i = 0; i < this.rules.length; ++i) {
            result.append(this.rules[i]);
            result.append(" ");
        }
        result.append("}]");
        return result.toString();
    }

    public void beingRemoved() {
        this.beingRemoved = true;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "set beingRemoved = true");
        }
        if (this.rules != null) {
            for (int i = 0; i < this.rules.length; ++i) {
                if (!(this.rules[i] instanceof RouteActionRule)) continue;
                RouteActionRule rar = (RouteActionRule)this.rules[i];
                rar.setDestroy();
            }
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.23 ");
        }
    }

    private final class NotificationTimer
    extends TimerTask {
        private NotificationTimer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "NotificationTimer running", super.toString());
            }
            Integer n = RuleEtiquette.this.syncObject;
            synchronized (n) {
                RuleEtiquette.this.timerRunning = false;
            }
            RuleEtiquette.this.triggerRuleUpdate();
        }
    }
}

