/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection.feedback;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cluster.selection.RouterMediator;
import com.ibm.ws.cluster.selection.algorithm.SelectionAlgorithm;
import com.ibm.ws.cluster.selection.feedback.WeightBasedFeedback;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.monitor.AdvisorFactory;
import com.ibm.wsspi.cluster.monitor.AdvisorMediator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class NoWeightFeedback
implements WeightBasedFeedback {
    private static final TraceComponent tc = Tr.register(NoWeightFeedback.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final ClusterService clusterService = ClusterServiceFactory.getClusterService();
    private final AdvisorMediator mediator = AdvisorFactory.getAdvisorMediator();
    private Identity clusterIdentity;
    private SelectionAlgorithm selectionAlgorithm;
    private Map members = Collections.EMPTY_MAP;
    private volatile boolean execute = true;

    public void init(Identity cluster, SelectionAlgorithm algorithm) {
        this.clusterIdentity = cluster;
        this.selectionAlgorithm = algorithm;
        this.applyStructuralUpdate(clusterService.getMemberIdentities(this.clusterIdentity));
        ((RouterMediator)this.mediator).registerFeedback(this, cluster);
    }

    public void applyStructuralUpdate(Identity[] memberArray) {
        HashMap<Identity, MemberData> memberMap = new HashMap<Identity, MemberData>(memberArray.length * 2);
        for (int i = 0; i < memberArray.length; ++i) {
            MemberData memberData = (MemberData)this.members.get(memberArray[i]);
            if (memberData == null) {
                memberData = new MemberData(memberArray[i]);
            }
            memberMap.put(memberArray[i], memberData);
        }
        this.members = memberMap;
        this.execute();
    }

    public void applyWorkloadUpdate(Identity member, int weight) {
    }

    public void applyExceptionUpdate(Identity member, int exceptionIncrement) {
    }

    private void execute() {
        MemberData[] memberData = new MemberData[this.members.size()];
        this.members.values().toArray(memberData);
        Identity[] membersArray = new Identity[memberData.length];
        int[] weightsArray = new int[membersArray.length];
        for (int i = 0; i < memberData.length; ++i) {
            membersArray[i] = memberData[i].memberIdentity;
            weightsArray[i] = 2;
        }
        this.selectionAlgorithm.prepare(membersArray, weightsArray);
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.1 ");
        }
    }

    private final class MemberData {
        private final Identity memberIdentity;
        private final int weight = 2;

        private MemberData(Identity member) {
            this.memberIdentity = member;
        }

        public String toString() {
            return "FeedbackData [" + this.memberIdentity + "]";
        }
    }
}

