/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection.algorithm;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cluster.selection.algorithm.SelectionAlgorithm;
import com.ibm.wsspi.cluster.Identity;

public class AffinityAlgorithm
implements SelectionAlgorithm {
    private static final TraceComponent tc = Tr.register(AffinityAlgorithm.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private final Identity affinityKey;
    private Identity member;

    public AffinityAlgorithm(Identity affinityKey) {
        if (affinityKey == null) {
            throw new IllegalArgumentException("Null affinityKey.");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{affinityKey});
        }
        this.affinityKey = affinityKey;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public Identity select() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "select", this.affinityKey);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "select", this.member);
        }
        return this.member;
    }

    public void prepare(Identity[] members, int[] weights) {
        if (members.length == 0) {
            this.member = null;
        } else {
            int lindex = Math.abs(this.affinityKey.hashCode() % members.length);
            this.member = members[lindex];
        }
    }

    public String toString() {
        return new String("[affinityKey: " + this.affinityKey + "]");
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.3 ");
        }
    }
}

