/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cluster.selection.SelectionCriteriaImpl;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.Target;
import com.ibm.wsspi.cluster.selection.ClusterIdentityResolver;
import com.ibm.wsspi.cluster.selection.ClusterIdentityResolverCoordinator;
import com.ibm.wsspi.cluster.selection.NoApplicableTargetException;
import com.ibm.wsspi.cluster.selection.NoAvailableTargetException;
import com.ibm.wsspi.cluster.selection.SelectionCriteria;
import com.ibm.wsspi.cluster.selection.SelectionRule;
import com.ibm.wsspi.cluster.selection.SelectionService;
import com.ibm.wsspi.cluster.selection.rule.AttributeRule;
import com.ibm.wsspi.cluster.selection.rule.DefaultRule;
import com.ibm.wsspi.cluster.selection.rule.EndPointRule;
import com.ibm.wsspi.cluster.selection.rule.LocalCellRule;
import com.ibm.wsspi.cluster.selection.rule.LocalHostRule;
import com.ibm.wsspi.cluster.selection.rule.LocalProcessRule;
import com.ibm.wsspi.cluster.selection.rule.LocalServerRule;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;

public class SelectionServiceImpl
implements SelectionService,
ClusterIdentityResolverCoordinator {
    private static final TraceComponent tc = Tr.register(SelectionServiceImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final TraceComponent tc1 = Tr.register(SoftKey.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap());
    private static final Map criteriaCache;
    private ClusterIdentityResolver[] resolvers = new ClusterIdentityResolver[0];
    private ReferenceQueue refqueue = new ReferenceQueue();

    public SelectionServiceImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CTOR");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CTOR");
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName());
        result.append('[').append(Arrays.toString(this.resolvers)).append(' ').append(criteriaCache).append(']');
        return result.toString();
    }

    public Target select(Identity clusterIdentity) throws NoAvailableTargetException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "select", clusterIdentity);
        }
        SelectionCriteria criteria = this.getCriteria(clusterIdentity, EMPTY_MAP);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "select");
        }
        return this.select(criteria);
    }

    public Target select(SelectionCriteria criteria) throws NoAvailableTargetException, NoApplicableTargetException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "select");
        }
        Target member = ((SelectionCriteriaImpl)criteria).select();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "select");
        }
        return member;
    }

    public SelectionCriteria getCriteria(Identity clusterIdentity, boolean process, boolean host, Map matchingEndpoints, Set matchingAttributes) {
        if (tc.isEventEnabled()) {
            Tr.entry(tc, "getCriteria", new Object[]{clusterIdentity, process, host, matchingEndpoints, matchingAttributes});
        }
        ArrayList<DefaultRule> rulesList = new ArrayList<DefaultRule>();
        if (process) {
            rulesList.add(new LocalProcessRule());
        }
        if (host) {
            rulesList.add(new LocalHostRule());
        }
        if (matchingAttributes != null) {
            rulesList.add(new AttributeRule(matchingAttributes));
        }
        if (matchingEndpoints != null) {
            rulesList.add(new EndPointRule(matchingEndpoints));
        }
        HashMap<String, SelectionRule[]> attributes = new HashMap<String, SelectionRule[]>();
        SelectionRule[] rules = new SelectionRule[rulesList.size()];
        rulesList.toArray(rules);
        attributes.put("rules.restriction", rules);
        SelectionCriteria result = this.getCriteria(clusterIdentity, attributes);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCriteria", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectionCriteria getCriteria(Identity clusterIdentity, Map context) {
        SelectionCriteriaImpl result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCriteria", clusterIdentity);
        }
        this.purge();
        if (context.containsKey("affinity.key")) {
            result = new SelectionCriteriaImpl(clusterIdentity, context);
        } else {
            Map<SoftKey, SoftReference<SelectionCriteriaImpl>> contextKey;
            Map map = criteriaCache;
            synchronized (map) {
                contextKey = (Map<SoftKey, SoftReference<SelectionCriteriaImpl>>)criteriaCache.get(clusterIdentity);
                if (contextKey == null) {
                    contextKey = Collections.synchronizedMap(new HashMap());
                    criteriaCache.put(clusterIdentity, contextKey);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "criteriaCache size is: " + criteriaCache.size());
                    }
                }
            }
            SoftKey skey = new SoftKey(clusterIdentity, context, this.refqueue);
            Map<SoftKey, SoftReference<SelectionCriteriaImpl>> map2 = contextKey;
            synchronized (map2) {
                SoftReference resultReference = (SoftReference)contextKey.get(skey);
                SelectionCriteria selectionCriteria = result = resultReference == null ? null : (SelectionCriteria)resultReference.get();
                if (result == null) {
                    TreeMap contextMap = new TreeMap(context);
                    result = new SelectionCriteriaImpl(clusterIdentity, contextMap);
                    contextKey.put(new SoftKey(clusterIdentity, contextMap, this.refqueue), new SoftReference<SelectionCriteriaImpl>(result));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCriteria", result);
        }
        return result;
    }

    public SelectionRule getRule(String ruleName) {
        if (ruleName == null) {
            throw new IllegalArgumentException("The rule name must not be null.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getRule", ruleName);
        }
        DefaultRule result = null;
        if (ruleName.equals("rule.default")) {
            result = new DefaultRule();
        } else if (ruleName.equals("rule.local.cell")) {
            result = new LocalCellRule();
        } else if (ruleName.equals("rule.local.host")) {
            result = new LocalHostRule();
        } else if (ruleName.equals("rule.local.server")) {
            result = new LocalServerRule();
        } else if (ruleName.equals("rule.local.process")) {
            result = new LocalProcessRule();
        } else {
            throw new IllegalArgumentException("There is no known rule " + ruleName + ".  Specialized rules should be retrieved from the specialized component.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerResolver(ClusterIdentityResolver resolver) {
        ClusterIdentityResolver[] clusterIdentityResolverArray = this.resolvers;
        synchronized (this.resolvers) {
            boolean slotfound = false;
            ClusterIdentityResolver[] tmpResolvers = new ClusterIdentityResolver[this.resolvers.length + 1];
            for (int i = 0; i < tmpResolvers.length; ++i) {
                if (slotfound) {
                    tmpResolvers[i] = this.resolvers[i - 1];
                    continue;
                }
                if (this.resolvers.length == i || this.resolvers[i].compareTo(resolver) < 0) {
                    tmpResolvers[i] = resolver;
                    slotfound = true;
                    continue;
                }
                tmpResolvers[i] = this.resolvers[i];
            }
            this.resolvers = tmpResolvers;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterResolver(ClusterIdentityResolver resolver) {
        ClusterIdentityResolver[] clusterIdentityResolverArray = this.resolvers;
        synchronized (this.resolvers) {
            int slotsfound = 0;
            ClusterIdentityResolver[] tmpResolvers = new ClusterIdentityResolver[this.resolvers.length];
            for (int i = 0; i < this.resolvers.length; ++i) {
                if (this.resolvers[i].equals(resolver)) {
                    ++slotsfound;
                    continue;
                }
                tmpResolvers[i - slotsfound] = this.resolvers[i];
            }
            this.resolvers = new ClusterIdentityResolver[this.resolvers.length - slotsfound];
            System.arraycopy(tmpResolvers, 0, this.resolvers, 0, this.resolvers.length);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public ClusterIdentityResolver[] getOrderedSequence() {
        return this.resolvers;
    }

    private void purge() {
        SoftKey reference;
        while ((reference = (SoftKey)this.refqueue.poll()) != null) {
            Identity clusterIdentity = reference.getClusterIdentity();
            Map contextCache = (Map)criteriaCache.get(clusterIdentity);
            if (contextCache == null) continue;
            contextCache.remove(reference);
            if (!contextCache.isEmpty()) continue;
            criteriaCache.remove(clusterIdentity);
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.32 ");
        }
        criteriaCache = Collections.synchronizedMap(new WeakHashMap());
    }

    private final class SoftKey
    extends SoftReference {
        private final WeakReference clusterIdentity;
        private final int hash;

        public SoftKey(Identity cluster, Map key, ReferenceQueue queue) {
            super(key, queue);
            if (tc1.isEntryEnabled()) {
                Tr.entry(tc1, "SoftKey<init>", key);
            }
            this.hash = this.setHashCode(key);
            this.clusterIdentity = new WeakReference<Identity>(cluster);
            if (tc1.isEntryEnabled()) {
                Tr.exit(tc1, "SoftKey<init>", String.valueOf(this.hash));
            }
        }

        private int setHashCode(Map map) {
            int result = 0;
            if (map == null) {
                return result;
            }
            Set entrySet = map.entrySet();
            if (entrySet.isEmpty()) {
                return result;
            }
            Iterator iterEntries = entrySet.iterator();
            Object value2 = null;
            while (iterEntries.hasNext()) {
                Map.Entry entry = iterEntries.next();
                Object key = entry.getKey();
                result += key == null ? 0 : key.hashCode();
                value2 = entry.getValue();
                if (value2 instanceof Object[]) {
                    result += Arrays.deepHashCode((Object[])value2);
                    continue;
                }
                result += value2 == null ? 0 : value2.hashCode();
            }
            return result;
        }

        private Identity getClusterIdentity() {
            return (Identity)this.clusterIdentity.get();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            Object referent = this.get();
            if (referent == null) {
                return false;
            }
            if (o.hashCode() != this.hash) {
                return false;
            }
            if (o instanceof SoftKey) {
                SoftKey other = (SoftKey)o;
                Object otherReferent = other.get();
                if (otherReferent == null) {
                    return false;
                }
                if (referent instanceof Map) {
                    return this.referentsEqual((Map)referent, (Map)otherReferent);
                }
                return referent.equals(otherReferent);
            }
            return false;
        }

        boolean referentsEqual(Map map1, Map map2) {
            if (map1.size() != map1.size()) {
                return false;
            }
            boolean result = true;
            for (Object key : map1.keySet()) {
                Object map1Value = map1.get(key);
                Object map2Value = map2.get(key);
                if (!(map1Value instanceof Object[] && map2Value instanceof Object[] ? !(result = Arrays.equals((Object[])map1Value, (Object[])map2Value)) : !(result = map1Value.equals(map2Value)))) continue;
                return result;
            }
            return result;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

