/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.DescriptionModificationListener;
import com.ibm.websphere.cluster.topography.IdentityListKey;
import com.ibm.ws.cluster.selection.NoAvailableTargetExceptionImpl;
import com.ibm.ws.cluster.selection.SelectionAdvisor;
import com.ibm.ws.cluster.selection.TargetImpl;
import com.ibm.ws.cluster.topography.IdentityListKeyImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.Target;
import com.ibm.wsspi.cluster.selection.NoAvailableTargetException;
import com.ibm.wsspi.cluster.selection.SelectionCriteria;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SelectionCriteriaImpl
implements SelectionCriteria,
DescriptionModificationListener {
    private static final TraceComponent tc = Tr.register(SelectionCriteriaImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final DescriptionManager descMgr = DescriptionManagerFactory.getDescriptionManager();
    private final Map strategyCache = Collections.synchronizedMap(new HashMap());
    private final Map<IdentityListKey, Target> targetCache = new HashMap<IdentityListKey, Target>();
    private final Integer targetCacheMutex = new Integer(42);
    private final ClusterDescription cluster;
    private final Identity identity;
    private final Map context;
    private final Set<Identity> registered = new HashSet<Identity>();
    private boolean affinityMapping;

    public SelectionCriteriaImpl(Identity identity, Map map) {
        try {
            if (identity == null) {
                throw new IllegalArgumentException("passed in identity can't be null");
            }
            this.identity = identity;
            this.cluster = (ClusterDescription)descMgr.getDescription((DescriptionKey)identity, ClusterDescription.class.getName());
            if (map == null) {
                throw new IllegalArgumentException("passed in map can't be null");
            }
            this.context = new HashMap(map);
            this.affinityMapping = this.context.containsKey("affinity.key");
            if (!this.affinityMapping) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "affinityMapping is " + this.affinityMapping);
                }
                this.cluster.registerNotificationListener(this, "member.added", null);
                this.cluster.registerNotificationListener(this, "member.removed", null);
                this.registered.add(identity);
            }
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException("The criteria may have been incorrect.");
            iae.initCause(e);
            throw iae;
        }
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public Map getAttributes() {
        return this.context;
    }

    public void match(List modifiedMembers) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Target select() throws NoAvailableTargetException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "select", this);
        }
        ArrayList<DescriptionKey> clusters = new ArrayList<DescriptionKey>(3);
        ClusterMemberDescription memberDescription = this.cluster;
        ClusterMemberDescription.Memento cmdMemento = (ClusterMemberDescription.Memento)memberDescription.getMemento();
        while (!cmdMemento.isLeaf()) {
            SelectionAdvisor strategy;
            DescriptionKey clusterKey = memberDescription.getKey();
            clusters.add(clusterKey);
            if (!this.affinityMapping && !this.registered.contains(clusterKey)) {
                memberDescription.registerNotificationListener(this, "member.added", null);
                memberDescription.registerNotificationListener(this, "member.removed", null);
                this.registered.add(clusterKey);
            }
            if ((strategy = (SelectionAdvisor)this.strategyCache.get(clusterKey)) == null) {
                strategy = new SelectionAdvisor(clusterKey, this.context);
                if (!this.affinityMapping) {
                    this.strategyCache.put(clusterKey, strategy);
                }
            }
            if ((memberDescription = strategy.select()) == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "select - null member from select.");
                }
                throw new NoAvailableTargetExceptionImpl(this, strategy.getReason());
            }
            cmdMemento = (ClusterMemberDescription.Memento)memberDescription.getMemento();
        }
        DescriptionKey memberKey = memberDescription.getKey();
        IdentityListKeyImpl targetCacheKey = new IdentityListKeyImpl();
        targetCacheKey.addAll(clusters);
        targetCacheKey.add(memberKey);
        TargetImpl result = null;
        Integer n = this.targetCacheMutex;
        synchronized (n) {
            result = (TargetImpl)this.targetCache.get(targetCacheKey);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "targetCacheKey is: " + targetCacheKey);
        }
        if (result == null) {
            ArrayList epList = new ArrayList(cmdMemento.getExtrinsicData().values());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Number of Endpoints in Memento: " + String.valueOf(epList.size()));
                Tr.debug(tc, "Endpoint List", epList);
            }
            Iterator iter = epList.iterator();
            while (iter.hasNext()) {
                if (iter.next() instanceof EndPoint) continue;
                iter.remove();
            }
            EndPoint[] eps = new EndPoint[epList.size()];
            epList.toArray(eps);
            Identity[] clusterHierarchy = new Identity[clusters.size()];
            clusters.toArray(clusterHierarchy);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (eps != null) {
                    Tr.debug(tc, "Number of Endpoints in array: " + String.valueOf(eps.length));
                }
                Tr.debug(tc, "Endpoint array", eps);
            }
            result = new TargetImpl(clusterHierarchy, memberKey, eps);
            Integer n2 = this.targetCacheMutex;
            synchronized (n2) {
                this.targetCache.put(targetCacheKey, result);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "select", result);
        }
        return result;
    }

    public boolean isAffinityKeyPresent() {
        return this.affinityMapping;
    }

    public String toString() {
        return super.toString() + "[" + this.identity + ":" + this.context + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(DescriptionKey key, String type, Object userData, Object handback) {
        SelectionAdvisor selAdv;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", new Object[]{key, type, userData, handback});
        }
        DescriptionKey clusterMember = null;
        try {
            clusterMember = ((Description)userData).getKey();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "clusterMember is: " + clusterMember);
            }
        }
        catch (ClassCastException cce) {
            Tr.debug(tc, "ClassCastException in handleNotification:", cce);
            FFDCFilter.processException(cce, SelectionCriteriaImpl.class.getName() + "handleNotification()", "237");
        }
        HashSet<Target> removedTargets = new HashSet<Target>();
        ArrayList<IdentityListKey> removedTargetKeys = new ArrayList<IdentityListKey>();
        Integer n = this.targetCacheMutex;
        synchronized (n) {
            Set<IdentityListKey> targetCacheKeySet = this.targetCache.keySet();
            for (IdentityListKey ilk : targetCacheKeySet) {
                if (!ilk.contains(clusterMember)) continue;
                removedTargets.add(this.targetCache.get(ilk));
                removedTargetKeys.add(ilk);
            }
            Iterator removedTargetKeysIterator = removedTargetKeys.iterator();
            while (removedTargetKeysIterator.hasNext()) {
                this.targetCache.remove(removedTargetKeysIterator.next());
            }
        }
        if (type.equals("member.removed") && (selAdv = (SelectionAdvisor)this.strategyCache.remove(this.cluster.getKey())) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "set beingRemoved in SelectionAdvisor ", this.cluster.getKey());
            }
            selAdv.beingRemoved();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            if (removedTargets.size() > 0) {
                StringBuilder sb = new StringBuilder(128);
                for (Target t : removedTargets) {
                    sb.append(t.getMemberIdentity());
                }
                Tr.exit(tc, "handleNotification", sb.toString());
            } else {
                Tr.exit(tc, "handleNotification");
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.context == null ? 0 : ((Object)this.context).hashCode());
        result = 31 * result + (this.identity == null ? 0 : this.identity.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        SelectionCriteriaImpl other = (SelectionCriteriaImpl)obj;
        if (this.context == null ? other.context != null : !((Object)this.context).equals(other.context)) {
            return false;
        }
        return !(this.identity == null ? other.identity != null : this.identity != other.identity);
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.23.1.8 ");
        }
    }
}

