/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.ws.cluster.selection.AdvisorMediatorA;
import com.ibm.ws.cluster.selection.feedback.WeightBasedFeedback;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.monitor.MembershipAdvisor;
import java.util.HashMap;
import java.util.Map;

public final class RouterMediator
extends AdvisorMediatorA {
    private static final TraceComponent tc = Tr.register(RouterMediator.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final DescriptionManager descMgr;
    private static Map<Identity, Integer> memberOutstandingCount;
    private static Map<Identity, Map<Identity, Integer>> errorCount;
    private static Map<Identity, WeightBasedFeedback[]> feedbackMap;
    private static Map<Identity, Boolean> thresholdReachedForCluster;
    private static final Integer OUTSTANDING_REQUEST_THRESHOLD;
    private static Map<Identity, Integer> clusterOutstandingCount;

    public RouterMediator() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CTOR");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CTOR", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObservedWeight(Identity cluster, Identity member, int weight) {
        Integer observed;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setObservedWeight", new Object[]{cluster, member, String.valueOf(weight)});
        }
        boolean runFeedback = false;
        Map<Identity, Integer> map = memberOutstandingCount;
        synchronized (map) {
            if (thresholdReachedForCluster.get(cluster) == null) {
                thresholdReachedForCluster.put(cluster, false);
            }
            observed = (observed = memberOutstandingCount.get(member)) == null ? new Integer(weight) : new Integer(weight + observed);
            memberOutstandingCount.put(member, observed);
            Integer requestsOutstanding = clusterOutstandingCount.get(cluster);
            if (requestsOutstanding == null) {
                clusterOutstandingCount.put(cluster, weight);
            } else {
                clusterOutstandingCount.put(cluster, requestsOutstanding + weight);
            }
            runFeedback = thresholdReachedForCluster.get(cluster);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ObservedWeight: " + observed + " total requestsOutstanding: " + clusterOutstandingCount.get(cluster));
        }
        WeightBasedFeedback[] feedback = null;
        if (observed >= OUTSTANDING_REQUEST_THRESHOLD || runFeedback) {
            feedback = feedbackMap.get(cluster);
            for (int i = 0; i < feedback.length; ++i) {
                feedback[i].applyWorkloadUpdate(member, observed);
            }
            Map<Identity, Integer> map2 = memberOutstandingCount;
            synchronized (map2) {
                if (clusterOutstandingCount.get(cluster) == 0) {
                    thresholdReachedForCluster.put(cluster, false);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No more outstanding requests");
                    }
                } else {
                    thresholdReachedForCluster.put(cluster, true);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setObservedWeight", feedback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getObservedWeight(Identity cluster, Identity member) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObservedWeight", new Object[]{cluster, member});
        }
        int result = 0;
        Map<Identity, Integer> map = memberOutstandingCount;
        synchronized (map) {
            Integer observed = memberOutstandingCount.get(member);
            if (observed != null) {
                result = observed;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObservedWeight - weight=" + result);
        }
        return result;
    }

    public void setErrorWeight(Identity cluster, Identity member, int error) {
        Integer errorWeight;
        Map<Identity, Integer> members = errorCount.get(cluster);
        if (members == null) {
            members = new HashMap<Identity, Integer>();
        }
        errorWeight = (errorWeight = members.get(member)) == null ? new Integer(error) : new Integer(errorWeight + error);
        members.put(member, errorWeight);
        WeightBasedFeedback[] feedback = feedbackMap.get(cluster);
        for (int i = 0; i < feedback.length; ++i) {
            feedback[i].applyExceptionUpdate(member, errorWeight);
        }
    }

    public int getErrorWeight(Identity cluster, Identity member) {
        Integer error;
        Map<Identity, Integer> members = errorCount.get(cluster);
        if (members != null && (error = members.get(member)) != null) {
            return error;
        }
        return 0;
    }

    public void tareErrorWeights(Identity cluster) {
        errorCount.remove(cluster);
    }

    public void setAvailable(Identity member) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAvailable", member);
        }
        if (member == null) {
            throw new IllegalArgumentException("The member identity must not be null.");
        }
        ClusterMemberDescription memberDescription = (ClusterMemberDescription)descMgr.getDescription((DescriptionKey)member);
        if (memberDescription == null) {
            throw new IllegalArgumentException("The member defined by " + member + " is not yet active in this process.");
        }
        memberDescription.setReachability((byte)0);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAvailable");
        }
    }

    public void setUnavailable(Identity member) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setUnavailable", member);
        }
        if (member == null) {
            throw new IllegalArgumentException("The member identity must not be null.");
        }
        ClusterMemberDescription memberDescription = (ClusterMemberDescription)descMgr.getDescription((DescriptionKey)member);
        if (memberDescription == null) {
            throw new IllegalArgumentException("The member defined by " + member + " is not yet active in this process.");
        }
        memberDescription.setReachability((byte)4);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setUnavailable");
        }
    }

    public boolean isAvailable(Identity member) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAvailable", member);
        }
        if (member == null) {
            throw new IllegalArgumentException("The member identity must not be null.");
        }
        ClusterMemberDescription memberDescription = (ClusterMemberDescription)descMgr.getDescription((DescriptionKey)member);
        if (memberDescription == null) {
            throw new IllegalArgumentException("The member defined by " + member + " is not yet active in this process.");
        }
        byte memberState = ((ClusterMemberDescription.Memento)memberDescription.getMemento()).getState();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAvailable", String.valueOf(memberState));
        }
        return memberState == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tareObservedWeights(Identity cluster) {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "tareObservedWeights", cluster);
        }
        ClusterService clusterService = ClusterServiceFactory.getClusterService();
        Identity[] members = clusterService.getMemberIdentities(cluster);
        Map<Identity, Integer> map = memberOutstandingCount;
        synchronized (map) {
            for (int i = 0; i < members.length; ++i) {
                memberOutstandingCount.remove(members[i]);
            }
        }
    }

    public void registerMembershipAdvisor(MembershipAdvisor advisor) {
    }

    public void deregisterMembershipAdvisor(MembershipAdvisor advisor) {
    }

    public void registerFeedback(WeightBasedFeedback feedback, Identity cluster) {
        feedbackMap.put(cluster, new WeightBasedFeedback[]{feedback});
    }

    static {
        DescriptionManagerFactory.getInstance();
        descMgr = DescriptionManagerFactory.getDescriptionManager();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.14");
        }
        memberOutstandingCount = new HashMap<Identity, Integer>();
        errorCount = new HashMap<Identity, Map<Identity, Integer>>();
        feedbackMap = new HashMap<Identity, WeightBasedFeedback[]>();
        thresholdReachedForCluster = new HashMap<Identity, Boolean>();
        OUTSTANDING_REQUEST_THRESHOLD = 2;
        clusterOutstandingCount = new HashMap<Identity, Integer>();
    }
}

