/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.cluster.channel.ChannelSelectionAdapterImpl;
import com.ibm.ws.cluster.channel.ChannelTargetImpl;
import com.ibm.ws.cluster.channel.HealthMonitorMaxDeadTimeRemovePolicyImpl;
import com.ibm.ws.cluster.channel.HealthMonitorRemoveTaskPolicy;
import com.ibm.ws.cluster.channel.HealthMonitorSleepTimePolicy;
import com.ibm.ws.cluster.channel.HealthMonitorSteppedSleepTimePolicy;
import com.ibm.ws.cluster.channel.MonitorAdvisorManager;
import com.ibm.ws.cluster.channel.MonitorAdvisorManagerFactory;
import com.ibm.ws.cluster.channel.MonitorTaskInfo;
import com.ibm.ws.cluster.selection.TargetImpl;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.wlm.threadmanager.SleeperThreadPool;
import com.ibm.ws.wlm.threadmanager.SleeperThreadPoolFactory;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.CFEndPointCriteria;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.Target;
import com.ibm.wsspi.cluster.adapter.IdentityMapping;
import com.ibm.wsspi.cluster.adapter.channel.ChannelTarget;
import com.ibm.wsspi.cluster.adapter.channel.HealthMonitorFactory;
import com.ibm.wsspi.cluster.adapter.channel.HealthMonitorManager;
import com.ibm.wsspi.cluster.adapter.channel.MonitorAdvisor;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.management.ObjectName;

public class HealthMonitorManagerImpl
extends WsComponentImpl
implements HealthMonitorManager {
    private static final TraceComponent tc = Tr.register(HealthMonitorManager.class, "WLMHealthMonitor", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final DescriptionManager descManager;
    private static final ClusterService clusterService;
    private static final int ENQUEUE_INTERVAL = 50;
    private static final int DEFAULT_MAX_SUCCESS_POLLING = 30000;
    private static final int DEFAULT_MAX_FAILURE_POLLING = Integer.MAX_VALUE;
    private WeakHashMap epTasks = null;
    private SleeperThreadPool sleeperThreadPool = null;
    private MonitorAdvisorManager advisorManager = null;
    private HealthMonitorSleepTimePolicy sleepTimePolicy = null;
    private HealthMonitorRemoveTaskPolicy removeTaskPolicy = null;
    private boolean postedNoHealthMonitorWarning = false;
    private HealthMonitorManager healthMonitorManager = null;
    private static final String ClusterMgrMBeanType = "ClusterMgr";
    private static final String ClusterMgrMBeanGetMethod = "getServerState";
    private static final String ProcessKeyProperty = "process";
    private static final String NodeKeyProperty = "node";
    private boolean enableMemberStoppedChecking = true;

    public void initialize(Object config) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        AdminService adminService;
        String processType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{config});
        }
        if ((processType = (adminService = AdminServiceFactory.getAdminService()).getProcessType()).equals("AdminAgent") || processType.equals("JobManager")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "initialize - running in a ADMIN_AGENT_PROCESS or JOB_MANAGER_PROCESS throwing ComponentDisabledException");
            }
            throw new ComponentDisabledException();
        }
        String serverType = AdminServiceFactory.getAdminService().getServerType();
        if (!serverType.equals("PROXY_SERVER") && !serverType.equals("ONDEMAND_ROUTER")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "initialize - not running in a Proxy Server throwing ComponentDisabledException");
            }
            throw new ComponentDisabledException();
        }
        try {
            WsServiceRegistry.addService(this, HealthMonitorManager.class);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, HealthMonitorManagerImpl.class.getName() + ".initialize", "129");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "initialize addService Failed");
            }
            throw new ComponentDisabledException();
        }
        this.epTasks = new WeakHashMap();
        this.sleeperThreadPool = SleeperThreadPoolFactory.getInstance();
        this.advisorManager = MonitorAdvisorManagerFactory.getInstance();
        this.sleeperThreadPool.setMinimumPoolSize(0);
        this.sleeperThreadPool.setMaximumPoolSize(10);
        this.sleepTimePolicy = new HealthMonitorSteppedSleepTimePolicy(this.epTasks, this.sleeperThreadPool);
        this.removeTaskPolicy = new HealthMonitorMaxDeadTimeRemovePolicyImpl(this.epTasks, this.sleeperThreadPool);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void start() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        this.healthMonitorManager = HealthMonitorFactory.getHealthMonitorManager();
        DescriptionManagerFactory descriptionManagerFactory = DescriptionManagerFactory.getInstance();
        boolean bl = this.enableMemberStoppedChecking = !descriptionManagerFactory.isStaticRoutingEnabled();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMonitoringEndPoints(CFEndPoint[] cfEPs, EndPoint[] eps, long timeout) {
        if (cfEPs == null || eps == null || cfEPs.length != eps.length) {
            throw new IllegalArgumentException("No [CF]EndPoint argument(s) or sizes not match.");
        }
        int cfEpsSize = cfEPs.length;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addMonitoringEndPoints", Integer.toString(cfEpsSize));
        }
        SetEndPointsUnavailableTask setEPUTask = new SetEndPointsUnavailableTask(eps);
        this.sleeperThreadPool.RunInTimeOrder((Runnable)setEPUTask);
        int waitTime = 100;
        for (int i = 0; i < cfEpsSize; ++i) {
            Identity identity = eps[i].getIdentity();
            if (i < 50 || i % 50 != 0) continue;
            WeakHashMap weakHashMap = this.epTasks;
            synchronized (weakHashMap) {
                EndPointMonitorTask task = (EndPointMonitorTask)this.epTasks.get(identity);
                if (task == null) {
                    task = new EndPointMonitorTask(cfEPs[i], eps[i], timeout);
                    this.epTasks.put(identity, task);
                    this.sleeperThreadPool.RunInTimeOrder((Runnable)task, waitTime);
                } else if (!this.sleeperThreadPool.inQueue((Runnable)task)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "addMonitoringEndPoints", "Sync task back to the sleep queue:" + task);
                    }
                    this.sleeperThreadPool.RunInTimeOrder((Runnable)task, waitTime);
                }
                continue;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addMonitoringEndPoints", this.epTasks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMonitoringEndPoints(CFEndPoint[] cfEPs, EndPoint[] eps) {
        if (cfEPs == null || eps == null || cfEPs.length != eps.length) {
            throw new IllegalArgumentException("No [CF]EndPoint argument(s) or sizes not match.");
        }
        int cfEpsSize = cfEPs.length;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeMonitoringEndPoints", Integer.toString(cfEpsSize));
        }
        for (int i = 0; i < cfEpsSize; ++i) {
            eps[i].setAvailability(true);
            Identity identity = eps[i].getIdentity();
            WeakHashMap weakHashMap = this.epTasks;
            synchronized (weakHashMap) {
                EndPointMonitorTask task = (EndPointMonitorTask)this.epTasks.get(identity);
                if (task != null) {
                    this.epTasks.remove(identity);
                }
                continue;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeMonitoringEndPoints", this.epTasks);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void startMonitorEndPoints(ChannelTargetImpl channelTarget, CFEndPointCriteria criteria, long timeout) {
        block15: {
            EndPoint[] choosenEndPoints;
            CFEndPoint[] chosenCFEndPoints;
            block13: {
                int j;
                EndPoint[] wlmEndPoints;
                CFEndPoint[] cfEndpoints;
                block14: {
                    block10: {
                        block11: {
                            block12: {
                                if (tc.isEntryEnabled()) {
                                    Tr.entry(tc, "startMonitorEndPoints");
                                }
                                boolean anyCFEndPoints = true;
                                cfEndpoints = channelTarget.getCFEndpoints();
                                wlmEndPoints = channelTarget.getEndpoints();
                                if (this.healthMonitorManager == null) break block10;
                                if (ChannelSelectionAdapterImpl.cfService == null) {
                                    Tr.error(tc, "NLSKEY_CFS_UNAVAILABLE");
                                    throw new IllegalStateException("The ChannelFrameworkService is not available for obtaining all selected end points..");
                                }
                                if (cfEndpoints == null) {
                                    CFEndPoint cfEndPoint = channelTarget.getCFEndPoint();
                                    cfEndpoints = channelTarget.getCFEndpoints();
                                    wlmEndPoints = channelTarget.getEndpoints();
                                    if (cfEndPoint == null) {
                                        anyCFEndPoints = false;
                                    }
                                }
                                if (!anyCFEndPoints || cfEndpoints == null || wlmEndPoints == null || cfEndpoints.length <= 0 || wlmEndPoints.length <= 0) break block11;
                                chosenCFEndPoints = ChannelSelectionAdapterImpl.cfService.getEndPoints(cfEndpoints, criteria);
                                choosenEndPoints = channelTarget.getEndpoints();
                                if (chosenCFEndPoints == null || chosenCFEndPoints == null || chosenCFEndPoints.length <= 0 || chosenCFEndPoints.length <= 0) break block12;
                                if (chosenCFEndPoints.length >= choosenEndPoints.length) break block13;
                                choosenEndPoints = new EndPoint[chosenCFEndPoints.length];
                                j = 0;
                                break block14;
                            }
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Unable to retrieve end points to monitor for this ChannelTarget.");
                            }
                            break block15;
                        }
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Unable to retrieve end points to monitor for this ChannelTarget.");
                        }
                        break block15;
                    }
                    if (!this.postedNoHealthMonitorWarning) {
                        this.postedNoHealthMonitorWarning = true;
                        Tr.event(tc, "HealthMonitorManager is not available.");
                    }
                    break block15;
                }
                for (int i = 0; i < chosenCFEndPoints.length; ++i) {
                    while (chosenCFEndPoints[i] != cfEndpoints[j]) {
                        ++j;
                    }
                    choosenEndPoints[i] = wlmEndPoints[j];
                }
            }
            this.addMonitoringEndPoints(chosenCFEndPoints, choosenEndPoints, timeout);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startMonitorEndPoints");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void stopMonitorEndPoints(ChannelTargetImpl channelTarget, CFEndPointCriteria criteria) {
        block15: {
            EndPoint[] choosenEndPoints;
            CFEndPoint[] chosenCFEndPoints;
            block13: {
                int j;
                EndPoint[] wlmEndPoints;
                CFEndPoint[] cfEndpoints;
                block14: {
                    block10: {
                        block11: {
                            block12: {
                                if (tc.isEntryEnabled()) {
                                    Tr.entry(tc, "stopMonitorEndPoints");
                                }
                                boolean anyCFEndPoints = true;
                                cfEndpoints = channelTarget.getCFEndpoints();
                                wlmEndPoints = channelTarget.getEndpoints();
                                if (this.healthMonitorManager == null) break block10;
                                if (ChannelSelectionAdapterImpl.cfService == null) {
                                    Tr.error(tc, "NLSKEY_CFS_UNAVAILABLE");
                                    throw new IllegalStateException("The ChannelFrameworkService is not available for obtaining all selected end points..");
                                }
                                if (cfEndpoints == null) {
                                    CFEndPoint cfEndPoint = channelTarget.getCFEndPoint();
                                    cfEndpoints = channelTarget.getCFEndpoints();
                                    wlmEndPoints = channelTarget.getEndpoints();
                                    if (cfEndPoint == null) {
                                        anyCFEndPoints = false;
                                    }
                                }
                                if (!anyCFEndPoints || cfEndpoints == null || wlmEndPoints == null || cfEndpoints.length <= 0 || wlmEndPoints.length <= 0) break block11;
                                chosenCFEndPoints = ChannelSelectionAdapterImpl.cfService.getEndPoints(cfEndpoints, criteria);
                                choosenEndPoints = channelTarget.getEndpoints();
                                if (chosenCFEndPoints == null || chosenCFEndPoints == null || chosenCFEndPoints.length <= 0 || chosenCFEndPoints.length <= 0) break block12;
                                if (chosenCFEndPoints.length >= choosenEndPoints.length) break block13;
                                choosenEndPoints = new EndPoint[chosenCFEndPoints.length];
                                j = 0;
                                break block14;
                            }
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Unable to retrieve end points to monitor for this ChannelTarget.");
                            }
                            break block15;
                        }
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Unable to retrieve end points for this ChannelTarget.");
                        }
                        break block15;
                    }
                    if (!this.postedNoHealthMonitorWarning) {
                        this.postedNoHealthMonitorWarning = true;
                        Tr.event(tc, "HealthMonitorManager is not available.");
                    }
                    break block15;
                }
                for (int i = 0; i < chosenCFEndPoints.length; ++i) {
                    while (chosenCFEndPoints[i] != cfEndpoints[j]) {
                        ++j;
                    }
                    choosenEndPoints[i] = wlmEndPoints[j];
                }
            }
            this.removeMonitoringEndPoints(chosenCFEndPoints, choosenEndPoints);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopMonitorEndPoints");
        }
    }

    public void startMonitor(ChannelTarget channelTarget) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startMonitor ChannelTarget", channelTarget);
        }
        if (channelTarget == null) {
            throw new IllegalArgumentException("The channelTarget attribute must not be null.");
        }
        this.startMonitor(channelTarget, Integer.MAX_VALUE);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startMonitor ChannelTarget");
        }
    }

    public void startMonitor(Identity clusterIdentity, CFEndPointCriteria cfEndPointCriteria) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startMonitor clusterIdentity", new Object[]{clusterIdentity, cfEndPointCriteria});
        }
        if (clusterIdentity == null) {
            throw new IllegalArgumentException("The Identity attribute must not be null.");
        }
        if (cfEndPointCriteria == null) {
            throw new IllegalArgumentException("The CFEndPointCriteria attribute must not be null.");
        }
        this.startMonitor(clusterIdentity, cfEndPointCriteria, Integer.MAX_VALUE);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startMonitor clusterIdentity");
        }
    }

    public void startMonitor(Identity memberIdentity) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startMonitor memberIdentity", new Object[]{memberIdentity});
        }
        if (memberIdentity == null) {
            throw new IllegalArgumentException("The Identity attribute must not be null.");
        }
        this.startMonitor(memberIdentity, Integer.MAX_VALUE);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startMonitor memberIdentity");
        }
    }

    public void stopMonitor(ChannelTarget channelTarget) {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "stopMonitor ChannelTarget", channelTarget);
            }
            if (channelTarget == null) {
                throw new IllegalArgumentException("The channelTarget attribute must not be null.");
            }
            try {
                this.stopMonitorEndPoints((ChannelTargetImpl)channelTarget, ((ChannelTargetImpl)channelTarget).getCFEndPointCriteria());
            }
            catch (Exception e) {
                FFDCFilter.processException(e, HealthMonitorManagerImpl.class.getName() + ".stopMonitor", "458");
                if (!tc.isEventEnabled()) break block5;
                Tr.event(tc, "Unexpected exception: could not stopMonitor ", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopMonitor ChannelTarget");
        }
    }

    public void stopMonitor(Identity clusterIdentity, CFEndPointCriteria cfEndPointCriteria) {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "stopMonitor clusterIdentity", new Object[]{clusterIdentity, cfEndPointCriteria});
            }
            if (clusterIdentity == null) {
                throw new IllegalArgumentException("The Identity attribute must not be null.");
            }
            if (cfEndPointCriteria == null) {
                throw new IllegalArgumentException("The CFEndPointCriteria attribute must not be null.");
            }
            try {
                Target[] TargetList = this.getTargetList(clusterIdentity);
                for (int i = 0; i < TargetList.length; ++i) {
                    ChannelTargetImpl channelTarget = new ChannelTargetImpl(TargetList[i], cfEndPointCriteria);
                    this.stopMonitorEndPoints(channelTarget, cfEndPointCriteria);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, HealthMonitorManagerImpl.class.getName() + ".stopMonitor", "491");
                if (!tc.isEventEnabled()) break block7;
                Tr.event(tc, "Unexpected exception: could not stopMonitor ", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopMonitor clusterIdentity");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMonitor(Identity memberIdentity) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopMonitor memberIdentity", new Object[]{memberIdentity});
        }
        if (memberIdentity == null) {
            throw new IllegalArgumentException("The Identity attribute must not be null.");
        }
        Map name2 = memberIdentity.getProperties();
        String memberCellName = (String)name2.get("CELLNAME");
        String memberNodeName = (String)name2.get("NODENAME");
        String memberName = (String)name2.get("MEMBERNAME");
        Identity identityFound = null;
        for (Identity identity : this.epTasks.keySet()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stopMonitor Identity: ", identity);
            }
            Map name22 = identity.getProperties();
            String endpointCellName = (String)name22.get("CELL");
            String endpointNodeName = (String)name22.get("NODE");
            String serverName = (String)name22.get("SERVER");
            if (!endpointCellName.equals(memberCellName) || !endpointNodeName.equals(memberNodeName) || !serverName.equals(memberName)) continue;
            identityFound = identity;
            break;
        }
        if (identityFound != null) {
            WeakHashMap weakHashMap = this.epTasks;
            synchronized (weakHashMap) {
                EndPointMonitorTask task = (EndPointMonitorTask)this.epTasks.get(identityFound);
                if (task != null) {
                    this.epTasks.remove(identityFound);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopMonitor memberIdentity");
        }
    }

    public void startMonitor(ChannelTarget channelTarget, long timeout) {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "startMonitor ChannelTarget with timeout", new Object[]{channelTarget, Long.toString(timeout)});
            }
            if (channelTarget == null) {
                throw new IllegalArgumentException("The channelTarget attribute must not be null.");
            }
            if (timeout <= 0L) {
                timeout = Integer.MAX_VALUE;
            }
            try {
                this.startMonitorEndPoints((ChannelTargetImpl)channelTarget, ((ChannelTargetImpl)channelTarget).getCFEndPointCriteria(), timeout);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, HealthMonitorManagerImpl.class.getName() + ".startMonitor", "591");
                if (!tc.isEventEnabled()) break block6;
                Tr.event(tc, "Unexpected exception: could not startMonitor ", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startMonitor ChannelTarget with timeout");
        }
    }

    public void startMonitor(Identity clusterIdentity, CFEndPointCriteria cfEndPointCriteria, long timeout) {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "startMonitor clusterIdentity with timeout", new Object[]{clusterIdentity, cfEndPointCriteria, Long.toString(timeout)});
            }
            if (clusterIdentity == null) {
                throw new IllegalArgumentException("The Identity attribute must not be null.");
            }
            if (cfEndPointCriteria == null) {
                throw new IllegalArgumentException("The CFEndPointCriteria attribute must not be null.");
            }
            if (timeout <= 0L) {
                timeout = Integer.MAX_VALUE;
            }
            try {
                Target[] TargetList = this.getTargetList(clusterIdentity);
                for (int i = 0; i < TargetList.length; ++i) {
                    ChannelTargetImpl channelTarget = new ChannelTargetImpl(TargetList[i], cfEndPointCriteria);
                    this.startMonitorEndPoints(channelTarget, cfEndPointCriteria, timeout);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, HealthMonitorManagerImpl.class.getName() + ".startMonitor", "625");
                if (!tc.isEventEnabled()) break block8;
                Tr.event(tc, "Unexpected exception: could not startMonitor ", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startMonitor clusterIdentity with timeout");
        }
    }

    public void startMonitor(Identity memberIdentity, long timeout) {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "startMonitor memberIdentity with timeout", new Object[]{memberIdentity, Long.toString(timeout)});
            }
            if (memberIdentity == null) {
                throw new IllegalArgumentException("The Identity attribute must not be null.");
            }
            if (timeout <= 0L) {
                timeout = Integer.MAX_VALUE;
            }
            try {
                EndPoint[] endPoints = clusterService.matchEndPoints(memberIdentity, ChannelTargetImpl.distinction);
                CFEndPoint[] cfEndpoints = new CFEndPoint[endPoints.length];
                for (int i = 0; i < endPoints.length; ++i) {
                    cfEndpoints[i] = IdentityMapping.getCFEndPoint(endPoints[i].getIdentity());
                }
                this.addMonitoringEndPoints(cfEndpoints, endPoints, timeout);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, HealthMonitorManagerImpl.class.getName() + ".startMonitor", "658");
                if (!tc.isEventEnabled()) break block7;
                Tr.event(tc, "Unexpected exception: could not startMonitor ", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startMonitor memberIdentity with timeout");
        }
    }

    public void registerMonitorAdvisor(Class monitorAdvisor) {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "registerMonitorAdvisor", monitorAdvisor);
            }
            if (monitorAdvisor == null) {
                throw new IllegalArgumentException("The Class attribute must not be null.");
            }
            try {
                this.advisorManager.registerAdvisor(monitorAdvisor);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, HealthMonitorManagerImpl.class.getName() + ".registerAdvisor", "513");
                if (!tc.isEventEnabled()) break block5;
                Tr.event(tc, "Unexpected exception: could not registerAdvisor ", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerMonitorAdvisor");
        }
    }

    public void deregisterMonitorAdvisor(Class monitorAdvisor) {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "deregisterMonitorAdvisor", monitorAdvisor);
            }
            if (monitorAdvisor == null) {
                throw new IllegalArgumentException("The Class attribute must not be null.");
            }
            try {
                this.advisorManager.deregisterAdvisor(monitorAdvisor);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, HealthMonitorManagerImpl.class.getName() + ".deregisterMonitorAdvisor", "535");
                if (!tc.isEventEnabled()) break block5;
                Tr.event(tc, "Unexpected exception: could not deregisterMonitorAdvisor ", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deregisterMonitorAdvisor");
        }
    }

    private Target[] getTargetList(Identity clusterIdentity) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTargetList", clusterIdentity);
        }
        Target[] result = null;
        Identity[] identity = new Identity[]{clusterIdentity};
        Identity[] memberIdentities = clusterService.getMemberIdentities(clusterIdentity);
        result = new Target[memberIdentities.length];
        for (int i = 0; i < memberIdentities.length; ++i) {
            EndPoint[] endPoints = clusterService.matchEndPoints(memberIdentities[i], ChannelTargetImpl.distinction);
            result[i] = new TargetImpl(identity, memberIdentities[i], endPoints);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTargetList", result);
        }
        return result;
    }

    public Class[] getRegisteredMonitorAdvisors() {
        return this.advisorManager.getRegisteredAdvisors();
    }

    public int getActiveMonitorAdvisorsSize() {
        return this.epTasks.size();
    }

    protected static boolean isMemberStopped(Identity memberIdentity) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isMemberStopped", new Object[]{memberIdentity});
        }
        boolean result = false;
        String serverState = null;
        try {
            final Identity finalMemberIdentity = memberIdentity;
            ContextManager contextManager = ContextManagerFactory.getInstance();
            PrivilegedExceptionAction action = new PrivilegedExceptionAction(){
                Object returnValue = null;

                public Object run() throws Exception {
                    try {
                        AdminClient adminClient = HealthMonitorManagerImpl.getAdminClient();
                        Map name2 = finalMemberIdentity.getProperties();
                        String nodeName = (String)name2.get("NODENAME");
                        String memberName = (String)name2.get("MEMBERNAME");
                        String domain = adminClient.getDomainName();
                        ObjectName clusterMgr = HealthMonitorManagerImpl.getObjName(domain, HealthMonitorManagerImpl.ClusterMgrMBeanType, HealthMonitorManagerImpl.ClusterMgrMBeanType, HealthMonitorManagerImpl.getDMGRNodeName(), HealthMonitorManagerImpl.getDMGRName());
                        this.returnValue = adminClient.invoke(clusterMgr, HealthMonitorManagerImpl.ClusterMgrMBeanGetMethod, new Object[]{memberName, nodeName}, new String[]{"java.lang.String", "java.lang.String"});
                    }
                    catch (Exception e) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Unexpected exception getting or using AdminClient:", e);
                        }
                        throw e;
                    }
                    return this.returnValue;
                }
            };
            serverState = (String)contextManager.runAsSystem(action);
            result = serverState.equals("STOPPED");
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isMemberStopped caught exception:", e);
            }
            result = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isMemberStopped", result ? Boolean.TRUE : Boolean.FALSE);
        }
        return result;
    }

    private static AdminClient getAdminClient() throws Exception {
        AdminClient result = null;
        AdminService adminService = AdminServiceFactory.getAdminService();
        try {
            result = adminService.getDeploymentManagerAdminClient();
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getAdminClient caught exception:", e);
            }
            throw e;
        }
        return result;
    }

    private static String getDMGRNodeName() throws Exception {
        String result = null;
        try {
            ContextManager contextManager = ContextManagerFactory.getInstance();
            PrivilegedExceptionAction action = new PrivilegedExceptionAction(){
                Object returnValue = null;

                public Object run() throws Exception {
                    try {
                        AdminClient adminClient = HealthMonitorManagerImpl.getAdminClient();
                        ObjectName name2 = adminClient.getServerMBean();
                        this.returnValue = name2.getKeyProperty(HealthMonitorManagerImpl.NodeKeyProperty);
                    }
                    catch (Exception e) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Unexpected exception getting or using AdminClient:", e);
                        }
                        throw e;
                    }
                    return this.returnValue;
                }
            };
            result = (String)contextManager.runAsSystem(action);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getDMGRNodeName caught exception:", e);
            }
            throw e;
        }
        return result;
    }

    private static String getDMGRName() {
        String result = "dmgr";
        try {
            ContextManager contextManager = ContextManagerFactory.getInstance();
            PrivilegedExceptionAction action = new PrivilegedExceptionAction(){
                Object returnValue = null;

                public Object run() throws Exception {
                    try {
                        AdminClient adminClient = HealthMonitorManagerImpl.getAdminClient();
                        ObjectName name2 = adminClient.getServerMBean();
                        this.returnValue = name2.getKeyProperty(HealthMonitorManagerImpl.ProcessKeyProperty);
                    }
                    catch (Exception e) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Unexpected exception getting or using AdminClient:", e);
                        }
                        throw e;
                    }
                    return this.returnValue;
                }
            };
            result = (String)contextManager.runAsSystem(action);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getDMGRName caught exception:", e);
            }
            result = "dmgr";
        }
        return result;
    }

    private static ObjectName getObjName(String domain, String name2, String type, String node, String process) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjName(5)", new Object[]{domain, name2, type, node, process});
        }
        ObjectName objName = null;
        String queryParameter = domain + ":*,name=" + name2 + ",type=" + type + ",node=" + node + ",process=" + process;
        objName = HealthMonitorManagerImpl.getObjectName(queryParameter);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjName(5)", objName);
        }
        return objName;
    }

    private static ObjectName getObjectName(String queryString) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectName", new Object[]{queryString});
        }
        ObjectName objName = null;
        try {
            ContextManager contextManager = ContextManagerFactory.getInstance();
            final String finalQueryString = queryString;
            PrivilegedExceptionAction action = new PrivilegedExceptionAction(){
                Object returnValue = null;

                public Object run() throws Exception {
                    try {
                        AdminClient adminClient = HealthMonitorManagerImpl.getAdminClient();
                        ObjectName qObjName = new ObjectName(finalQueryString);
                        this.returnValue = adminClient.queryNames(qObjName, null);
                    }
                    catch (Exception e) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Unexpected exception getting or using AdminClient:", e);
                        }
                        throw e;
                    }
                    return this.returnValue;
                }
            };
            Set result = (Set)contextManager.runAsSystem(action);
            if (!result.isEmpty()) {
                Iterator iterator = result.iterator();
                objName = (ObjectName)iterator.next();
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getObjectName: new ObjectName() for query failed", e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectName", objName);
        }
        return objName;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : 1.23 : none");
        }
        DescriptionManagerFactory.getInstance();
        descManager = DescriptionManagerFactory.getDescriptionManager();
        clusterService = ClusterServiceFactory.getClusterService();
    }

    class SetEndPointsUnavailableTask
    implements Runnable {
        EndPoint[] endPoints = null;

        protected SetEndPointsUnavailableTask(EndPoint[] eps) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SetEndPointsUnavailableTask number of endPoints is " + eps.length);
            }
            this.endPoints = eps;
        }

        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "run: set endpoints unavailable");
            }
            for (EndPoint endPoint : this.endPoints) {
                endPoint.setAvailability(false);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "run", endPoint);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "run: set endpoints unavailable");
            }
        }
    }

    class EndPointMonitorTask
    extends MonitorTask {
        EndPointMonitorTask(CFEndPoint cfep, EndPoint ep, long timeout) {
            super(cfep, ep, timeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Identity memberIdentity;
            EndPointMonitorTask endPointMonitorTask;
            Identity identity = this.endPoint.getIdentity();
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "run", new Object[]{identity, HealthMonitorManagerImpl.this.epTasks});
            }
            if ((endPointMonitorTask = (EndPointMonitorTask)HealthMonitorManagerImpl.this.epTasks.get(identity)) == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "run: identity is not in epTasks");
                }
                this.advisorsCache.remove(identity);
                return;
            }
            if (this.getTestCount() == 0 && HealthMonitorManagerImpl.this.enableMemberStoppedChecking && HealthMonitorManagerImpl.isMemberStopped(memberIdentity = IdentityMapping.getMemberIdentityFromEndPointIdentity(identity))) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "run: member is stopped");
                }
                this.advisorsCache.remove(identity);
                this.endPoint.setAvailability(false);
                return;
            }
            Description desc = descManager.getDescription((DescriptionKey)identity);
            Class accessor = this.cfEndPoint.getChannelAccessor();
            if (desc != null && accessor != null) {
                this.advisors = (ArrayList)this.advisorsCache.get(identity);
                if (this.advisors == null) {
                    Map map = this.advisorsCache;
                    synchronized (map) {
                        this.advisors = HealthMonitorManagerImpl.this.advisorManager.getAdvisors(accessor);
                        this.advisorsCache.put(identity, this.advisors);
                    }
                }
                if (this.advisors != null && this.advisors.size() > 0) {
                    boolean done = false;
                    block17: for (int i = 0; !done && i < this.advisors.size(); ++i) {
                        block35: {
                            MonitorAdvisor advisor = (MonitorAdvisor)this.advisors.get(i);
                            try {
                                this.lastAdvice = advisor.getAdvice(this.cfEndPoint);
                            }
                            catch (Exception e) {
                                this.lastAdvice = -2;
                                if (!tc.isDebugEnabled()) break block35;
                                Tr.debug(tc, "run Exception: ", e);
                            }
                        }
                        switch (this.lastAdvice) {
                            case 1: {
                                this.endPoint.setAvailability(true);
                                this.incSuccessfulTest();
                                done = true;
                                continue block17;
                            }
                            case -1: {
                                this.endPoint.setAvailability(false);
                                this.incUnsuccessfulTest();
                                done = true;
                                continue block17;
                            }
                            case 0: {
                                continue block17;
                            }
                            case -2: {
                                done = true;
                            }
                        }
                    }
                } else {
                    this.lastAdvice = -2;
                }
                int nextSleepTime = HealthMonitorManagerImpl.this.sleepTimePolicy.getSleepTime(this);
                long currentTime = System.currentTimeMillis();
                if (this.endPoint.isAvailable() && (currentTime - this.getStateChangedTimeStamp() > 30000L || currentTime - this.getLastAccessedTimeStamp() > 30000L) || this.lastAdvice == -2 || !this.endPoint.isAvailable() && HealthMonitorManagerImpl.this.removeTaskPolicy.canRemove(this)) {
                    WeakHashMap weakHashMap = HealthMonitorManagerImpl.this.epTasks;
                    synchronized (weakHashMap) {
                        EndPointMonitorTask task = (EndPointMonitorTask)HealthMonitorManagerImpl.this.epTasks.get(identity);
                        if (task != null) {
                            HealthMonitorManagerImpl.this.epTasks.remove(identity);
                        }
                    }
                }
                if (nextSleepTime > 0) {
                    HealthMonitorManagerImpl.this.sleeperThreadPool.RunInTimeOrder((Runnable)this, nextSleepTime);
                } else {
                    HealthMonitorManagerImpl.this.sleeperThreadPool.RunAfterLast((Runnable)this, -nextSleepTime);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "run: removing identity from epTasks");
                }
                WeakHashMap weakHashMap = HealthMonitorManagerImpl.this.epTasks;
                synchronized (weakHashMap) {
                    EndPointMonitorTask task = (EndPointMonitorTask)HealthMonitorManagerImpl.this.epTasks.get(identity);
                    if (task != null) {
                        HealthMonitorManagerImpl.this.epTasks.remove(identity);
                    }
                }
            }
            this.setLastAccessedTimeStamp();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "run", this.endPoint.isAvailable() ? Boolean.TRUE : Boolean.FALSE);
            }
        }

        public String toString() {
            String taskString = "EndPointMonitorTask@" + Integer.toHexString(System.identityHashCode(this));
            String epString = this.endPoint.getClass().getName();
            epString = epString.substring(epString.lastIndexOf(46) + 1) + "@" + Integer.toHexString(System.identityHashCode(this.endPoint));
            String available = this.endPoint.isAvailable() ? "" : "UN";
            return "[" + available + "available]" + taskString + ":" + epString + ":" + this.endPoint.getIdentity();
        }
    }

    abstract class MonitorTask
    implements Runnable,
    MonitorTaskInfo {
        CFEndPoint cfEndPoint;
        EndPoint endPoint;
        int testCount;
        int lastAdvice;
        long stateChangedTimeStamp;
        long lastAccessedTimeStamp;
        ArrayList advisors;
        Map advisorsCache = Collections.synchronizedMap(new HashMap());
        long timeout;

        MonitorTask(CFEndPoint cfep, EndPoint ep, long timeout) {
            this.endPoint = ep;
            this.cfEndPoint = cfep;
            this.testCount = 0;
            this.lastAdvice = 0;
            this.stateChangedTimeStamp = this.lastAccessedTimeStamp = System.currentTimeMillis();
            this.advisors = null;
            this.timeout = timeout;
        }

        public EndPoint getEndPoint() {
            return this.endPoint;
        }

        public CFEndPoint getCFEndPoint() {
            return this.cfEndPoint;
        }

        public int getTestCount() {
            return this.testCount;
        }

        public long getTimeout() {
            return this.timeout;
        }

        final void resetTestCount() {
            this.testCount = 0;
        }

        final void incSuccessfulTest() {
            if (this.testCount < 0) {
                this.testCount = 1;
                this.setStateChangedTimeStamp();
            } else if (this.testCount < Integer.MAX_VALUE) {
                ++this.testCount;
            }
        }

        final void incUnsuccessfulTest() {
            if (this.testCount > 0) {
                this.testCount = -1;
                this.setStateChangedTimeStamp();
            } else if (this.testCount > Integer.MIN_VALUE) {
                --this.testCount;
            }
        }

        public int getLastAdvice() {
            return this.lastAdvice;
        }

        public long getStateChangedTimeStamp() {
            return this.stateChangedTimeStamp;
        }

        long setStateChangedTimeStamp() {
            this.stateChangedTimeStamp = System.currentTimeMillis();
            return this.stateChangedTimeStamp;
        }

        public long getLastAccessedTimeStamp() {
            return this.lastAccessedTimeStamp;
        }

        long setLastAccessedTimeStamp() {
            this.lastAccessedTimeStamp = System.currentTimeMillis();
            return this.lastAccessedTimeStamp;
        }

        public boolean equals(Object cmd) {
            boolean rtnVal = false;
            if (cmd instanceof MonitorTask) {
                rtnVal = this.endPoint == ((MonitorTask)cmd).endPoint;
            }
            return rtnVal;
        }
    }
}

