/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.validation;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.channelservice.Chain;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelFactory;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.websphere.validation.base.config.MOFValidator;
import com.ibm.websphere.validation.base.config.WebSphereDelegateCrossValidator;
import com.ibm.ws.channel.framework.ChannelTypeManager;
import com.ibm.ws.channel.framework.ctm.ValidationChannelTypeManager;
import com.ibm.ws.channel.validation.ChannelFrameworkValidator;
import com.ibm.ws.channel.validation.ChannelTypeValidatorManager;
import com.ibm.ws.channel.validation.ChannelValidationCollector;
import com.ibm.wsspi.channel.ChannelFactoryTypeValidator;
import com.ibm.wsspi.channel.ChannelTypeValidator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.validation.internal.core.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelFrameworkCrossValidator
extends WebSphereDelegateCrossValidator {
    private static final TraceComponent tc = Tr.register(ChannelFrameworkCrossValidator.class, "ChannelFrameworkService", "com.ibm.ws.channel.resources.channelframeworkservice");
    private ChannelTypeManager _typeManager = new ValidationChannelTypeManager();
    private ChannelTypeValidatorManager _validatorManager = new ChannelTypeValidatorManager((MOFValidator)this, this._typeManager);

    public ChannelFrameworkCrossValidator(MOFValidator parent) {
        super(parent);
    }

    public String getLocalBundleID() {
        return "com.ibm.ws.channel.resources.channelframeworkvalidation";
    }

    public String getLocalTraceName() {
        return "ChannelFrameworkCrossValidator";
    }

    protected boolean basicValidate(Object target) throws ValidationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "basicValidate", ChannelFrameworkValidator.getID((EObject)target));
        }
        if (!(target instanceof TransportChannelService)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "basicValidate");
            }
            return super.basicValidate(target);
        }
        try {
            TransportChannelService root = (TransportChannelService)target;
            EList list = root.getFactories();
            if (list != null && !list.isEmpty()) {
                this.validateFactories(list);
            }
            if ((list = root.getTransportChannels()) != null && !list.isEmpty()) {
                this.validateChannels(list);
            }
            if ((list = root.getChains()) != null && !list.isEmpty()) {
                this.validateChains(list);
            }
        }
        catch (Exception exp) {
            this.addError("generic.validation.exception", new String[]{exp.getMessage()}, target);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "basicValidate");
        }
        return true;
    }

    private void validateFactories(List<?> factories) throws ValidationException {
        for (TransportChannelFactory factory : factories) {
            ChannelFactoryTypeValidator validator;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "cross validating " + ChannelFrameworkValidator.getID((EObject)factory));
            }
            if (null == (validator = this._validatorManager.getChannelFactoryTypeValidator(factory))) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Validator: " + ((Object)((Object)validator)).getClass().getName());
            }
            validator.crossValidate(factory);
        }
    }

    private void validateChannels(List<?> channels) throws ValidationException {
        ChannelValidationCollector collector = new ChannelValidationCollector(this._typeManager);
        for (TransportChannel channel : channels) {
            ChannelTypeValidator validator;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "cross validating " + ChannelFrameworkValidator.getID((EObject)channel));
            }
            if (null == (validator = this._validatorManager.getChannelTypeValidator(channel))) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Validator: " + ((Object)((Object)validator)).getClass().getName());
            }
            validator.crossValidate(channel);
            collector.collectChannel(channel);
        }
        for (ChannelTypeManager.ChannelMetaData type : collector.getChannelTypes()) {
            this.validateAllChannels(type, collector.getChannels(type));
        }
    }

    private void validateChains(List<?> chains) {
        for (Chain chain : chains) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "cross validating " + ChannelFrameworkValidator.getID((EObject)chain));
            }
            this.validateChainChannels(chain);
        }
    }

    private void validateAllChannels(ChannelTypeManager.ChannelMetaData type, List<TransportChannel> channels) {
        block4: {
            if (channels == null || channels.isEmpty()) {
                return;
            }
            try {
                TransportChannel[] all = channels.toArray(new TransportChannel[channels.size()]);
                ChannelTypeValidator validator = (ChannelTypeValidator)this._validatorManager.getValidator(type.getClass(type.getValidatorClass()));
                if (null != validator) {
                    validator.crossValidateAll(all);
                }
            }
            catch (Throwable t) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "validateAllChannels caught " + t);
            }
        }
    }

    private void validateChainChannels(Chain chain) {
        Iterator it = chain.getTransportChannels().iterator();
        while (it.hasNext()) {
            try {
                TransportChannel channel = (TransportChannel)it.next();
                ChannelTypeValidator validator = this._validatorManager.getChannelTypeValidator(channel);
                if (null == validator) continue;
                validator.crossValidateInChain(channel, chain);
            }
            catch (ValidationException exp) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "caught exception in validateChainChannels (Chain): " + (Object)((Object)exp));
            }
        }
    }
}

