/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bundle;

import com.ibm.ws.bundle.ParentableResourceBundle;
import com.ibm.ws.bundle.SimpleLRUCache;
import com.ibm.ws.bundle.WrappedResourceBundle;
import com.ibm.ws.security.util.AccessController;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CachingTextResourceBundle
extends ParentableResourceBundle {
    private static final int DEFAULT_MAX_BAD_ENTRIES = 25;
    private static final int DEFAULT_MAX_BUNDLE_ENTRIES = 150;
    private static SimpleLRUCache bundleCache = null;
    private static SimpleLRUCache badBundleCache = null;
    private SimpleLRUCache keyCache = null;
    private SimpleLRUCache badKeyCache = null;
    private static Vector excludeLazyList = null;
    protected URL fullBundleName = null;
    private static Integer overrideBundleMax = null;
    private static Integer overrideKeyMax = null;
    private static boolean useJvmResourceLoader = false;
    private static boolean emitKeyRequests = false;
    private static String className = "com.ibm.ws.bundle.CachingTextResourceBundle";
    private static Logger logger = Logger.getLogger(className, null);

    public CachingTextResourceBundle() {
        int maxKeys = 25;
        if (overrideKeyMax != null) {
            maxKeys = overrideKeyMax;
        }
        this.keyCache = maxKeys == -1 ? new SimpleLRUCache(-1) : new SimpleLRUCache(maxKeys);
    }

    public CachingTextResourceBundle(int mKeys) {
        this.keyCache = mKeys > 0 ? new SimpleLRUCache(mKeys) : new SimpleLRUCache(-1);
    }

    public static ResourceBundle getBundle(String baseName, Locale locale, ClassLoader loader) throws NullPointerException, MissingResourceException {
        int maxKeys = 25;
        if (overrideKeyMax != null) {
            maxKeys = overrideKeyMax;
        }
        return CachingTextResourceBundle.getBundle(baseName, locale, loader, maxKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceBundle getBundle(String baseName, Locale locale, ClassLoader loader, int maxKeys) throws NullPointerException, MissingResourceException {
        boolean loadLazy = true;
        ResourceBundle completeBundle = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "getBundle(String,Locale,ClassLoader,int)");
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, className, "getBundle", "Calling load for bundle: [" + baseName + "]");
        }
        if (baseName == null) {
            return null;
        }
        if (locale == null) {
            throw new NullPointerException("Locale cannot be null");
        }
        if (loader == null) {
            try {
                loader = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                try {
                    loader = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return ClassLoader.getSystemClassLoader();
                        }
                    });
                }
                catch (PrivilegedActionException e1) {
                    throw new MissingResourceException("Could not determine classloader to search on.  Do not have classloader lookup privilages.", baseName, e1.toString());
                }
            }
        }
        if (useJvmResourceLoader) {
            completeBundle = ResourceBundle.getBundle(baseName, locale, loader);
        } else {
            SimpleLRUCache simpleLRUCache = bundleCache;
            synchronized (simpleLRUCache) {
                if (bundleCache != null) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, className, "getBundle", "Checking bundle cache to see if: [" + baseName + "] is already loaded.");
                    }
                    completeBundle = (ResourceBundle)bundleCache.getEntry(baseName + "_" + locale.toString());
                }
                if (completeBundle == null) {
                    ParentableResourceBundle topLevel = null;
                    ParentableResourceBundle secondaryLevel = null;
                    ParentableResourceBundle basicLevel = null;
                    ParentableResourceBundle noLocaleLevel = null;
                    String strLocale = locale.getLanguage() + "_" + locale.getCountry() + "_" + locale.getVariant();
                    topLevel = CachingTextResourceBundle.loadBundle(baseName, strLocale, loader, maxKeys);
                    if (topLevel != null) {
                        topLevel.setLocale(locale);
                    }
                    if ((secondaryLevel = CachingTextResourceBundle.loadBundle(baseName, strLocale = locale.getLanguage() + "_" + locale.getCountry(), loader, maxKeys)) != null) {
                        secondaryLevel.setLocale(new Locale(locale.getLanguage(), locale.getCountry()));
                    }
                    if ((basicLevel = CachingTextResourceBundle.loadBundle(baseName, strLocale = locale.getLanguage(), loader, maxKeys)) != null) {
                        basicLevel.setLocale(new Locale(locale.getLanguage()));
                    }
                    if (topLevel == null && secondaryLevel == null && basicLevel == null) {
                        locale = Locale.getDefault();
                        strLocale = locale.getLanguage() + "_" + locale.getCountry() + "_" + locale.getVariant();
                        topLevel = CachingTextResourceBundle.loadBundle(baseName, strLocale, loader, maxKeys);
                        if (topLevel != null) {
                            topLevel.setLocale(locale);
                        }
                        if ((secondaryLevel = CachingTextResourceBundle.loadBundle(baseName, strLocale = locale.getLanguage() + "_" + locale.getCountry(), loader, maxKeys)) != null) {
                            secondaryLevel.setLocale(new Locale(locale.getLanguage(), locale.getCountry()));
                        }
                        if ((basicLevel = CachingTextResourceBundle.loadBundle(baseName, strLocale = locale.getLanguage(), loader, maxKeys)) != null) {
                            basicLevel.setLocale(new Locale(locale.getLanguage()));
                        }
                    }
                    if ((noLocaleLevel = CachingTextResourceBundle.loadBundle(baseName, null, loader, maxKeys)) != null) {
                        noLocaleLevel.setLocale(Locale.getDefault());
                    }
                    ParentableResourceBundle[] bundles = new ParentableResourceBundle[]{topLevel, secondaryLevel, basicLevel, noLocaleLevel};
                    ParentableResourceBundle top = null;
                    ParentableResourceBundle current = null;
                    for (int i = 0; i < 4; ++i) {
                        if (bundles[i] == null) continue;
                        if (top == null) {
                            current = top = bundles[i];
                            continue;
                        }
                        if (current.getParent() != null) break;
                        current.setParent(bundles[i]);
                        current = bundles[i];
                    }
                    completeBundle = top;
                }
            }
            if (completeBundle == null) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, className, "getBundle", "Bad bundle load request: [" + baseName + "].");
                }
                throw new MissingResourceException("Bundle could not be loaded", baseName, "key");
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "getBundle(String,Locale,ClassLoader,int)");
        }
        return completeBundle;
    }

    private static Class checkAndLoadClassType(String baseName, String locale, ClassLoader loader) {
        Class<?> clazz = null;
        String fullBN = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "checkAndLoadClassType(String, String, ClassLoader)");
        }
        fullBN = locale != null ? baseName + "_" + locale : baseName;
        try {
            clazz = loader.loadClass(fullBN);
        }
        catch (ClassNotFoundException ncfe) {
            // empty catch block
        }
        if (logger.isLoggable(Level.FINEST) && clazz != null) {
            logger.logp(Level.FINEST, className, "checkAndLoadClass", "Loaded bundle that was a class-type bundle: [" + baseName + "].");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "checkAndLoadClassType(String, String, ClassLoader)");
        }
        return clazz;
    }

    private static ParentableResourceBundle loadBundle(String baseName, String locale, ClassLoader loader, int maxKeys) {
        String fullBN = null;
        ParentableResourceBundle retVal = null;
        String cacheKey = baseName;
        if (locale != null) {
            cacheKey = cacheKey + "_" + locale;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "loadBundle(String, String, ClassLoader, int)");
        }
        if (bundleCache.containsEntry(cacheKey)) {
            retVal = (ParentableResourceBundle)bundleCache.getEntry(cacheKey);
        } else if (badBundleCache != null && badBundleCache.containsEntry(cacheKey)) {
            retVal = null;
        } else if (loader != null) {
            final Class clazz = CachingTextResourceBundle.checkAndLoadClassType(baseName, locale, loader);
            if (clazz != null) {
                try {
                    ResourceBundle rbInst = null;
                    rbInst = (ResourceBundle)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            try {
                                return clazz.newInstance();
                            }
                            catch (InstantiationException ieex) {
                                logger.logp(Level.FINE, className, "loadBundle", "Failed to instantiate a class type bundle for: [" + clazz.getName() + "].");
                                return null;
                            }
                            catch (IllegalAccessException iaex) {
                                logger.logp(Level.FINE, className, "loadBundle", "Received IllegalAccessException when instantiating a class type bundle for: [" + clazz.getName() + "].");
                                return null;
                            }
                        }
                    });
                    retVal = new WrappedResourceBundle(rbInst);
                }
                catch (PrivilegedActionException pe) {
                    logger.logp(Level.FINE, className, "loadBundle", "Could not instantiate a new resource bundle class due to SecurityController exceptions on: [" + baseName + "].");
                    retVal = null;
                }
                catch (ClassCastException cce) {
                    retVal = null;
                }
            } else {
                URL res = null;
                fullBN = baseName;
                fullBN = fullBN.replace('.', '/');
                fullBN = locale != null ? fullBN + "_" + locale + ".properties" : fullBN + ".properties";
                res = loader.getResource(fullBN);
                if (res != null) {
                    CachingTextResourceBundle cachingBundle = new CachingTextResourceBundle(maxKeys);
                    cachingBundle.fullBundleName = res;
                    retVal = cachingBundle;
                }
                if (logger.isLoggable(Level.FINEST) && retVal != null) {
                    logger.logp(Level.FINEST, className, "loadBundle", "Loaded bundle that was a property type and therefore on-demand key-caching is enabled: [" + baseName + "].");
                }
            }
        }
        if (retVal != null) {
            bundleCache.putEntry(cacheKey, retVal);
        } else {
            if (badBundleCache == null) {
                badBundleCache = new SimpleLRUCache(25);
            }
            badBundleCache.putEntry(cacheKey, null);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "loadBundle(String, String, ClassLoader, int)");
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handleGetObject(String key) throws NullPointerException {
        Object retVal = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "handleGetObject(String)");
        }
        if (key == null) {
            throw new NullPointerException();
        }
        if (emitKeyRequests) {
            System.out.println("Bundle: [" + this.fullBundleName.toString() + "].  Key: [" + key + "].");
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, className, "handleGetObject", "Trying to fetch key: [" + key + "].");
        }
        SimpleLRUCache simpleLRUCache = this.keyCache;
        synchronized (simpleLRUCache) {
            if (this.keyCache.containsEntry(key)) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, className, "handleGetObject", "Getting key: [" + key + "] from cache.");
                }
                retVal = this.keyCache.getEntry(key);
            } else if (this.badKeyCache != null && this.badKeyCache.containsEntry(key)) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, className, "handleGetObject", "Known bad key: [" + key + "].");
                }
                retVal = null;
            } else {
                retVal = this.keyCache.getEntry(key);
                if (!(retVal != null || this.badKeyCache != null && this.badKeyCache.containsEntry(key))) {
                    retVal = this.getValueFromResource(key);
                    if (retVal != null) {
                        this.keyCache.putEntry(key, retVal);
                    } else {
                        if (this.badKeyCache == null) {
                            this.badKeyCache = new SimpleLRUCache(25);
                        }
                        this.badKeyCache.putEntry(key, key);
                    }
                }
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "handleGetObject(String)");
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String getValueFromResource(String key) {
        String retVal;
        block33: {
            block34: {
                boolean closed;
                InputStream is;
                block32: {
                    retVal = null;
                    is = null;
                    closed = true;
                    if (logger.isLoggable(Level.FINER)) {
                        logger.entering(className, "getValueFromResource(String)");
                    }
                    try {
                        is = this.fullBundleName.openStream();
                        closed = false;
                    }
                    catch (Exception iox) {
                        is = null;
                    }
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, className, "getValueFromResource", "Trying to load key: [" + key + "] from disk bundle: [" + this.fullBundleName.toString() + "]");
                    }
                    if (is == null) break block34;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is, "ISO-8859-1"));
                    String line = reader.readLine();
                    while (line != null) {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.logp(Level.FINEST, className, "getValueFromResource", "Read line from file:  [" + line + "]");
                        }
                        if ((line = this.trimLeadingWhitespace(line)).length() > 0 && line.charAt(0) != '#' && line.charAt(0) != '!') {
                            while (line.charAt(line.length() - 1) == '\\') {
                                if (logger.isLoggable(Level.FINEST)) {
                                    logger.logp(Level.FINEST, className, "getValueFromResource", "Appending line: [" + line + "]");
                                }
                                line = line.substring(0, line.length() - 1);
                                String nextLine = reader.readLine();
                                if (nextLine == null) continue;
                                line = line + this.trimLeadingWhitespace(nextLine);
                            }
                            int keySep = this.findKeySeparator(line);
                            if (keySep == -1) continue;
                            String value2 = null;
                            String extractedKey = null;
                            String tempKey = line.substring(0, keySep).trim();
                            try {
                                extractedKey = this.decodeChars(tempKey);
                            }
                            catch (Exception ex) {
                                extractedKey = tempKey;
                            }
                            if (extractedKey.equals(key)) {
                                int valueStart = keySep + 1;
                                if (valueStart < line.length()) {
                                    String tempValue = line.substring(valueStart, line.length());
                                    tempValue = this.trimLeadingWhitespace(tempValue);
                                    try {
                                        value2 = this.decodeChars(tempValue);
                                    }
                                    catch (Exception ex) {
                                        value2 = tempValue;
                                    }
                                } else {
                                    value2 = "";
                                }
                                line = null;
                                retVal = value2;
                                reader.close();
                                closed = true;
                                continue;
                            }
                            line = reader.readLine();
                            continue;
                        }
                        line = reader.readLine();
                    }
                    if (reader == null || closed) break block32;
                    reader.close();
                    closed = true;
                }
                Object var15_19 = null;
                try {
                    if (is != null && !closed) {
                        is.close();
                        closed = true;
                    }
                    break block33;
                }
                catch (IOException iox) {}
                break block33;
                {
                    catch (UnsupportedEncodingException ueex) {
                        logger.logp(Level.FINE, className, "getValueFromResource", "Input stream could not be opened with encoding type: [ISO-8859-1] on resource: [" + this.fullBundleName.toString() + "].");
                        Object var15_20 = null;
                        try {
                            if (is != null && !closed) {
                                is.close();
                                closed = true;
                            }
                            break block33;
                        }
                        catch (IOException iox) {}
                        break block33;
                    }
                    catch (IOException ioex) {
                        logger.logp(Level.FINE, className, "getValueFromResource", "Input stream read failure on resource: [" + this.fullBundleName.toString() + "].");
                        Object var15_21 = null;
                        try {
                            if (is != null && !closed) {
                                is.close();
                                closed = true;
                            }
                            break block33;
                        }
                        catch (IOException iox) {}
                        break block33;
                    }
                }
                catch (Throwable throwable) {
                    Object var15_22 = null;
                    try {
                        if (is != null && !closed) {
                            is.close();
                            closed = true;
                        }
                    }
                    catch (IOException iox) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, className, "getValueFromResource", "Failed to obtain input stream to bundle: [" + this.fullBundleName.toString() + "]");
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "getValueFromResource(String)");
        }
        return retVal;
    }

    public Enumeration getKeys() {
        Object temp;
        HashMap keys = this.generateKeyList();
        Enumeration<String> parentKeys = null;
        Enumeration vEnum = null;
        if (this.parent != null) {
            parentKeys = this.parent.getKeys();
        }
        if (parentKeys != null) {
            if (keys == null) {
                keys = new HashMap();
            }
            while (parentKeys.hasMoreElements()) {
                temp = parentKeys.nextElement();
                if (keys.containsKey(temp)) continue;
                keys.put(temp, null);
            }
            vEnum = null;
        }
        if (keys != null) {
            temp = new Vector(keys.size());
            Set set = keys.keySet();
            Iterator itr = set.iterator();
            while (itr.hasNext()) {
                ((Vector)temp).add(itr.next());
            }
            vEnum = ((Vector)temp).elements();
        } else {
            vEnum = new Vector().elements();
        }
        return vEnum;
    }

    public void printAccessInformation(PrintStream out) {
        if (out == null) {
            out = System.out;
        }
        if (this.keyCache != null) {
            out.println("Access data for bundle: [" + this.fullBundleName.toString() + "]");
            this.keyCache.printAccessInformation(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void preloadCache(String[] keyArray) {
        block47: {
            if (logger.isLoggable(Level.FINER)) {
                logger.entering(className, "preloadCache(String[])");
            }
            if (keyArray == null) break block47;
            HashMap<String, String> keys = new HashMap<String, String>(keyArray.length);
            SimpleLRUCache simpleLRUCache = this.keyCache;
            synchronized (simpleLRUCache) {
                block46: {
                    block48: {
                        boolean closed;
                        InputStream is;
                        block45: {
                            Set badKeys;
                            is = null;
                            closed = true;
                            for (int i = 0; i < keyArray.length; ++i) {
                                if (keyArray[i] == null || this.keyCache.containsEntry(keyArray[i]) || this.badKeyCache != null && this.badKeyCache.containsEntry(keyArray[i])) continue;
                                keys.put(keyArray[i], keyArray[i]);
                            }
                            if (this.keyCache.size() != -1 && keys.size() > this.keyCache.freeEntriesRemaining()) {
                                int newSize = this.keyCache.size() + (keys.size() - this.keyCache.freeEntriesRemaining());
                                if (logger.isLoggable(Level.FINEST)) {
                                    logger.logp(Level.FINEST, className, "preloadCache", "For bundle: [" + this.fullBundleName.toString() + "] scaling cache to: [" + newSize + "] entries.");
                                }
                                this.keyCache.resize(newSize);
                            }
                            try {
                                is = this.fullBundleName.openStream();
                                closed = false;
                            }
                            catch (Exception iox) {
                                is = null;
                            }
                            if (logger.isLoggable(Level.FINEST)) {
                                logger.logp(Level.FINEST, className, "preloadCache", "Trying to load keys from disk bundle: [" + this.fullBundleName.toString() + "].");
                            }
                            if (is == null) break block48;
                            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "ISO-8859-1"));
                            String line = reader.readLine();
                            while (line != null && !keys.isEmpty()) {
                                if (logger.isLoggable(Level.FINEST)) {
                                    logger.logp(Level.FINEST, className, "preloadCache", "Read line from file:  [" + line + "].");
                                }
                                if ((line = this.trimLeadingWhitespace(line)).length() > 0 && line.charAt(0) != '#' && line.charAt(0) != '!') {
                                    while (line.charAt(line.length() - 1) == '\\') {
                                        if (logger.isLoggable(Level.FINEST)) {
                                            logger.logp(Level.FINEST, className, "preloadCache", "Appending line: [" + line + "].");
                                        }
                                        line = line.substring(0, line.length() - 1);
                                        String nextLine = reader.readLine();
                                        if (nextLine == null) continue;
                                        line = line + this.trimLeadingWhitespace(nextLine);
                                    }
                                    int keySep = this.findKeySeparator(line);
                                    if (keySep != -1) {
                                        String value2 = null;
                                        String extractedKey = null;
                                        String tempKey = line.substring(0, keySep).trim();
                                        try {
                                            extractedKey = this.decodeChars(tempKey);
                                        }
                                        catch (Exception ex) {
                                            extractedKey = tempKey;
                                        }
                                        if (keys.containsKey(extractedKey)) {
                                            int valueStart = keySep + 1;
                                            if (valueStart < line.length()) {
                                                String tempValue = line.substring(valueStart, line.length());
                                                tempValue = this.trimLeadingWhitespace(tempValue);
                                                try {
                                                    value2 = this.decodeChars(tempValue);
                                                }
                                                catch (Exception ex) {
                                                    value2 = tempValue;
                                                }
                                            } else {
                                                value2 = "";
                                            }
                                            line = null;
                                            this.keyCache.putEntry(extractedKey, value2);
                                            keys.remove(extractedKey);
                                        }
                                        line = reader.readLine();
                                        continue;
                                    }
                                    line = reader.readLine();
                                    continue;
                                }
                                line = reader.readLine();
                            }
                            if (reader != null && !closed) {
                                reader.close();
                                closed = true;
                            }
                            if (keys.isEmpty() || (badKeys = keys.keySet()) == null) break block45;
                            String[] badKeyStrings = new String[keys.size()];
                            int count = 0;
                            if (this.badKeyCache == null) {
                                this.badKeyCache = 25 < badKeyStrings.length ? new SimpleLRUCache(badKeyStrings.length) : new SimpleLRUCache(25);
                            } else if (this.badKeyCache.size() < badKeyStrings.length) {
                                // empty if block
                            }
                            this.badKeyCache.resize(badKeyStrings.length);
                            Iterator itr = badKeys.iterator();
                            if (itr != null) {
                                while (itr.hasNext()) {
                                    String badKey = (String)itr.next();
                                    this.badKeyCache.putEntry(badKey, badKey);
                                    badKeyStrings[count] = badKey;
                                    ++count;
                                }
                            }
                            if (this.parent == null || !(this.parent instanceof CachingTextResourceBundle)) break block45;
                            ((CachingTextResourceBundle)this.parent).preloadCache(badKeyStrings);
                        }
                        Object var16_24 = null;
                        try {
                            if (!closed) {
                                is.close();
                            }
                            break block46;
                        }
                        catch (IOException iox) {}
                        break block46;
                        {
                            catch (UnsupportedEncodingException ueex) {
                                logger.logp(Level.FINE, className, "preloadCache", "Input stream could not be opened with encoding type: [ISO-8859-1] on resource: [" + this.fullBundleName.toString() + "].");
                                Object var16_25 = null;
                                try {
                                    if (!closed) {
                                        is.close();
                                    }
                                    break block46;
                                }
                                catch (IOException iox) {}
                                break block46;
                            }
                            catch (IOException ioex) {
                                logger.logp(Level.FINE, className, "preloadCache", "Input stream read failure on resource: [" + this.fullBundleName.toString() + "].");
                                Object var16_26 = null;
                                try {
                                    if (!closed) {
                                        is.close();
                                    }
                                    break block46;
                                }
                                catch (IOException iox) {}
                                break block46;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var16_27 = null;
                            try {
                                if (!closed) {
                                    is.close();
                                }
                            }
                            catch (IOException iox) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, className, "preloadCache", "Failed to obtain input stream to bundle: [" + this.fullBundleName.toString() + "].");
                    }
                }
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "preloadCache(String[])");
        }
    }

    protected void finalize() throws Throwable {
        this.keyCache = null;
        this.badKeyCache = null;
        this.fullBundleName = null;
    }

    private String decodeChars(String str) throws Exception {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "decodeChars(String)");
        }
        StringBuffer buf = new StringBuffer();
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, className, "decodeChars", "Trying to decode string: [" + str + "]");
        }
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != '\\') {
                buf.append(str.charAt(i));
                continue;
            }
            if (i + 2 < str.length() && str.charAt(i) == '\\' && str.charAt(i + 1) == 'u') {
                int uniC = 0;
                char uniCval = '\u0000';
                if (str.length() - i >= 5) {
                    ++i;
                    ++i;
                    block19: for (int j = 0; j < 4; ++j) {
                        char tempChar = str.charAt(j + i);
                        uniC <<= 4;
                        switch (tempChar) {
                            case '0': {
                                uniC |= 0;
                                continue block19;
                            }
                            case '1': {
                                uniC |= 1;
                                continue block19;
                            }
                            case '2': {
                                uniC |= 2;
                                continue block19;
                            }
                            case '3': {
                                uniC |= 3;
                                continue block19;
                            }
                            case '4': {
                                uniC |= 4;
                                continue block19;
                            }
                            case '5': {
                                uniC |= 5;
                                continue block19;
                            }
                            case '6': {
                                uniC |= 6;
                                continue block19;
                            }
                            case '7': {
                                uniC |= 7;
                                continue block19;
                            }
                            case '8': {
                                uniC |= 8;
                                continue block19;
                            }
                            case '9': {
                                uniC |= 9;
                                continue block19;
                            }
                            case 'A': 
                            case 'a': {
                                uniC |= 0xA;
                                continue block19;
                            }
                            case 'B': 
                            case 'b': {
                                uniC |= 0xB;
                                continue block19;
                            }
                            case 'C': 
                            case 'c': {
                                uniC |= 0xC;
                                continue block19;
                            }
                            case 'D': 
                            case 'd': {
                                uniC |= 0xD;
                                continue block19;
                            }
                            case 'E': 
                            case 'e': {
                                uniC |= 0xE;
                                continue block19;
                            }
                            case 'F': 
                            case 'f': {
                                uniC |= 0xF;
                                continue block19;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed character encoding encountered when decoding unicode characters.");
                            }
                        }
                    }
                    uniCval = (char)(uniCval | uniC);
                    buf.append(uniCval);
                    i += 3;
                    continue;
                }
                throw new IllegalArgumentException("Malformed character encoding encountered when decoding unicode characters.");
            }
            if (i + 1 < str.length() && str.charAt(i) == '\\' && str.charAt(i + 1) == 't') {
                buf.append('\t');
                ++i;
                continue;
            }
            if (i + 1 < str.length() && str.charAt(i) == '\\' && str.charAt(i + 1) == 'r') {
                buf.append('\r');
                ++i;
                continue;
            }
            if (i + 1 < str.length() && str.charAt(i) == '\\' && str.charAt(i + 1) == 'f') {
                buf.append('\f');
                ++i;
                continue;
            }
            if (i + 1 < str.length() && str.charAt(i) == '\\' && str.charAt(i + 1) == 'n') {
                buf.append('\n');
                ++i;
                continue;
            }
            if (i + 1 < str.length() && str.charAt(i) == '\\' && str.charAt(i + 1) == ':') {
                buf.append(':');
                ++i;
                continue;
            }
            if (i + 1 < str.length() && str.charAt(i) == '\\' && str.charAt(i + 1) == '=') {
                buf.append('=');
                ++i;
                continue;
            }
            if (i + 1 >= str.length()) continue;
            buf.append(str.charAt(i + 1));
            ++i;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, className, "decodeChars", "Decoded [" + str + "] to: [" + buf.toString() + "]");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "decodeChars(String)");
        }
        return buf.toString();
    }

    private int findKeySeparator(String str) {
        int sepIndex = -1;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "findKeySeperator(String)");
        }
        if (str != null) {
            sepIndex = -1;
            for (int i = 0; i < str.length(); ++i) {
                if (str.charAt(i) == '\\') {
                    if (i + 1 >= str.length() - 1 || str.charAt(i + 1) != ':' && str.charAt(i + 1) != '=' && str.charAt(i + 1) != ' ') continue;
                    ++i;
                    continue;
                }
                if (str.charAt(i) != '=' && str.charAt(i) != ':' && str.charAt(i) != ' ') continue;
                sepIndex = i;
                break;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "findKeySeperator(String)");
        }
        return sepIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private HashMap generateKeyList() {
        HashMap<String, Object> keys;
        block24: {
            block25: {
                boolean closed;
                InputStream is;
                block23: {
                    keys = new HashMap<String, Object>();
                    is = null;
                    closed = true;
                    if (logger.isLoggable(Level.FINER)) {
                        logger.entering(className, "generateKeyList()");
                    }
                    try {
                        is = this.fullBundleName.openStream();
                        closed = false;
                    }
                    catch (Exception iox) {
                        is = null;
                    }
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, className, "generateKeyList", "Trying to load key set for disk bundle: [" + this.fullBundleName + "]");
                    }
                    if (is == null) break block25;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is, "ISO-8859-1"));
                    String line = reader.readLine();
                    while (line != null) {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.logp(Level.FINEST, className, "generateKeyList", "Read line from file:  [" + line + "]");
                        }
                        if ((line = this.trimLeadingWhitespace(line)).length() > 0 && line.charAt(0) != '#' && line.charAt(0) != '!') {
                            while (line.charAt(line.length() - 1) == '\\') {
                                if (logger.isLoggable(Level.FINEST)) {
                                    logger.logp(Level.FINEST, className, "generateKeyList", "Appending line: [" + line + "]");
                                }
                                line = line.substring(0, line.length() - 1);
                                String nextLine = reader.readLine();
                                if (nextLine == null) continue;
                                line = line + this.trimLeadingWhitespace(nextLine);
                            }
                            int keySep = this.findKeySeparator(line);
                            if (keySep == -1) continue;
                            Object value2 = null;
                            String extractedKey = null;
                            String tempKey = line.substring(0, keySep).trim();
                            try {
                                extractedKey = this.decodeChars(tempKey);
                            }
                            catch (Exception ex) {
                                extractedKey = tempKey;
                            }
                            keys.put(extractedKey, null);
                            line = reader.readLine();
                            continue;
                        }
                        line = reader.readLine();
                    }
                    if (reader == null || closed) break block23;
                    reader.close();
                    closed = true;
                }
                Object var12_15 = null;
                try {
                    is.close();
                    closed = true;
                }
                catch (IOException iox) {}
                break block24;
                {
                    catch (UnsupportedEncodingException ueex) {
                        logger.logp(Level.FINE, className, "generateKeyList", "Input stream could not be opened with encoding type: [ISO-8859-1] on resource: [" + this.fullBundleName.toString() + "].");
                        Object var12_16 = null;
                        try {
                            is.close();
                            closed = true;
                        }
                        catch (IOException iox) {}
                        break block24;
                    }
                    catch (IOException ioex) {
                        logger.logp(Level.FINE, className, "generateKeyList", "Input stream read failure on resource: [" + this.fullBundleName.toString() + "].");
                        Object var12_17 = null;
                        try {
                            is.close();
                            closed = true;
                        }
                        catch (IOException iox) {}
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_18 = null;
                    try {
                        is.close();
                        closed = true;
                    }
                    catch (IOException iox) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, className, "generateKeyList", "Failed to obtain input stream to bundle: [" + this.fullBundleName.toString() + "].");
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "generateKeyList()");
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration viewCache() {
        Enumeration vEnum;
        SimpleLRUCache simpleLRUCache = this.keyCache;
        synchronized (simpleLRUCache) {
            vEnum = this.keyCache.getKeys();
        }
        return vEnum;
    }

    private String trimLeadingWhitespace(String str) {
        if (str != null) {
            int pos;
            for (pos = 0; pos < str.length() - 1 && str.charAt(pos) == ' '; ++pos) {
            }
            if (pos > 0 && pos < str.length()) {
                str = str.substring(pos, str.length());
            }
        }
        return str;
    }

    static {
        Integer temp = null;
        String bSize = System.getProperty("was.bundlecaching.maxbundlecache");
        String kSize = System.getProperty("was.bundlecaching.maxkeycache");
        String useJavaDefault = System.getProperty("was.bundlecaching.usevmloader");
        String emitKeys = System.getProperty("was.bundlecaching.emitkeyrequests");
        if (kSize != null) {
            try {
                temp = new Integer(Integer.parseInt(kSize));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (temp != null) {
                overrideKeyMax = temp == 0 ? new Integer(1) : (temp < 0 ? new Integer(-1) : temp);
            }
        }
        if (bSize != null) {
            temp = null;
            try {
                temp = new Integer(Integer.parseInt(bSize));
            }
            catch (NumberFormatException nfe) {
                bundleCache = new SimpleLRUCache(150);
            }
            if (temp != null) {
                bundleCache = temp == 0 ? new SimpleLRUCache(1) : (temp < 0 ? new SimpleLRUCache(-1) : new SimpleLRUCache(temp));
            }
        } else {
            bundleCache = new SimpleLRUCache(150);
        }
        if (useJavaDefault != null) {
            useJvmResourceLoader = useJavaDefault.equalsIgnoreCase("true");
        }
        if (emitKeys != null) {
            emitKeyRequests = emitKeys.equalsIgnoreCase("true");
        }
    }
}

