/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bootstrap;

import com.ibm.ws.bootstrap.LoggingServices;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;

public class TimeBomb {
    static ResourceBundle bundle;
    static final String LICENSE_FILENAME = "was.license";
    static final int LICENSE_TRIAL_PERIOD = 60;
    static final int VERSION = 0;
    static final int PROBATION_PERIOD = 30;

    public static boolean checkLicense(boolean createLicense) {
        return TimeBomb.checkLicense(createLicense, 30);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkLicense(boolean createLicense, int probationPeriod) {
        block12: {
            InputStream is = null;
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                String userLicense = TimeBomb.getLicenseFileName();
                is = cl.getResourceAsStream(LICENSE_FILENAME);
                if (is == null) {
                    try {
                        is = new FileInputStream(userLicense);
                    }
                    catch (FileNotFoundException fnfe) {
                        // empty catch block
                    }
                }
                if (is == null && createLicense) {
                    LoggingServices.trace("WSVR0025I");
                    LoggingServices.trace("WSVR0027I", new Long(60L));
                    TimeBomb.createLicense(true, userLicense);
                    is = new FileInputStream(userLicense);
                }
                if (is == null) break block12;
                ObjectInputStream ois = new ObjectInputStream(is);
                Date creationDate = null;
                Date expirationDate = null;
                try {
                    int licenseVersion = ois.readInt();
                    if (licenseVersion != 0) {
                        LoggingServices.trace("WSVR0026I");
                        boolean bl = false;
                        return bl;
                    }
                    creationDate = (Date)ois.readObject();
                    expirationDate = (Date)ois.readObject();
                }
                finally {
                    ois.close();
                }
                if (creationDate.equals(expirationDate)) {
                    return true;
                }
                Date currentDate = new Date();
                if (currentDate.before(expirationDate)) {
                    long daysLeft = expirationDate.getTime() - currentDate.getTime();
                    daysLeft /= 86400000L;
                    if (++daysLeft > (long)probationPeriod) return true;
                    LoggingServices.trace("WSVR0027I", new Long(daysLeft));
                    return true;
                }
                LoggingServices.trace("WSVR0028I");
                return false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        LoggingServices.trace("WSVR0026I");
        return false;
    }

    public static Date createLicense(boolean trial, String licenseFileName) {
        Date creationDate;
        Date expirationDate = creationDate = new Date();
        if (trial) {
            Calendar expirationCalendar = Calendar.getInstance();
            expirationCalendar.setTime(creationDate);
            expirationCalendar.add(5, 60);
            expirationDate = expirationCalendar.getTime();
        }
        TimeBomb.createLicenseFile(licenseFileName, creationDate, expirationDate);
        return expirationDate;
    }

    static void createLicenseFile(String licenseFileName, Date creationDate, Date expirationDate) {
        try {
            FileOutputStream fos = new FileOutputStream(licenseFileName);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeInt(0);
            oos.writeObject(creationDate);
            oos.writeObject(expirationDate);
            oos.close();
            fos.close();
        }
        catch (Exception ex) {
            LoggingServices.trace("Exception creating license file: ", ex);
        }
    }

    private static String getLicenseFileName() {
        return System.getProperty("was.install.root") + File.separator + "properties" + File.separator + LICENSE_FILENAME;
    }
}

