/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wsaddressing;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReference;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.websphere.wsaddressing.ReferenceParameterCreationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.integration.Registry;
import java.rmi.Remote;
import javax.xml.namespace.QName;

public abstract class EndpointReferenceManager {
    private static final String CLASSNAME = "com.ibm.websphere.wsaddressing.EndpointReferenceManager";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(EndpointReferenceManager.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    protected static final EndpointReferenceManager _endpointReferenceManager;
    private static final String IMPL_CLASSNAME = "com.ibm.ws.wsaddressing.EndpointReferenceManagerImpl";

    protected abstract EndpointReference createConcreteEndpointReference(QName var1, String var2) throws EndpointReferenceCreationException;

    protected abstract EndpointReference createConcreteEndpointReference(QName var1, String var2, Remote var3) throws EndpointReferenceCreationException;

    protected static EndpointReferenceManager getEPRManager() {
        return _endpointReferenceManager;
    }

    public static EndpointReference createEndpointReference(QName serviceName, String endpointName) throws EndpointReferenceCreationException {
        EndpointReference epr = null;
        if (EndpointReferenceManager.getEPRManager() != null) {
            epr = EndpointReferenceManager.getEPRManager().createConcreteEndpointReference(serviceName, endpointName);
        }
        return epr;
    }

    public static EndpointReference createEndpointReference(QName serviceName, String endpointName, Remote statefulSessionBean) throws EndpointReferenceCreationException {
        EndpointReference epr = null;
        if (EndpointReferenceManager.getEPRManager() != null) {
            epr = EndpointReferenceManager.getEPRManager().createConcreteEndpointReference(serviceName, endpointName, statefulSessionBean);
        }
        return epr;
    }

    public static String getReferenceParameterFromMessageContext(QName name2) throws ReferenceParameterCreationException {
        String referenceParameter = Registry.getCombinedReferenceParameterReader().getReferenceParameterFromMessageContext(name2);
        return referenceParameter;
    }

    private static void traceAndFFDCException(Exception e) {
        String exceptionName = e.getClass().getName();
        String exceptionMessage = e.getMessage();
        String message = "Caught a " + exceptionName + ": " + exceptionMessage + " when trying to create a new concrete EndpointReferenceManager instance within a static initializer";
        Tr.warning(TRACE_COMPONENT, message);
        FFDCFilter.processException(e, CLASSNAME, "1:1.24:277");
    }

    static {
        EndpointReferenceManager eprManager = null;
        try {
            eprManager = (EndpointReferenceManager)Class.forName(IMPL_CLASSNAME).newInstance();
        }
        catch (InstantiationException e) {
            EndpointReferenceManager.traceAndFFDCException(e);
        }
        catch (IllegalAccessException e) {
            EndpointReferenceManager.traceAndFFDCException(e);
        }
        catch (ClassNotFoundException e) {
            EndpointReferenceManager.traceAndFFDCException(e);
        }
        _endpointReferenceManager = eprManager;
    }
}

