/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security;

import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import java.lang.reflect.Array;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class SampleSAFMappingModule
implements LoginModule {
    private static final String MAPPING_MODULE_NAME = "com.ibm.websphere.security.SampleSAFMappingModule";
    private static final int MAXIMUM_NAME_LENGTH = 8;
    private boolean useWSPrincipalName = true;
    private boolean debugEnabled = false;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean succeeded = false;

    public void initialize(Subject newSubject, CallbackHandler newCallbackHandler, Map newSharedState, Map newOptions) {
        String useWSPrincipalNameString;
        String debugEnabledString;
        if (newOptions.containsKey("debug") && (debugEnabledString = (String)newOptions.get("debug")) != null && debugEnabledString.toLowerCase().equals("true")) {
            this.debugEnabled = true;
        }
        if (this.debugEnabled) {
            this.debug("initialize() entry");
        }
        this.subject = newSubject;
        this.callbackHandler = newCallbackHandler;
        this.sharedState = newSharedState;
        this.options = newOptions;
        if (this.options.containsKey("useWSPrincipalName") && (useWSPrincipalNameString = (String)this.options.get("useWSPrincipalName")) != null && useWSPrincipalNameString.toLowerCase().equals("false")) {
            this.useWSPrincipalName = false;
        }
        if (this.debugEnabled) {
            this.debug(new Object[]{"initialize() exit", this.subject, this.callbackHandler, this.sharedState, this.options});
        }
    }

    public boolean login() throws LoginException {
        if (this.debugEnabled) {
            this.debug("login() entry");
        }
        if (this.sharedState.containsKey("com.ibm.wsspi.security.token.zos_userid")) {
            if (this.debugEnabled) {
                this.debug("ZOS_USERID already exists:  so no additional work is needed");
            }
            this.succeeded = true;
        } else if (!this.sharedState.containsKey("WSPrincipal") || !this.sharedState.containsKey("WSCredential")) {
            if (this.debugEnabled) {
                this.debug("Principal or Credential is unavailable:  skipping this Login Module");
            }
            this.succeeded = false;
        } else {
            if (this.debugEnabled) {
                this.debug("Principal and Credential are available:  continue with login");
            }
            String name2 = null;
            String audit = null;
            String principalClass = null;
            WSPrincipal principal = (WSPrincipal)this.sharedState.get("WSPrincipal");
            WSCredential credential = (WSCredential)this.sharedState.get("WSCredential");
            if (this.useWSPrincipalName) {
                if (this.debugEnabled) {
                    this.debug("Using name from WSPrincipal to obtain ZOS_USERID");
                }
                name2 = this.createName(principal);
                String realm = this.getRealm(credential);
                audit = realm + "/" + name2 + " MappingModule:" + MAPPING_MODULE_NAME;
                principalClass = "com.ibm.websphere.security.auth.WSPrincipal";
                this.succeeded = true;
            } else {
                if (this.debugEnabled) {
                    this.debug("Using Custom logic to obtain ZOS_USERID");
                }
                this.succeeded = false;
            }
            if (this.succeeded) {
                this.sharedState.put("com.ibm.wsspi.security.token.zos_userid", name2);
                this.sharedState.put("com.ibm.wsspi.security.token.zos_audit_string", audit);
                this.sharedState.put("com.ibm.wsspi.security.token.caller_principal_class", principalClass);
                if (this.debugEnabled) {
                    this.debug(new Object[]{"Values have been stored into the shared state", name2, audit, principalClass});
                }
            }
        }
        if (this.debugEnabled) {
            this.debug("login() exit");
        }
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (this.debugEnabled) {
            this.debug("commit() entry");
        }
        boolean returnVal = this.succeeded;
        this.cleanup();
        if (this.debugEnabled) {
            this.debug("commit() exit");
        }
        return returnVal;
    }

    public boolean abort() throws LoginException {
        if (this.debugEnabled) {
            this.debug("abort() entry");
        }
        boolean returnVal = this.succeeded;
        this.cleanup();
        if (this.debugEnabled) {
            this.debug("abort() exit");
        }
        return returnVal;
    }

    public boolean logout() throws LoginException {
        if (this.debugEnabled) {
            this.debug("logout() entry");
        }
        if (this.debugEnabled) {
            this.debug("logout() exit");
        }
        return true;
    }

    private void cleanup() {
        if (this.debugEnabled) {
            this.debug("cleanup() entry");
        }
        this.succeeded = false;
        if (this.debugEnabled) {
            this.debug("cleanup() exit");
        }
    }

    private void debug(Object o) {
        System.out.println("Debug: com.ibm.websphere.security.SampleSAFMappingModule");
        if (o != null) {
            if (o.getClass().isArray()) {
                int length = Array.getLength(o);
                for (int i = 0; i < length; ++i) {
                    System.out.println("\t" + Array.get(o, i));
                }
            } else {
                System.out.println("\t" + o);
            }
        }
    }

    private String getRealm(WSCredential credential) {
        if (this.debugEnabled) {
            this.debug("getRealm() entry");
        }
        String realm = null;
        try {
            realm = credential.getRealmName();
            if (this.debugEnabled) {
                this.debug("Got realm='" + realm + "' from credential");
            }
        }
        catch (Exception e) {
            if (this.debugEnabled) {
                this.debug(new Object[]{"Caught exception in getRealm: ", e});
            }
            realm = "UNKNOWN_REALM";
        }
        if (this.debugEnabled) {
            this.debug("getRealm() exit");
        }
        return realm;
    }

    private String createName(WSPrincipal principal) {
        int index;
        if (this.debugEnabled) {
            this.debug("createName() entry");
        }
        String name2 = principal.getName();
        if (this.debugEnabled) {
            this.debug("Using name='" + name2 + "' from principal");
        }
        if ((index = name2.indexOf("/") + 1) >= name2.length()) {
            name2 = name2.substring(0, index - 1);
            if (this.debugEnabled) {
                this.debug("Stripping trailing / from WSPrincipal name");
            }
        } else {
            name2 = name2.substring(index);
        }
        if (name2.length() > 8) {
            name2 = name2.substring(0, 8);
            if (this.debugEnabled) {
                this.debug("WSPrincipal name shortened to " + name2);
            }
        }
        name2 = name2.toUpperCase();
        if (this.debugEnabled) {
            this.debug("createName() exit");
        }
        return name2;
    }
}

