/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Properties;

public class ManagedObjectMetadataAccessorFactory {
    private static TraceComponent _tc = Tr.register(ManagedObjectMetadataAccessorFactory.class, "Admin", null);
    private static final String DEFAULT_ACCESSOR_IMPL_CLASS_NAME = "com.ibm.ws.management.metadata.ManagedObjectMetadataAccessorImpl";
    private static final String WORKSPACE_ACCESSOR_PROP = "CONFIG_SESSION";
    private static final String WORKSPACE_ACCESSOR_FACTORY_CLASS_NAME = "com.ibm.ws.sm.workspace.impl.WorkspaceMetadataAccessor";
    private static HashMap _accessorCache = new HashMap();

    public static ManagedObjectMetadataAccessor createAccessor(Properties props) throws AdminException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createAccessor", "Input props: " + props);
        }
        IllegalArgumentException badArgException = null;
        String configSession = (props = props == null ? new Properties() : (Properties)props.clone()).getProperty(WORKSPACE_ACCESSOR_PROP);
        if (configSession != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "configSession", configSession);
            }
            try {
                Class<?> factoryClass = Class.forName(WORKSPACE_ACCESSOR_FACTORY_CLASS_NAME);
                Method factoryMethod = factoryClass.getMethod("createAccessor", String.class);
                ManagedObjectMetadataAccessor accessor = (ManagedObjectMetadataAccessor)factoryMethod.invoke(null, configSession);
                if (_tc.isEntryEnabled()) {
                    Tr.debug(_tc, "createAccessor", accessor);
                }
                return accessor;
            }
            catch (Exception e) {
                throw new AdminException(e, "Encountered an error while attempting to create a ManagedObjectMetadataAccessor instance.");
            }
        }
        AdminService adminService = AdminServiceFactory.getAdminService();
        String prop = props.getProperty("was.repository.root");
        if (prop == null || prop.length() == 0) {
            prop = System.getProperty("was.repository.root");
            if (prop == null || prop.length() == 0) {
                if (adminService == null) {
                    badArgException = new IllegalArgumentException("The property \"was.repository.root\" setting does not exist in the set of input properties or system properties or has a zero-length value.");
                }
            } else {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "createAccessor: Using repository root from sys props: " + prop);
                }
                props.setProperty("was.repository.root", prop);
            }
        }
        if (prop != null && (prop.endsWith("/") || prop.endsWith("\\"))) {
            prop = prop.substring(0, prop.length() - 1);
            props.setProperty("was.repository.root", prop);
        }
        String wasRepoRoot = prop;
        prop = props.getProperty("local.cell");
        if (badArgException == null && (prop == null || prop.length() == 0)) {
            prop = System.getProperty("local.cell");
            if (prop == null || prop.length() == 0) {
                if (adminService != null) {
                    prop = adminService.getCellName();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "createAccessor: Using cell name from AdminService.");
                    }
                } else {
                    String errMsg = null;
                    try {
                        Properties rProps = new Properties();
                        rProps.setProperty("location", "local");
                        rProps.setProperty("was.repository.root", wasRepoRoot);
                        ConfigRepository repo = ConfigRepositoryClientFactory.getConfigRepositoryClient(rProps);
                        String[] cells = repo.listResourceNames("cells", 2, 1);
                        if (cells.length == 1) {
                            prop = cells[0].substring(6);
                            Tr.debug(_tc, "createAccessor: Using cell name from repository.");
                        } else {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "ManagedObjectMetadataAccessorImpl", "Mult cells in repo");
                            }
                            errMsg = "Property \"local.cell\" not defined or has a zero-length value, and could not uniquely determine the cell name because more than one cell name was found in the configuration repository.";
                        }
                    }
                    catch (AdminException e) {
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, "Could not get ConfigRepository reference.", e);
                        }
                        errMsg = "Property \"local.cell\" not defined or has a zero-length value, and could not access configuration repository to determine the cell name.";
                    }
                    if (errMsg != null) {
                        badArgException = new IllegalArgumentException(errMsg);
                    }
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "createAccessor: Using cell name system environment.");
            }
            if (prop != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "createAccessor: cellName=" + prop);
                }
                props.setProperty("local.cell", prop);
            }
        }
        if (badArgException != null) {
            throw new AdminException(badArgException, "Invalid input.  See nested exception for more information.");
        }
        AccessorCacheKey key = new AccessorCacheKey(props.getProperty("was.repository.root"), props.getProperty("local.cell"));
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Accessor cache key: " + key);
        }
        HashMap hashMap = _accessorCache;
        synchronized (hashMap) {
            ManagedObjectMetadataAccessor accessor = (ManagedObjectMetadataAccessor)_accessorCache.get(key);
            if (accessor != null) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "createAccessor: Returning cached accessor.");
                }
                return accessor;
            }
            try {
                Class<?> accessorClass = Class.forName(DEFAULT_ACCESSOR_IMPL_CLASS_NAME);
                Constructor<?> accessorCtor = accessorClass.getConstructor(Properties.class);
                accessor = (ManagedObjectMetadataAccessor)accessorCtor.newInstance(props);
                _accessorCache.put(key, accessor);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "createAccessor");
                }
                return accessor;
            }
            catch (Exception e) {
                throw new AdminException(e, "Encountered an error while attempting to create a ManagedObjectMetadataAccessor instance.");
            }
        }
    }

    private static class AccessorCacheKey {
        private static String SERVER_PROC = "///THIS_SERVER_REPO///";
        private String _repoRoot;
        private String _cellName;

        public AccessorCacheKey(String repositoryRoot, String cellName) {
            this._repoRoot = repositoryRoot != null ? repositoryRoot : SERVER_PROC;
            this._cellName = cellName;
        }

        public boolean equals(Object that) {
            if (that instanceof AccessorCacheKey) {
                AccessorCacheKey thatKey = (AccessorCacheKey)that;
                return this._repoRoot.equals(thatKey._repoRoot) && this._cellName.equals(thatKey._cellName);
            }
            return super.equals(that);
        }

        public int hashCode() {
            return 31 * this._repoRoot.hashCode() + this._cellName.hashCode();
        }

        public String toString() {
            StringBuffer buff = new StringBuffer(64);
            buff.append(this._repoRoot);
            buff.append(":");
            buff.append(this._cellName);
            return buff.toString();
        }
    }
}

