/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.configservice.tasks;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandStep;
import com.ibm.websphere.management.cmdframework.TaskCommand;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.InvalidAttributeValException;
import com.ibm.websphere.management.exception.RequiredAttributeNotFoundException;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class ServerClusterTasks {
    private static TraceComponent tc = Tr.register(ServerClusterTasks.class, "management", "com.ibm.ws.management.resources.configservice");
    private ConfigService configService;
    private static String CLUSTER_CREATE_COMMAND = "createCluster";
    private static String CLUSTER_CONFIG_STEP = "clusterConfig";
    private static String CLUSTER_NAME_PARAM = "clusterName";
    private static String PREFER_LOCAL_PARAM = "preferLocal";
    private static String REP_DOMAIN_STEP = "replicationDomain";
    private static String CREATE_DOMAIN_PARM = "createDomain";
    private static String CONVERT_SERVER_STEP = "convertServer";
    private static String SERVER_NODE_PARAM = "serverNode";
    private static String SERVER_NAME_PARAM = "serverName";
    private static String MEMBER_WEIGHT_PARAM = "memberWeight";
    private static String NODE_GROUP_PARAM = "nodeGroup";
    private static String REP_ENTRY_PARAM = "replicatorEntry";
    private static String MEMBER_CREATE_COMMAND = "createClusterMember";
    private static String MEMBER_DELETE_COMMAND = "deleteClusterMember";
    private static String MEMBER_CONFIG_STEP = "memberConfig";
    private static String MEMBER_NODE_PARAM = "memberNode";
    private static String MEMBER_NAME_PARAM = "memberName";
    private static String MEMBER_UUID_PARAM = "memberUUID";
    private static String GEN_UNIQUE_PORTS_PARAM = "genUniquePorts";
    private static String REPLICATOR_ENTRY_PARAM = "replicatorEntry";
    private static String FIRST_MEMBER_STEP = "firstMember";
    private static String TEMPLATE_NAME_PARAM = "templateName";
    private static String TEMPLATE_SERVER_NODE_PARAM = "templateServerNode";
    private static String TEMPLATE_SERVER_NAME_PARAM = "templateServerName";

    public ServerClusterTasks(ConfigService configService) {
        this.configService = configService;
    }

    public ObjectName createClusterMember(Session session, ObjectName serverCluster, AttributeList clusterMemberAttrList, ObjectName node, ObjectName serverTemplate) throws ConfigServiceException, ConnectorException {
        String uniqueId;
        String serverName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createClusterMember", new Object[]{session, serverCluster, node, clusterMemberAttrList, serverTemplate});
        }
        ObjectName clusterMember = null;
        try {
            String val = (String)ConfigServiceHelper.getAttributeValue(clusterMemberAttrList, "memberName");
            if (!(val instanceof String)) {
                throw new InvalidAttributeValException("memberName");
            }
            serverName = val;
        }
        catch (AttributeNotFoundException ex) {
            throw new RequiredAttributeNotFoundException("memberName");
        }
        try {
            Object val = ConfigServiceHelper.getAttributeValue(clusterMemberAttrList, "uniqueId");
            if (!(val instanceof String)) {
                throw new InvalidAttributeValException("uniqueId");
            }
            uniqueId = (String)val;
        }
        catch (AttributeNotFoundException ex) {
            uniqueId = String.valueOf(System.currentTimeMillis());
            ConfigServiceHelper.setAttributeValue(clusterMemberAttrList, "uniqueId", uniqueId);
        }
        boolean genPort = true;
        try {
            Object val = ConfigServiceHelper.getAttributeValue(clusterMemberAttrList, "adjustPort");
            if (val != null && val instanceof Boolean && !((Boolean)val).booleanValue()) {
                genPort = (Boolean)val;
            }
        }
        catch (AttributeNotFoundException ex) {
            // empty catch block
        }
        String clusterName = ConfigServiceHelper.getDisplayName(serverCluster);
        String nodeName = ConfigServiceHelper.getDisplayName(node);
        String serverTemplateName = null;
        if (serverTemplate != null) {
            serverTemplateName = ConfigServiceHelper.getDisplayName(serverTemplate);
        }
        Properties props = null;
        String templateServerName = null;
        String templateNodeName = null;
        if (serverTemplate != null) {
            props = ConfigServiceHelper.getObjectLocation(serverTemplate);
            templateNodeName = props.getProperty("node");
            templateServerName = props.getProperty("server");
        }
        Integer weight = null;
        try {
            Object val = ConfigServiceHelper.getAttributeValue(clusterMemberAttrList, "weight");
            if (!(val instanceof Integer)) {
                throw new InvalidAttributeValException("weight");
            }
            weight = (Integer)val;
        }
        catch (AttributeNotFoundException ex) {
            // empty catch block
        }
        clusterMember = this.createClusterMember(clusterName, nodeName, serverName, genPort, uniqueId, templateNodeName, templateServerName, serverTemplateName, session, weight);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createClusterMember", clusterMember);
        }
        return clusterMember;
    }

    public ObjectName convertToCluster(Session session, ObjectName server2, String clusterName) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToCluster", new Object[]{session, server2, clusterName});
        }
        String attrVal = (String)this.configService.getAttribute(session, server2, "clusterName");
        String serverName = ConfigServiceHelper.getDisplayName(server2);
        if (attrVal != null) {
            String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0029W", new Object[]{serverName, attrVal}, null);
            throw new ConfigServiceException(msg);
        }
        ObjectName node = this.configService.getRelationship(session, server2, "parent")[0];
        String nodeName = ConfigServiceHelper.getDisplayName(node);
        ObjectName cell = this.configService.getRelationship(session, node, "parent")[0];
        ObjectName result = this.createCluster(clusterName, nodeName, serverName, session);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToCluster", result);
        }
        return result;
    }

    private ObjectName createCluster(String clusterName, String nodeName, String serverName, Session session) throws ConfigServiceException {
        try {
            CommandMgr cmdMgr = null;
            try {
                cmdMgr = this.getCmdMgr(this.configService);
            }
            catch (Exception e) {
                throw new ConfigServiceException(e.getMessage());
            }
            TaskCommand createClusterCmd = (TaskCommand)cmdMgr.createCommand(CLUSTER_CREATE_COMMAND);
            createClusterCmd.setConfigSession(session);
            CommandStep step1 = createClusterCmd.getCommandStep(CLUSTER_CONFIG_STEP);
            step1.setParameter(CLUSTER_NAME_PARAM, clusterName);
            if (serverName != null && nodeName != null) {
                CommandStep step2 = createClusterCmd.getCommandStep(CONVERT_SERVER_STEP);
                step2.setParameter(SERVER_NODE_PARAM, nodeName);
                step2.setParameter(SERVER_NAME_PARAM, serverName);
            }
            createClusterCmd.execute();
            CommandResult res = createClusterCmd.getCommandResult();
            if (!res.isSuccessful()) {
                Object errMsg = res.getResult();
                if (errMsg != null && errMsg instanceof String) {
                    throw new ConfigServiceException(res.getException(), (String)errMsg);
                }
                throw new ConfigServiceException(res.getException());
            }
            return (ObjectName)res.getResult();
        }
        catch (Exception e) {
            throw new ConfigServiceException(e, e.getMessage());
        }
    }

    private ObjectName createClusterMember(String clusterName, String nodeName, String serverName, boolean genPort, String uniqueId, String nodeTemplate, String serverTemplate, String templateName, Session session, Integer weight) throws ConfigServiceException {
        try {
            CommandStep step2;
            CommandMgr cmdMgr = null;
            try {
                cmdMgr = this.getCmdMgr(this.configService);
            }
            catch (Exception e) {
                throw new ConfigServiceException(e.getMessage());
            }
            TaskCommand createMemberCmd = (TaskCommand)cmdMgr.createCommand(MEMBER_CREATE_COMMAND);
            createMemberCmd.setConfigSession(session);
            createMemberCmd.setParameter(CLUSTER_NAME_PARAM, clusterName);
            CommandStep step1 = createMemberCmd.getCommandStep(MEMBER_CONFIG_STEP);
            step1.setParameter(MEMBER_NODE_PARAM, nodeName);
            step1.setParameter(MEMBER_NAME_PARAM, serverName);
            step1.setParameter(MEMBER_UUID_PARAM, uniqueId);
            step1.setParameter("genUniquePorts", new Boolean(genPort));
            step1.setParameter(MEMBER_WEIGHT_PARAM, weight);
            String clusterSpec = "ServerCluster=" + clusterName;
            ObjectName[] matches = this.configService.resolve(session, clusterSpec);
            ObjectName clusterObj = null;
            if (matches.length > 0) {
                clusterObj = matches[0];
            }
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "ClusterMember");
            ObjectName[] currentMemberObjs = this.configService.queryConfigObjects(session, clusterObj, pattern, null);
            if (nodeTemplate != null) {
                if (currentMemberObjs.length == 0) {
                    step2 = createMemberCmd.getCommandStep(FIRST_MEMBER_STEP);
                    step2.setParameter(TEMPLATE_SERVER_NODE_PARAM, nodeTemplate);
                    step2.setParameter(TEMPLATE_SERVER_NAME_PARAM, serverTemplate);
                } else {
                    Tr.warning(tc, "Template specified is ignored, since it is not a first cluster member");
                }
            } else if (templateName != null) {
                if (currentMemberObjs.length == 0) {
                    step2 = createMemberCmd.getCommandStep(FIRST_MEMBER_STEP);
                    step2.setParameter(TEMPLATE_NAME_PARAM, templateName);
                } else {
                    Tr.warning(tc, "Template specified is ignored, since it is not a first cluster member");
                }
            }
            createMemberCmd.execute();
            CommandResult res = createMemberCmd.getCommandResult();
            if (!res.isSuccessful()) {
                Object errMsg = res.getResult();
                if (errMsg != null && errMsg instanceof String) {
                    throw new ConfigServiceException(res.getException(), (String)errMsg);
                }
                throw new ConfigServiceException(res.getException());
            }
            return (ObjectName)res.getResult();
        }
        catch (Exception e) {
            throw new ConfigServiceException(e, e.getMessage());
        }
    }

    private void deleteClusterMember(String clusterName, String nodeName, String serverName, Session session) throws ConfigServiceException {
        try {
            CommandMgr cmdMgr = null;
            try {
                cmdMgr = this.getCmdMgr(this.configService);
            }
            catch (Exception e) {
                throw new ConfigServiceException(e.getMessage());
            }
            TaskCommand deleteMemberCmd = (TaskCommand)cmdMgr.createCommand(MEMBER_DELETE_COMMAND);
            deleteMemberCmd.setConfigSession(session);
            deleteMemberCmd.setParameter(CLUSTER_NAME_PARAM, clusterName);
            deleteMemberCmd.setParameter(MEMBER_NODE_PARAM, nodeName);
            deleteMemberCmd.setParameter(MEMBER_NAME_PARAM, serverName);
            deleteMemberCmd.execute();
            CommandResult res = deleteMemberCmd.getCommandResult();
            if (!res.isSuccessful()) {
                Object errMsg = res.getResult();
                if (errMsg != null && errMsg instanceof String) {
                    throw new ConfigServiceException(res.getException(), (String)errMsg);
                }
                throw new ConfigServiceException(res.getException());
            }
        }
        catch (Exception e) {
            throw new ConfigServiceException(e, e.getMessage());
        }
    }

    private CommandMgr getCmdMgr(ConfigService configService) throws Exception {
        CommandMgr cmdMgr = null;
        cmdMgr = configService instanceof ConfigServiceProxy ? CommandMgr.getCommandMgr(((ConfigServiceProxy)configService).getAdminClient()) : CommandMgr.getCommandMgr();
        return cmdMgr;
    }
}

