/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.cmdframework.provider;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandStep;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.TaskCommand;
import com.ibm.websphere.management.cmdframework.TaskCommandResult;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commanddata.CommandDataFactory;
import com.ibm.websphere.management.cmdframework.commanddata.CommandStepData;
import com.ibm.websphere.management.cmdframework.commanddata.TaskCommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.AbstractCommandStep;
import com.ibm.websphere.management.cmdframework.provider.CommandProvider;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.ws.management.cmdframework.impl.CommandMetadataMgr;
import com.ibm.ws.management.cmdframework.impl.CommandSecurityUtil;
import com.ibm.ws.management.cmdframework.impl.LocalCommandMgr;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.security.auth.Subject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public abstract class AbstractTaskCommand
extends AbstractAdminCommand
implements TaskCommand {
    private static TraceComponent tc = Tr.register(AbstractTaskCommand.class, "AbstractTaskCommand", "com.ibm.websphere.management.cmdframework");
    private static transient TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.cmdframework");
    private Map steps = new HashMap();
    private int currentStepIndex = 0;
    private boolean isLocal;
    private AbstractCommandStep currentStep = null;

    public AbstractTaskCommand(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AbstractTaskCommand", inMetadata);
        }
        if (CommandMgr.getCommandMgr() instanceof LocalCommandMgr) {
            this.isLocal = true;
        }
        this.contructSteps();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AbstractTaskCommand");
        }
    }

    protected void contructSteps() throws CommandNotFoundException {
        TaskCommandData taskCmdData = this.getTaskCommandData();
        TaskCommandMetadata metadata = this.getTaskCommandMetadata();
        EList steps = metadata.getSteps();
        for (CommandStepMetadata stepMetadata : steps) {
            if (this.isLocal && (!stepMetadata.isSupportLocalMode() || !this.isLocal)) continue;
            String stepName = stepMetadata.getName();
            CommandProvider provider = CommandMetadataMgr.getInstance().getCommandProvider(this.getName(), stepName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stepName", stepName);
            }
            AbstractCommandStep step = provider.createCommandStep(this, stepName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "step", step);
            }
            this.addStep(step, provider.commandStepPosition(this, stepName));
        }
    }

    public AbstractTaskCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AbstractTaskCommand", commandData);
        }
        TaskCommandData taskCmdData = this.getTaskCommandData();
        EList stepDataList = taskCmdData.getSteps();
        for (CommandStepData stepData : stepDataList) {
            String stepName = stepData.getName();
            CommandProvider provider = CommandMetadataMgr.getInstance().getCommandProvider(this.getName(), stepName);
            AbstractCommandStep step = provider.loadCommandStep(this, stepData);
            this.steps.put(stepName, step);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AbstractTaskCommand");
        }
    }

    protected CommandData initCommandData() {
        return CommandDataFactory.eINSTANCE.createTaskCommandData();
    }

    public CommandStep getCurrentStep(int operation) {
        if (tc.isDebugEnabled() && this.currentStep != null) {
            Tr.debug(tc, "currentstep", this.currentStep.getName());
        }
        return this.getCurrentStep(operation, "");
    }

    public CommandStep getCurrentStep(int operation, String stepName) {
        if (tc.isDebugEnabled() && this.currentStep != null) {
            Tr.debug(tc, "currentstep", this.currentStep.getName());
        }
        return this.currentStep;
    }

    public void setCurrentStep(AbstractCommandStep newCurrentStep) {
        this.currentStep = newCurrentStep;
    }

    public int getCurrentStepIndex() {
        return this.currentStepIndex;
    }

    public void setCurrentStepIndex(int index) {
        this.currentStepIndex = index;
    }

    public String[] listCommandSteps() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listCommandSteps, cmd: " + this.getName());
        }
        EList steps = this.getTaskCommandData().getSteps();
        String allSteps = "[";
        String[] result = new String[steps.size()];
        for (int i = 0; i < steps.size(); ++i) {
            result[i] = ((CommandStepData)steps.get(i)).getName();
            if (!allSteps.equals("[")) {
                allSteps = allSteps + ", ";
            }
            allSteps = allSteps + result[i];
        }
        allSteps = allSteps + "]";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listCommandSteps, cmd: " + this.getName() + ", result: " + allSteps);
        }
        return result;
    }

    public final CommandStep nextStep() throws NoSuchElementException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "nextStep");
        }
        this.currentStep = (AbstractCommandStep)this.getCurrentStep(0);
        if (tc.isDebugEnabled()) {
            EList stepList = this.getTaskCommandData().getSteps();
            for (int i = 0; i < stepList.size(); ++i) {
                Tr.debug(tc, "nextStep, cmd: " + this.getName() + " has step [" + i + "]: " + ((CommandStepData)stepList.get(i)).getName());
            }
        }
        if (this.currentStep != null) {
            this.stepModified(this.currentStep.getName());
        } else {
            this.commandParamsModified();
        }
        EList stepDataList = this.getTaskCommandData().getSteps();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "1. Step data list is " + stepDataList);
        }
        int length = stepDataList.size();
        AbstractCommandStep result = null;
        for (int index = this.currentStepIndex; index < length; ++index) {
            CommandStepData stepData = (CommandStepData)stepDataList.get(index);
            if (!stepData.isEnabled()) continue;
            result = (AbstractCommandStep)this.steps.get(stepData.getName());
            this.currentStepIndex = index + 1;
            break;
        }
        if (result == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Next step not available ");
            }
            throw new NoSuchElementException();
        }
        this.currentStep = result;
        try {
            result.initStep();
        }
        catch (CommandException ce) {
            NoSuchElementException nse = new NoSuchElementException(ce.toString());
            nse.initCause(ce);
            throw nse;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "nextStep", result.getName());
        }
        return result;
    }

    public final CommandStep previousStep() throws NoSuchElementException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "previousStep");
        }
        this.currentStep = (AbstractCommandStep)this.getCurrentStep(1);
        if (this.currentStep != null) {
            this.stepModified(this.currentStep.getName());
        }
        EList stepDataList = this.getTaskCommandData().getSteps();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "3. Step data list is " + stepDataList);
        }
        int length = stepDataList.size();
        AbstractCommandStep result = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "current stepindex is " + this.currentStepIndex);
        }
        for (int index = this.currentStepIndex - 1; index > 0; --index) {
            if (index <= 0) {
                throw new NoSuchElementException();
            }
            CommandStepData stepData = (CommandStepData)stepDataList.get(index - 1);
            if (!stepData.isEnabled()) continue;
            result = (AbstractCommandStep)this.steps.get(stepData.getName());
            this.currentStepIndex = index;
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, "index is  " + index);
            break;
        }
        if (result == null) {
            throw new NoSuchElementException();
        }
        this.currentStep = result;
        try {
            result.initStep();
        }
        catch (CommandException ce) {
            NoSuchElementException nse = new NoSuchElementException();
            nse.initCause(ce);
            throw nse;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "previousStep", result.getName());
        }
        return result;
    }

    public final boolean hasNextStep() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasNextStep");
        }
        EList stepDataList = this.getTaskCommandData().getSteps();
        int length = stepDataList.size();
        boolean result = false;
        for (int index = this.currentStepIndex; index < length; ++index) {
            CommandStepData stepData = (CommandStepData)stepDataList.get(index);
            if (!stepData.isEnabled()) continue;
            result = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasNextStep," + result);
        }
        return result;
    }

    public final boolean hasPreviousStep() {
        EList stepDataList = this.getTaskCommandData().getSteps();
        int length = stepDataList.size();
        boolean result = false;
        for (int index = this.currentStepIndex - 2; index >= 0; --index) {
            CommandStepData stepData;
            if (index < 0 || !(stepData = (CommandStepData)stepDataList.get(index)).isEnabled()) continue;
            result = true;
            break;
        }
        return result;
    }

    public final CommandStep gotoStep(String stepName) throws NoSuchElementException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "gotoStep, cmd: " + this.getName() + ", stepName: " + stepName);
        }
        try {
            this.currentStep = (AbstractCommandStep)this.getCurrentStep(2, stepName);
        }
        catch (RuntimeException re) {
            for (Throwable t = re.getCause(); t != null; t = t.getCause()) {
                if (!(t instanceof NoSuchElementException)) continue;
                throw (NoSuchElementException)t;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "gotoStep, got unexpected exception " + re + ", root cause: " + re.getCause(), re);
            }
            throw re;
        }
        if (this.currentStep != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "gotoStep, currentStep: " + this.currentStep.getName());
            }
            this.stepModified(this.currentStep.getName());
        }
        TaskCommandData cmdData = this.getTaskCommandData();
        CommandStepData stepData = cmdData.getStepData(stepName);
        AbstractCommandStep result = null;
        if (stepData == null || !stepData.isEnabled()) {
            CommandNotFoundException cnfe = new CommandNotFoundException(this.getName(), stepName);
            NoSuchElementException nse = new NoSuchElementException(cnfe.toString());
            nse.initCause(cnfe);
            throw nse;
        }
        this.currentStepIndex = cmdData.getSteps().indexOf(stepData) + 1;
        result = (AbstractCommandStep)this.steps.get(stepData.getName());
        this.currentStep = result;
        try {
            result.initStep();
        }
        catch (CommandException ce) {
            NoSuchElementException nse = new NoSuchElementException(ce.toString());
            nse.initCause(ce);
            throw nse;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "gotoStep, cmd: " + this.getName() + ", stepName: " + stepName + ", result: " + result);
        }
        return result;
    }

    public CommandStep getCommandStep(String stepName) throws CommandNotFoundException {
        CommandStep result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandStep", stepName);
        }
        if ((result = (CommandStep)this.steps.get(stepName)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCommandStep");
            }
            throw new CommandNotFoundException(this.getName(), stepName);
        }
        try {
            ((AbstractCommandStep)result).initStep();
        }
        catch (CommandException ce) {
            CommandNotFoundException nse = new CommandNotFoundException(this.getName(), stepName);
            nse.initCause(ce);
            throw nse;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandStep", result.getName());
        }
        return result;
    }

    public final TaskCommandData getTaskCommandData() {
        return (TaskCommandData)this.getCommandData();
    }

    public final TaskCommandMetadata getTaskCommandMetadata() {
        return (TaskCommandMetadata)this.getCommandMetadata();
    }

    public void addStep(AbstractCommandStep step, int index) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addStep", new Object[]{step, new Integer(index)});
        }
        this.steps.put(step.getName(), step);
        TaskCommandData cmdData = this.getTaskCommandData();
        EList stepDataList = cmdData.getSteps();
        CommandStepData currentStepData = cmdData.getStepData(step.getName());
        if (currentStepData != null) {
            stepDataList.remove(currentStepData);
        }
        if (index < 0 || index > stepDataList.size()) {
            stepDataList.add(step.getCommandData());
        } else {
            stepDataList.add(index, step.getCommandData());
        }
        try {
            CommandMetadataMgr.getInstance().createParamDataEObject(this.getName(), step.getName(), this.getTaskCommandMetadata());
        }
        catch (CommandNotFoundException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.commandframework.provider.AbstractTaskCommand", "347");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addStep", stepDataList);
        }
    }

    public void resetCommandData(CommandData cmdData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetCommandData", cmdData);
        }
        super.resetCommandData(cmdData);
        EList stepDataList = this.getTaskCommandData().getSteps();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "step data list is  ", stepDataList);
        }
        for (int i = 0; i < stepDataList.size(); ++i) {
            AbstractCommandStep step;
            CommandStepData stepData = (CommandStepData)stepDataList.get(i);
            String stepName = stepData.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "steps are ", this.steps);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "step Name is ", stepName);
            }
            if ((step = (AbstractCommandStep)this.steps.get(stepName)) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "reload step comanddata", stepData);
                }
                step.resetCommandData(stepData);
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "create new step", stepData);
            }
            TaskCommandMetadata metadata = this.getTaskCommandMetadata();
            this.addNewStep(metadata, stepData, i);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetCommandData");
        }
    }

    protected void addNewStep(TaskCommandMetadata metadata, CommandStepData stepData, int i) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNewStep", new Object[]{metadata, stepData});
        }
        if (metadata != null) {
            this.setCommandMetadata(metadata);
        }
        CommandStepMetadata stepMetadata = null;
        String stepName = stepData.getName();
        for (CommandStepMetadata temp : metadata.getSteps()) {
            if (!temp.getName().equals(stepName)) continue;
            stepMetadata = temp;
            break;
        }
        if (stepMetadata == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unable to create step", stepMetadata);
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stepMetadata", stepMetadata);
        }
        AbstractCommandStep step = new AbstractCommandStep(this, stepMetadata);
        step.resetCommandData(stepData);
        this.addStep(step, i);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addNewStep");
        }
    }

    public void validate() throws CommandValidationException {
        super.validate();
        EList stepDataList = this.getTaskCommandData().getSteps();
        for (CommandStepData stepData : stepDataList) {
            AbstractCommandStep step = (AbstractCommandStep)this.steps.get(stepData.getName());
            if (!step.isEnabled()) continue;
            step.validate();
        }
    }

    public void processTaskParameters() {
        TaskCommandResultImpl taskCmdResult;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processTaskParameters for cmd: " + this.getName());
        }
        if ((taskCmdResult = (TaskCommandResultImpl)this.getCommandResult()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Create a new TaskCommandResultImpl object for cmd: " + this.getName());
            }
            taskCmdResult = new TaskCommandResultImpl();
            this.setCommandResult(taskCmdResult);
        }
        if (this.isAsyncCommand()) {
            try {
                this.validate();
            }
            catch (Throwable ex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception thrown during command validation");
                }
                taskCmdResult.setException(ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processTaskParameters for cmd: " + this.getName() + ", is result successful? " + taskCmdResult.isSuccessful());
        }
    }

    protected void beforeStepsExecuted() {
    }

    protected void afterStepsExecuted() {
    }

    protected void taskCommandExecuted(boolean success) {
    }

    protected String showArrayContents(Object[] array) {
        String result = "[";
        for (int i = 0; i < array.length; ++i) {
            if (!result.equals("[")) {
                result = result + ", ";
            }
            result = array[i] instanceof CommandStepData ? result + ((CommandStepData)array[i]).getName() : result + array[i];
        }
        result = result + "]";
        return result;
    }

    protected String showListContents(List list) {
        String result = "[";
        for (int i = 0; i < list.size(); ++i) {
            if (!result.equals("[")) {
                result = result + ", ";
            }
            result = list.get(i) instanceof CommandStepData ? result + ((CommandStepData)list.get(i)).getName() : (list.get(i) instanceof CommandStepMetadata ? result + ((CommandStepMetadata)list.get(i)).getName() : result + list.get(i));
        }
        result = result + "]";
        return result;
    }

    protected void stepModified(String stepName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stepModified, step: " + stepName);
        }
        EList stepDataCollection = this.getTaskCommandData().getSteps();
        HashMap<String, Boolean> stepData = new HashMap<String, Boolean>();
        Object[] cmdStepDataList = stepDataCollection.toArray();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stepModified, cmdStepDataList[]: " + this.showArrayContents(cmdStepDataList));
        }
        for (int i = 0; i < cmdStepDataList.length; ++i) {
            String thisStepName = ((CommandStepData)cmdStepDataList[i]).getName();
            if (stepData.containsKey(thisStepName)) continue;
            if (!thisStepName.equals(stepName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stepModified, stepName: " + stepName + ", thisStepName: " + thisStepName);
                }
                try {
                    AbstractCommandStep step = (AbstractCommandStep)this.getCommandStep(thisStepName);
                    step.stepModified(stepName);
                }
                catch (CommandNotFoundException cnfe) {
                    if (tc.isDebugEnabled()) {
                        Tr.error(tc, cnfe.getMessage());
                    }
                    throw new RuntimeException(cnfe);
                }
                catch (CommandException ce) {
                    if (tc.isDebugEnabled()) {
                        Tr.error(tc, ce.getMessage());
                    }
                    throw new RuntimeException(ce);
                }
            }
            stepData.put(thisStepName, true);
            cmdStepDataList = stepDataCollection.toArray();
            i = -1;
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "stepModified, stepData: " + stepData);
        }
        try {
            AbstractCommandStep step = (AbstractCommandStep)this.getCommandStep(stepName);
            step.stepModified(stepName);
        }
        catch (CommandNotFoundException cnfe) {
            if (tc.isDebugEnabled()) {
                Tr.error(tc, cnfe.getMessage());
            }
            throw new RuntimeException(cnfe);
        }
        catch (CommandException ce) {
            if (tc.isDebugEnabled()) {
                Tr.error(tc, ce.getMessage());
            }
            throw new RuntimeException(ce);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stepModified");
        }
    }

    public void commandParamsModified() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commandParamsModified");
        }
        EList stepDataCollection = this.getTaskCommandData().getSteps();
        Iterator iter = stepDataCollection.iterator();
        while (iter.hasNext()) {
            String thisStepName = ((CommandStepData)iter.next()).getName();
            try {
                AbstractCommandStep step = (AbstractCommandStep)this.getCommandStep(thisStepName);
                step.commandParamModified();
            }
            catch (CommandNotFoundException cnfe) {
                if (!tc.isDebugEnabled()) continue;
                Tr.error(tc, cnfe.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commandParamsModified");
        }
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute cmd: " + this.getName());
        }
        CommandResultImpl cmdResult = (CommandResultImpl)this.getCommandResult();
        TaskCommandResultImpl taskCmdResult = null;
        if (cmdResult == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Create a new TaskCommandResultImpl object for cmd: " + this.getName());
            }
            taskCmdResult = new TaskCommandResultImpl();
            this.setCommandResult(taskCmdResult);
        } else if (!(cmdResult instanceof TaskCommandResultImpl)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Update a new TaskCommandResultImpl object for cmd: " + this.getName());
            }
            taskCmdResult = new TaskCommandResultImpl();
            this.setCommandResult(taskCmdResult);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using the existing TaskCommandResultImpl object for cmd: " + this.getName());
            }
            taskCmdResult = (TaskCommandResultImpl)cmdResult;
        }
        CommandSecurityUtil cmdSecurityUtil = CommandSecurityUtil.getInstance();
        boolean accessGranted = cmdSecurityUtil.checkAccess(this, "execute command");
        if (!accessGranted) {
            String msg = nls.getFormattedMessage("ADMF0010E", new Object[]{this.getName()}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg);
            }
            SecurityException e = new SecurityException(msg);
            taskCmdResult.setException(e);
            return;
        }
        String delegationMode = cmdSecurityUtil.getDelegationMode(this);
        if (delegationMode != null && delegationMode.equals("System")) {
            try {
                Subject subject = ContextManagerFactory.getInstance().getServerSubject();
                ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        AbstractTaskCommand.this.executeReal();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Exception ex = pae.getException();
                taskCmdResult.setException(ex);
            }
            catch (Exception e) {
                taskCmdResult.setException(e);
            }
        } else {
            this.executeReal();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeReal() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeReal");
        }
        EList stepDataList = this.getTaskCommandData().getSteps();
        ArrayList<String> executedSteps = new ArrayList<String>(stepDataList.size());
        boolean success = true;
        TaskCommandResultImpl taskCmdResult = (TaskCommandResultImpl)this.getCommandResult();
        try {
            if (!this.isAsyncCommand()) {
                this.validate();
            }
            this.beforeStepsExecuted();
            if (!taskCmdResult.isSuccessful()) {
                success = false;
            } else {
                for (CommandStepData stepData : stepDataList) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "stepData", stepData);
                    }
                    AbstractCommandStep step = (AbstractCommandStep)this.getCommandStep(stepData.getName());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "step", step);
                    }
                    step.executeStep();
                    CommandResult result = step.getCommandResult();
                    taskCmdResult.setStepResult(step.getName(), result);
                    executedSteps.add(step.getName());
                    if (taskCmdResult.isSuccessful()) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "task command " + this.getName() + " failed on step " + step.getName());
                    }
                    success = false;
                    break;
                }
                if (success) {
                    this.afterStepsExecuted();
                }
            }
        }
        catch (Throwable ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown during command validation");
            }
            taskCmdResult.setException(ex);
        }
        finally {
            EList stepDataCollection = this.getTaskCommandData().getSteps();
            Iterator iter = stepDataCollection.iterator();
            while (iter.hasNext()) {
                String thisStepName = ((CommandStepData)iter.next()).getName();
                try {
                    AbstractCommandStep step = (AbstractCommandStep)this.getCommandStep(thisStepName);
                    step.taskCommandExecuted(taskCmdResult.isSuccessful(), executedSteps.contains(thisStepName));
                }
                catch (CommandNotFoundException cnfe) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.error(tc, cnfe.getMessage());
                }
            }
            this.taskCommandExecuted(taskCmdResult.isSuccessful());
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeReal");
        }
    }

    public TaskCommandResult getTaskCommandResult() {
        return (TaskCommandResult)this.getCommandResult();
    }

    public void listAllStepParamsData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAllStepParamsData", this.getTaskCommandData());
        }
        EList stepDataList = this.getTaskCommandData().getSteps();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "step data list is  ", stepDataList);
        }
        for (CommandStepData stepData : stepDataList) {
            String stepName = stepData.getName();
            EList params = stepData.getCmdParams();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Parameters are " + params);
            }
            EObject paramData = null;
            for (int i = 0; i < params.size(); ++i) {
                paramData = (EObject)params.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "paraData name is ", paramData);
                }
                EClass metaObj = paramData.eClass();
                for (EStructuralFeature feature : metaObj.getEAllAttributes()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "feature", feature);
                    }
                    if (!paramData.eIsSet(feature)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "setted feature is " + feature.getName());
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "setted feature value is " + paramData.eGet(feature));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listAllStepParamsData");
        }
    }
}

