/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASHandler;
import com.ibm.ras.RASUtil;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.Hashtable;

public class RASSocketHandler
extends RASHandler {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    private static final long serialVersionUID = 2940626756544830743L;
    private static final int DEFAULT_PORT = 9991;
    private static final String DEFAULT_SERVER = "localhost";
    private int port = 9991;
    private String server = "localhost";
    private transient Socket socket = null;

    public RASSocketHandler() {
    }

    public RASSocketHandler(String name2) {
        super(name2);
    }

    public RASSocketHandler(String name2, String desc) {
        super(name2, desc);
    }

    public RASSocketHandler(String name2, String desc, String server2, int port2) {
        super(name2, desc);
        this.setServer(server2);
        this.setPort(port2);
    }

    protected void init() {
        super.init();
        this.port = 9991;
        this.server = DEFAULT_SERVER;
        this.socket = null;
    }

    public Hashtable getConfig() {
        Hashtable ht = super.getConfig();
        ht.put("socketPort", new Integer(this.getPort()).toString());
        ht.put("socketServer", this.getServer());
        return ht;
    }

    public void setConfig(Hashtable ht) {
        super.setConfig(ht);
        if (ht.containsKey("socketPort")) {
            String port2 = ((String)ht.get("socketPort")).trim();
            this.setPort(new Integer(port2));
        }
        if (ht.containsKey("socketServer")) {
            this.setServer((String)ht.get("socketServer"));
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port2) {
        this.port = port2;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server2) {
        if (server2 != null) {
            this.server = server2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openDevice() {
        this.closeDevice();
        Object object = this.deviceLock;
        synchronized (object) {
            block5: {
                try {
                    this.socket = new Socket(this.getServer(), this.getPort());
                    DataOutputStream dos = new DataOutputStream(this.socket.getOutputStream());
                    OutputStreamWriter osw = new OutputStreamWriter(dos);
                    this.pWriter = new PrintWriter((Writer)new BufferedWriter(osw), true);
                    this.deviceOpen = true;
                }
                catch (Exception e) {
                    if (++this.deviceFailures > 2) break block5;
                    RASUtil.errorMsg(RASUtil.rasMsgs.getMessage("ERR_OPEN_SOCKET", this.getServer(), new Integer(this.getPort())));
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDevice() {
        Object object = this.deviceLock;
        synchronized (object) {
            super.closeDevice();
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
    }
}

