/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASIHandler;
import com.ibm.ras.RASIMessageEvent;
import com.ibm.ras.RASIMessageLogger;
import com.ibm.ras.RASLogger;
import com.ibm.ras.RASMaskChangeEvent;
import com.ibm.ras.RASMessageEvent;
import com.ibm.ras.RASUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class RASMessageLogger
extends RASLogger
implements RASIMessageLogger,
RASIMessageEvent {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    private static final long serialVersionUID = -774966808967971274L;
    private String component;
    private String organization;
    private String product;
    private String messageFile;
    private Vector suppressedKeys;

    public RASMessageLogger() {
    }

    public RASMessageLogger(String name2) {
        super(name2);
    }

    public RASMessageLogger(String name2, String desc) {
        super(name2, desc);
    }

    public RASMessageLogger(String name2, String desc, String org, String prod, String comp, String server2, String client2) {
        super(name2, desc);
        this.setOrganization(org);
        this.setProduct(prod);
        this.setComponent(comp);
        this.setServer(server2);
        this.setClient(client2);
    }

    protected void init() {
        super.init();
        this.setComponent("");
        this.setOrganization("");
        this.setProduct("");
        this.setMessageFile(null);
        this.suppressedKeys = new Vector();
        this.setLogging(true);
        this.addMessageEventClass("com.ibm.ras.RASMessageEvent");
    }

    public Hashtable getConfig() {
        Hashtable ht = super.getConfig();
        ht.put("organization", this.getOrganization());
        ht.put("product", this.getProduct());
        ht.put("component", this.getComponent());
        String file = this.getMessageFile();
        if (file != null) {
            ht.put("messageFile", file);
        }
        ht.put("suppressedKeys", RASUtil.vectorToString(this.suppressedKeys));
        return ht;
    }

    public void setConfig(Hashtable ht) {
        super.setConfig(ht);
        if (ht.containsKey("organization")) {
            this.setOrganization((String)ht.get("organization"));
        }
        if (ht.containsKey("product")) {
            this.setProduct((String)ht.get("product"));
        }
        if (ht.containsKey("component")) {
            this.setComponent((String)ht.get("component"));
        }
        if (ht.containsKey("messageFile")) {
            this.messageFile = (String)ht.get("messageFile");
        }
        if (ht.containsKey("suppressedKeys")) {
            this.suppressedKeys = RASUtil.stringToVector((String)ht.get("suppressedKeys"));
        }
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String name2) {
        if (name2 != null) {
            this.organization = name2;
        }
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String name2) {
        if (name2 != null) {
            this.product = name2;
        }
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String name2) {
        if (name2 != null) {
            this.component = name2;
        }
    }

    public String getMessageFile() {
        return this.messageFile;
    }

    public void setMessageFile(String file) {
        if (file != null) {
            this.messageFile = file;
        }
    }

    public void addSuppressedKey(String key) {
        if (key != null && !this.suppressedKeys.contains(key)) {
            this.suppressedKeys.addElement(key);
        }
    }

    public void removeSuppressedKey(String key) {
        if (key != null && this.suppressedKeys.contains(key)) {
            this.suppressedKeys.removeElement(key);
        }
    }

    public Vector getSuppressedKeys() {
        return this.suppressedKeys;
    }

    public void message(long type, Object obj, String methodName, String key) {
        if (this.isLoggable(type)) {
            String className = obj.getClass().getName();
            this.logMsg(type, className, methodName, key, this.getMessageFile(), null, null);
        }
    }

    public void message(long type, Object obj, String methodName, String key, Object parm1) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{parm1};
            String className = obj.getClass().getName();
            this.logMsg(type, className, methodName, key, this.getMessageFile(), parms, null);
        }
    }

    public void message(long type, Object obj, String methodName, String key, Object parm1, Object parm2) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{parm1, parm2};
            String className = obj.getClass().getName();
            this.logMsg(type, className, methodName, key, this.getMessageFile(), parms, null);
        }
    }

    public void message(long type, Object obj, String methodName, String key, Object[] parms) {
        if (this.isLoggable(type)) {
            String className = obj.getClass().getName();
            this.logMsg(type, className, methodName, key, this.getMessageFile(), parms, null);
        }
    }

    public void message(long type, String className, String methodName, String key) {
        if (this.isLoggable(type)) {
            this.logMsg(type, className, methodName, key, this.getMessageFile(), null, null);
        }
    }

    public void message(long type, String className, String methodName, String key, Object parm1) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{parm1};
            this.logMsg(type, className, methodName, key, this.getMessageFile(), parms, null);
        }
    }

    public void message(long type, String className, String methodName, String key, Object parm1, Object parm2) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{parm1, parm2};
            this.logMsg(type, className, methodName, key, this.getMessageFile(), parms, null);
        }
    }

    public void message(long type, String className, String methodName, String key, Object[] parms) {
        if (this.isLoggable(type)) {
            this.logMsg(type, className, methodName, key, this.getMessageFile(), parms, null);
        }
    }

    public void msg(long type, Object obj, String methodName, String key, String file) {
        if (this.isLoggable(type)) {
            String className = obj.getClass().getName();
            this.logMsg(type, className, methodName, key, file, null, null);
        }
    }

    public void msg(long type, Object obj, String methodName, String key, String file, Object parm1) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{parm1};
            String className = obj.getClass().getName();
            this.logMsg(type, className, methodName, key, file, parms, null);
        }
    }

    public void msg(long type, Object obj, String methodName, String key, String file, Object parm1, Object parm2) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{parm1, parm2};
            String className = obj.getClass().getName();
            this.logMsg(type, className, methodName, key, file, parms, null);
        }
    }

    public void msg(long type, Object obj, String methodName, String key, String file, Object[] parms) {
        if (this.isLoggable(type)) {
            String className = obj.getClass().getName();
            this.logMsg(type, className, methodName, key, file, parms, null);
        }
    }

    public void msg(long type, String className, String methodName, String key, String file) {
        if (this.isLoggable(type)) {
            this.logMsg(type, className, methodName, key, file, null, null);
        }
    }

    public void msg(long type, String className, String methodName, String key, String file, Object parm1) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{parm1};
            this.logMsg(type, className, methodName, key, file, parms, null);
        }
    }

    public void msg(long type, String className, String methodName, String key, String file, Object parm1, Object parm2) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{parm1, parm2};
            this.logMsg(type, className, methodName, key, file, parms, null);
        }
    }

    public void msg(long type, String className, String methodName, String key, String file, Object[] parms) {
        if (this.isLoggable(type)) {
            this.logMsg(type, className, methodName, key, file, parms, null);
        }
    }

    public void textMessage(long type, Object obj, String methodName, String text) {
        if (this.isLoggable(type)) {
            String className = obj.getClass().getName();
            this.logMsg(type, className, methodName, text, null, null, null);
        }
    }

    public void textMessage(long type, Object obj, String methodName, String text, Object parm1) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{parm1};
            String className = obj.getClass().getName();
            this.logMsg(type, className, methodName, text, null, parms, null);
        }
    }

    public void textMessage(long type, Object obj, String methodName, String text, Object parm1, Object parm2) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{parm1, parm2};
            String className = obj.getClass().getName();
            this.logMsg(type, className, methodName, text, null, parms, null);
        }
    }

    public void textMessage(long type, Object obj, String methodName, String text, Object[] parms) {
        if (this.isLoggable(type)) {
            String className = obj.getClass().getName();
            this.logMsg(type, className, methodName, text, null, parms, null);
        }
    }

    public void textMessage(long type, String className, String methodName, String text) {
        if (this.isLoggable(type)) {
            this.logMsg(type, className, methodName, text, null, null, null);
        }
    }

    public void textMessage(long type, String className, String methodName, String text, Object parm1) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{parm1};
            this.logMsg(type, className, methodName, text, null, parms, null);
        }
    }

    public void textMessage(long type, String className, String methodName, String text, Object parm1, Object parm2) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{parm1, parm2};
            this.logMsg(type, className, methodName, text, null, parms, null);
        }
    }

    public void textMessage(long type, String className, String methodName, String text, Object[] parms) {
        if (this.isLoggable(type)) {
            this.logMsg(type, className, methodName, text, null, parms, null);
        }
    }

    public void exception(long type, Object obj, String methodName, Exception exception) {
        this.exception(type, obj, methodName, (Throwable)exception);
    }

    public void exception(long type, String className, String methodName, Exception exception) {
        this.exception(type, className, methodName, (Throwable)exception);
    }

    public void exception(long type, Object obj, String methodName, Throwable exception) {
        if (this.isLoggable(type)) {
            String className = obj.getClass().getName();
            this.logMsg(type, className, methodName, null, null, null, exception);
        }
    }

    public void exception(long type, String className, String methodName, Throwable exception) {
        if (this.isLoggable(type)) {
            this.logMsg(type, className, methodName, null, null, null, exception);
        }
    }

    protected void logMsg(long type, String className, String methodName, String keyOrText, String file, Object[] parms, Throwable exception) {
        if (file == null || !this.getSuppressedKeys().contains(keyOrText)) {
            RASMessageEvent event = new RASMessageEvent(type, keyOrText, parms, file, className, methodName, this.getOrganization(), this.getProduct(), this.getComponent(), this.getServer(), this.getClient(), exception);
            this.fireRASEvent(event);
        }
    }

    public synchronized void maskValueChanged(RASMaskChangeEvent mc) {
        this.isLoggableMask = 0L;
        Enumeration e = this.getHandlers();
        while (e.hasMoreElements()) {
            RASIHandler h = (RASIHandler)e.nextElement();
            this.isLoggableMask |= h.getMessageMask();
        }
        this.isLoggableMask &= this.getMessageMask();
    }
}

