/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ffdc.util.provider;

import com.ibm.ffdc.config.Formattable;
import com.ibm.ffdc.util.provider.FfdcProvider;
import com.ibm.ffdc.util.provider.IncidentEntry;
import com.ibm.ffdc.util.provider.IncidentLogger;
import com.ibm.ffdc.util.provider.IncidentStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FfdcOnFileProvider
extends FfdcProvider
implements com.ibm.ffdc.provider.FfdcProvider {
    private final File log;
    private FileOutputStream out;
    private long position;
    private static final String thisClass = FfdcOnFileProvider.class.getName();
    private static Logger LOGGER = Logger.getLogger(thisClass, "com.ibm.ffdc.FFDCBundleMessages");

    public FfdcOnFileProvider(File ffdclog, FileOutputStream out) {
        assert (out != null);
        assert (ffdclog != null);
        this.log = ffdclog;
        this.out = out;
    }

    @Override
    protected synchronized void logIncident(IncidentEntry incident, Object reporter, Throwable th, List<Formattable> data) {
        IncidentLogger<FfdcOnFileProvider> incidentLogger = new IncidentLogger<FfdcOnFileProvider>(this);
        FileChannel channel = this.out.getChannel();
        try {
            channel.truncate(this.position);
            IncidentStream<FfdcOnFileProvider> is = new IncidentStream<FfdcOnFileProvider>(this, this.out);
            incidentLogger.writeIncidentTo(is, incident, reporter, th, data);
            is.release();
            this.position = channel.position();
            LOGGER.logp(Level.INFO, thisClass, "logIncident", "FFDCIncidentEmitted", new Object[]{this.log.getAbsolutePath(), incident.getSourceId(), incident.getProbeId()});
            incidentLogger.logIncidentSummary(this.out, this.getIncidents());
            this.out.flush();
        }
        catch (IOException e) {
            this.abort(e);
        }
    }
}

