/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ffdc.util.bulkdata;

import com.ibm.ffdc.util.bulkdata.CapacityException;
import java.io.ByteArrayOutputStream;

public class FixedCapacityOutputStream
extends ByteArrayOutputStream {
    private int capacity;

    public FixedCapacityOutputStream() {
        this(0);
    }

    public FixedCapacityOutputStream(int capacity) {
        this.capacity = capacity;
    }

    public synchronized void write(int b) {
        int newcount = this.count + 1;
        this.checkCapacity(newcount);
        super.write(b);
    }

    public synchronized void write(byte[] b, int off, int len) {
        int newcount = this.count + len;
        this.checkCapacity(newcount);
        super.write(b, off, len);
    }

    public synchronized void reset(int capacity) {
        super.reset();
        this.capacity = capacity;
    }

    private void checkCapacity(int newcount) {
        if (newcount > this.capacity) {
            throw new CapacityException();
        }
    }

    public byte[] getBytes() {
        byte[] bytes = new byte[this.count];
        System.arraycopy(this.buf, 0, bytes, 0, this.count);
        return bytes;
    }
}

