/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ffdc.osgi;

import com.ibm.ffdc.impl.Ffdc;
import com.ibm.ffdc.osgi.DataCollectorTracker;
import com.ibm.ffdc.osgi.FormatterTracker;
import com.ibm.ffdc.osgi.IncidentForwarderTracker;
import com.ibm.ffdc.provider.FfdcProvider;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

class ProviderTracker
extends ServiceTracker {
    private static final String thisClass = ProviderTracker.class.getName();
    private static Logger tracer = Logger.getLogger(thisClass, "com.ibm.ffdc.FFDCBundleMessages");
    private FormatterTracker formatterTracker;
    private DataCollectorTracker dataCollectorTracker;
    private IncidentForwarderTracker incidentForwarderTracker;
    private static final Level LOGLEVEL = Level.INFO;

    public ProviderTracker(BundleContext context) {
        super(context, FfdcProvider.class.getName(), null);
    }

    public Object addingService(ServiceReference reference) {
        FfdcProvider ffdcProvider = (FfdcProvider)this.context.getService(reference);
        Ffdc.set(ffdcProvider);
        this.unsetTrackers();
        this.setTrackers(ffdcProvider);
        if (tracer.isLoggable(LOGLEVEL)) {
            tracer.logp(LOGLEVEL, thisClass, "AddingService", "FFDCProviderInstalled", ffdcProvider);
        }
        return ffdcProvider;
    }

    public void removedService(ServiceReference reference, Object service) {
        Ffdc.unset();
        this.unsetTrackers();
    }

    private void setTrackers(FfdcProvider ffdcProvider) {
        this.formatterTracker = new FormatterTracker(this.context, ffdcProvider);
        this.formatterTracker.open();
        this.dataCollectorTracker = new DataCollectorTracker(this.context, ffdcProvider);
        this.dataCollectorTracker.open();
        this.incidentForwarderTracker = new IncidentForwarderTracker(this.context, ffdcProvider);
        this.incidentForwarderTracker.open();
    }

    private void unsetTrackers() {
        if (this.formatterTracker != null) {
            this.formatterTracker.close();
        }
        this.formatterTracker = null;
        if (this.dataCollectorTracker != null) {
            this.dataCollectorTracker.close();
        }
        this.dataCollectorTracker = null;
        if (this.incidentForwarderTracker != null) {
            this.incidentForwarderTracker.close();
        }
        this.incidentForwarderTracker = null;
    }

    public void close() {
        Ffdc.unset();
        super.close();
    }
}

