/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras.ffdc;

import com.ibm.ejs.ras.ffdc.FfdcProvider;
import com.ibm.ffdc.util.bulkdata.CapacityException;
import com.ibm.ffdc.util.bulkdata.FixedCapacityOutputStream;
import com.ibm.ffdc.util.provider.Incident;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IncidentSummaryLogger
extends com.ibm.ffdc.util.provider.IncidentSummaryLogger<FfdcProvider> {
    public static final int MAXSUMMARYSIZE = 0x100000;

    protected IncidentSummaryLogger(FfdcProvider provider) {
        super(provider);
    }

    @Override
    protected void log(List<Incident> incidents) {
        if (this.getLogIdx() != incidents.size() - 1) {
            FixedCapacityOutputStream os = new FixedCapacityOutputStream(0x100000);
            PrintStream ffdcFile = FfdcProvider.getFFDCFilePrintStream();
            if (ffdcFile != null) {
                try {
                    PrintStream ps = new PrintStream(os);
                    super.logIncidentSummary(ps, incidents);
                    ps.flush();
                    os.writeTo(ffdcFile);
                }
                catch (CapacityException cex) {
                    try {
                        os.writeTo(System.err);
                    }
                    catch (IOException e) {
                        this.ffdcerror(e);
                    }
                }
                catch (Throwable th) {
                    this.ffdcerror(th);
                }
            }
        }
    }
}

