/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.DNSName;
import com.ibm.security.x509.EDIPartyName;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.GeneralSubtree;
import com.ibm.security.x509.IPAddressName;
import com.ibm.security.x509.OIDName;
import com.ibm.security.x509.OtherName;
import com.ibm.security.x509.RFC822Name;
import com.ibm.security.x509.URIName;
import com.ibm.security.x509.X400Address;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public final class GeneralSubtrees
implements Cloneable {
    private final List<GeneralSubtree> trees;
    private static final int NAME_DIFF_TYPE = -1;
    private static final int NAME_MATCH = 0;
    private static final int NAME_NARROWS = 1;
    private static final int NAME_WIDENS = 2;
    private static final int NAME_SAME_TYPE = 3;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.GeneralSubtrees";

    public GeneralSubtrees() {
        this.trees = new ArrayList<GeneralSubtree>();
    }

    private GeneralSubtrees(GeneralSubtrees source) {
        ArrayList sourceTrees = (ArrayList)source.trees;
        this.trees = (List)sourceTrees.clone();
    }

    public GeneralSubtrees(Vector<GeneralSubtree> trees) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "GeneralSubtrees", trees);
        }
        if (trees != null) {
            ArrayList<GeneralSubtree> vec = new ArrayList<GeneralSubtree>();
            for (int i = 0; i < trees.size(); ++i) {
                GeneralSubtree tree = trees.get(i);
                DerOutputStream derout = new DerOutputStream();
                tree.encode(derout);
                DerValue derval = new DerValue(derout.toByteArray());
                GeneralSubtree tree2 = new GeneralSubtree(derval);
                vec.add(tree2);
            }
            this.trees = vec;
        } else {
            this.trees = trees;
        }
        if (debug != null) {
            debug.exit(16384L, className, "GeneralSubtrees");
        }
    }

    public GeneralSubtrees(DerValue val) throws IOException {
        this();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "GeneralSubtrees", val);
        }
        if (val.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "GeneralSubtrees", "Invalid encoding of GeneralSubtrees.");
            }
            throw new IOException("Invalid encoding of GeneralSubtrees.");
        }
        while (val.getData().available() != 0) {
            DerValue opt = val.getData().getDerValue();
            GeneralSubtree tree = new GeneralSubtree(opt);
            this.trees.add(tree);
        }
        if (debug != null) {
            debug.exit(16384L, className, "GeneralSubtrees");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String s = "   GeneralSubtrees:\n" + this.trees.toString() + "\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", s);
        }
        return s;
    }

    public void encode(DerOutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream seq = new DerOutputStream();
        for (int i = 0; i < this.trees.size(); ++i) {
            this.trees.get(i).encode(seq);
        }
        out.write((byte)48, seq);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public Vector getSubtrees() {
        if (debug != null) {
            debug.entry(16384L, className, "getSubtrees");
        }
        if (this.trees == null || this.trees.size() == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSubtrees_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSubtrees_2", ((ArrayList)this.trees).clone());
        }
        return new Vector((ArrayList)((ArrayList)this.trees).clone());
    }

    public void add(GeneralSubtree tree) {
        if (tree == null) {
            throw new NullPointerException();
        }
        this.trees.add(tree);
    }

    public Object clone() {
        return new GeneralSubtrees(this);
    }

    public boolean contains(GeneralSubtree tree) {
        if (tree == null) {
            throw new NullPointerException();
        }
        return this.trees.contains(tree);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GeneralSubtrees)) {
            return false;
        }
        GeneralSubtrees other = (GeneralSubtrees)obj;
        return ((Object)this.trees).equals(other.trees);
    }

    public int hashCode() {
        return ((Object)this.trees).hashCode();
    }

    public GeneralSubtree get(int index) {
        return this.trees.get(index);
    }

    public GeneralSubtrees intersect(GeneralSubtrees other) {
        int j;
        int i;
        if (other == null) {
            throw new NullPointerException("other GeneralSubtrees must not be null");
        }
        GeneralSubtrees newThis = new GeneralSubtrees();
        GeneralSubtrees newExcluded = null;
        if (this.size() == 0) {
            this.union(other);
            return null;
        }
        this.minimize();
        other.minimize();
        for (i = 0; i < this.size(); ++i) {
            GeneralNameInterface thisEntry = this.getGeneralNameInterface(i);
            boolean removeThisEntry = false;
            boolean sameType = false;
            block10: for (j = 0; j < other.size(); ++j) {
                GeneralSubtree otherEntryGS = other.get(j);
                GeneralNameInterface otherEntry = GeneralSubtrees.getGeneralNameInterface(otherEntryGS);
                switch (thisEntry.constrains(otherEntry)) {
                    case 1: {
                        this.remove(i);
                        --i;
                        newThis.add(otherEntryGS);
                        sameType = false;
                        break block10;
                    }
                    case 3: {
                        sameType = true;
                        continue block10;
                    }
                    case 0: 
                    case 2: {
                        sameType = false;
                        break block10;
                    }
                    default: {
                        continue block10;
                    }
                }
            }
            if (!sameType) continue;
            boolean intersection = false;
            block11: for (int j2 = 0; j2 < this.size(); ++j2) {
                GeneralNameInterface thisAltEntry = this.getGeneralNameInterface(j2);
                if (thisAltEntry.getType() != thisEntry.getType()) continue;
                for (int k = 0; k < other.size(); ++k) {
                    GeneralNameInterface othAltEntry = other.getGeneralNameInterface(k);
                    int constraintType = thisAltEntry.constrains(othAltEntry);
                    if (constraintType != 0 && constraintType != 2 && constraintType != 1) continue;
                    intersection = true;
                    continue block11;
                }
            }
            if (!intersection) {
                GeneralSubtree widestSubtree;
                if (newExcluded == null) {
                    newExcluded = new GeneralSubtrees();
                }
                if (!newExcluded.contains(widestSubtree = this.createWidestSubtree(thisEntry))) {
                    newExcluded.add(widestSubtree);
                }
            }
            this.remove(i);
            --i;
        }
        if (newThis.size() > 0) {
            this.union(newThis);
        }
        for (i = 0; i < other.size(); ++i) {
            GeneralSubtree otherEntryGS = other.get(i);
            GeneralNameInterface otherEntry = GeneralSubtrees.getGeneralNameInterface(otherEntryGS);
            boolean diffType = false;
            block14: for (j = 0; j < this.size(); ++j) {
                GeneralNameInterface thisEntry = this.getGeneralNameInterface(j);
                switch (thisEntry.constrains(otherEntry)) {
                    case -1: {
                        diffType = true;
                        continue block14;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        diffType = false;
                        break block14;
                    }
                    default: {
                        continue block14;
                    }
                }
            }
            if (!diffType) continue;
            this.add(otherEntryGS);
        }
        return newExcluded;
    }

    public void union(GeneralSubtrees other) {
        if (other != null) {
            int n = other.size();
            for (int i = 0; i < n; ++i) {
                this.add(other.get(i));
            }
            this.minimize();
        }
    }

    public Iterator iterator() {
        return this.trees.iterator();
    }

    public void reduce(GeneralSubtrees excluded) {
        if (excluded == null) {
            return;
        }
        int n = excluded.size();
        for (int i = 0; i < n; ++i) {
            GeneralNameInterface excludedName = excluded.getGeneralNameInterface(i);
            block7: for (int j = 0; j < this.size(); ++j) {
                GeneralNameInterface permitted = this.getGeneralNameInterface(j);
                switch (excludedName.constrains(permitted)) {
                    case -1: {
                        continue block7;
                    }
                    case 0: {
                        this.remove(j);
                        --j;
                        continue block7;
                    }
                    case 1: {
                        this.remove(j);
                        --j;
                        continue block7;
                    }
                    case 2: {
                        continue block7;
                    }
                }
            }
        }
    }

    private void minimize() {
        for (int i = 0; i < this.size(); ++i) {
            boolean remove1;
            block9: {
                GeneralNameInterface current = this.getGeneralNameInterface(i);
                remove1 = false;
                block8: for (int j = i + 1; j < this.size(); ++j) {
                    GeneralNameInterface subsequent = this.getGeneralNameInterface(j);
                    switch (current.constrains(subsequent)) {
                        case -1: {
                            continue block8;
                        }
                        case 0: {
                            remove1 = true;
                            break block9;
                        }
                        case 1: {
                            this.remove(j);
                            --j;
                            continue block8;
                        }
                        case 2: {
                            remove1 = true;
                            break block9;
                        }
                        case 3: {
                            continue block8;
                        }
                    }
                }
            }
            if (!remove1) continue;
            this.remove(i);
            --i;
        }
    }

    private GeneralSubtree createWidestSubtree(GeneralNameInterface name) {
        try {
            GeneralName newName;
            switch (name.getType()) {
                case 0: {
                    ObjectIdentifier otherOID = ((OtherName)name).getOID();
                    newName = new GeneralName(new OtherName(otherOID, null));
                    break;
                }
                case 1: {
                    newName = new GeneralName(new RFC822Name(""));
                    break;
                }
                case 2: {
                    newName = new GeneralName(new DNSName(""));
                    break;
                }
                case 3: {
                    newName = new GeneralName(new X400Address((byte[])null));
                    break;
                }
                case 4: {
                    newName = new GeneralName(new X500Name(""));
                    break;
                }
                case 5: {
                    newName = new GeneralName(new EDIPartyName(""));
                    break;
                }
                case 6: {
                    newName = new GeneralName(new URIName(""));
                    break;
                }
                case 7: {
                    newName = new GeneralName(new IPAddressName((byte[])null));
                    break;
                }
                case 8: {
                    newName = new GeneralName(new OIDName(new ObjectIdentifier((int[])null)));
                    break;
                }
                default: {
                    throw new IOException("Unsupported GeneralNameInterface type: " + name.getType());
                }
            }
            return new GeneralSubtree(newName, 0, -1);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error: " + e);
        }
    }

    private GeneralNameInterface getGeneralNameInterface(int ndx) {
        return GeneralSubtrees.getGeneralNameInterface(this.get(ndx));
    }

    private static GeneralNameInterface getGeneralNameInterface(GeneralSubtree gs) {
        GeneralName gn = gs.getBase();
        GeneralNameInterface gni = gn.getName();
        return gni;
    }

    public void remove(int index) {
        this.trees.remove(index);
    }

    public int size() {
        return this.trees.size();
    }
}

