/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util;

import com.ibm.security.util.DerInputBuffer;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import java.io.IOException;
import java.io.Serializable;

public final class ObjectIdentifier
implements Serializable {
    private static final long serialVersionUID = 8697030238860181294L;
    private static final int maxFirstComponent = 2;
    private static final int maxSecondComponent = 39;
    private int[] components;
    private int componentLen;
    private static final int allocationQuantum = 5;
    private volatile transient String stringForm;

    public ObjectIdentifier(String oid) throws IOException {
        int ch = 46;
        int start = 0;
        int end = 0;
        this.componentLen = 0;
        while ((end = oid.indexOf(ch, start)) != -1) {
            start = end + 1;
            ++this.componentLen;
        }
        ++this.componentLen;
        this.components = new int[this.componentLen];
        start = 0;
        int i = 0;
        String comp = null;
        while ((end = oid.indexOf(ch, start)) != -1) {
            comp = oid.substring(start, end);
            this.components[i++] = Integer.valueOf(comp);
            if (this.components[i++] < 0) {
                throw new IOException("oid components must be nonnegative");
            }
            start = end + 1;
        }
        comp = oid.substring(start);
        this.components[i] = Integer.valueOf(comp);
        if (this.components[0] < 0 || this.components[0] > 2) {
            throw new IOException("First oid component is invalid ");
        }
        if (this.components[1] < 0 || this.components[0] < 2 && this.components[1] > 39) {
            throw new IOException("Second oid component is invalid ");
        }
        this.stringForm = oid;
    }

    public ObjectIdentifier(int[] values) throws IOException {
        if (values.length >= 1 && (values[0] < 0 || values[0] > 2)) {
            throw new IOException("First oid component is invalid ");
        }
        if (values.length >= 2 && (values[1] < 0 || values[1] > 39)) {
            throw new IOException("Second oid component is invalid ");
        }
        this.components = (int[])values.clone();
        this.componentLen = values.length;
    }

    public ObjectIdentifier(DerInputStream in) throws IOException {
        byte type_id = (byte)in.getByte();
        if (type_id != 6) {
            throw new IOException("X509.ObjectIdentifier() -- data isn't an object ID (tag = " + type_id + ")");
        }
        int bufferEnd = in.available() - in.getLength() - 1;
        if (bufferEnd < 0) {
            throw new IOException("X509.ObjectIdentifier() -- not enough data");
        }
        this.initFromEncoding(in, bufferEnd);
    }

    ObjectIdentifier(DerInputBuffer buf) throws IOException {
        this.initFromEncoding(new DerInputStream(buf), 0);
    }

    private ObjectIdentifier(int[] components, boolean dummy) {
        this.components = components;
        this.componentLen = components.length;
    }

    public static ObjectIdentifier newInternal(int[] values) {
        return new ObjectIdentifier(values, true);
    }

    private void initFromEncoding(DerInputStream in, int bufferEnd) throws IOException {
        boolean first_subid = true;
        this.components = new int[5];
        this.componentLen = 0;
        while (in.available() > bufferEnd) {
            int component = ObjectIdentifier.getComponent(in);
            if (component < 0) {
                throw new IOException("X509.ObjectIdentifier() -- component values must be nonnegative");
            }
            if (first_subid) {
                int X = component < 40 ? 0 : (component < 80 ? 1 : 2);
                int Y = component - X * 40;
                if ((X == 0 || X == 1) && Y > 39) {
                    throw new IOException("X509.ObjectIdentifier() -- Invalid second component");
                }
                this.components[0] = X;
                this.components[1] = Y;
                this.componentLen = 2;
                first_subid = false;
                continue;
            }
            if (this.componentLen >= this.components.length) {
                int[] tmp_components = new int[this.components.length + 5];
                System.arraycopy(this.components, 0, tmp_components, 0, this.components.length);
                this.components = tmp_components;
            }
            this.components[this.componentLen++] = component;
        }
        if (in.available() != bufferEnd) {
            throw new IOException("X509.ObjectIdentifier() -- malformed input data");
        }
    }

    void encode(DerOutputStream out) throws IOException {
        DerOutputStream bytes = new DerOutputStream();
        ObjectIdentifier.putComponent(bytes, this.components[0] * 40 + this.components[1]);
        for (int i = 2; i < this.componentLen; ++i) {
            ObjectIdentifier.putComponent(bytes, this.components[i]);
        }
        out.write((byte)6, bytes);
    }

    private static int getComponent(DerInputStream in) throws IOException {
        int retval = 0;
        for (int i = 0; i < 4; ++i) {
            retval <<= 7;
            int tmp = in.getByte();
            retval |= tmp & 0x7F;
            if ((tmp & 0x80) != 0) continue;
            return retval;
        }
        throw new IOException("X509.OID, component value too big");
    }

    private static void putComponent(DerOutputStream out, int val) throws IOException {
        int i;
        byte[] buf = new byte[4];
        for (i = 0; i < 4; ++i) {
            buf[i] = (byte)(val & 0x7F);
            if ((val >>>= 7) == 0) break;
        }
        while (i > 0) {
            out.write(buf[i] | 0x80);
            --i;
        }
        out.write(buf[0]);
    }

    public boolean precedes(ObjectIdentifier other) {
        if (other == this || this.componentLen < other.componentLen) {
            return false;
        }
        if (other.componentLen < this.componentLen) {
            return true;
        }
        for (int i = 0; i < this.componentLen; ++i) {
            if (other.components[i] >= this.components[i]) continue;
            return true;
        }
        return false;
    }

    public boolean equals(ObjectIdentifier other) {
        return this.equals((Object)other);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ObjectIdentifier)) {
            return false;
        }
        ObjectIdentifier o = (ObjectIdentifier)other;
        if (this.componentLen != o.componentLen) {
            return false;
        }
        for (int i = 0; i < this.componentLen; ++i) {
            if (this.components[i] == o.components[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = this.componentLen;
        for (int i = 0; i < this.componentLen; ++i) {
            h += this.components[i] * 37;
        }
        return h;
    }

    public String toString() {
        String s = this.stringForm;
        if (s == null) {
            StringBuilder sb = new StringBuilder(this.componentLen * 4);
            for (int i = 0; i < this.componentLen; ++i) {
                if (i != 0) {
                    sb.append('.');
                }
                sb.append(this.components[i]);
            }
            this.stringForm = s = sb.toString();
        }
        return s;
    }
}

