/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util;

import com.ibm.security.util.MemoryCache;
import com.ibm.security.util.NullCache;
import java.util.Arrays;

public abstract class Cache {
    protected Cache() {
    }

    public abstract int size();

    public abstract void clear();

    public abstract void put(Object var1, Object var2);

    public abstract Object get(Object var1);

    public abstract void remove(Object var1);

    public static Cache newSoftMemoryCache(int size) {
        return new MemoryCache(true, size);
    }

    public static Cache newSoftMemoryCache(int size, int timeout) {
        return new MemoryCache(true, size, timeout);
    }

    public static Cache newHardMemoryCache(int size) {
        return new MemoryCache(false, size);
    }

    public static Cache newNullCache() {
        return NullCache.INSTANCE;
    }

    public static Cache newHardMemoryCache(int size, int timeout) {
        return new MemoryCache(false, size, timeout);
    }

    public static class EqualByteArray {
        private final byte[] b;
        private volatile int hash;

        public EqualByteArray(byte[] b) {
            this.b = b;
        }

        public int hashCode() {
            int h = this.hash;
            if (h == 0) {
                h = this.b.length + 1;
                for (int i = 0; i < this.b.length; ++i) {
                    h += (this.b[i] & 0xFF) * 37;
                }
                this.hash = h;
            }
            return h;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof EqualByteArray)) {
                return false;
            }
            EqualByteArray other = (EqualByteArray)obj;
            return Arrays.equals(this.b, other.b);
        }
    }
}

