/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs12.PKCS12Utils;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.SignerInfo;
import com.ibm.security.pkcs9.ChallengePassword;
import com.ibm.security.pkcs9.ContentType;
import com.ibm.security.pkcs9.Countersignature;
import com.ibm.security.pkcs9.EmailAddress;
import com.ibm.security.pkcs9.ExtendedCertificateAttributes;
import com.ibm.security.pkcs9.ExtensionRequest;
import com.ibm.security.pkcs9.FriendlyName;
import com.ibm.security.pkcs9.LocalKeyId;
import com.ibm.security.pkcs9.MessageDigest;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcs9.SignatureTimestampToken;
import com.ibm.security.pkcs9.SigningCertificate;
import com.ibm.security.pkcs9.SigningTime;
import com.ibm.security.pkcs9.UnstructuredAddress;
import com.ibm.security.pkcs9.UnstructuredName;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.CertificateExtensions;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;

public final class PKCS9 {
    public static final String EMAIL_ADDRESS_STR = "EmailAddress";
    public static final String UNSTRUCTURED_NAME_STR = "UnstructuredName";
    public static final String CONTENT_TYPE_STR = "ContentType";
    public static final String MESSAGE_DIGEST_STR = "MessageDigest";
    public static final String SIGNING_TIME_STR = "SigningTime";
    public static final String COUNTERSIGNATURE_STR = "Countersignature";
    public static final String CHALLENGE_PASSWORD_STR = "ChallengePassword";
    public static final String UNSTRUCTURED_ADDRESS_STR = "UnstructuredAddress";
    public static final String EXTENDED_CERTIFICATE_ATTRIBUTES_STR = "ExtendedCertificateAttributes";
    public static final String FRIENDLY_NAME_STR = "FriendlyName";
    public static final String LOCAL_KEY_ID_STR = "LocalKeyId";
    public static final String SIGNING_CERTIFICATE_STR = "SigningCertificate";
    public static final String EXTENSION_REQUEST_STR = "ExtensionRequest";
    public static final String SIGNATURE_TIMESTAMP_TOKEN_STR = "SignatureTimestampToken";
    private static final int TABLE_SIZE = 14;
    private static final Hashtable NAME_OID_TABLE = new Hashtable(14);
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.PKCS9";
    private static final Hashtable OID_NAME_TABLE;

    private PKCS9() {
    }

    public static ObjectIdentifier getObjectIdentifier(String name) {
        return (ObjectIdentifier)NAME_OID_TABLE.get(name.toLowerCase());
    }

    public static String getName(ObjectIdentifier oid) {
        return (String)OID_NAME_TABLE.get(oid);
    }

    public static PKCS9DerObject getPKCS9Attribute(ObjectIdentifier oid, Object value) {
        return PKCS9.init(oid, value);
    }

    public static PKCS9DerObject getPKCS9Attribute(ObjectIdentifier oid, Object value, String provider) {
        return PKCS9.init(oid, value, provider);
    }

    public static PKCS9DerObject getPKCS9Attribute(String name, Object value) {
        ObjectIdentifier oid = PKCS9.getObjectIdentifier(name);
        if (oid == null) {
            throw new IllegalArgumentException("Unrecognized attribute name " + name + ".");
        }
        return PKCS9.init(oid, value);
    }

    public static PKCS9DerObject getPKCS9Attribute(String name, Object value, String provider) {
        ObjectIdentifier oid = PKCS9.getObjectIdentifier(name);
        if (oid == null) {
            throw new IllegalArgumentException("Unrecognized attribute name " + name + ".");
        }
        return PKCS9.init(oid, value, provider);
    }

    public static PKCS9DerObject getPKCS9Attribute(byte[] encoding) throws IOException {
        return PKCS9.getPKCS9Attribute(encoding, null);
    }

    public static PKCS9DerObject getPKCS9Attribute(byte[] encoding, String provider) throws IOException {
        DerInputStream derIn = new DerInputStream(encoding);
        DerValue[] val = derIn.getSequence(2);
        if (derIn.available() != 0) {
            throw new IOException("Excess data parsing PKCS9 Attribute");
        }
        if (val.length != 2) {
            throw new IOException("PKCS9 Attribute does not have two components");
        }
        ObjectIdentifier oid = val[0].getOID();
        if (oid.equals(PKCSOID.EMAIL_ADDRESS_OID)) {
            return new EmailAddress(encoding, provider);
        }
        if (oid.equals(PKCSOID.UNSTRUCTURED_NAME_OID)) {
            return new UnstructuredName(encoding, provider);
        }
        if (oid.equals(PKCSOID.CONTENT_TYPE_OID)) {
            return new ContentType(encoding, provider);
        }
        if (oid.equals(PKCSOID.MESSAGE_DIGEST_OID)) {
            return new MessageDigest(encoding, provider);
        }
        if (oid.equals(PKCSOID.SIGNING_TIME_OID)) {
            return new SigningTime(encoding, provider);
        }
        if (oid.equals(PKCSOID.COUNTERSIGNATURE_OID)) {
            return new Countersignature(encoding, provider);
        }
        if (oid.equals(PKCSOID.CHALLENGE_PASSWORD_OID)) {
            return new ChallengePassword(encoding, provider);
        }
        if (oid.equals(PKCSOID.UNSTRUCTURED_ADDRESS_OID)) {
            return new UnstructuredAddress(encoding, provider);
        }
        if (oid.equals(PKCSOID.EXTENDED_CERTIFICATE_ATTRIBUTES_OID)) {
            return new ExtendedCertificateAttributes(encoding, provider);
        }
        if (oid.equals(PKCSOID.FRIENDLY_NAME_OID)) {
            return new FriendlyName(encoding, provider);
        }
        if (oid.equals(PKCSOID.LOCAL_KEY_ID_OID)) {
            return new LocalKeyId(encoding, provider);
        }
        if (oid.equals(PKCSOID.SIGNING_CERTIFICATE_OID)) {
            return new SigningCertificate(encoding, provider);
        }
        if (oid.equals(PKCSOID.EXTENSION_REQUEST_OID)) {
            return new ExtensionRequest(encoding, provider);
        }
        if (oid.equals(PKCSOID.SIGNATURE_TIMESTAMP_TOKEN_OID)) {
            return new SignatureTimestampToken(encoding, provider);
        }
        throw new IOException("Unrecognized Object Identifier " + oid + ".");
    }

    public static boolean isAuthenticatedData(String oidString) {
        return oidString.equals(PKCSOID.AUTHENTICATED_DATA_OID.toString());
    }

    public static boolean isAuthenticatedData(ObjectIdentifier oid) {
        return oid.equals(PKCSOID.AUTHENTICATED_DATA_OID);
    }

    private static PKCS9DerObject init(ObjectIdentifier oid, Object value) {
        return PKCS9.init(oid, value, null);
    }

    private static PKCS9DerObject init(ObjectIdentifier oid, Object value, String provider) {
        try {
            if (oid.equals(PKCSOID.EMAIL_ADDRESS_OID)) {
                if (value instanceof String) {
                    return new EmailAddress((String)value, provider);
                }
                return new EmailAddress((String[])value, provider);
            }
            if (oid.equals(PKCSOID.UNSTRUCTURED_NAME_OID)) {
                if (value instanceof String) {
                    String[] names = new String[]{(String)value};
                    return new UnstructuredName(names, provider);
                }
                return new UnstructuredName((String[])value, provider);
            }
            if (oid.equals(PKCSOID.CONTENT_TYPE_OID)) {
                return new ContentType((ObjectIdentifier)value, provider);
            }
            if (oid.equals(PKCSOID.MESSAGE_DIGEST_OID)) {
                DerOutputStream tmpout = new DerOutputStream();
                DerOutputStream tmpout2 = new DerOutputStream();
                tmpout.putOID(PKCSOID.MESSAGE_DIGEST_OID);
                tmpout2.putOctetString((byte[])value);
                tmpout.write((byte)49, tmpout2.toByteArray());
                DerOutputStream tmpout3 = new DerOutputStream();
                tmpout3.write((byte)48, tmpout.toByteArray());
                return new MessageDigest(tmpout3.toByteArray(), provider);
            }
            if (oid.equals(PKCSOID.SIGNING_TIME_OID)) {
                return new SigningTime((Date)value, provider);
            }
            if (oid.equals(PKCSOID.COUNTERSIGNATURE_OID)) {
                return new Countersignature((SignerInfo[])value, provider);
            }
            if (oid.equals(PKCSOID.CHALLENGE_PASSWORD_OID)) {
                return new ChallengePassword((char[])value, provider);
            }
            if (oid.equals(PKCSOID.UNSTRUCTURED_ADDRESS_OID)) {
                if (value instanceof String) {
                    String[] addrs = new String[]{(String)value};
                    return new UnstructuredAddress(addrs, 19, provider);
                }
                return new UnstructuredAddress((String[])value, 19, provider);
            }
            if (oid.equals(PKCSOID.EXTENDED_CERTIFICATE_ATTRIBUTES_OID)) {
                return new ExtendedCertificateAttributes((PKCSAttributes)value, provider);
            }
            if (oid.equals(PKCSOID.FRIENDLY_NAME_OID)) {
                DerOutputStream tmpout = new DerOutputStream();
                DerOutputStream tmpout2 = new DerOutputStream();
                DerOutputStream tmpout3 = new DerOutputStream();
                tmpout.putOID(PKCSOID.FRIENDLY_NAME_OID);
                if (value instanceof String) {
                    String str = (String)value;
                    tmpout2.putBMPString(PKCS12Utils.ascii2bmp(str.toCharArray()));
                } else {
                    tmpout2.putBMPString((byte[])value);
                }
                tmpout.write((byte)49, tmpout2.toByteArray());
                tmpout3.write((byte)48, tmpout.toByteArray());
                return new FriendlyName(tmpout3.toByteArray(), provider);
            }
            if (oid.equals(PKCSOID.LOCAL_KEY_ID_OID)) {
                DerOutputStream tmpout = new DerOutputStream();
                DerOutputStream tmpout2 = new DerOutputStream();
                DerOutputStream tmpout3 = new DerOutputStream();
                tmpout.putOID(PKCSOID.LOCAL_KEY_ID_OID);
                tmpout2.putOctetString((byte[])value);
                tmpout.write((byte)49, tmpout2.toByteArray());
                tmpout3.write((byte)48, tmpout.toByteArray());
                return new LocalKeyId(tmpout3.toByteArray(), provider);
            }
            if (oid.equals(PKCSOID.SIGNING_CERTIFICATE_OID)) {
                return (SigningCertificate)value;
            }
            if (oid.equals(PKCSOID.EXTENSION_REQUEST_OID)) {
                return new ExtensionRequest((CertificateExtensions)value);
            }
            if (oid.equals(PKCSOID.TSTINFO_OID)) {
                return new SignatureTimestampToken((ContentInfo)value);
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Class " + value.getClass().getName() + " does not match the class required for Object Identifier " + oid);
        }
        catch (IOException e2) {
            throw new IllegalArgumentException("Cannot construct attribute from input value.");
        }
        throw new IllegalArgumentException("Unrecognized Object Identifier " + oid + ".");
    }

    static {
        NAME_OID_TABLE.put(new String(EMAIL_ADDRESS_STR).toLowerCase(), PKCSOID.EMAIL_ADDRESS_OID);
        NAME_OID_TABLE.put(new String(UNSTRUCTURED_NAME_STR).toLowerCase(), PKCSOID.UNSTRUCTURED_NAME_OID);
        NAME_OID_TABLE.put(new String(CONTENT_TYPE_STR).toLowerCase(), PKCSOID.CONTENT_TYPE_OID);
        NAME_OID_TABLE.put(new String(MESSAGE_DIGEST_STR).toLowerCase(), PKCSOID.MESSAGE_DIGEST_OID);
        NAME_OID_TABLE.put(new String(SIGNING_TIME_STR).toLowerCase(), PKCSOID.SIGNING_TIME_OID);
        NAME_OID_TABLE.put(new String(COUNTERSIGNATURE_STR).toLowerCase(), PKCSOID.COUNTERSIGNATURE_OID);
        NAME_OID_TABLE.put(new String(CHALLENGE_PASSWORD_STR).toLowerCase(), PKCSOID.CHALLENGE_PASSWORD_OID);
        NAME_OID_TABLE.put(new String(UNSTRUCTURED_ADDRESS_STR).toLowerCase(), PKCSOID.UNSTRUCTURED_ADDRESS_OID);
        NAME_OID_TABLE.put(new String(EXTENDED_CERTIFICATE_ATTRIBUTES_STR).toLowerCase(), PKCSOID.EXTENDED_CERTIFICATE_ATTRIBUTES_OID);
        NAME_OID_TABLE.put(new String(FRIENDLY_NAME_STR).toLowerCase(), PKCSOID.FRIENDLY_NAME_OID);
        NAME_OID_TABLE.put(new String(LOCAL_KEY_ID_STR).toLowerCase(), PKCSOID.LOCAL_KEY_ID_OID);
        NAME_OID_TABLE.put(new String(SIGNING_CERTIFICATE_STR).toLowerCase(), PKCSOID.SIGNING_CERTIFICATE_OID);
        NAME_OID_TABLE.put(new String(EXTENSION_REQUEST_STR).toLowerCase(), PKCSOID.EXTENSION_REQUEST_OID);
        NAME_OID_TABLE.put(new String(SIGNATURE_TIMESTAMP_TOKEN_STR).toLowerCase(), PKCSOID.SIGNATURE_TIMESTAMP_TOKEN_OID);
        OID_NAME_TABLE = new Hashtable(14);
        OID_NAME_TABLE.put(PKCSOID.EMAIL_ADDRESS_OID, EMAIL_ADDRESS_STR);
        OID_NAME_TABLE.put(PKCSOID.UNSTRUCTURED_NAME_OID, UNSTRUCTURED_NAME_STR);
        OID_NAME_TABLE.put(PKCSOID.CONTENT_TYPE_OID, CONTENT_TYPE_STR);
        OID_NAME_TABLE.put(PKCSOID.MESSAGE_DIGEST_OID, MESSAGE_DIGEST_STR);
        OID_NAME_TABLE.put(PKCSOID.SIGNING_TIME_OID, SIGNING_TIME_STR);
        OID_NAME_TABLE.put(PKCSOID.COUNTERSIGNATURE_OID, COUNTERSIGNATURE_STR);
        OID_NAME_TABLE.put(PKCSOID.CHALLENGE_PASSWORD_OID, CHALLENGE_PASSWORD_STR);
        OID_NAME_TABLE.put(PKCSOID.UNSTRUCTURED_ADDRESS_OID, UNSTRUCTURED_ADDRESS_STR);
        OID_NAME_TABLE.put(PKCSOID.EXTENDED_CERTIFICATE_ATTRIBUTES_OID, EXTENDED_CERTIFICATE_ATTRIBUTES_STR);
        OID_NAME_TABLE.put(PKCSOID.FRIENDLY_NAME_OID, FRIENDLY_NAME_STR);
        OID_NAME_TABLE.put(PKCSOID.LOCAL_KEY_ID_OID, LOCAL_KEY_ID_STR);
        OID_NAME_TABLE.put(PKCSOID.SIGNING_CERTIFICATE_OID, SIGNING_CERTIFICATE_STR);
        OID_NAME_TABLE.put(PKCSOID.EXTENSION_REQUEST_OID, EXTENSION_REQUEST_STR);
        OID_NAME_TABLE.put(PKCSOID.SIGNATURE_TIMESTAMP_TOKEN_OID, SIGNATURE_TIMESTAMP_TOKEN_STR);
    }
}

