/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.IssuerAndSerialNumber;
import com.ibm.security.pkcs7.PKCS7;
import com.ibm.security.pkcs7.SignerIdentifier;
import com.ibm.security.pkcs9.ContentType;
import com.ibm.security.pkcs9.MessageDigest;
import com.ibm.security.pkcs9.SigningTime;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public final class SignerInfo
extends PKCSDerObject
implements Cloneable,
DerEncoder {
    private static final byte TAG_SIGNED_ATTRS = 0;
    private static final byte TAG_UNSIGNED_ATTRS = 1;
    private BigInteger version;
    private SignerIdentifier sid;
    private AlgorithmId digestAlgorithm;
    private PKCSAttributes signedAttrs;
    private AlgorithmId signatureAlgorithm;
    private byte[] signature;
    private PKCSAttributes unsignedAttrs;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.SignerInfo";
    private volatile int cachedHashVal = 0;

    public SignerInfo(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SignerInfo", (Object)der);
            debug.exit(16384L, className, "SignerInfo");
        }
    }

    public SignerInfo(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "SignerInfo", der, provider);
            debug.exit(16384L, className, "SignerInfo");
        }
    }

    SignerInfo(Certificate cert) throws IOException {
        this(cert, null);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SignerInfo", cert);
            debug.exit(16384L, className, "SignerInfo");
        }
    }

    SignerInfo(Certificate cert, String provider) throws IOException {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "SignerInfo", cert, provider);
        }
        if (cert == null) {
            if (debug != null) {
                debug.text(16384L, className, "SignerInfo", "Certificate must be specified.");
            }
            throw new IllegalArgumentException("Certificate must be specified.");
        }
        this.setIssuer(cert);
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "SignerInfo");
        }
    }

    public SignerInfo(SignerIdentifier sid, ContentInfo contentInfo, String digestSignatureAlgorithm, PrivateKey privateKey, PKCSAttributes signedAttrs, PKCSAttributes unsignedAttrs) throws PKCSException, IOException, NoSuchAlgorithmException, NoSuchProviderException {
        this(sid, contentInfo, digestSignatureAlgorithm, privateKey, signedAttrs, unsignedAttrs, null);
        if (debug != null) {
            Object[] parms = new Object[]{sid, contentInfo, digestSignatureAlgorithm, privateKey, signedAttrs, unsignedAttrs};
            debug.entry(16384L, (Object)className, "SignerInfo", parms);
            debug.exit(16384L, className, "SignerInfo");
        }
    }

    public SignerInfo(SignerIdentifier sid, ContentInfo contentInfo, String digestSignatureAlgorithm, PrivateKey privateKey, PKCSAttributes signedAttrs, PKCSAttributes unsignedAttrs, String provider) throws PKCSException, IOException, NoSuchAlgorithmException, NoSuchProviderException {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{sid, contentInfo, digestSignatureAlgorithm, privateKey, signedAttrs, unsignedAttrs, provider};
            debug.entry(16384L, (Object)className, "SignerInfo", parms);
        }
        if (digestSignatureAlgorithm == null) {
            if (debug != null) {
                debug.text(16384L, className, "SignerInfo", "Digest and signature algorithm not specified.");
            }
            throw new IllegalArgumentException("Digest and signature algorithm not specified.");
        }
        this.signedAttrs = signedAttrs;
        this.unsignedAttrs = unsignedAttrs;
        this.sid = sid;
        this.sign(contentInfo, digestSignatureAlgorithm, privateKey);
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "SignerInfo");
        }
    }

    public SignerInfo(Certificate cert, ContentInfo contentInfo, String digestSignatureAlgorithm, PrivateKey privateKey, PKCSAttributes signedAttrs, PKCSAttributes unsignedAttrs) throws PKCSException, IOException, NoSuchAlgorithmException {
        this(cert, contentInfo, digestSignatureAlgorithm, privateKey, signedAttrs, unsignedAttrs, null);
        if (debug != null) {
            Object[] parms = new Object[]{cert, contentInfo, digestSignatureAlgorithm, privateKey, signedAttrs, unsignedAttrs};
            debug.entry(16384L, (Object)className, "SignerInfo", parms);
            debug.exit(16384L, className, "SignerInfo");
        }
    }

    public SignerInfo(Certificate cert, ContentInfo contentInfo, String digestSignatureAlgorithm, PrivateKey privateKey, PKCSAttributes signedAttrs, PKCSAttributes unsignedAttrs, String provider) throws PKCSException, IOException, NoSuchAlgorithmException {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{cert, contentInfo, digestSignatureAlgorithm, privateKey, signedAttrs, unsignedAttrs, provider};
            debug.entry(16384L, (Object)className, "SignerInfo", parms);
        }
        if (cert == null) {
            if (debug != null) {
                debug.text(16384L, className, "SignerInfo", "Certificate not specified.");
            }
            throw new IllegalArgumentException("Certificate not specified.");
        }
        this.sid = new SignerIdentifier(cert, provider);
        this.signedAttrs = signedAttrs;
        this.unsignedAttrs = unsignedAttrs;
        this.sign(contentInfo, digestSignatureAlgorithm, privateKey);
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "SignerInfo");
        }
    }

    public SignerInfo(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "SignerInfo", filename, new Boolean(base64));
            debug.exit(16384L, className, "SignerInfo");
        }
    }

    public SignerInfo(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "SignerInfo", parms);
            debug.exit(16384L, className, "SignerInfo");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            SignerInfo result = new SignerInfo(derout.toByteArray());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    private void setIssuer(Certificate cert) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setIssuer", cert);
        }
        if (cert == null) {
            if (debug != null) {
                debug.text(8192L, className, "setIssuer", "Certificate must be specified.");
            }
            throw new IllegalArgumentException("Certificate must be specified.");
        }
        X509Certificate x509cert = (X509Certificate)cert;
        Principal princ = x509cert.getIssuerDN();
        String pszprinc = princ.getName();
        X500Name xname = new X500Name(pszprinc);
        BigInteger snbigint = x509cert.getSerialNumber();
        IssuerAndSerialNumber iasn = new IssuerAndSerialNumber(xname, snbigint, this.provider);
        this.sid = new SignerIdentifier(iasn, this.provider);
        if (debug != null) {
            debug.exit(8192L, className, "setIssuer");
        }
    }

    byte[] signSignatureOnly(byte[] message, String digestSignatureAlgorithm, PrivateKey privateKey) throws PKCSException, NoSuchAlgorithmException, IOException {
        if (debug != null) {
            Object[] parms = new Object[]{message, digestSignatureAlgorithm, privateKey};
            debug.entry(16384L, (Object)className, "signSignatureOnly", parms);
        }
        if (digestSignatureAlgorithm == null) {
            if (debug != null) {
                debug.text(16384L, className, "signSignatureOnly", "Digest and signature algorithm must be specified.");
            }
            throw new IllegalArgumentException("Digest and signature algorithm must be specified.");
        }
        this.signature = null;
        String digestAlgorithm = PKCS7.getDigestAlgorithm(digestSignatureAlgorithm);
        this.setDigestAlgorithm(digestAlgorithm);
        this.setSignatureAlgorithm(digestSignatureAlgorithm);
        byte[] result = this.signSignatureOnly(message, privateKey);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "signSignatureOnly", result);
        }
        return result;
    }

    private byte[] signSignatureOnly(byte[] message, PrivateKey privateKey) throws PKCSException, IOException, NoSuchAlgorithmException {
        Signature sign;
        if (debug != null) {
            Object[] parms = new Object[]{message, privateKey};
            debug.entry(8192L, (Object)className, "signSignatureOnly", parms);
        }
        if (this.signatureAlgorithm == null) {
            if (debug != null) {
                debug.text(8192L, className, "signSignatureOnly", "Signature algorithm was not set.");
            }
            throw new IllegalArgumentException("Signature algorithm was not set.");
        }
        if (privateKey == null) {
            if (debug != null) {
                debug.text(8192L, className, "signSignatureOnly", "Private key was not specified.");
            }
            throw new IllegalArgumentException("Private key was not specified.");
        }
        if (message == null) {
            if (debug != null) {
                debug.text(8192L, className, "signSignatureOnly", "Message was not specified.");
            }
            throw new IllegalArgumentException("Message was not specified.");
        }
        this.signature = null;
        String signname = this.signatureAlgorithm.getName();
        try {
            sign = this.provider != null ? Signature.getInstance(signname, this.provider) : Signature.getInstance(signname);
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(8192L, className, "signSignatureOnly", e);
            }
            this.removeSignedAttributes();
            throw new PKCSException(e, "Could not obtain the algorithm for " + signname);
        }
        catch (NoSuchProviderException e) {
            if (debug != null) {
                debug.exception(8192L, className, "signSignatureOnly", e);
            }
            this.removeSignedAttributes();
            throw new PKCSException(e, "Provider " + this.provider + " not found");
        }
        try {
            sign.initSign(privateKey);
            sign.update(message);
            this.signature = sign.sign();
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(8192L, className, "signSignatureOnly", e);
            }
            throw new PKCSException(e, "Error signing digest: " + e.toString());
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "signSignatureOnly", this.signature);
        }
        return this.signature;
    }

    private byte[] sign(ContentInfo contentInfo, String digestSignatureAlgorithm, PrivateKey privateKey) throws PKCSException, NoSuchAlgorithmException, IOException {
        if (debug != null) {
            Object[] parms = new Object[]{contentInfo, digestSignatureAlgorithm, privateKey};
            debug.entry(8192L, (Object)className, "sign", parms);
        }
        if (digestSignatureAlgorithm == null) {
            if (debug != null) {
                debug.text(8192L, className, "sign", "Message digest and signature algorithm must be specified.");
            }
            throw new IllegalArgumentException("Message digest and signature algorithm must be specified.");
        }
        String digestAlgorithm = PKCS7.getDigestAlgorithm(digestSignatureAlgorithm);
        this.signature = null;
        this.setDigestAlgorithm(digestAlgorithm);
        this.setSignatureAlgorithm(digestSignatureAlgorithm);
        this.setSignedAttributes(contentInfo);
        byte[] result = this.sign(digestSignatureAlgorithm, privateKey);
        if (debug != null) {
            debug.exit(8192L, (Object)className, "sign", result);
        }
        return result;
    }

    private byte[] sign(PrivateKey privateKey) throws PKCSException, IOException, NoSuchAlgorithmException {
        Signature sign;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "sign", privateKey);
        }
        if (this.signatureAlgorithm == null) {
            if (debug != null) {
                debug.text(8192L, className, "sign", "Signature algorithm was not set.");
            }
            throw new IllegalArgumentException("Signature algorithm was not set.");
        }
        if (privateKey == null) {
            if (debug != null) {
                debug.text(8192L, className, "sign", "Private key was not specified.");
            }
            throw new IllegalArgumentException("Private key was not specified.");
        }
        if (!this.hasSignedAttribute(PKCSOID.MESSAGE_DIGEST_OID)) {
            String pszerror = "Could not find the MESSAGE_DIGEST_OID signed attribute.  Message digest needs to be calculated.";
            if (debug != null) {
                debug.text(8192L, className, "sign", pszerror);
            }
            throw new IllegalArgumentException(pszerror);
        }
        this.signature = null;
        this.setSigningTime();
        byte[] predigest = this.calculatePreMessageDigest((byte)0);
        if (predigest == null) {
            if (debug != null) {
                debug.text(8192L, className, "sign", "Could not calculate a message digest.");
            }
            this.removeSignedAttributes();
            throw new PKCSException("Could not calculate a message digest.");
        }
        String signname = this.signatureAlgorithm.getName();
        try {
            sign = this.provider != null ? Signature.getInstance(signname, this.provider) : Signature.getInstance(signname);
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(8192L, className, "sign", e);
                debug.text(8192L, className, "sign", "Could not obtain the algorithm for " + signname);
            }
            this.removeSignedAttributes();
            throw new PKCSException(e, "Could not obtain the algorithm for " + signname);
        }
        catch (NoSuchProviderException e) {
            if (debug != null) {
                debug.exception(8192L, className, "sign", e);
                debug.text(8192L, className, "sign", "Provider " + this.provider + " not found.");
            }
            this.removeSignedAttributes();
            throw new PKCSException(e, "Provider " + this.provider + " not found.");
        }
        try {
            sign.initSign(privateKey);
            sign.update(predigest);
            this.signature = sign.sign();
        }
        catch (Exception e) {
            this.removeSignedAttributes();
            if (debug != null) {
                debug.exception(8192L, className, "sign", e);
                debug.text(8192L, className, "sign", "Error signing digest: " + e.toString());
            }
            throw new PKCSException(e, "Error signing digest: " + e.toString());
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "sign", this.signature);
        }
        return this.signature;
    }

    private void setSigningTime() throws PKCSException, IOException {
        if (debug != null) {
            debug.entry(8192L, className, "setSigningTime");
        }
        Calendar cal = Calendar.getInstance();
        Date date = cal.getTime();
        SigningTime stime = new SigningTime(date);
        this.addSignedAttribute(stime.getPKCSAttribute());
        if (debug != null) {
            debug.exit(8192L, className, "setSigningTime");
        }
    }

    public SigningTime getSigningTime() {
        PKCSAttribute signingTimeAttrib;
        if (debug != null) {
            debug.entry(8192L, className, "getSigningTime");
        }
        if ((signingTimeAttrib = this.getSignedAttribute(PKCSOID.SIGNING_TIME_OID)) != null) {
            SigningTime result = (SigningTime)signingTimeAttrib.getPKCS9DerObject();
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getSigningTime", result);
            }
            return result;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getSigningTime", null);
        }
        return null;
    }

    private byte[] sign(String signatureAlgorithm, PrivateKey privateKey) throws PKCSException, IOException, NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(8192L, className, "sign", signatureAlgorithm, privateKey);
        }
        if (signatureAlgorithm == null) {
            if (debug != null) {
                debug.text(8192L, className, "sign", "Signature algorithm was not specified.");
            }
            throw new IllegalArgumentException("Signature algorithm was not specified.");
        }
        if (privateKey == null) {
            if (debug != null) {
                debug.text(8192L, className, "sign", "Private key was not specified.");
            }
            throw new IllegalArgumentException("Private key was not specified.");
        }
        this.signature = null;
        this.setSignatureAlgorithm(signatureAlgorithm);
        byte[] result = this.sign(privateKey);
        if (debug != null) {
            debug.exit(8192L, (Object)className, "sign", result);
        }
        return result;
    }

    public boolean verify(Certificate cert, byte[] msg) throws PKCSException, IOException, NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, className, "verify", cert, msg);
        }
        if (cert == null) {
            if (debug != null) {
                debug.text(8192L, className, "verify", "Certificate was not specified.");
            }
            throw new IllegalArgumentException("Certificate was not specified.");
        }
        PublicKey publicKey = ((X509Certificate)cert).getPublicKey();
        boolean result = this.verify(publicKey, msg);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "verify", new Boolean(result));
        }
        return result;
    }

    public boolean verify(PublicKey publicKey, byte[] msg) throws PKCSException, IOException, NoSuchAlgorithmException {
        return this.verify(publicKey, msg, (byte)0);
    }

    boolean verify(PublicKey publicKey, byte[] msg, byte flag) throws PKCSException, IOException, NoSuchAlgorithmException {
        Signature sign;
        String mdname;
        if (debug != null) {
            debug.entry(16384L, className, "verify", publicKey, msg);
        }
        if (publicKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Private key was not specified.");
            }
            throw new IllegalArgumentException("Private key was not specified.");
        }
        if (this.signature == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Signature was not set.");
            }
            throw new IllegalArgumentException("Signature was not set.");
        }
        if (this.signatureAlgorithm == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Signature algorithm was not set.");
            }
            throw new IllegalArgumentException("Signature algorithm was not set.");
        }
        if (msg == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Byte array to compute the message digest comparision was not set.");
            }
            throw new IllegalArgumentException("Byte array to compute the message digest comparision was not set.");
        }
        if (!this.compareDigest(msg)) {
            return false;
        }
        byte[] predigest = this.calculatePreMessageDigest(flag);
        if (predigest == null && !this.hasSignedAttributes()) {
            predigest = msg;
        }
        if (predigest == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Could not calculate the signature verification digest.");
            }
            throw new PKCSException("Could not calculate the signature verification digest.");
        }
        String signname = this.signatureAlgorithm.getName();
        int index = signname.indexOf(mdname = this.digestAlgorithm.getName());
        if (index == -1) {
            signname = this.digestAlgorithm.getName() + "/" + this.signatureAlgorithm.getName();
        }
        try {
            sign = this.provider != null ? Signature.getInstance(signname, this.provider) : Signature.getInstance(signname);
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(16384L, className, "verify", e);
                debug.text(16384L, className, "verify", "Could not obtain the algorithm for " + signname);
            }
            throw new PKCSException(e, "Could not obtain the algorithm for " + signname);
        }
        catch (NoSuchProviderException e) {
            if (debug != null) {
                debug.exception(16384L, className, "verify", e);
                debug.text(16384L, className, "verify", "Provider " + this.provider + " not found");
            }
            throw new PKCSException(e, "Provider " + this.provider + " not found");
        }
        try {
            sign.initVerify(publicKey);
            sign.update(predigest);
            boolean bverify = sign.verify(this.signature);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "verify", new Boolean(bverify));
            }
            return bverify;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Error verifying signature: " + e.toString());
            }
            throw new PKCSException(e, "Error verifying signature: " + e.toString());
        }
    }

    public boolean compareDigest(byte[] msg) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "compareDigest", (Object)msg);
        }
        if (msg == null) {
            throw new IllegalArgumentException("Byte array to compute the message digest comparision was not set.");
        }
        byte[] messageDigest = this.calculateMessageDigest(msg);
        if (messageDigest == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "compareDigest_1", new Boolean(false));
            }
            return false;
        }
        byte[] signerInfoMessageDigest = this.getMessageDigest();
        if (signerInfoMessageDigest == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "compareDigest_2", new Boolean(true));
            }
            return true;
        }
        if (messageDigest.length != signerInfoMessageDigest.length) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "compareDigest_3", new Boolean(false));
            }
            return false;
        }
        for (int i = 0; i < messageDigest.length; ++i) {
            if (messageDigest[i] == signerInfoMessageDigest[i]) continue;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "compareDigest_4", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "compareDigest", new Boolean(true));
        }
        return true;
    }

    private byte[] calculatePreMessageDigest(byte usage) throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "calculatePreMessageDigest");
        }
        if (this.signedAttrs == null || this.signedAttrs.size() < 2) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "calculatePreMessageDigest_1", null);
            }
            return null;
        }
        PKCSAttribute mdSignedAttrib = this.getSignedAttribute(PKCSOID.MESSAGE_DIGEST_OID);
        PKCSAttribute ctSignedAttrib = this.getSignedAttribute(PKCSOID.CONTENT_TYPE_OID);
        if (ctSignedAttrib == null || mdSignedAttrib == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "calculatePreMessageDigest_2", null);
            }
            return null;
        }
        byte[] result = null;
        if (usage == 0) {
            DerOutputStream mdout = new DerOutputStream();
            this.encodeSignedAttributesExplicit(mdout);
            result = mdout.toByteArray();
        } else if (usage == 1) {
            if (this.signedAttrs != null && this.signedAttrs.size() > 0) {
                result = this.signedAttrs.getOriginalEncoded();
                if (result == null) {
                    DerOutputStream mdout2 = new DerOutputStream();
                    this.encodeSignedAttributesExplicit(mdout2);
                    result = mdout2.toByteArray();
                }
            } else {
                result = new DerOutputStream().toByteArray();
            }
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "calculatePreMessageDigest", result);
        }
        return result;
    }

    public byte[] getMessageDigest() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getMessageDigest");
        }
        if (this.signedAttrs == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getMessageDigest_1", null);
            }
            return null;
        }
        PKCSAttribute mdSignedAttrib = this.getSignedAttribute(PKCSOID.MESSAGE_DIGEST_OID);
        if (mdSignedAttrib == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getMessageDigest_2", null);
            }
            return null;
        }
        MessageDigest md = (MessageDigest)mdSignedAttrib.getPKCS9DerObject();
        if (md == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getMessageDigest_3", null);
            }
            return null;
        }
        byte[] bytes = md.getBytes();
        byte[] result = (byte[])bytes.clone();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getMessageDigest", result);
        }
        return result;
    }

    private void setSignedAttributes(ContentInfo contentInfo) throws IOException, PKCSException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setSignedAttributes", contentInfo);
        }
        if (this.digestAlgorithm == null) {
            if (debug != null) {
                debug.text(8192L, className, "setSignedAttributes", "Digest algorithm was not set.");
            }
            throw new IllegalArgumentException("Digest algorithm was not set.");
        }
        if (contentInfo == null) {
            if (debug != null) {
                debug.text(8192L, className, "setSignedAttributes", "ContentInfo was not specified.");
            }
            throw new IllegalArgumentException("ContentInfo was not specified.");
        }
        ContentType ct = new ContentType(contentInfo.getContentType(), this.provider);
        byte[] digest = this.calculateMessageDigest(contentInfo);
        MessageDigest md = new MessageDigest(this.provider);
        md.setData(digest);
        this.addSignedAttribute(ct.getPKCSAttribute());
        this.addSignedAttribute(md.getPKCSAttribute());
        if (debug != null) {
            debug.exit(8192L, className, "setSignedAttributes");
        }
    }

    private void removeSignedAttributes() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "removeSignedAttributes");
        }
        this.removeSignedAttribute(PKCSOID.CONTENT_TYPE_OID);
        this.removeSignedAttribute(PKCSOID.MESSAGE_DIGEST_OID);
        this.removeSignedAttribute(PKCSOID.SIGNING_TIME_OID);
        if (debug != null) {
            debug.exit(8192L, className, "removeSignedAttributes");
        }
    }

    private void addSignedAttribute(PKCSAttributes signedAttribs) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "addSignedAttribute", signedAttribs);
        }
        if (signedAttribs == null || signedAttribs.size() == 0) {
            if (debug != null) {
                debug.exit(8192L, className, "addSignedAttribute_1");
            }
            return;
        }
        this.signedAttrs = this.signedAttrs == null ? (PKCSAttributes)signedAttribs.clone() : this.signedAttrs.addAttributes(signedAttribs);
        if (debug != null) {
            debug.exit(8192L, className, "addSignedAttribute");
        }
    }

    private void addSignedAttribute(PKCSAttribute signedAttrib) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "addSignedAttribute", signedAttrib);
        }
        if (signedAttrib == null) {
            if (debug != null) {
                debug.entry(8192L, className, "addSignedAttribute_1");
            }
            return;
        }
        if (this.signedAttrs == null) {
            this.signedAttrs = new PKCSAttributes(this.provider);
        }
        this.signedAttrs = this.signedAttrs.addAttribute(signedAttrib);
        if (debug != null) {
            debug.entry(8192L, className, "addSignedAttribute");
        }
    }

    void removeSignedAttribute(ObjectIdentifier oid) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "removeSignedAttribute", oid);
        }
        if (oid == null || this.signedAttrs == null) {
            if (debug != null) {
                debug.exit(16384L, className, "removeSignedAttribute_1");
            }
            return;
        }
        this.signedAttrs = this.signedAttrs.deleteAttribute(oid);
        if (debug != null) {
            debug.exit(16384L, className, "removeSignedAttribute");
        }
    }

    private void addUnsignedAttribute(PKCSAttributes unsignedAttribs) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "addUnsignedAttribute", unsignedAttribs);
        }
        if (unsignedAttribs == null || unsignedAttribs.size() == 0) {
            if (debug != null) {
                debug.exit(8192L, className, "addUnsignedAttribute_1");
            }
            return;
        }
        this.unsignedAttrs = this.unsignedAttrs == null ? (PKCSAttributes)this.unsignedAttrs.clone() : this.unsignedAttrs.addAttributes(unsignedAttribs);
        if (debug != null) {
            debug.exit(8192L, className, "addUnsignedAttribute");
        }
    }

    private void addUnsignedAttribute(PKCSAttribute unsignedAttrib) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "addUnsignedAttribute", unsignedAttrib);
        }
        if (unsignedAttrib == null) {
            if (debug != null) {
                debug.exit(8192L, className, "addUnsignedAttribute_1");
            }
            return;
        }
        if (this.unsignedAttrs == null) {
            PKCSAttribute[] attribs = new PKCSAttribute[]{unsignedAttrib};
            this.unsignedAttrs = new PKCSAttributes(attribs, this.provider);
        } else {
            this.unsignedAttrs = this.unsignedAttrs.addAttribute(unsignedAttrib);
        }
        if (debug != null) {
            debug.exit(8192L, className, "addUnsignedAttribute");
        }
    }

    void removeUnsignedAttribute(ObjectIdentifier oid) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "removeUnsignedAttribute", oid);
        }
        if (oid == null || this.unsignedAttrs == null) {
            if (debug != null) {
                debug.exit(16384L, className, "removeUnsignedAttribute_1");
            }
            return;
        }
        this.unsignedAttrs = this.unsignedAttrs.deleteAttribute(oid);
        if (debug != null) {
            debug.exit(16384L, className, "removeUnsignedAttribute");
        }
    }

    public PKCSAttribute getSignedAttribute(ObjectIdentifier oid) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getSignedAttribute", oid);
        }
        if (oid == null || this.signedAttrs == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSignedAttribute_1", null);
            }
            return null;
        }
        PKCSAttribute attrib = (PKCSAttribute)this.signedAttrs.getAttribute(oid);
        if (attrib == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSignedAttribute_2", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignedAttribute", attrib);
        }
        return attrib;
    }

    public PKCSAttribute getUnsignedAttribute(ObjectIdentifier oid) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getUnsignedAttribute", oid);
        }
        if (oid == null || this.unsignedAttrs == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getUnsignedAttribute_1", null);
            }
            return null;
        }
        PKCSAttribute attrib = (PKCSAttribute)this.unsignedAttrs.getAttribute(oid);
        if (attrib == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getUnsignedAttribute_2", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getUnsignedAttribute", attrib);
        }
        return attrib;
    }

    public boolean hasSignedAttribute(ObjectIdentifier oid) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "hasSignedAttribute", oid);
        }
        PKCSAttribute signedAttrib = this.getSignedAttribute(oid);
        boolean result = false;
        if (signedAttrib != null) {
            result = true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasSignedAttribute", new Boolean(result));
        }
        return result;
    }

    private byte[] getMessageDigest(ContentInfo contentInfo, String digestAlgorithm) throws IOException, PKCSException, NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(8192L, className, "getMessageDigest", contentInfo, digestAlgorithm);
        }
        if (contentInfo == null) {
            if (debug != null) {
                debug.text(8192L, className, "getMessageDigest", "ContentInfo was not specified.");
            }
            throw new IllegalArgumentException("ContentInfo was not specified.");
        }
        if (digestAlgorithm == null && this.digestAlgorithm == null) {
            if (debug != null) {
                debug.text(8192L, className, "getMessageDigest", "Message digest algorithm was not specified.");
            }
            throw new IllegalArgumentException("Message digest algorithm was not specified.");
        }
        if (digestAlgorithm != null) {
            this.setDigestAlgorithm(digestAlgorithm);
        }
        byte[] result = this.getMessageDigest(contentInfo);
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getMessageDigest", result);
        }
        return result;
    }

    private byte[] getMessageDigest(ContentInfo contentInfo) throws IOException, PKCSException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "getMessageDigest", contentInfo);
        }
        if (contentInfo == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getMessageDigest", "Content info was not specified.");
            }
            throw new IllegalArgumentException("Content info was not specified.");
        }
        if (this.digestAlgorithm == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getMessageDigest", "Digest algorithm was not set.");
            }
            throw new IllegalArgumentException("Digest algorithm was not set.");
        }
        this.signature = null;
        this.setSignedAttributes(contentInfo);
        byte[] result = this.getMessageDigest();
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getMessageDigest", result);
        }
        return result;
    }

    private byte[] calculateMessageDigest(ContentInfo contentInfo) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "calculateMessageDigest", contentInfo);
        }
        if (contentInfo == null) {
            if (debug != null) {
                debug.text(8192L, className, "calculateMessageDigest", "ContentInfo was not specified.");
            }
            throw new IllegalArgumentException("ContentInfo was not specified.");
        }
        if (this.digestAlgorithm == null) {
            if (debug != null) {
                debug.text(8192L, className, "calculateMessageDigest", "Digest algorithm was not set.");
            }
            throw new IllegalArgumentException("Digest algorithm was not set.");
        }
        this.signature = null;
        DerOutputStream derout = new DerOutputStream();
        contentInfo.getContent().encode(derout);
        DerValue der = new DerValue(derout.toByteArray());
        byte[] bytesToBeDigested = der.getData().toByteArray();
        byte[] result = this.calculateMessageDigest(bytesToBeDigested);
        if (debug != null) {
            debug.exit(8192L, (Object)className, "calculateMessageDigest", result);
        }
        return result;
    }

    private byte[] calculateMessageDigest(byte[] bytes) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "calculateMessageDigest", (Object)bytes);
        }
        if (this.digestAlgorithm == null) {
            if (debug != null) {
                debug.text(8192L, className, "calculateMessageDigest", "Digest algorithm was not set.");
            }
            throw new IllegalArgumentException("Digest algorithm was not set.");
        }
        String mdname = this.digestAlgorithm.getName();
        java.security.MessageDigest md = null;
        try {
            md = this.provider != null ? java.security.MessageDigest.getInstance(mdname, this.provider) : java.security.MessageDigest.getInstance(mdname);
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(8192L, className, "calculateMessageDigest", e);
                debug.text(8192L, className, "calculateMessageDigest", "Could not obtain the algorithm for " + mdname);
            }
            throw new IOException("Could not obtain the algorithm for " + mdname);
        }
        catch (NoSuchProviderException e) {
            if (debug != null) {
                debug.exception(8192L, className, "calculateMessageDigest", e);
                debug.text(8192L, className, "calculateMessageDigest", "Could not obtain the provider for " + this.provider);
            }
            throw new IOException("Could not obtain the provider for " + this.provider);
        }
        byte[] digest = md.digest(bytes);
        if (debug != null) {
            debug.exit(8192L, (Object)className, "calculateMessageDigest", digest);
        }
        return digest;
    }

    public boolean hasCertificate(Certificate cert) throws IOException {
        BigInteger oldbigSN;
        X500Name sixname;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "hasCertificate", cert);
        }
        if (cert == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasCertificate_1", new Boolean(false));
            }
            return false;
        }
        if (!this.sid.isIssuer()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasCertificate_2", new Boolean(false));
            }
            return false;
        }
        X509Certificate x509cert = (X509Certificate)cert;
        Principal princ = x509cert.getIssuerDN();
        X500Name xname = new X500Name(princ.getName());
        if (!xname.equals(sixname = this.sid.getIssuer().getIssuer())) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasCertificate_3", new Boolean(false));
            }
            return false;
        }
        BigInteger bigSN = x509cert.getSerialNumber();
        if (!bigSN.equals(oldbigSN = this.sid.getIssuer().getSerialNumber())) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasCertificate_4", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasCertificate", new Boolean(true));
        }
        return true;
    }

    public boolean hasIssuer(IssuerAndSerialNumber issuer) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "hasIssuer", issuer);
        }
        if (issuer == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasIssuer_1", new Boolean(false));
            }
            return false;
        }
        if (!this.sid.isIssuer()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasIssuer_1", new Boolean(false));
            }
            return false;
        }
        IssuerAndSerialNumber iss = this.sid.getIssuer();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasIssuer_2", new Boolean(iss.equals(issuer)));
        }
        return iss.equals(issuer);
    }

    @Override
    public void derEncode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "derEncode", out);
        }
        this.encode(out);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "derEncode", out);
        }
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        this.checkValues();
        this.calculateVersion();
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        bytes.putInteger(this.version);
        this.sid.encode(bytes);
        this.digestAlgorithm.encode(bytes);
        this.encodeSignedAttributes(bytes);
        AlgorithmId signAlgorithm = this.getSignatureAlgorithmOnly();
        if (signAlgorithm == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Cannot retrieve signature algorithm from " + this.signatureAlgorithm + ".");
            }
            throw new IOException("Cannot retrieve signature algorithm from " + this.signatureAlgorithm + ".");
        }
        signAlgorithm.encode(bytes);
        bytes.putOctetString(this.signature);
        if (this.unsignedAttrs != null && this.unsignedAttrs.size() > 0) {
            DerOutputStream tmpout = new DerOutputStream();
            this.unsignedAttrs.encode(tmpout);
            bytes.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), tmpout);
        }
        tmp.write((byte)48, bytes);
        os.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    void encodeWithOriginalAttrs(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        this.checkValues();
        this.calculateVersion();
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        bytes.putInteger(this.version);
        this.sid.encode(bytes);
        this.digestAlgorithm.encode(bytes);
        this.encodeOriginalSignedAttributes(bytes);
        AlgorithmId signAlgorithm = this.getSignatureAlgorithmOnly();
        if (signAlgorithm == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Cannot retrieve signature algorithm from " + this.signatureAlgorithm + ".");
            }
            throw new IOException("Cannot retrieve signature algorithm from " + this.signatureAlgorithm + ".");
        }
        signAlgorithm.encode(bytes);
        bytes.putOctetString(this.signature);
        if (this.unsignedAttrs != null && this.unsignedAttrs.size() > 0) {
            DerOutputStream tmpout = new DerOutputStream();
            byte[] temp = this.unsignedAttrs.getOriginalEncoded();
            if (temp != null) {
                tmpout.write(temp);
            } else {
                this.unsignedAttrs.encode(tmpout);
            }
            bytes.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), tmpout);
        }
        tmp.write((byte)48, bytes);
        os.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    private void encodeSignedAttributes(DerOutputStream bytes) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "encodeSignedAttributes", bytes);
        }
        if (this.signedAttrs != null && this.signedAttrs.size() > 0) {
            DerOutputStream tmpout = new DerOutputStream();
            this.signedAttrs.encode(tmpout);
            bytes.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), tmpout);
        }
        if (debug != null) {
            debug.exit(8192L, className, "encodeSignedAttributes");
        }
    }

    private void encodeOriginalSignedAttributes(DerOutputStream bytes) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "encodeSignedAttributes", bytes);
        }
        if (this.signedAttrs != null && this.signedAttrs.size() > 0) {
            DerOutputStream tmpout = new DerOutputStream();
            byte[] temp = this.signedAttrs.getOriginalEncoded();
            if (temp != null) {
                tmpout.write(temp);
            } else {
                this.signedAttrs.encode(tmpout);
            }
            bytes.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), tmpout);
        }
        if (debug != null) {
            debug.exit(8192L, className, "encodeSignedAttributes");
        }
    }

    void encodeSignedAttributesExplicit(DerOutputStream bytes) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encodeSignedAttributesExplicit", bytes);
        }
        if (this.signedAttrs != null && this.signedAttrs.size() > 0) {
            bytes.write(this.signedAttrs.generateDerEncoding());
        }
        if (debug != null) {
            debug.exit(16384L, className, "encodeSignedAttributesExplicit");
        }
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        DerInputStream derin;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "SignedData parsing error");
            }
            throw new IOException("SignedData parsing error");
        }
        this.version = encoding.getData().getInteger();
        if (this.version.intValue() != 1 && this.version.intValue() != 3) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Invalid SignerInfo version = " + this.version + " (must be 1 or 3).");
            }
            throw new IOException("Invalid SignerInfo version = " + this.version + " (must be 1 or 3).");
        }
        this.sid = new SignerIdentifier(encoding.getData().getDerValue().toByteArray(), this.provider);
        this.digestAlgorithm = AlgorithmId.parse(encoding.getData().getDerValue());
        boolean gotSignedAttrs = false;
        DerValue opt = encoding.getData().getDerValue();
        if (opt.isContextSpecific((byte)0) && opt.isConstructed()) {
            derin = new DerInputStream(opt.toByteArray());
            this.signedAttrs = new PKCSAttributes(derin, this.provider);
            gotSignedAttrs = true;
        } else {
            this.signedAttrs = null;
        }
        this.signatureAlgorithm = gotSignedAttrs ? AlgorithmId.parse(encoding.getData().getDerValue()) : AlgorithmId.parse(opt);
        this.signature = encoding.getData().getOctetString();
        if (encoding.getData().available() != 0) {
            opt = encoding.getData().getDerValue();
            if (opt.isContextSpecific((byte)1) && opt.isConstructed()) {
                derin = new DerInputStream(opt.toByteArray());
                this.unsignedAttrs = new PKCSAttributes(derin, this.provider);
            } else {
                this.unsignedAttrs = null;
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    @Override
    public boolean equals(Object other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", new Boolean(true));
            }
            return true;
        }
        if (!(other instanceof SignerInfo)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", new Boolean(false));
            }
            return false;
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            ((SignerInfo)other).encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", new Boolean(false));
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    @Override
    public String toString() {
        Date date;
        HexDumpEncoder hexDump = new HexDumpEncoder();
        String out = "PKCS7 SignerInfo:\r\n";
        out = out + "\tversion: " + this.version.intValue();
        out = out + "\r\n" + this.sid;
        out = out + "\r\n\tdigestAlgorithm: " + this.digestAlgorithm;
        out = out + "\r\n\tsignatureAlgorithm: " + this.signatureAlgorithm + "\r\n";
        if (this.signedAttrs != null) {
            out = out + "\r\n\tsignedAttributes (" + this.signedAttrs.size() + "):\r\n";
            out = out + this.signedAttrs + "\r\n";
        } else {
            out = out + "\tsignedAttributes: null\r\n";
        }
        out = out + "\tdigestEncryptionAlgorithmId: " + this.digestAlgorithm;
        out = this.signature != null ? out + "\r\n\tsignature: \r\n" + hexDump.encodeBuffer(this.signature) : out + "\r\n\tsignature: null\r\n";
        if (this.unsignedAttrs != null) {
            out = out + "\r\n\tunsignedAttributes (" + this.unsignedAttrs.size() + "):\r\n";
            out = out + this.unsignedAttrs + "\r\n";
        } else {
            out = out + "\tunsignedAttributes: null\r\n";
        }
        SigningTime stime = this.getSigningTime();
        out = stime == null ? out + "\tSigning Time = not set\r\n" : ((date = stime.getDate()) != null ? out + "\tSigning Time = " + date + "\r\n" : out + "\tSigning Time = not set\r\n");
        return out;
    }

    public boolean hasSignedAttributes() {
        if (debug != null) {
            debug.entry(16384L, className, "hasSignedAttributes");
        }
        boolean result = false;
        if (this.signedAttrs != null && this.signedAttrs.size() > 0) {
            result = true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasSignedAttributes", new Boolean(result));
        }
        return result;
    }

    public boolean hasUnsignedAttributes() {
        if (debug != null) {
            debug.entry(16384L, className, "hasUnsignedAttributes");
        }
        boolean result = false;
        if (this.unsignedAttrs == null && this.unsignedAttrs.size() > 0) {
            return true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasUnsignedAttributes", new Boolean(result));
        }
        return result;
    }

    public BigInteger getVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "getVersion");
            debug.exit(16384L, (Object)className, "getVersion", this.version);
        }
        return this.version;
    }

    public SignerIdentifier getSignerIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getSignerIdentifier");
        }
        SignerIdentifier result = null;
        if (this.sid != null) {
            result = (SignerIdentifier)this.sid.clone();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignerIdentifier", result);
        }
        return result;
    }

    public AlgorithmId getDigestAlgorithm() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getDigestAlgorithm");
        }
        AlgorithmId result = null;
        if (this.digestAlgorithm != null) {
            result = new AlgorithmId(this.digestAlgorithm.getOID(), this.digestAlgorithm.getParameters(), this.provider);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDigestAlgorithm", result);
        }
        return result;
    }

    public PKCSAttributes getSignedAttributes() {
        if (debug != null) {
            debug.entry(16384L, className, "getSignedAttributes");
        }
        PKCSAttributes result = null;
        if (this.signedAttrs != null) {
            result = this.signedAttrs;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignedAttributes", result);
        }
        return result;
    }

    public PKCSAttributes getUnsignedAttributes() {
        if (debug != null) {
            debug.entry(16384L, className, "getUnsignedAttributes");
        }
        PKCSAttributes result = null;
        if (this.unsignedAttrs != null) {
            result = this.unsignedAttrs;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getUnsignedAttributes", result);
        }
        return result;
    }

    public AlgorithmId getSignatureAlgorithm() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getSignatureAlgorithm");
        }
        AlgorithmId result = null;
        if (this.signatureAlgorithm != null) {
            result = new AlgorithmId(this.signatureAlgorithm.getOID(), this.signatureAlgorithm.getParameters(), this.provider);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignatureAlgorithm", result);
        }
        return result;
    }

    private AlgorithmId getSignatureAlgorithmOnly() {
        String alg;
        String alg2;
        int index;
        if (debug != null) {
            debug.entry(8192L, className, "getSignatureAlgorithmOnly");
        }
        if ((index = (alg2 = (alg = this.signatureAlgorithm.toString()).toUpperCase(Locale.US)).indexOf("WITH")) != -1) {
            alg = alg.substring(index += 4);
        }
        try {
            AlgorithmId algid = AlgorithmId.get(alg);
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getSignatureAlgorithmOnly", algid);
            }
            return algid;
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(8192L, className, "getSignatureAlgorithmOnly", e);
                debug.exit(8192L, (Object)className, "getSignatureAlgorithmOnly", null);
            }
            return null;
        }
    }

    private void setSignatureAlgorithm(AlgorithmId signatureAlgorithm) throws NoSuchAlgorithmException {
        AlgorithmId signatureAlg;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setSignatureAlgorithm", signatureAlgorithm);
        }
        String digestSignatureAlgorithm = PKCS7.getDigestSignatureAlgorithm(this.digestAlgorithm, signatureAlgorithm);
        this.signatureAlgorithm = signatureAlg = AlgorithmId.get(digestSignatureAlgorithm);
        if (debug != null) {
            debug.exit(8192L, className, "setSignatureAlgorithm");
        }
    }

    private void setSignatureAlgorithm(String signatureAlgorithm) throws NoSuchAlgorithmException {
        AlgorithmId signatureAlg;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setSignatureAlgorithm", signatureAlgorithm);
        }
        String digestAlgorithm = null;
        if (this.digestAlgorithm != null) {
            digestAlgorithm = this.digestAlgorithm.getName();
        }
        String digestSignatureAlgorithm = PKCS7.getDigestSignatureAlgorithm(digestAlgorithm, signatureAlgorithm);
        this.signatureAlgorithm = signatureAlg = AlgorithmId.get(digestSignatureAlgorithm);
        if (debug != null) {
            debug.exit(8192L, className, "setSignatureAlgorithm");
        }
    }

    private void setDigestAlgorithm(AlgorithmId digestAlgorithm) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setDigestAlgorithm", digestAlgorithm);
        }
        this.digestAlgorithm = digestAlgorithm;
        if (debug != null) {
            debug.exit(8192L, className, "setDigestAlgorithm");
        }
    }

    private void setDigestAlgorithm(String digestAlgorithm) throws IOException, NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setDigestAlgorithm", digestAlgorithm);
        }
        this.digestAlgorithm = AlgorithmId.get(digestAlgorithm);
        if (debug != null) {
            debug.exit(8192L, className, "setDigestAlgorithm");
        }
    }

    public byte[] getSignature() {
        if (debug != null) {
            debug.entry(16384L, className, "setSignature");
        }
        byte[] result = null;
        if (this.signature != null) {
            result = (byte[])this.signature.clone();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "setSignature", result);
        }
        return result;
    }

    static DerEncoder[] castToDerEncoder(Object[] objs) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "castToDerEncoder", objs);
        }
        DerEncoder[] encoders = new DerEncoder[objs.length];
        for (int i = 0; i < encoders.length; ++i) {
            encoders[i] = (DerEncoder)objs[i];
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "castToDerEncoder", encoders);
        }
        return encoders;
    }

    private void calculateVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "castToDerEncoder");
        }
        this.version = BigInteger.ONE;
        if (!this.sid.isIssuer()) {
            this.version = BigInteger.valueOf(3L);
        }
        if (debug != null) {
            debug.exit(16384L, className, "castToDerEncoder");
        }
    }

    private void checkValues() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "checkValues");
        }
        if (this.sid == null) {
            if (debug != null) {
                debug.text(8192L, className, "checkValues", "SignerInfo missing sid value.");
            }
            throw new IOException("SignerInfo missing sid value.");
        }
        if (this.digestAlgorithm == null) {
            if (debug != null) {
                debug.text(8192L, className, "checkValues", "SignerInfo missing digestAlgorithm value.");
            }
            throw new IOException("SignerInfo missing digestAlgorithm value.");
        }
        if (this.signatureAlgorithm == null) {
            if (debug != null) {
                debug.text(8192L, className, "checkValues", "SignerInfo missing signatureAlgorithm value.");
            }
            throw new IOException("SignerInfo missing signatureAlgorithm value.");
        }
        if (this.signature == null) {
            if (debug != null) {
                debug.text(8192L, className, "checkValues", "SignerInfo missing signature value.");
            }
            throw new IOException("SignerInfo missing signature value.");
        }
        if (debug != null) {
            debug.exit(8192L, className, "checkValues");
        }
    }
}

