/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.jgss;

import com.ibm.security.jgss.i18n.I18NException;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.InputStream;
import org.ietf.jgss.GSSException;

public class Oid {
    private ObjectIdentifier oid;
    private byte[] derEncoding;

    public Oid(String strOid) throws GSSException {
        try {
            this.oid = new ObjectIdentifier(strOid);
            this.derEncoding = null;
        }
        catch (Exception e) {
            I18NException.throwGSSException((int)11, (int)0, (String)"BadOidString", (Object[])new String[]{e.toString()});
        }
    }

    public Oid(InputStream derOid) throws GSSException {
        try {
            DerValue derVal = new DerValue(derOid);
            this.derEncoding = derVal.toByteArray();
            this.oid = derVal.getOID();
        }
        catch (Exception e) {
            I18NException.throwGSSException((int)11, (int)0, (String)"BadOidDer", (Object[])new String[]{e.toString()});
        }
    }

    public Oid(byte[] data) throws GSSException {
        try {
            DerValue derVal = new DerValue(data);
            this.derEncoding = derVal.toByteArray();
            this.oid = derVal.getOID();
        }
        catch (Exception e) {
            I18NException.throwGSSException((int)11, (int)0, (String)"BadOidDer", (Object[])new String[]{e.toString()});
        }
    }

    static Oid getInstance(String strOid) {
        Oid retVal = null;
        try {
            retVal = new Oid(strOid);
        }
        catch (GSSException gSSException) {
            // empty catch block
        }
        return retVal;
    }

    public String toString() {
        return this.oid.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Oid) {
            return this.oid.equals(((Oid)other).oid);
        }
        if (other instanceof ObjectIdentifier) {
            return this.oid.equals(other);
        }
        return false;
    }

    public byte[] getDER() throws GSSException {
        if (this.derEncoding == null) {
            DerOutputStream dout = new DerOutputStream();
            try {
                dout.putOID(this.oid);
            }
            catch (Exception e) {
                throw new GSSException(11, 0, e.toString());
            }
            this.derEncoding = dout.toByteArray();
        }
        return this.derEncoding;
    }

    public boolean containedIn(Oid[] oids) {
        for (int i = 0; i < oids.length; ++i) {
            if (!oids[i].equals(this)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.oid.hashCode();
    }
}

